' *****************************************************************
' Custom Font Printing Routine ver.1 by Lachie Dazdarian; Aug.2007.
' For 8bit color depth mode. Refer to readme.txt for more details.
' Attach this module on your source code with #include "24bitcustomfont.bi"
' Modified for my entry in ciw's Invaders compo (Nov 2007).
' *****************************************************************

' The font data type
TYPE FontType
FontBuffer(97, 9750) AS INTEGER  ' Memory buffer for each character.
FontWidth(97) AS INTEGER         ' Will store width of each character.
FontHeight AS INTEGER            ' Will hold the font's unique height.
END TYPE

' The sub declarations.
DECLARE SUB PrintFont (xx AS INTEGER, yy AS INTEGER, CText AS STRING, BYREF PrintSFont AS FontType, spacing AS INTEGER, PMode AS INTEGER)
DECLARE SUB PrintAlphaFont (xx AS INTEGER, yy AS INTEGER, CText AS STRING, BYREF PrintTFont AS FontType, spacing AS INTEGER, pblender AS INTEGER)
DECLARE SUB LoadFont (fontimage AS STRING, BYREF ImportFont AS FontType, widthmode AS INTEGER)


SUB LoadFont (fontimage AS STRING, BYREF ImportFont AS FontType, widthmode AS INTEGER)

widthmode = 2

'0,24 - 6,30
' 8, 16 - 14, 22
' 16,16 - 22,22

ImportFont.FontWidth(0) = 6
ImportFont.FontHeight = 6
' Loop through the entire font.
FOR frow AS INTEGER = 0 TO 3
FOR fcolumn AS INTEGER = 0 TO 15

' If widthmode = 2 the all the characters have the same width 
' which equals the width of SPACE key(spacing in the inputted string).

' Get the current character from appropriate coordinates and
' store it on appropriate position(FontBuffer).
dim as integer tempx1 = (fcolumn*8)
dim as integer tempy1 = 16+(frow*8)
dim as integer tempx2 = (fcolumn*8)+ImportFont.FontWidth(0)
dim as integer tempy2 = 16+(frow*8)+ImportFont.FontHeight
dim as integer buffer_seg = (fcolumn+1)+(frow*16)-1
'Dim p as any ptr = @ImportFont.FontBuffer( buffer_seg, 0 )

GET (tempx1, tempy1) - (tempx2, tempy2 ), ImportFont.FontBuffer( buffer_seg, 0 )
' This recaptures the first character in the font(blank space).
IF fcolumn = 0 AND frow = 0 THEN GET (0,16)-(ImportFont.FontWidth(0), 16+ImportFont.FontHeight), ImportFont.FontBuffer(0, 0)
    
' Flag the current character's width if it's not character 0(spacing).
IF (fcolumn+1)+(frow*16) > 0 THEN ImportFont.FontWidth((fcolumn+1)+(frow*16)-1) = ImportFont.FontWidth(0)

NEXT fcolumn
NEXT frow

'CLS

END SUB


SUB PrintFont (xx AS INTEGER, yy AS INTEGER, CText AS STRING, BYREF PrintSFont AS FontType, spacing AS INTEGER, PMode AS INTEGER)

' This sub prints CText$ with font saved in PrintSFont 
' array, on coordinates xx and yy, with inputted spacing and
' with TRANS(PMode=1) or PSET(PMode=2).

' If inexistent print mode is defined we flag 
' the default mode => TRANS
IF PMode<>1 AND PMode<>2 THEN PMode = 1

DIM MessLen AS INTEGER
DIM CharNo AS INTEGER
DIM CharWidth AS INTEGER

' Get the number of characters in the string.
MessLen = LEN(CText)

' Loop to display each character of CText$.
FOR nn AS INTEGER = 1 TO MessLen
    CharNo = ASC(MID$(CText, nn, 1)) - 32
    ' Get character's width
    CharWidth = PrintSFont.FontWidth(CharNo)
    
    IF CharNo < 98 THEN ' A precaution measure
    IF PMode=1 THEN PUT (xx, yy), PrintSFont.FontBuffer(CharNo, 0), TRANS
    IF PMode=2 THEN PUT (xx, yy), PrintSFont.FontBuffer(CharNo, 0), PSET
    END IF
    ' Add horizontal space according to inputted spacing
    ' and last character's width.
    xx = xx + CharWidth + spacing
        
NEXT nn

END SUB

SUB PrintAlphaFont (xx AS INTEGER, yy AS INTEGER, CText AS STRING, BYREF PrintTFont AS FontType, spacing AS INTEGER, pblender AS INTEGER)

' This sub prints CText with font saved in PrintSFont 
' array, on coordinates xx and yy, with ALPHA pblender.

' If blender is out of bounds set it to 255.
IF pblender > 255 OR pblender < 0 THEN pblender = 255

DIM MessLen AS INTEGER
DIM CharNo AS INTEGER
DIM CharWidth AS INTEGER

' Get the number of characters in the string.
MessLen = LEN(CText)

' Loop to display each character of CText$.
FOR nn AS INTEGER = 1 TO MessLen
    CharNo = ASC(MID$(CText, nn, 1)) - 32
    ' Get character's width
    CharWidth = PrintTFont.FontWidth(CharNo)
    
    IF CharNo < 98 THEN ' A precaution measure   
    PUT (xx, yy), PrintTFont.FontBuffer(CharNo, 0), ALPHA, pblender
    END IF
    ' Add horizontal space according to inputted spacing
    ' and last character's width.
    xx = xx + CharWidth + spacing
        
NEXT nn

END SUB


