#include "fbgfx.bi" 
#include "24bitcustomfont.bi"
#include "multiput_unofficial.bas"
#include "fmod.bi"
Using FB

CONST ScrnXmax = 640, ScrnYmax = 480

CONST FALSE = 0
CONST TRUE = 1
CONST fpslimit = 51
CONST numofParticles = 100
CONST numofExplosions = 50
CONST numofstars = 400

const PI = 3.141593

CONST FREE = 1       ' Flags that a block is free
CONST OCCUPIED = 2   ' Flags that a block is occupied
CONST WALL = 3       ' Flags that a block is wall
CONST CLEARED = 4    ' Flags that a block is cleared (new wall)
CONST BLOCK = 1      ' Flags that a falling object is a block
CONST BOMB = 2       ' Flags that a falling object is a bomb
CONST ALIVE = 1      
CONST DESTROYED = 2

TYPE BlockTyp
Column AS INTEGER
Row AS SINGLE
Status AS INTEGER
DColor AS UINTEGER
END TYPE

TYPE ParticleTyp
X           AS SINGLE
Y           AS SINGLE
LifeTime    AS INTEGER
Locked      AS INTEGER
Typ         AS INTEGER
XSpeed      AS SINGLE
YSpeed      AS SINGLE
YInertia    AS SINGLE
XInertia    AS SINGLE
PColor      AS UINTEGER
MText       AS STRING
END TYPE

DECLARE SUB LoadGraphics 
DECLARE SUB LoadLevel (llevel AS INTEGER)
DECLARE SUB DrawLevel
DECLARE SUB DrawBlocks
DECLARE SUB DrawBombs
DECLARE SUB UpdateBlocks
DECLARE SUB InitLevel
DECLARE SUB CheckLinesToClear
DECLARE SUB PushLinesUp
DECLARE SUB DoLineDeletionAnimation 
DECLARE SUB ResetPiece
DECLARE SUB ResetBomb
DECLARE SUB CheckEntireFieldForDeletion
DECLARE SUB MovePiece
DECLARE SUB MoveBomb
DECLARE SUB UpdateBombs
DECLARE SUB Convert8bit16bit
DECLARE SUB InitiateParticle (pposx AS SINGLE, pposy AS SINGLE, ptyp AS INTEGER, plifetime AS INTEGER)
DECLARE SUB ParticleLayer
DECLARE SUB InitiateExplosion (eposx AS SINGLE, eposy AS SINGLE, etyp AS INTEGER, elifetime AS INTEGER)
DECLARE SUB ExplosionLayer
DECLARE SUB MainLoop
DECLARE SUB UpdateNextBlocks
DECLARE SUB DrawNextBlocksBombs
DECLARE SUB UpdateNextBombs
DECLARE SUB DrawShipOrnament (startx AS INTEGER, starty AS INTEGER, orn_type AS INTEGER, orn_color_border AS UINTEGER, orn_color_fill AS UINTEGER)
DECLARE SUB DrawLevelShips
DECLARE SUB CommenceNewPhase
DECLARE SUB DesignLevel
DECLARE SUB InputName (mode AS INTEGER, ypos AS INTEGER)
DECLARE SUB StartNewLevel
DECLARE SUB StartNewClassicLevel
DECLARE SUB DrawStars (mode AS INTEGER)
DECLARE SUB MainMenu
DECLARE SUB Options
DECLARE SUB InitiateTextMessage (tx AS INTEGER, ty AS INTEGER, tstring AS STRING, ttime AS INTEGER)
DECLARE SUB DisplayTextMessage
DECLARE SUB WriteHighScore (mode AS INTEGER)
DECLARE SUB ReadHighScore ()
DECLARE SUB neoENCpass (Offset AS ANY PTR, Length AS INTEGER, password AS STRING)
DECLARE SUB neoENCdepass (Offsett AS ANY PTR, Lengthh AS INTEGER, passsword AS STRING) 

DECLARE SUB Recolorize_Normal ( img As ANY Ptr, col As UInteger, h As Integer, w As Integer)        
DECLARE SUB Recolorize_Special1 ( img As ANY Ptr, col As UInteger, h As Integer, w As Integer)        
DECLARE SUB Recolorize_Special2 ( img As ANY Ptr, col As UInteger, h As Integer, w As Integer)        
DECLARE SUB Recolorize_Special3 ( img As ANY Ptr, col As UInteger, h As Integer, w As Integer)        

DECLARE SUB setSoundVolume
DECLARE SUB playsample (plsnd as integer ptr)

DIM SHARED sprite(26) AS ANY PTR
DIM SHARED bigsprite(20) AS ANY PTR
DIM SHARED text_message(12) AS ANY PTR
DIM SHARED menu_image AS ANY PTR
DIM SHARED sidenebula(2) AS ANY PTR
DIM SHARED FullScreenBuffer AS ANY PTR

DIM SHARED big_ship_sprite AS ANY PTR

DIM SHARED row_size(50) AS INTEGER
DIM SHARED bgrcolor AS UINTEGER
DIM SHARED workpage AS INTEGER
DIM SHARED FPS2 AS INTEGER, FPS AS INTEGER, starttime_FPSCount AS DOUBLE, starttimer AS DOUBLE
Dim SHARED frameintvl As Double = 1.0/fpslimit
Dim SHARED sleepintvl As Integer
DIM SHARED AS INTEGER Frame1, Frame2, Frame3, Frame4, Frame5, DropBlock_FrameValue
Dim SHARED As IMAGE Ptr img8, img16
DIM SHARED AS INTEGER MenuPos
DIM SHARED AS INTEGER ornament_typ
Dim SHARED As Single xZoom,yZoom,Rotate
DIM SHARED AS SINGLE MenuZoom(6)
DIM SHARED AS INTEGER menuypos
DIM SHARED AS INTEGER CountGameOver, GameOver, GameMode
DIM SHARED AS INTEGER KeyFree, cur_level, start_blocks, level_demarcation_line, numofrows, blocksprite, current_block_max_position, current_block_type, current_block_position, dropping_object, freez_movement
DIM SHARED AS UINTEGER block_color
DIM SHARED AS INTEGER LineClearingStatus, Count_Deletion_Animation
DIM SHARED LineToDelete(100) AS INTEGER
DIM SHARED misc_random_number AS INTEGER
DIM SHARED MoveScreen AS INTEGER
DIM SHARED AS INTEGER new_blocksprite, new_block_type, new_bomb_type
DIM SHARED AS INTEGER countstart_level, countend_level, countend_game, new_dropping_object, count_drop
DIM SHARED AS INTEGER count_cleared_lines_total, count_cleared_lines_level, count_current_cleared_lines, speedup_after_numrows, count_clearing_lines, nebulastartx 
DIM SHARED AS INTEGER Score, AddToScore, MoveSaucerDirec, MoveSaucer, playagain
DIM SHARED AS STRING zeros, ship_name, playername, highname
DIM SHARED textarray(20) AS STRING

DIM SHARED AS UINTEGER Wall_Color, BackG_Color, BackG_Color2, BackG_BorderColor
DIM SHARED AS UINTEGER Block_Color1, Block_Color2, Block_Color3

DIM SHARED AS INTEGER CameraX, CameraY, nebulamov

' The playfield elements are drawn from a CENTER X
' coordinate and starting Y coordinate.
DIM SHARED AS INTEGER PlayFieldMidX
DIM SHARED AS INTEGER PlayFieldStartY
DIM SHARED AS INTEGER GridSize
DIM SHARED AS INTEGER playfield_maxwidth

DIM SHARED sample(8) AS INTEGER PTR

' Options variables
DIM SHARED AS INTEGER GraphicMode, SFXVolume, PlayField_Backg, SetVol, PlaySound
' Mouse varibles
DIM SHARED AS INTEGER mousex, mousey, mbutton

DIM SHARED falling_block(8) AS BlockTyp
DIM SHARED falling_bomb(12) AS BlockTyp
DIM SHARED field_block(50,-2 TO 100) AS BlockTyp
DIM SHARED Particle(numofParticles) AS ParticleTyp
DIM SHARED Explosion(numofExplosions) AS ParticleTyp
DIM SHARED Star(numofstars) AS ParticleTyp
DIM SHARED InGame_Message AS ParticleTyp

DIM SHARED Font1 AS FontType

DIM SHARED linel(100) AS ParticleTyp

Convert8bit16bit

SCREENRES 640, 480, 16, 2, GFX_WINDOWED
SCREENSET 1, 0
SETMOUSE 50,50,0

RANDOMIZE TIMER

PlaySound = TRUE
FSOUND_Init(44100, 16, 0) 
IF FSOUND_Init(44100, 16, 0) = 0 THEN PlaySound = FALSE
IF PlaySound = TRUE THEN
sample(1)=FSOUND_SAMPLE_Load(FSOUND_FREE,"mp3/2.mp3",0,0,0)
sample(2)=FSOUND_SAMPLE_Load(FSOUND_FREE,"mp3/4.mp3",0,0,0)
sample(3)=FSOUND_SAMPLE_Load(FSOUND_FREE,"mp3/0.mp3",0,0,0)
sample(4)=FSOUND_SAMPLE_Load(FSOUND_FREE,"mp3/8.mp3",0,0,0)
END IF

FOR c_sprite AS INTEGER = 1 TO 26
sprite(c_sprite) = IMAGECREATE (32, 32)
IF c_sprite < 21 THEN bigsprite(c_sprite) = IMAGECREATE (32, 32)
NEXT c_sprite

FOR count_tm AS INTEGER = 1 TO 7
text_message(count_tm) = IMAGECREATE (210, 26)
NEXT count_tm
text_message(8) = IMAGECREATE (450, 100)
text_message(9) = IMAGECREATE (450, 100)
text_message(10) = IMAGECREATE (450, 100)
text_message(11) = IMAGECREATE (450, 100)
text_message(12) = IMAGECREATE (250, 100)

menu_image = IMAGECREATE (640, 480)

sidenebula(1) = IMAGECREATE (300, 480)
sidenebula(2) = IMAGECREATE (300, 480)

CameraX = 0
CameraY = 0
LoadGraphics

GraphicMode = 1
PlayField_Backg = TRUE
SFXVolume = 3

FOR initstar AS INTEGER = 1 TO numofstars
    Star(initstar).X = INT(RND * 640) + 1
    Star(initstar).Y = INT(RND * 480) + 1
    Star(initstar).Typ = INT(RND * 6) + 1
    Star(initstar).YSpeed = (INT(RND * 20) +1)/10
NEXT initstar

restart:
MainMenu
repeatloop:
MainLoop
IF GameMode = 2 AND playagain = TRUE THEN goto repeatloop:
'IF GameOver = FALSE THEN CommenceNewPhase
goto restart:

SUB MainLoop
    
DO

starttimer = Timer

FPS = FPS + 1                 
if StartTime_FPSCount + 1 < timer then
 FPS2 = FPS
 FPS = 0
 StartTime_FPSCount = timer
end if

screenlock 
screenset workpage, workpage xor 1

Frame1 = (Frame1 MOD 40) + 1
Frame2 = (Frame2 MOD DropBlock_FrameValue) + 1
Frame3 = (Frame3 MOD 8) + 1
Frame4 = (Frame4 MOD 3) + 1
Frame5 = (Frame5 MOD 5) + 1

GETMOUSE mousex, mousey,,mbutton

LINE (0,0)-(ScrnXmax-1, ScrnYmax-1),RGB(0,0,0),BF

IF GameMOde = 1 THEN
PUT (0-nebulastartx,nebulamov),sidenebula(1), TRANS
PUT (0-nebulastartx,nebulamov+480),sidenebula(1), TRANS
PUT (540+nebulastartx,nebulamov),sidenebula(2), TRANS
PUT (540+nebulastartx,nebulamov+480),sidenebula(2), TRANS
nebulamov = nebulamov - 1
IF nebulamov <=-480 THEN nebulamov = 0
IF nebulastartx > 0 AND countend_game = 0 THEN nebulastartx = nebulastartx - 5
END IF

DrawStars 3

IF GameMode = 2 THEN
    
        PrintFont 370+15 - CameraX, 40 - CameraY, "H I G H  S C O R E S", Font1, 1,1
    FOR tar AS INTEGER = 1 TO 10
        PrintFont 390+15-CameraX, 60 + tar * 15-CameraY, textarray(tar), Font1, 1,1
    NEXT tar
    FOR ar AS INTEGER = 11 TO 20
        PrintFont 460+15-CameraX, 60 + (ar - 10) * 15-CameraY, textarray(ar), Font1, 1,1
    NEXT ar
    
    PrintFont 390+15-CameraX,280-CameraY, "SCORE: "+zeros+STR$(Score), Font1, 1, 1
    PrintFont 390+15-CameraX,300-CameraY, "LINES CLEARED:"+STR$(count_cleared_lines_total), Font1, 1, 1
    PrintFont 390+15-CameraX,320-CameraY, "LEVEL:"+STR$(cur_level), Font1, 1, 1
    PrintFont 130+15-CameraX,12-CameraY, "NEXT PIECE:", Font1, 1, 1

END IF

zeros =""
IF countstart_level<121 AND GameMode = 1 AND countend_game = 0THEN
IF Score > 9 THEN zeros = "000"
IF Score > 99 THEN zeros = "00"
IF Score > 999 and Score<9999 THEN zeros = "0"
PrintFont 70,200, "SCORE: "+zeros+STR$(Score), Font1, 1, 1
PrintFont 70,220, "INVADING: " + ship_name, Font1, 1, 1
PrintFont 70,210, "LINES CLEARED:"+STR$(count_cleared_lines_total), Font1, 1, 1
'PrintFont 70,240, "DROP-BLOCK:"+STR$(DropBlock_FrameValue), Font1, 1, 1

END IF

IF count_drop = 10 THEN
    count_drop = 0
    InitiateTextMessage 438, 230, "STOP WASTING TIME!", 100
END IF

' First level start control related dirt.
IF countstart_level>120 AND Frame1 > 20 THEN PrintFont 280,450, "PRESS ENTER TO SKIP", Font1, 1, 1
IF countstart_level>120 AND MULTIKEY(SC_ENTER) THEN 
    countstart_level = 120
    InGame_Message.Locked = FALSE
END IF
' ************

DrawLevel
IF GameMode = 1 THEN
    DisplayTextMessage
    DrawLevelShips
END IF

'LOCATE 3,1
'PRINT mousex, mousey

IF GameMode = 1 THEN MultiPut(,500-CameraX,200+nebulastartx+MoveSaucer,sprite(23), 3,3,0,0, @trans)

IF MoveSaucerDirec = 1 AND Frame3 = 1 THEN MoveSaucer = MoveSaucer + 1
IF MoveSaucerDirec = 2 AND Frame3 = 1 THEN MoveSaucer = MoveSaucer - 1
IF MoveSaucer = 5 THEN MoveSaucerDirec = 2
IF MoveSaucer = -5 THEN MoveSaucerDirec = 1

IF MULTIKEY(SC_1) THEN ornament_typ = 1
IF MULTIKEY(SC_2) THEN ornament_typ = 2
IF MULTIKEY(SC_3) THEN ornament_typ = 3
IF MULTIKEY(SC_4) THEN ornament_typ = 4
IF MULTIKEY(SC_5) THEN ornament_typ = 5
IF MULTIKEY(SC_6) THEN ornament_typ = 6
IF MULTIKEY(SC_7) THEN ornament_typ = 7
IF MULTIKEY(SC_8) THEN ornament_typ = 8
IF MULTIKEY(SC_9) THEN ornament_typ = 9

'LOCATE 1,1
'PRINT FPS2
'LOCATE 2,1
'PRINT mousex, mousey

'DrawShipOrnament mousex, mousey, ornament_typ, Wall_Color, Wall_Color
'MultiPut(,mousex,mousey,sidenebula(1), 32,12,PI/2,0, @trans)

'LINE (mousex,mousey)-(mousex+22, mousey+22),RGB(250,255,255),BF
'PAINT (mousex+5, mousey+5),  RGB(250,255,255),  RGB(250,255,255)
'MultiPut(,mousex-CameraX,mousey-CameraY,text_message(1), 2,2,0,0, @trans)

IF count_cleared_lines_level > speedup_after_numrows THEN
    count_cleared_lines_level = 0
    IF GameMode = 2 THEN 
        IF cur_level<11 THEN 
            cur_level = cur_level + 1
            SELECT CASE cur_level
            CASE 2
                Wall_Color = RGB(70,0,10)
                BackG_Color = RGB(170,65,20)
                BackG_BorderColor = RGB(140,50,20)
            CASE 3
                Wall_Color = RGB(0,50,10)
                BackG_Color = RGB(45,150,10)
                BackG_BorderColor = RGB(40,120,10)
            CASE 4
                Wall_Color = RGB(117-100,0,172-100)
                BackG_BorderColor = RGB(149-80,0,218-100)
                BackG_Color = RGB(179-100,15,255-100)
            CASE 5
                Wall_Color = RGB(176-100,116-100,0)
                BackG_BorderColor = RGB(198-100,130-100,0)
                BackG_Color = RGB(224-100,148-100,0)
            CASE 6
                Wall_Color = RGB(0,136-90,136-90)
                BackG_BorderColor = RGB(0,136-70,136-70)
                BackG_Color = RGB(0,136-50,136-50)
            CASE 7
                Wall_Color = RGB(94-20,93-20,0)
                BackG_BorderColor = RGB(94,93,0)
                BackG_Color = RGB(94+20,93+20,0)
            CASE 8
                Wall_Color = RGB(94,38,0)
                BackG_BorderColor = RGB(94+20,38+20,0)
                BackG_Color = RGB(94+40,38+40,0)
            CASE 9
                Wall_Color = RGB(0,58,90)
                BackG_BorderColor = RGB(0,58+20,90+20)
                BackG_Color = RGB(0,58+40,90+40)
            CASE 10
                Wall_Color = RGB(0,94,75)
                BackG_BorderColor = RGB(0,94+20,75+20)
                BackG_Color = RGB(0,94+40,75+40)
            CASE 11
                Wall_Color = RGB(49,0,94)
                BackG_BorderColor = RGB(49+20,0,94+20)
                BackG_Color = RGB(49+40,0,94+40)
            END SELECT
        END IF
        DropBlock_FrameValue = DropBlock_FrameValue - 4
    END IF
    DropBlock_FrameValue = DropBlock_FrameValue - 1
    
    IF DropBlock_FrameValue < 5 THEN DropBlock_FrameValue = 5

END IF

' Draw falling pieces and move them if no lines are being
' cleared (flashing animation).
IF (LineClearingStatus = 0 AND GameOver = FALSE AND countend_level = 0) THEN 

' According to falling object, execute
' the appropriate subs.
IF dropping_object = BLOCK THEN 
    UpdateBlocks ' Update blocks.
    MovePiece    ' Move and collide them.
    DrawBlocks   ' Draw them.
END IF
IF dropping_object = BOMB THEN 
    UpdateBombs
    MoveBomb
    DrawBombs
END IF

END IF

IF (GameOver = FALSE AND countstart_level = 0 AND countend_level = 0) THEN DrawNextBlocksBombs
IF countstart_level > 0 THEN countstart_level = countstart_level - 1

IF countend_level > 0 THEN
    IF countend_level = 1 THEN
        InitiateTextMessage 438, 230, "THE SHIP IS OURS!", 100
        playsample (sample(1))
        IF new_dropping_object = BLOCK THEN
        FOR count_newblock AS INTEGER = 5 TO 8
            playsample (sample(4))
            FOR init_part AS INTEGER = 1 TO 8
                InitiateParticle PlayFieldMidX-(GridSize+1)-(playfield_maxwidth/2)*(GridSize+1)+falling_block(count_newblock).Column*(GridSize+1)+4, falling_block(count_newblock).Row*(GridSize+1)+PlayFieldStartY+4, 1, 100
            NEXT init_part
        NEXT count_newblock
        END IF
        IF new_dropping_object = BOMB THEN
        FOR count_newblock AS INTEGER = 7 TO 12
            playsample (sample(1))
            FOR init_part AS INTEGER = 1 TO 8
                InitiateParticle PlayFieldMidX-(GridSize+1)-(playfield_maxwidth/2)*(GridSize+1)+falling_bomb(count_newblock).Column*(GridSize+1)+4, falling_bomb(count_newblock).Row*(GridSize+1)+PlayFieldStartY+4, 1, 100
            NEXT init_part
        NEXT count_newblock
        END IF
    END IF
    
    Score = Score + AddToScore
    
    countend_level = countend_level + 1

    IF Frame3 = 1 OR Frame3 = 3 THEN
    FOR count_columns AS INTEGER = 1 TO playfield_maxwidth
        IF count_clearing_lines>0 AND field_block(count_columns, count_clearing_lines).Status<>WALL THEN field_block(count_columns, count_clearing_lines).Status = CLEARED
    NEXT count_columns
    IF count_clearing_lines>0 THEN count_clearing_lines = count_clearing_lines - 1
    END IF
END IF

ExplosionLayer
ParticleLayer

' Levels exchange animation
IF count_clearing_lines = 0 AND countend_level > 1 THEN
    IF CameraY <= 0 THEN CameraY = CameraY - 10
    IF CameraY < -480 THEN 
        CameraY = 480
        cur_level = cur_level + 1
        Score = Score + 1000
        IF cur_level = 6 THEN
            xZoom = 0
            yZoom = 0
        END IF
        IF cur_level < 6 THEN StartNewLevel
    END IF
END IF

IF cur_level = 6 THEN 
    CameraY = 490
    countend_game = countend_game + 1
    IF xZoom < 2 THEN xZoom = xZoom + 0.2
    IF yZoom < 2 THEN yZoom = yZoom + 0.2
    MultiPut(,350+xZoom*40, 167,text_message(12), xZoom,yZoom,0,0, @trans)
    IF countend_game = 50 THEN InitiateTextMessage 440, 225, "THAT WOULD BE IT.", 100
    IF countend_game = 250 THEN InitiateTextMessage 480, 225, "THANKS.", 100
    IF countend_game = 490 THEN InitiateTextMessage 420, 225, "NIPPY HERE IN SPACE, EH?", 100
    IF countend_game = 670 THEN InitiateTextMessage 440, 225, "WELL, I'M OFF. BYE!", 130
    IF countend_game > 830 THEN 
        nebulastartx = nebulastartx + 20
        PrintFont 270, 405, "PRESS ESC TO END", Font1, 1, 1
    END IF
END IF


IF CameraY > 0 AND MoveScreen = FALSE THEN CameraY = CameraY - 10 

IF GameOver = TRUE AND GameMode = 1 THEN
    IF xZoom < 5 THEN xZoom = xZoom + 0.1
    IF yZoom < 5 THEN yZoom = yZoom + 0.1
    CountGameOver = CountGameOver + 1
    LineClearingStatus = 1
    MultiPut(,320-CameraX+xZoom*40,397-CameraY,text_message(7), xZoom,yZoom,Rotate,0, @trans)
END IF
IF GameOver = TRUE AND GameMode = 2 THEN
    IF xZoom < 3 THEN xZoom = xZoom + 0.2
    IF yZoom < 3 THEN yZoom = yZoom + 0.2
    CountGameOver = CountGameOver + 1
    LineClearingStatus = 1
    MultiPut(,450-CameraX+xZoom*40,397-CameraY,text_message(7), xZoom,yZoom,Rotate,0, @trans)
END IF

'PrintFont 40,60, "TESTING 1234", Font1, 1, 1

'rotate=0
'xZoom=Cos(Rotate*2)*2+2.1
'yZoom=Sin(Rotate*3)*2+2.1
'MultiPut(,30,30,sprite(2),5,5,Rotate,0, @trans) 
  
' Line clearing checkup.

' Initial line clearing after a piece is dropped.
' If not lines are to be cleared LineClearingStatus 
' is equalized with 7. This sub is executed only when
' LineClearingStatus = 1
IF LineClearingStatus = 1 THEN CheckLinesToClear

' If lines are cleared LineClearingStatus is equalized with
' 3 and the following sub is executed. It flashes the
' deleting lines and equalizes LineClearingStatus with 4
' after a certain amount of time.
IF LineClearingStatus = 3 THEN DoLineDeletionAnimation

' When LineClearingStatus = 4 this sub is executed which moves
' the blocks in the playfiled up or down depending on the
' demarcation line (Super Tetris style).
IF LineClearingStatus = 4 THEN PushLinesUp

' When LineClearingStatus is 5 we execute this sub which
' checks the entire field for lines to delete (this happens
' because of the irregular shape of the playfield). If
' this is the case, LineClearingStatus is 3 again and
' we go over the entire procedure again.
IF LineClearingStatus = 5 THEN CheckEntireFieldForDeletion

' If the line clearing procedure has ended, spawn new
' piece in the playfield or bomb (randomization).
IF LineClearingStatus = 7 THEN
    
    Score = Score + AddToScore
    AddToScore = 0
    count_current_cleared_lines = 0
            
    dropping_object = new_dropping_object
    
    new_dropping_object = BLOCK
    misc_random_number = INT(RND * 12) + 1
    IF misc_random_number = 10 THEN new_dropping_object = BOMB
    IF GameMode = 2 THEN new_dropping_object = BLOCK
    freez_movement = 0
    IF dropping_object = BLOCK THEN ResetPiece
    IF dropping_object = BOMB THEN ResetBomb
    LineClearingStatus = 0
END IF

IF (CameraY < 0 AND MoveScreen = TRUE AND countstart_level<121) THEN 
    CameraY = CameraY + 10
    IF CameraY >= 0 THEN 
        CameraY = 0
        MoveScreen = FALSE
    END IF
END IF

IF (GameMode = 2 AND CameraX < 0 AND MoveScreen = TRUE) THEN 
    CameraX = CameraX + 20
    IF CameraX >= 0 THEN 
        CameraX = 0
        MoveScreen = FALSE
    END IF
END IF

workpage xor = 1
screenunlock

' Frame limiter!
sleepintvl = Cint((starttimer + frameintvl - Timer)*1000.0)
If sleepintvl>1 Then 
    Sleep sleepintvl, 1
else 
    sleep 1, 1
end if

goback:
  
LOOP UNTIL (countstart_level<121 AND GameOver = FALSE AND MULTIKEY(SC_ESCAPE)) or CountGameOver = 160

IF CountGameOver = 160 THEN 
    CameraY = 0
    WriteHighScore GameMode
    EXIT SUB
END IF

DO

IF countend_game > 0 THEN 
    CameraY = 0
    WriteHighScore GameMode
    EXIT SUB
END IF
    
starttimer = Timer

screenlock 
screenset workpage, workpage xor 1

IF GameMode = 1 THEN MultiPut(,455-CameraX,430-CameraY,text_message(8), 2,2,0,0, @trans)
IF GameMode = 2 THEN MultiPut(,598-CameraX,430-CameraY,text_message(8), 2,2,0,0, @trans)

'PrintFont 290, 410, "QUIT(Y/N)?", Font1,1,1

workpage xor = 1
screenunlock

sleepintvl = Cint((starttimer + frameintvl - Timer)*1000.0)
If sleepintvl>1 Then 
    Sleep sleepintvl, 1
else 
    sleep 1, 1
end if

IF MULTIKEY(SC_N) THEN GOTO goback:

LOOP UNTIL MULTIKEY(SC_Y)
playagain = FALSE
CameraY = 0

END SUB

SUB LoadGraphics
    
' A sub that loads the game graphics.
    
'BLOAD "graphics/graphics_24bit.bmp", 0
Put (0, 0), img16, PSET

LoadFont "", Font1, 2

bgrcolor = POINT(1,1)
GET (8, 0)-(15, 7), sprite(1)
GET (8, 8)-(15, 15), sprite(2)
GET (112, 9)-(113+7, 9+7), sprite(17)
GET (75, 0)-(75+7, 0+7), sprite(18)
GET (34,0)-(45,7),sprite(19)
GET (34,8)-(45,15),sprite(20)
GET (18,0)-(28,7),sprite(21)
GET (18,8)-(28,15),sprite(22)
GET (47,0)-(64,8),sprite(23)
GET (24,48)-(39,55),sidenebula(1)

PUT (8,0), sprite(1), PSET
PSET (8+4,0+3), RGB(255,255,255)
GET (8, 0)-(15, 7), sprite(1)
PAINT (12,1), RGB(255,0,0), bgrcolor
PSET (8+2,0+5), RGB(255,0,0)
PSET (8+1,0+6), RGB(255,0,0)
PSET (8+0,0+7), RGB(255,0,0)
'PSET (8+4,0+5), RGB(255,255,255)
PSET (8+3,0+6), RGB(255,0,0)
PSET (8+2,0+7), RGB(255,0,0)
'PSET (8+3,0+5), RGB(255,255,255)
PSET (8+4,0+6), RGB(255,0,0)
PSET (8+5,0+7), RGB(255,0,0)
PSET (8+5,0+5), RGB(255,0,0)
PSET (8+6,0+6), RGB(255,0,0)
PSET (8+7,0+7), RGB(255,0,0)
GET (8,0)-(15,7), sprite(3)

PUT (8,0), sprite(1), PSET
PSET (8+4,0+3), RGB(255,255,255)
PAINT (12,1), RGB(0,255,0), bgrcolor
PSET (8+2,0+5), RGB(0,255,0)
PSET (8+1,0+6), RGB(0,255,0)
PSET (8+0,0+7), RGB(0,255,0)
'PSET (8+4,0+5), RGB(0,255,0)
PSET (8+3,0+6), RGB(0,255,0)
PSET (8+2,0+7), RGB(0,255,0)
'PSET (8+3,0+5), RGB(0,255,0)
PSET (8+4,0+6), RGB(0,255,0)
PSET (8+5,0+7), RGB(0,255,0)
PSET (8+5,0+5), RGB(0,255,0)
PSET (8+6,0+6), RGB(0,255,0)
PSET (8+7,0+7), RGB(0,255,0)
GET (8,0)-(15,7), sprite(4)

PUT (8,0), sprite(1), PSET
PSET (8+4,0+3), RGB(255,255,255)
PAINT (12,1), RGB(100,100,255), bgrcolor
PSET (8+2,0+5), RGB(100,100,255)
PSET (8+1,0+6), RGB(100,100,255)
PSET (8+0,0+7), RGB(100,100,255)
'PSET (8+4,0+5), RGB(100,100,255)
PSET (8+3,0+6), RGB(100,100,255)
PSET (8+2,0+7), RGB(100,100,255)
'PSET (8+3,0+5), RGB(100,100,255)
PSET (8+4,0+6), RGB(100,100,255)
PSET (8+5,0+7), RGB(100,100,255)
PSET (8+5,0+5), RGB(100,100,255)
PSET (8+6,0+6), RGB(100,100,255)
PSET (8+7,0+7), RGB(100,100,255)
GET (8,0)-(15,7), sprite(5)

PUT (8,0), sprite(1), PSET
PSET (8+4,0+3), RGB(255,255,255)
PAINT (12,1), RGB(0,255,255), bgrcolor
PSET (8+2,0+5), RGB(0,255,255)
PSET (8+1,0+6), RGB(0,255,255)
PSET (8+0,0+7), RGB(0,255,255)
'PSET (8+4,0+5), RGB(0,255,255)
PSET (8+3,0+6), RGB(0,255,255)
PSET (8+2,0+7), RGB(0,255,255)
'PSET (8+3,0+5), RGB(0,255,255)
PSET (8+4,0+6), RGB(0,255,255)
PSET (8+5,0+7), RGB(0,255,255)
PSET (8+5,0+5), RGB(0,255,255)
PSET (8+6,0+6), RGB(0,255,255)
PSET (8+7,0+7), RGB(0,255,255)
GET (8,0)-(15,7), sprite(6)

PUT (8,0), sprite(1), PSET
PSET (8+4,0+3), RGB(255,255,255)
PAINT (12,1), RGB(255,255,0), bgrcolor
PSET (8+2,0+5), RGB(255,255,0)
PSET (8+1,0+6), RGB(255,255,0)
PSET (8+0,0+7), RGB(255,255,0)
'PSET (8+4,0+5), RGB(255,255,0)
PSET (8+3,0+6), RGB(255,255,0)
PSET (8+2,0+7), RGB(255,255,0)
'PSET (8+3,0+5), RGB(255,255,0)
PSET (8+4,0+6), RGB(255,255,0)
PSET (8+5,0+7), RGB(255,255,0)
PSET (8+5,0+5), RGB(255,255,0)
PSET (8+6,0+6), RGB(255,255,0)
PSET (8+7,0+7), RGB(255,255,0)
GET (8,0)-(15,7), sprite(7)

PUT (8,0), sprite(1), PSET
PSET (8+4,0+3), RGB(255,255,255)
PAINT (12,1), RGB(240,0,240), bgrcolor
PSET (8+2,0+5), RGB(240,0,240)
PSET (8+1,0+6), RGB(240,0,240)
PSET (8+0,0+7), RGB(240,0,240)
'PSET (8+4,0+5), RGB(240,0,240)
PSET (8+3,0+6), RGB(240,0,240)
PSET (8+2,0+7), RGB(240,0,240)
'PSET (8+3,0+5), RGB(240,0,240)
PSET (8+4,0+6), RGB(240,0,240)
PSET (8+5,0+7), RGB(240,0,240)
PSET (8+5,0+5), RGB(240,0,240)
PSET (8+6,0+6), RGB(240,0,240)
PSET (8+7,0+7), RGB(240,0,240)
GET (8,0)-(15,7), sprite(8)

PUT (8,0), sprite(1), PSET
PSET (8+4,0+3), RGB(255,255,255)
PAINT (12,1), RGB(255,172,0), bgrcolor
PSET (8+2,0+5), RGB(255,172,0)
PSET (8+1,0+6), RGB(255,172,0)
PSET (8+0,0+7), RGB(255,172,0)
'PSET (8+4,0+5), RGB(255,172,0)
PSET (8+3,0+6), RGB(255,172,0)
PSET (8+2,0+7), RGB(255,172,0)
'PSET (8+3,0+5), RGB(255,172,0)
PSET (8+4,0+6), RGB(255,172,0)
PSET (8+5,0+7), RGB(255,172,0)
PSET (8+5,0+5), RGB(255,172,0)
PSET (8+6,0+6), RGB(255,172,0)
PSET (8+7,0+7), RGB(255,172,0)
GET (8,0)-(15,7), sprite(9)

PUT (8,0), sprite(2), PSET
PAINT (12,1), RGB(255,0,0), bgrcolor
PSET (8+1,0+5), RGB(255,0,0)
PSET (8+0,0+6), RGB(255,0,0)
PSET (8+1,0+7), RGB(255,0,0)
PSET (8+6,0+5), RGB(255,0,0)
PSET (8+7,0+6), RGB(255,0,0)
PSET (8+6,0+7), RGB(255,0,0)
GET (8,0)-(15,7), sprite(10)

PUT (8,0), sprite(2), PSET
PAINT (12,1), RGB(0,255,0), bgrcolor
PSET (8+1,0+5), RGB(0,255,0)
PSET (8+0,0+6), RGB(0,255,0)
PSET (8+1,0+7), RGB(0,255,0)
PSET (8+6,0+5), RGB(0,255,0)
PSET (8+7,0+6), RGB(0,255,0)
PSET (8+6,0+7), RGB(0,255,0)
GET (8,0)-(15,7), sprite(11)

PUT (8,0), sprite(2), PSET
PAINT (12,1), RGB(100,100,255), bgrcolor
PSET (8+1,0+5), RGB(100,100,255)
PSET (8+0,0+6), RGB(100,100,255)
PSET (8+1,0+7), RGB(100,100,255)
PSET (8+6,0+5), RGB(100,100,255)
PSET (8+7,0+6), RGB(100,100,255)
PSET (8+6,0+7), RGB(100,100,255)
GET (8,0)-(15,7), sprite(12)

PUT (8,0), sprite(2), PSET
PAINT (12,1), RGB(0,255,255), bgrcolor
PSET (8+1,0+5), RGB(0,255,255)
PSET (8+0,0+6), RGB(0,255,255)
PSET (8+1,0+7), RGB(0,255,255)
PSET (8+6,0+5), RGB(0,255,255)
PSET (8+7,0+6), RGB(0,255,255)
PSET (8+6,0+7), RGB(0,255,255)
GET (8,0)-(15,7), sprite(13)

PUT (8,0), sprite(2), PSET
PAINT (12,1), RGB(255,255,0), bgrcolor
PSET (8+1,0+5), RGB(255,255,0)
PSET (8+0,0+6), RGB(255,255,0)
PSET (8+1,0+7), RGB(255,255,0)
PSET (8+6,0+5), RGB(255,255,0)
PSET (8+7,0+6), RGB(255,255,0)
PSET (8+6,0+7), RGB(255,255,0)
GET (8,0)-(15,7), sprite(14)

PUT (8,0), sprite(2), PSET
PAINT (12,1), RGB(240,0,240), bgrcolor
PSET (8+1,0+5), RGB(240,0,240)
PSET (8+0,0+6), RGB(240,0,240)
PSET (8+1,0+7), RGB(240,0,240)
PSET (8+6,0+5), RGB(240,0,240)
PSET (8+7,0+6), RGB(240,0,240)
PSET (8+6,0+7), RGB(240,0,240)
GET (8,0)-(15,7), sprite(15)

PUT (8,0), sprite(2), PSET
PAINT (12,1), RGB(255,172,0), bgrcolor
PSET (8+1,0+5), RGB(255,172,0)
PSET (8+0,0+6), RGB(255,172,0)
PSET (8+1,0+7), RGB(255,172,0)
PSET (8+6,0+5), RGB(255,172,0)
PSET (8+7,0+6), RGB(255,172,0)
PSET (8+6,0+7), RGB(255,172,0)
GET (8,0)-(15,7), sprite(16)

FOR count_bigsprite AS INTEGER = 1 TO 16
LINE (0,0)-(400,400), RGB(255,0,255), BF
PUT (8,8), sprite(count_bigsprite), PSET
GET (8-1,8-1)-(15+2,8+8), bigsprite(count_bigsprite)
LINE (0,0)-(400,400), RGB(255,0,255), BF
Multiput (,8,8, bigsprite(count_bigsprite), 2,2,0,0, @trans)
GET (8-8,8-8)-(15+8,8+8), bigsprite(count_bigsprite)
IF count_bigsprite < 10 THEN Recolorize_Special3 bigsprite(count_bigsprite), count_bigsprite, 17, 17
IF count_bigsprite > 9 THEN Recolorize_Special3 bigsprite(count_bigsprite), count_bigsprite-7, 17, 17

NEXT count_bigsprite

LINE (0,0)-(400,400), RGB(255,0,255), BF
PrintFont 4,10, "START NEW GAME", Font1, 1, 2
PrintFont 4,30, "PLAY CLASSIC TETRIS", Font1, 1, 2
PrintFont 4,60, "OPTIONS", Font1, 1, 2
PrintFont 4,90, "HELP", Font1, 1, 2
PrintFont 4,120, "HIGH SCORES", Font1, 1, 2
PrintFont 4,138, "QUIT", Font1, 1, 2
PrintFont 4,180, "QUIT(Y/N)?", Font1, 1, 2
PrintFont 4,210, "I N V A T R I S", Font1, 1, 2
PrintFont 4,240, "O P T I O N S", Font1, 1, 2
PrintFont 4,280, "HIGH SCORES", Font1, 1, 2
PrintFont 4,380, "T H E  E N D", Font1, 1, 2

PrintFont 4,150, "G A M E  O V E R", Font1, 1, 2

GET (0,6)-(200,21), text_message(1)
GET (0,30-6)-(200,30+11), text_message(2)
GET (0,60-6)-(200,60+11), text_message(3)
GET (0,90-6)-(200,90+11), text_message(6)
GET (0,120-6)-(200,120+11), text_message(4)
GET (0,151-6)-(200,151+11), text_message(7)
GET (0,180-6)-(200,180+11), text_message(8)
GET (0,210-6)-(200,210+11), text_message(9)
GET (0,240-6)-(200,240+11), text_message(10)
GET (0,280-6)-(200,280+11), text_message(11)
GET (0,380-6)-(200,380+11), text_message(12)

GET (0,138-6)-(200,138+11), text_message(5)

LINE (0,0)-(640,480), RGB(255,0,255), BF

PUT (0+9*10,0+9*10), sprite(5)
PUT (0+9*11,0+9*10), sprite(7)
PUT (0+9*12,0+9*10), sprite(6)
PUT (0+9*11,0+9*11), sprite(3)

LINE (0+9*11+4,0+9*11+12)-(0+9*11+4,0+9*11+16), RGB(255,255,255), BF
LINE (0+9*11+4,0+9*11+18)-(0+9*11+4,0+9*11+22), RGB(255,255,255), BF

LINE (0+9*10,0+9*14)-(8+9*10,8+9*14), RGB(200,200,200), BF
LINE (0+9*10,0+9*14)-(8+9*10,8+9*14), RGB(180,180,180)
LINE (0+9*10,0+9*14)-(8+9*10,8+9*14), RGB(180,180,180), B

LINE (0+9*11,0+9*14)-(8+9*11,8+9*14), RGB(140,140,140), BF
LINE (0+9*11,0+9*14)-(8+9*11,8+9*14), RGB(120,120,120)
LINE (0+9*11,0+9*14)-(8+9*11,8+9*14), RGB(120,120,120), B

LINE (0+9*12,0+9*14)-(8+9*12,8+9*14), RGB(100,100,100), BF
LINE (0+9*12,0+9*14)-(8+9*12,8+9*14), RGB(80,80,80)
LINE (0+9*12,0+9*14)-(8+9*12,8+9*14), RGB(80,80,80), B

LINE (0+9*12,0+9*15)-(8+9*12,8+9*15), RGB(120,120,120), BF
LINE (0+9*12,0+9*15)-(8+9*12,8+9*15), RGB(100,100,100)
LINE (0+9*12,0+9*15)-(8+9*12,8+9*15), RGB(100,100,100), B

LINE (0+9*13,0+9*15)-(8+9*13,8+9*15), RGB(180,180,180), BF
LINE (0+9*13,0+9*15)-(8+9*13,8+9*15), RGB(160,160,160)
LINE (0+9*13,0+9*15)-(8+9*13,8+9*15), RGB(160,160,160), B

GET (0,0)-(200,200), menu_image

LINE (0,0)-(640,480), RGB(255,0,255), BF
MultiPut(,130,300,menu_image, 6,6,3.14*(3/2),0, @trans)

GET (0,0)-(400,400), menu_image

LINE (0,0)-(640,480), RGB(255,0,255), BF
MultiPut(,48,211,sidenebula(1), 32,12,PI/2,0, @trans)
GET (1,0)-(200,479), sidenebula(1)
Recolorize_Special1 sidenebula(1),0,480,199
LINE (0,0)-(640,480), RGB(255,0,255), BF
MultiPut(,0,240,sidenebula(1), 1,1,PI,0, @trans)
GET (0,0)-(199,479), sidenebula(2)

LINE (0,0)-(640,480), RGB(255,0,255), BF
MultiPut(,460-CameraX,80-CameraY,text_message(9), 4,4,0,0, @trans)
GET (77,61)-(497,106), text_message(9)
LINE (0,0)-(640,480), RGB(255,0,255), BF
Recolorize_Normal text_message(9), RGB(180,180,180), 44,419
PUT (77+3,61), text_message(9), TRANS
PUT (77,61+3), text_message(9), TRANS
PUT (77-3,61), text_message(9), TRANS
PUT (77,61-3), text_message(9), TRANS
PUT (77,61), text_message(9), TRANS
Recolorize_Normal text_message(9), RGB(250,250,250), 44,419
PUT (77+1,61), text_message(9), TRANS
PUT (77,61+1), text_message(9), TRANS
PUT (77-1,61), text_message(9), TRANS
PUT (77,61-1), text_message(9), TRANS
Recolorize_Normal text_message(9), RGB(0,0,0), 44,419
PUT (77,61), text_message(9), TRANS
GET (77,61)-(497,106), text_message(9)

LINE (0,0)-(640,480), RGB(255,0,255), BF
MultiPut(,300,100,text_message(10), 2,2,0,0, @trans)
GET (105,88)-(292,114), text_message(10)
Recolorize_Special2 text_message(10), 0, 23, 186

LINE (0,0)-(640,480), RGB(255,0,255), BF
MultiPut(,300,100,text_message(11), 2,2,0,0, @trans)
GET (105,88)-(292,114), text_message(11)
Recolorize_Special2 text_message(11), 0, 23, 186

CLS

END SUB

SUB LoadLevel (llevel AS INTEGER)
    
' A sub that inits each level wideness
' for each row.

SELECT CASE llevel
CASE 1
    
numofrows = 26

FOR count_row AS INTEGER = 1 TO 8
row_size(count_row) = 20   
NEXT count_row

FOR count_row AS INTEGER = 9 TO numofrows
row_size(count_row) = 14    
NEXT count_row

level_demarcation_line = 22
start_blocks = 22
DropBlock_FrameValue = 60
speedup_after_numrows = 5
countend_level = 0
Wall_Color = RGB(245,245,245)
BackG_Color = RGB(65,65,65)
BackG_Color2 = RGB(170,170,170)
ship_name = "ENDEAVOR"
Block_Color1 = RGB(200,200,200)
Block_Color2 = RGB(180,180,180)
Block_Color3 = RGB(150,150,150)

CASE 2
    
numofrows = 28

FOR count_row AS INTEGER = 1 TO 8
row_size(count_row) = 24   
NEXT count_row

FOR count_row AS INTEGER = 9 TO 10
row_size(count_row) = 16   
NEXT count_row

FOR count_row AS INTEGER = 11 TO numofrows
row_size(count_row) = 14    
NEXT count_row

level_demarcation_line = 22
start_blocks = 20
DropBlock_FrameValue = 55
speedup_after_numrows = 5
countend_level = 0

BackG_Color = RGB(84-20,75-20,0)
Wall_Color = RGB(200,180,0)
BackG_Color2 = RGB(230,210,00)
Block_Color1 = RGB(205-20,185-20,0)
Block_Color2 = RGB(205-50,185-50,0)
Block_Color3 = RGB(205-70,185-70,0)
ship_name = "TX MAURUDER"

CASE 3
    
numofrows = 28

FOR count_row AS INTEGER = 1 TO 12
row_size(count_row) = 18   
NEXT count_row

FOR count_row AS INTEGER = 13 TO 30
row_size(count_row) = 14   
NEXT count_row

level_demarcation_line = 22
start_blocks = 19
DropBlock_FrameValue = 45
speedup_after_numrows = 4
countend_level = 0

Wall_Color = RGB(160,0,160)
BackG_Color = RGB(53,0,53)
BackG_Color2 = RGB(210,0,210)
Block_Color1 = RGB(140,0,140)
Block_Color2 = RGB(110,0,110)
Block_Color3 = RGB(90,0,90)
ship_name = "SEELIAN"

CASE 4
    
numofrows = 30

FOR count_row AS INTEGER = 1 TO 2
row_size(count_row) = 24  
NEXT count_row

FOR count_row AS INTEGER = 3 TO 4
row_size(count_row) = 22   
NEXT count_row

FOR count_row AS INTEGER = 5 TO 6
row_size(count_row) = 20   
NEXT count_row

FOR count_row AS INTEGER = 7 TO 8
row_size(count_row) = 18   
NEXT count_row

FOR count_row AS INTEGER = 9 TO 32
row_size(count_row) = 14   
NEXT count_row

level_demarcation_line = 20
start_blocks = 18
DropBlock_FrameValue = 40
speedup_after_numrows = 3
countend_level = 0

Wall_Color = RGB(0,150,0)
BackG_Color = RGB(0,58,0)
BackG_Color2 = RGB(0,190,0)
Block_Color1 = RGB(0,120,0)
Block_Color2 = RGB(0,150,0)
Block_Color3 = RGB(0,170,0)
ship_name = "Q-5"

CASE 5
    
numofrows = 33

FOR count_row AS INTEGER = 1 TO 36
row_size(count_row) = 12  
NEXT count_row

level_demarcation_line = 20
start_blocks = 17
DropBlock_FrameValue = 35
speedup_after_numrows = 3
countend_level = 0

Wall_Color = RGB(0,128,188)
BackG_Color = RGB(0,51,84)
BackG_Color2 = RGB(0,179,255)
Block_Color1 = RGB(0,150,235)
Block_Color2 = RGB(0,120,205)
Block_Color3 = RGB(0,90,175)
ship_name = "INVADER IV"

END SELECT
    
END SUB

SUB DrawLevel
    

' A sub that draws the row edges and block in the playfield.

IF PlayField_Backg = TRUE AND GameMode = 2 THEN LINE (PlayFieldMidX-(playfield_maxwidth/2)*(GridSize+1)-CameraX-2,PlayFieldStartY-CameraY+(GridSize+1)-2)-(PlayFieldMidX+(playfield_maxwidth/2)*(GridSize+1)-CameraX+2,PlayFieldStartY+numofrows*(GridSize+1)-CameraY+(GridSize+1)+2), BackG_Color, BF

FOR count_field_block_row AS INTEGER = 1 TO numofrows
    
    FOR count_field_block_column AS INTEGER = 1 TO playfield_maxwidth
        
        IF field_block(count_field_block_column, count_field_block_row).Status = WALL THEN block_color = RGB(255,255,255)
        IF field_block(count_field_block_column, count_field_block_row).Status = CLEARED THEN block_color = Wall_Color
        
        IF PlayField_Backg = TRUE AND field_block(count_field_block_column, count_field_block_row).Status = FREE THEN LINE(PlayFieldMidX-(GridSize+1)-(playfield_maxwidth/2)*(GridSize+1)+count_field_block_column*(GridSize+1)-CameraX,PlayFieldStartY+count_field_block_row*(GridSize+1)-CameraY)-(PlayFieldMidX-1-(playfield_maxwidth/2)*(GridSize+1)+count_field_block_column*(GridSize+1)-CameraX,PlayFieldStartY+GridSize+count_field_block_row*(GridSize+1)-CameraY), BackG_Color, BF
        IF GameMode = 2 AND PlayField_Backg = TRUE AND field_block(count_field_block_column, count_field_block_row).Status = FREE THEN LINE(PlayFieldMidX-(GridSize+1)-(playfield_maxwidth/2)*(GridSize+1)+count_field_block_column*(GridSize+1)-CameraX,PlayFieldStartY+count_field_block_row*(GridSize+1)-CameraY)-(PlayFieldMidX-1-(playfield_maxwidth/2)*(GridSize+1)+count_field_block_column*(GridSize+1)-CameraX,PlayFieldStartY+GridSize+count_field_block_row*(GridSize+1)-CameraY), BackG_BorderColor, B

        'IF field_block(count_field_block_column, count_field_block_row).Status = WALL OR field_block(count_field_block_column, count_field_block_row).Status = FREE THEN LINE(320-(playfield_maxwidth/2)*(GridSize+1)+count_field_block_column*(GridSize+1),60+count_field_block_row*(GridSize+1))-(328-(playfield_maxwidth/2)*(GridSize+1)+count_field_block_column*(GridSize+1),68+count_field_block_row*(GridSize+1)), block_color, B
        IF field_block(count_field_block_column, count_field_block_row).Status = OCCUPIED THEN
            IF field_block(count_field_block_column, count_field_block_row).DColor = 1 THEN 
                IF PlayField_Backg = TRUE THEN LINE(PlayFieldMidX-(GridSize+1)-(playfield_maxwidth/2)*(GridSize+1)+count_field_block_column*(GridSize+1)-CameraX,PlayFieldStartY+count_field_block_row*(GridSize+1)-CameraY)-(PlayFieldMidX-1-(playfield_maxwidth/2)*(GridSize+1)+count_field_block_column*(GridSize+1)-CameraX,PlayFieldStartY+GridSize+count_field_block_row*(GridSize+1)-CameraY), BackG_Color, BF
                IF GameMode = 1 THEN PUT (PlayFieldMidX-(GridSize+1)-(playfield_maxwidth/2)*(GridSize+1)+count_field_block_column*(GridSize+1)-CameraX,PlayFieldStartY+count_field_block_row*(GridSize+1)-CameraY), sprite(1), TRANS
                IF GameMode = 2 THEN 
                    IF GameMode = 2 AND PlayField_Backg = TRUE THEN LINE(PlayFieldMidX-(GridSize+1)-(playfield_maxwidth/2)*(GridSize+1)+count_field_block_column*(GridSize+1)-CameraX,PlayFieldStartY+count_field_block_row*(GridSize+1)-CameraY)-(PlayFieldMidX-1-(playfield_maxwidth/2)*(GridSize+1)+count_field_block_column*(GridSize+1)-CameraX,PlayFieldStartY+GridSize+count_field_block_row*(GridSize+1)-CameraY), BackG_BorderColor, B
                    PUT (PlayFieldMidX-(GridSize+1)-(playfield_maxwidth/2)*(GridSize+1)+count_field_block_column*(GridSize+1)-CameraX,PlayFieldStartY+count_field_block_row*(GridSize+1)-CameraY), bigsprite(1), TRANS
                END IF
            END IF
            IF field_block(count_field_block_column, count_field_block_row).DColor = 2 THEN LINE(PlayFieldMidX-(GridSize+1)-(playfield_maxwidth/2)*(GridSize+1)+count_field_block_column*(GridSize+1)-CameraX,PlayFieldStartY+count_field_block_row*(GridSize+1)-CameraY)-(PlayFieldMidX-1-(playfield_maxwidth/2)*(GridSize+1)+count_field_block_column*(GridSize+1)-CameraX,PlayFieldStartY+GridSize+count_field_block_row*(GridSize+1)-CameraY), Block_Color1, BF
            IF field_block(count_field_block_column, count_field_block_row).DColor = 3 THEN LINE(PlayFieldMidX-(GridSize+1)-(playfield_maxwidth/2)*(GridSize+1)+count_field_block_column*(GridSize+1)-CameraX,PlayFieldStartY+count_field_block_row*(GridSize+1)-CameraY)-(PlayFieldMidX-1-(playfield_maxwidth/2)*(GridSize+1)+count_field_block_column*(GridSize+1)-CameraX,PlayFieldStartY+GridSize+count_field_block_row*(GridSize+1)-CameraY), Block_Color2, BF
            IF field_block(count_field_block_column, count_field_block_row).DColor = 4 THEN LINE(PlayFieldMidX-(GridSize+1)-(playfield_maxwidth/2)*(GridSize+1)+count_field_block_column*(GridSize+1)-CameraX,PlayFieldStartY+count_field_block_row*(GridSize+1)-CameraY)-(PlayFieldMidX-1-(playfield_maxwidth/2)*(GridSize+1)+count_field_block_column*(GridSize+1)-CameraX,PlayFieldStartY+GridSize+count_field_block_row*(GridSize+1)-CameraY), Block_Color3, BF
        
        END IF
        
        IF field_block(count_field_block_column, count_field_block_row).Status = CLEARED THEN LINE(PlayFieldMidX-(GridSize+1)-(playfield_maxwidth/2)*(GridSize+1)+count_field_block_column*(GridSize+1)-CameraX,PlayFieldStartY+count_field_block_row*(GridSize+1)-CameraY)-(PlayFieldMidX-1-(playfield_maxwidth/2)*(GridSize+1)+count_field_block_column*(GridSize+1)-CameraX,PlayFieldStartY+GridSize+count_field_block_row*(GridSize+1)-CameraY), block_color, BF
    
    NEXT count_field_block_column
    
NEXT count_field_block_row

IF countend_level = 0 AND GameMode = 1 THEN LINE (PlayFieldMidX+1-(row_size(level_demarcation_line)/2)*(GridSize+1)-CameraX-1,PlayFieldStartY+level_demarcation_line*(GridSize+1)-CameraY)-(PlayFieldMidX-1+(row_size(level_demarcation_line)/2)*(GridSize+1)-CameraX,PlayFieldStartY+level_demarcation_line*(GridSize+1)-CameraY), RGB(255,255,0)

FOR count_row AS INTEGER = 1 TO numofrows

IF GameMode = 1 THEN
LINE (PlayFieldMidX-1-(row_size(count_row)/2)*(GridSize+1)-CameraX,PlayFieldStartY+count_row*(GridSize+1)-CameraY)-(PlayFieldMidX-1-(row_size(count_row)/2)*(GridSize+1)-CameraX,PlayFieldStartY+GridSize+count_row*(GridSize+1)-CameraY), Wall_Color
IF count_row > 1 AND row_size(count_row) < row_size(count_row-1) THEN
LINE (PlayFieldMidX-1-(row_size(count_row-1)/2)*(GridSize+1)-CameraX,PlayFieldStartY+count_row*(GridSize+1)-CameraY)-(PlayFieldMidX-1-(row_size(count_row)/2)*(GridSize+1)-CameraX,PlayFieldStartY+count_row*(GridSize+1)-CameraY), Wall_Color   
LINE (PlayFieldMidX+(row_size(count_row-1)/2)*(GridSize+1)-CameraX,PlayFieldStartY+count_row*(GridSize+1)-CameraY)-(PlayFieldMidX+(row_size(count_row)/2)*(GridSize+1)-CameraX,PlayFieldStartY+count_row*(GridSize+1)-CameraY), Wall_Color
END IF
LINE (PlayFieldMidX+(row_size(count_row)/2)*(GridSize+1)-CameraX,PlayFieldStartY+count_row*(GridSize+1)-CameraY)-(PlayFieldMidX+(row_size(count_row)/2)*(GridSize+1)-CameraX,PlayFieldStartY+GridSize+count_row*(GridSize+1)-CameraY), Wall_Color
IF count_row = numofrows THEN LINE (PlayFieldMidX-(row_size(count_row)/2)*(GridSize+1)-CameraX,PlayFieldStartY+GridSize+count_row*(GridSize+1)-CameraY)-(PlayFieldMidX+(row_size(count_row)/2)*(GridSize+1)-CameraX,PlayFieldStartY+GridSize+count_row*(GridSize+1)-CameraY), Wall_Color
END IF

NEXT count_row

IF GameMode = 2 THEN
LINE (PlayFieldMidX-(playfield_maxwidth/2)*(GridSize+1)-CameraX-1,PlayFieldStartY-CameraY+(GridSize+1)-1)-(PlayFieldMidX+(playfield_maxwidth/2)*(GridSize+1)-CameraX,PlayFieldStartY+numofrows*(GridSize+1)-CameraY+(GridSize+1)), Wall_Color, B
LINE (PlayFieldMidX-(playfield_maxwidth/2)*(GridSize+1)-CameraX-8,PlayFieldStartY-CameraY+(GridSize+1)-7)-(PlayFieldMidX+(playfield_maxwidth/2)*(GridSize+1)-CameraX+6,PlayFieldStartY+numofrows*(GridSize+1)-CameraY+(GridSize+1)+1+5), Wall_Color, B
PAINT (PlayFieldMidX-(playfield_maxwidth/2)*(GridSize+1)-CameraX-4,PlayFieldStartY-CameraY+(GridSize+1)-4), BackG_BorderColor, Wall_Color
END IF

LINE (PlayFieldMidX-(row_size(1)/2)*(GridSize+1)-CameraX-1,PlayFieldStartY+GridSize+0*(GridSize+1)-CameraY)-(PlayFieldMidX+(row_size(1)/2)*(GridSize+1)-CameraX,PlayFieldStartY+GridSize+0*(GridSize+1)-CameraY), Wall_Color
IF GameMode = 1 THEN LINE (PlayFieldMidX-(4/2)*(GridSize+1)-CameraX,PlayFieldStartY+GridSize+0*(GridSize+1)-CameraY)-(PlayFieldMidX+(4/2)*(GridSize+1)-CameraX,PlayFieldStartY+GridSize+0*(GridSize+1)-CameraY), RGB(65,65,65)

FOR county AS INTEGER = 0 TO 11
IF countstart_level = 0 AND GameMode = 1 AND PlayField_Backg = TRUE THEN 
    IF cur_level = 1 THEN LINE (PlayFieldMidX-(4/2)*(GridSize+1)-CameraX,PlayFieldStartY+GridSize+0*(GridSize+1)-CameraY-county)-(PlayFieldMidX+(4/2)*(GridSize+1)-CameraX,PlayFieldStartY+GridSize+0*(GridSize+1)-CameraY-county), RGB(65-county*3,65-county*3,65-county*3)
    IF cur_level = 2 THEN LINE (PlayFieldMidX-(4/2)*(GridSize+1)-CameraX,PlayFieldStartY+GridSize+0*(GridSize+1)-CameraY-county)-(PlayFieldMidX+(4/2)*(GridSize+1)-CameraX,PlayFieldStartY+GridSize+0*(GridSize+1)-CameraY-county), RGB(84-20-county*3,75-20-county*3,0)
    IF cur_level = 3 THEN LINE (PlayFieldMidX-(4/2)*(GridSize+1)-CameraX,PlayFieldStartY+GridSize+0*(GridSize+1)-CameraY-county)-(PlayFieldMidX+(4/2)*(GridSize+1)-CameraX,PlayFieldStartY+GridSize+0*(GridSize+1)-CameraY-county), RGB(53-county*3,0,53-county*3)
    IF cur_level = 4 THEN LINE (PlayFieldMidX-(4/2)*(GridSize+1)-CameraX,PlayFieldStartY+GridSize+0*(GridSize+1)-CameraY-county)-(PlayFieldMidX+(4/2)*(GridSize+1)-CameraX,PlayFieldStartY+GridSize+0*(GridSize+1)-CameraY-county), RGB(0,58-county*3,0)
    IF cur_level = 5 THEN LINE (PlayFieldMidX-(4/2)*(GridSize+1)-CameraX,PlayFieldStartY+GridSize+0*(GridSize+1)-CameraY-county)-(PlayFieldMidX+(4/2)*(GridSize+1)-CameraX,PlayFieldStartY+GridSize+0*(GridSize+1)-CameraY-county), RGB(0,51-county*3,84-county*3)

END IF
NEXT county

END SUB

SUB InitLevel

DIM block_to_randomize AS INTEGER
DIM count_randomized AS INTEGER

IF GameMode = 2 THEN
    FOR count_field_block_row AS INTEGER = 1 TO numofrows
        FOR count_field_block_column AS INTEGER = 1 TO playfield_maxwidth
            field_block(count_field_block_column, count_field_block_row).Status = FREE
        NEXT count_field_block_column
    NEXT count_field_block_row
    EXIT SUB
END IF


' A sub that inits the level according to set playfield
' row widenesses in the row_size() array.

FOR count_field_block_row AS INTEGER = -2 TO numofrows
    FOR count_field_block_column AS INTEGER = 1 TO playfield_maxwidth
        field_block(count_field_block_column, count_field_block_row).Status = OCCUPIED
        field_block(count_field_block_column, count_field_block_row).DColor = INT(RND * 3) + 2
        IF count_field_block_column<((playfield_maxwidth-row_size(count_field_block_row))/2)+1 THEN field_block(count_field_block_column, count_field_block_row).Status = WALL
        IF count_field_block_column>(playfield_maxwidth/2)+(row_size(count_field_block_row)/2) THEN field_block(count_field_block_column, count_field_block_row).Status = WALL
    NEXT count_field_block_column
NEXT count_field_block_row


' Free blocks than don't need to be filled.
FOR count_field_block_row AS INTEGER = -2 TO start_blocks-1
    FOR count_field_block_column AS INTEGER = 1 TO playfield_maxwidth
        IF field_block(count_field_block_column, count_field_block_row).Status <>WALL THEN field_block(count_field_block_column, count_field_block_row).Status = FREE    
    NEXT count_field_block_column
NEXT count_field_block_row

' In the zone that is left fille (from start_blocks) free
' in each line from 1 to 4 blocks.
FOR count_field_block_row AS INTEGER = start_blocks TO numofrows
    
    count_randomized = 0
    misc_random_number = INT(RND * 4) + 1
        
    DO
        block_to_randomize = INT(RND * playfield_maxwidth) + 1
        IF field_block(block_to_randomize, count_field_block_row).Status = OCCUPIED THEN
            field_block(block_to_randomize, count_field_block_row).Status = FREE
            count_randomized = count_randomized + 1
        END IF
    LOOP UNTIL count_randomized = misc_random_number
    
NEXT count_field_block_row

' Free blocks above the playfield so that
' the "entering" block can move
FOR count_field_block_row AS INTEGER = -2 TO 0
    
    FOR count_field_block_column AS INTEGER = 1 TO playfield_maxwidth
        field_block(count_field_block_column, count_field_block_row).Status = WALL
        IF count_field_block_column>(playfield_maxwidth-4)/2 AND count_field_block_column<((playfield_maxwidth/2)+(4/2))+1 THEN field_block(count_field_block_column, count_field_block_row).Status = FREE
    NEXT count_field_block_column    
NEXT count_field_block_row

'field_block(17, 10).Status = CLEARED

END SUB

SUB UpdateBlocks
    
' A sub that updates falling blocks around
' the main block according to block group
' type and current block group rotation 
' position.
    
SELECT CASE current_block_type

CASE 1
    blocksprite = 4
    current_block_max_position = 2
    SELECT CASE current_block_position
    CASE 1
        falling_block(2).Column = falling_block(1).Column - 1
        falling_block(3).Column = falling_block(1).Column + 1
        falling_block(4).Column = falling_block(1).Column + 2
        FOR count_fblock AS INTEGER = 2 TO 4
            falling_block(count_fblock).Row = falling_block(1).Row
        NEXT count_fblock
    CASE 2
        falling_block(2).Row = falling_block(1).Row - 1
        falling_block(3).Row = falling_block(1).Row + 1
        falling_block(4).Row = falling_block(1).Row + 2
        FOR count_fblock AS INTEGER = 2 TO 4
            falling_block(count_fblock).Column = falling_block(1).Column
        NEXT count_fblock
    END SELECT
CASE 2
    blocksprite = 3
    current_block_max_position = 1
    falling_block(2).Column = falling_block(1).Column - 1
    falling_block(2).Row = falling_block(1).Row
    falling_block(3).Column = falling_block(1).Column - 1
    falling_block(3).Row = falling_block(1).Row + 1
    falling_block(4).Column = falling_block(1).Column
    falling_block(4).Row = falling_block(1).Row + 1 
CASE 3
    blocksprite = 8
    current_block_max_position = 4
    SELECT CASE current_block_position
    CASE 1
        falling_block(2).Column = falling_block(1).Column - 1
        falling_block(2).Row = falling_block(1).Row
        falling_block(3).Column = falling_block(1).Column + 1
        falling_block(3).Row = falling_block(1).Row
        falling_block(4).Column = falling_block(1).Column
        falling_block(4).Row = falling_block(1).Row - 1
    CASE 2
        falling_block(2).Column = falling_block(1).Column
        falling_block(2).Row = falling_block(1).Row - 1
        falling_block(3).Column = falling_block(1).Column
        falling_block(3).Row = falling_block(1).Row + 1
        falling_block(4).Column = falling_block(1).Column - 1
        falling_block(4).Row = falling_block(1).Row 
    CASE 3
        falling_block(2).Column = falling_block(1).Column + 1
        falling_block(2).Row = falling_block(1).Row
        falling_block(3).Column = falling_block(1).Column - 1
        falling_block(3).Row = falling_block(1).Row
        falling_block(4).Column = falling_block(1).Column
        falling_block(4).Row = falling_block(1).Row + 1
    CASE 4
        falling_block(2).Column = falling_block(1).Column
        falling_block(2).Row = falling_block(1).Row - 1
        falling_block(3).Column = falling_block(1).Column
        falling_block(3).Row = falling_block(1).Row + 1
        falling_block(4).Column = falling_block(1).Column + 1
        falling_block(4).Row = falling_block(1).Row
    END SELECT
CASE 4
    blocksprite = 5
    current_block_max_position = 4
    SELECT CASE current_block_position
    CASE 1
        falling_block(2).Column = falling_block(1).Column - 1
        falling_block(2).Row = falling_block(1).Row
        falling_block(3).Column = falling_block(1).Column + 1
        falling_block(3).Row = falling_block(1).Row
        falling_block(4).Column = falling_block(1).Column + 1
        falling_block(4).Row = falling_block(1).Row - 1
    CASE 2
        falling_block(2).Column = falling_block(1).Column - 1
        falling_block(2).Row = falling_block(1).Row - 1
        falling_block(3).Column = falling_block(1).Column
        falling_block(3).Row = falling_block(1).Row - 1
        falling_block(4).Column = falling_block(1).Column
        falling_block(4).Row = falling_block(1).Row + 1
    CASE 3
        falling_block(2).Column = falling_block(1).Column - 1
        falling_block(2).Row = falling_block(1).Row
        falling_block(3).Column = falling_block(1).Column - 1
        falling_block(3).Row = falling_block(1).Row + 1 
        falling_block(4).Column = falling_block(1).Column + 1
        falling_block(4).Row = falling_block(1).Row
    CASE 4
        falling_block(2).Column = falling_block(1).Column
        falling_block(2).Row = falling_block(1).Row - 1
        falling_block(3).Column = falling_block(1).Column
        falling_block(3).Row = falling_block(1).Row + 1
        falling_block(4).Column = falling_block(1).Column + 1
        falling_block(4).Row = falling_block(1).Row + 1
    END SELECT
CASE 5
    blocksprite = 6
    current_block_max_position = 4
    SELECT CASE current_block_position
    CASE 1
        falling_block(2).Column = falling_block(1).Column - 1
        falling_block(2).Row = falling_block(1).Row
        falling_block(3).Column = falling_block(1).Column + 1
        falling_block(3).Row = falling_block(1).Row
        falling_block(4).Column = falling_block(1).Column + 1
        falling_block(4).Row = falling_block(1).Row + 1
    CASE 2
        falling_block(2).Column = falling_block(1).Column + 1
        falling_block(2).Row = falling_block(1).Row - 1
        falling_block(3).Column = falling_block(1).Column
        falling_block(3).Row = falling_block(1).Row - 1
        falling_block(4).Column = falling_block(1).Column
        falling_block(4).Row = falling_block(1).Row + 1
    CASE 3
        falling_block(2).Column = falling_block(1).Column - 1
        falling_block(2).Row = falling_block(1).Row - 1
        falling_block(3).Column = falling_block(1).Column - 1
        falling_block(3).Row = falling_block(1).Row
        falling_block(4).Column = falling_block(1).Column + 1
        falling_block(4).Row = falling_block(1).Row
    CASE 4
        falling_block(2).Column = falling_block(1).Column
        falling_block(2).Row = falling_block(1).Row - 1
        falling_block(3).Column = falling_block(1).Column
        falling_block(3).Row = falling_block(1).Row + 1
        falling_block(4).Column = falling_block(1).Column - 1
        falling_block(4).Row = falling_block(1).Row + 1
    END SELECT
CASE 6
    blocksprite = 7
    current_block_max_position = 2
    SELECT CASE current_block_position
    CASE 1
        falling_block(2).Column = falling_block(1).Column - 1
        falling_block(2).Row = falling_block(1).Row
        falling_block(3).Column = falling_block(1).Column - 1
        falling_block(3).Row = falling_block(1).Row - 1
        falling_block(4).Column = falling_block(1).Column
        falling_block(4).Row = falling_block(1).Row + 1
    CASE 2
        falling_block(2).Column = falling_block(1).Column
        falling_block(2).Row = falling_block(1).Row + 1
        falling_block(3).Column = falling_block(1).Column - 1
        falling_block(3).Row = falling_block(1).Row + 1
        falling_block(4).Column = falling_block(1).Column + 1
        falling_block(4).Row = falling_block(1).Row
    END SELECT
CASE 7
    blocksprite = 9
    current_block_max_position = 2
    SELECT CASE current_block_position
    CASE 1
        falling_block(2).Column = falling_block(1).Column - 1
        falling_block(2).Row = falling_block(1).Row - 1
        falling_block(3).Column = falling_block(1).Column
        falling_block(3).Row = falling_block(1).Row - 1
        falling_block(4).Column = falling_block(1).Column + 1
        falling_block(4).Row = falling_block(1).Row
    CASE 2
        falling_block(2).Column = falling_block(1).Column - 1
        falling_block(2).Row = falling_block(1).Row
        falling_block(3).Column = falling_block(1).Column - 1
        falling_block(3).Row = falling_block(1).Row + 1
        falling_block(4).Column = falling_block(1).Column
        falling_block(4).Row = falling_block(1).Row - 1
    END SELECT

END SELECT

IF Frame1 > 25 THEN blocksprite = blocksprite + 7

END SUB

SUB DrawBlocks

' A simple sub for drawing falling blocks in the playfield.
FOR count_fblock AS INTEGER = 1 TO 4
        IF GameMode = 1 THEN PUT (PlayFieldMidX-(GridSize+1)-(playfield_maxwidth/2)*(GridSize+1)+falling_block(count_fblock).Column*(GridSize+1)-CameraX,(falling_block(count_fblock).Row*(GridSize+1))+PlayFieldStartY-CameraY), sprite(blocksprite), TRANS
        IF GameMode = 2 THEN PUT (PlayFieldMidX-(GridSize+1)-(playfield_maxwidth/2)*(GridSize+1)+falling_block(count_fblock).Column*(GridSize+1)-CameraX,(falling_block(count_fblock).Row*(GridSize+1))+PlayFieldStartY-CameraY), bigsprite(blocksprite), TRANS
NEXT count_fblock
    
END SUB

SUB CheckLinesToClear

' Check lines to delete in the playfield after
' a new block has dropped.

DIM endrow AS INTEGER
DIM startrow AS INTEGER 
DIM count_lines AS INTEGER

FOR reset_deleted_lines AS INTEGER = 1 TO 100
    LineToDelete(reset_deleted_lines) = 0
NEXT reset_deleted_lines

count_lines = 0
LineClearingStatus = 2
Count_Deletion_Animation = 0
endrow = falling_block(1).Row + 2
startrow = falling_block(1).Row - 1
IF endrow>numofrows THEN endrow = numofrows
IF startrow<1 THEN startrow = 1

' Check rows around the dropped piece.
FOR count_row AS INTEGER = startrow TO endrow
    
count_lines = count_lines + 1  

    FOR count_column_for_free AS INTEGER = 1 TO playfield_maxwidth
        
        ' In case a CLEARED or FREE block is found that line
        ' obviously does not need to be deleted, so we
        ' prompt for the next line to be checked.
        IF field_block(count_column_for_free, count_row).Status = FREE OR field_block(count_column_for_free, count_row).Status = CLEARED THEN GOTO nextrow:
        
    NEXT count_column_for_free
    
    ' Flag the line that is deleted with LineToDelete().
    ' Flag the new status of the clearing procedure
    ' with LineClearingStatus (prompt to line deletion animation).
    LineToDelete(count_lines) = count_row
    count_cleared_lines_level = count_cleared_lines_level + 1
    count_current_cleared_lines = count_current_cleared_lines + 1
    count_cleared_lines_total = count_cleared_lines_total + 1
    AddToScore = AddToScore + 100 + count_current_cleared_lines * 50
    count_drop = 0
    LineClearingStatus = 3
    Count_Deletion_Animation = 0
        
    FOR count_column AS INTEGER = 1 TO playfield_maxwidth
        ' Flag all blocks in the line to delete as FREE.
        FOR count_column_to_delete AS INTEGER = 1 TO playfield_maxwidth
            IF field_block(count_column_to_delete, count_row).Status<>WALL AND field_block(count_column_to_delete, count_row).Status<>CLEARED THEN field_block(count_column_to_delete, count_row).Status = FREE
        NEXT count_column_to_delete
        
    NEXT count_column
    
nextrow:    
NEXT count_row

IF LineClearingStatus = 2 THEN LineClearingStatus = 7

END SUB

SUB PushLinesUp


' Check for lines that flag which row has been deleted.
FOR count_del_lines AS INTEGER = 100 TO 1 STEP -1
    
    ' If such line is not 0 (no deletion) then move
    ' all blocks above one position down.
    IF (LineToDelete(count_del_lines) > 0 AND LineToDelete(count_del_lines) < level_demarcation_line) THEN
    
    ' All other lines that flag rows that have
    ' been deleted now need to be moved one
    ' row down.
    FOR move_line_to_delete_down AS INTEGER = 1 TO 100
        IF (LineToDelete(count_del_lines) > LineToDelete(move_line_to_delete_down) AND move_line_to_delete_down <> count_del_lines AND LineToDelete(count_del_lines) < level_demarcation_line) THEN LineToDelete(move_line_to_delete_down) = LineToDelete(move_line_to_delete_down) + 1
    NEXT move_line_to_delete_down
    
    ' Check all rows from the row to delete toward down (till row 2).
    FOR count_row_to_delete AS INTEGER = LineToDelete(count_del_lines) TO 2 STEP - 1
        ' Count all the blocks in a specific row (but wide as the
        ' starting deleted row) and move down.
        FOR count_columns_in_a_row_to_delete AS INTEGER = ((playfield_maxwidth-row_size(LineToDelete(count_del_lines)))/2)+1 TO playfield_maxwidth/2+row_size(LineToDelete(count_del_lines))/2
            IF field_block(count_columns_in_a_row_to_delete, count_row_to_delete).Status<>WALL THEN 
                field_block(count_columns_in_a_row_to_delete, count_row_to_delete).Status = field_block(count_columns_in_a_row_to_delete, count_row_to_delete-1).Status
                field_block(count_columns_in_a_row_to_delete, count_row_to_delete).DColor = field_block(count_columns_in_a_row_to_delete, count_row_to_delete-1).DColor
            END IF
        NEXT count_columns_in_a_row_to_delete
    NEXT count_row_to_delete
    
    END IF
    
    ' If line to delete is not 0 (no deletion) then move
    ' all blocks below one position up.
    IF (LineToDelete(count_del_lines) > 0 AND LineToDelete(count_del_lines) >= level_demarcation_line) THEN
    
    ' All other lines that flag rows that have
    ' been deleted now need to be moved one
    ' row up.
    FOR move_line_to_delete_down AS INTEGER = 1 TO 100
        IF (LineToDelete(count_del_lines) < LineToDelete(move_line_to_delete_down) AND move_line_to_delete_down <> count_del_lines AND LineToDelete(move_line_to_delete_down)>= level_demarcation_line) THEN LineToDelete(move_line_to_delete_down) = LineToDelete(move_line_to_delete_down) - 1
    NEXT move_line_to_delete_down
    
    ' Check all rows from the row to delete toward down (till the edge of playfield).
    FOR count_row_to_delete AS INTEGER = LineToDelete(count_del_lines) TO numofrows
        ' Count all the blocks in a specific row (but wide as the
        ' starting deleted row) and move up.
        FOR count_columns_in_a_row_to_delete AS INTEGER = ((playfield_maxwidth-row_size(LineToDelete(count_del_lines)))/2)+1 TO playfield_maxwidth/2+row_size(LineToDelete(count_del_lines))/2
            IF LineToDelete(count_del_lines) < numofrows AND field_block(count_columns_in_a_row_to_delete, count_row_to_delete).Status<>WALL THEN 
                field_block(count_columns_in_a_row_to_delete, count_row_to_delete).Status = field_block(count_columns_in_a_row_to_delete, count_row_to_delete+1).Status
                field_block(count_columns_in_a_row_to_delete, count_row_to_delete).DColor = field_block(count_columns_in_a_row_to_delete, count_row_to_delete+1).DColor
                IF field_block(count_columns_in_a_row_to_delete, count_row_to_delete).Status = CLEARED AND count_row_to_delete = level_demarcation_line + 1 THEN InitiateTextMessage 415, 230, "ALMOST THERE - CONQUER!", 101
            END IF
        NEXT count_columns_in_a_row_to_delete
    NEXT count_row_to_delete
    
    ' Change the new empty space at the bottom into CLEARED
    ' row.
    playsample (sample(3))
    FOR count_columns_to_clear AS INTEGER = ((playfield_maxwidth-row_size(LineToDelete(count_del_lines)))/2)+1 TO playfield_maxwidth/2+row_size(LineToDelete(count_del_lines))/2
        field_block(count_columns_to_clear,numofrows).Status = CLEARED
    NEXT count_columns_to_clear
    
    END IF

NEXT count_del_lines

LineClearingStatus = LineClearingStatus + 1

FOR count_columns AS INTEGER = 1 TO playfield_maxwidth
IF countend_level = 0 AND field_block(count_columns,level_demarcation_line).Status = CLEARED THEN 
    countend_level = 1
    AddToScore = 2000
    count_clearing_lines = level_demarcation_line
END IF
NEXT count_columns

IF countend_level = 0 THEN
IF AddToScore = 150 AND InGame_Message.LifeTime < 101 THEN InitiateTextMessage 460, 230, "LINE CLEARED!", 100
IF AddToScore = 350 AND InGame_Message.LifeTime < 101 THEN InitiateTextMessage 460, 230, "DOUBLE LINE!", 100
IF AddToScore = 600 AND InGame_Message.LifeTime < 101 THEN InitiateTextMessage 460, 230, "TRIPLE LINE!", 100
IF AddToScore = 900 AND InGame_Message.LifeTime < 101 THEN InitiateTextMessage 420, 230, "FOUR LINES - WOHO!", 100
END IF

END SUB

SUB DoLineDeletionAnimation 

' Animation that happens after any lines are cleared.
' LineToDelete(count_del_lines) variable is used
' to flag which lines have been deleted.
' The animation last for certain amount of loops and
' when this time passed LineClearingStatus becomes
' 4 and pieces are moved around according to deleted
' ones.

DIM flashing_color AS UINTEGER

Count_Deletion_Animation = Count_Deletion_Animation + 1
IF Count_Deletion_Animation = 50 THEN 
    LineClearingStatus = LineClearingStatus + 1
    playsample (sample(1))
END IF

flashing_color = RGB(255,0,0)
IF Frame3 > 4 THEN flashing_color = RGB(55,0,0) 

FOR count_del_lines AS INTEGER = 1 TO 100
    IF LineToDelete(count_del_lines) > 0 THEN 
        LINE(PlayFieldMidX+1-(row_size(LineToDelete(count_del_lines))/2)*(GridSize+1)-1,PlayFieldStartY+LineToDelete(count_del_lines)*(GridSize+1))-(PlayFieldMidX-1+(row_size(LineToDelete(count_del_lines))/2)*(GridSize+1),PlayFieldStartY+GridSize+LineToDelete(count_del_lines)*(GridSize+1)), flashing_color, BF
        IF Count_Deletion_Animation = 49 THEN
            FOR init_part AS INTEGER = (PlayFieldMidX+3-(row_size(LineToDelete(count_del_lines))/2)*(GridSize+1)) TO (PlayFieldMidX-3+(row_size(LineToDelete(count_del_lines))/2)*(GridSize+1)) STEP 9
                FOR init_part2 AS INTEGER = 1 TO 2
                    InitiateParticle init_part,PlayFieldStartY+4+LineToDelete(count_del_lines)*(GridSize+1), 1, 100
                NEXT init_part2
            NEXT init_part
        END IF
    END IF
NEXT count_del_lines
    
END SUB

SUB ResetPiece
   
' Reset new piece starting position, and
' randomize its type.
IF GameMode = 1 THEN
    falling_block(1).Column = 25
    falling_block(1).Row = -1
    falling_block(5).Column = 25
    falling_block(5).Row = -5
END IF

IF new_dropping_object = BOMB THEN
    new_bomb_type = INT(RND * 3) + 1
    falling_bomb(7).Column = 25
    falling_bomb(7).Row = -5
    FOR reset_bomb AS INTEGER = 1 TO 12
        falling_bomb(reset_bomb).Status = DESTROYED
    NEXT reset_bomb
    FOR reset_bomb AS INTEGER = 7 TO 6+new_bomb_type*2
        falling_bomb(reset_bomb).Status = ALIVE
    NEXT reset_bomb
END IF

Frame2 = 2
current_block_position = 1
current_block_type = new_block_type
new_block_type = INT(RND * 7) + 1

IF GameMode = 2 THEN
    falling_block(1).Column = 5
    falling_block(1).Row = 1
    IF current_block_type > 2 AND current_block_type <> 5 THEN falling_block(1).Row = 2
    falling_block(5).Column = 0
    falling_block(5).Row = 0
    IF new_block_type > 2 AND new_block_type <> 5 THEN falling_block(5).Row = 1
END IF


IF current_block_type = 2 OR current_block_type = 6 THEN falling_block(1).Column = falling_block(1).Column+1
IF new_block_type = 2 OR new_block_type = 6 THEN falling_block(5).Column = falling_block(5).Column+1

UpdateBlocks
    
END SUB

SUB CheckEntireFieldForDeletion

' Due the nature of the playfield new
' lines to delete can appear if a lower section 
' of the playfield moves down and new lines to
' delete appear in the upper wider area.
' Thus, I need to use this sub to check for the
' entire field for lines to delete after
' the usual 4 are checked once a falling
' block is dropped.

DIM endrow AS INTEGER
DIM startrow AS INTEGER 
DIM count_lines AS INTEGER

FOR reset_deleted_lines AS INTEGER = 1 TO 100
    LineToDelete(reset_deleted_lines) = 0
NEXT reset_deleted_lines

count_lines = 0
LineClearingStatus = 6
Count_Deletion_Animation = 0
endrow = numofrows
startrow = 1

FOR count_row AS INTEGER = startrow TO endrow
    
count_lines = count_lines + 1  

    FOR count_column AS INTEGER = 1 TO playfield_maxwidth
        
        IF field_block(count_column, count_row).Status = FREE OR field_block(count_column, count_row).Status = CLEARED THEN GOTO nextrow:
        
    NEXT count_column
    
    FOR count_column AS INTEGER = 1 TO playfield_maxwidth

        LineToDelete(count_lines) = count_row
        count_cleared_lines_level = count_cleared_lines_level + 1
        count_current_cleared_lines = count_current_cleared_lines + 1
        count_cleared_lines_total = count_cleared_lines_total + 1
        AddToScore = AddToScore + 100 + count_current_cleared_lines * 50
        LineClearingStatus = 3
        Count_Deletion_Animation = 0
        count_drop = 0
        
        FOR count_column_to_delete AS INTEGER = 1 TO playfield_maxwidth
            IF field_block(count_column_to_delete, count_row).Status<>WALL AND field_block(count_column_to_delete, count_row).Status<>CLEARED THEN field_block(count_column_to_delete, count_row).Status = FREE
        NEXT count_column_to_delete
        
    NEXT count_column
    
nextrow:    
NEXT count_row

' In case no new lines to delete are found prompt for
' new falling piece to appear.
IF LineClearingStatus = 6 THEN LineClearingStatus = 7

END SUB

SUB MovePiece

' Sub for moving pieces and colliding them with other block.
' Works on a similar way like MoveBomb

' Used with starting level animation.
' Blocks are approaching and shooting at the
' ship gate.
IF countstart_level = 1050+50 THEN InitiateTextMessage 480, 230, "OH, HI!", 150
IF countstart_level = 900+50 THEN InitiateTextMessage 425, 230, "YOU DON'T KNOW ME, BUT", 150
IF countstart_level = 750+50 THEN InitiateTextMessage 410+7, 230, "I'M LORD OF SPACE SQUIDS.", 150
IF countstart_level = 600+50 THEN InitiateTextMessage 420+10, 230, "WE STEAL SPACE SHIPS", 150
IF countstart_level = 450+50 THEN InitiateTextMessage 470+5, 230, "BECUASE...", 150
IF countstart_level = 300+50 THEN InitiateTextMessage 430+5, 230, "BECAUSE WE ARE EVIL!", 150
IF countstart_level = 220 THEN InitiateTextMessage 425, 230, "UH, JUST WORK WITH ME.", 90
IF countstart_level > 0 AND countstart_level<121 THEN
    IF countstart_level = 70 THEN 
        misc_random_number = INT(RND * 3) + 1
        IF misc_random_number = 1 THEN InitiateTextMessage 470, 230, "PENETRATE!", 100
        IF misc_random_number = 2 THEN InitiateTextMessage 472, 230, " INVADE!", 100
        IF misc_random_number = 3 THEN InitiateTextMessage 467, 230, "INFILTRATE!", 100
    END IF
    IF falling_block(1).Row < -1 THEN falling_block(1).Row = falling_block(1).Row + 0.024
    UpdateBlocks
    LINE (PlayFieldMidX-(GridSize+1)-(playfield_maxwidth/2)*(GridSize+1)+falling_block(3).Column*(GridSize+1)-CameraX+4,(falling_block(3).Row*(GridSize+1))+PlayFieldStartY-CameraY+9)-(PlayFieldMidX-(GridSize+1)-(playfield_maxwidth/2)*(GridSize+1)+falling_block(3).Column*(GridSize+1)-CameraX+9,(falling_block(3).Row*(GridSize+1))+PlayFieldStartY-CameraY+12), RGB(255,255,22)
    LINE (PlayFieldMidX-(GridSize+1)-(playfield_maxwidth/2)*(GridSize+1)+falling_block(4).Column*(GridSize+1)-CameraX,(falling_block(4).Row*(GridSize+1))+PlayFieldStartY-CameraY+12)-(PlayFieldMidX-(GridSize+1)-(playfield_maxwidth/2)*(GridSize+1)+falling_block(4).Column*(GridSize+1)-CameraX+4,(falling_block(4).Row*(GridSize+1))+PlayFieldStartY-CameraY+9), RGB(255,255,22)
    LINE (PlayFieldMidX-(GridSize+1)-(playfield_maxwidth/2)*(GridSize+1)+falling_block(4).Column*(GridSize+1)-CameraX,(falling_block(4).Row*(GridSize+1))+PlayFieldStartY-CameraY+12)-(PlayFieldMidX-(GridSize+1)-(playfield_maxwidth/2)*(GridSize+1)+falling_block(4).Column*(GridSize+1)-CameraX,PlayFieldStartY+GridSize+0*(GridSize+1)-CameraY), RGB(255,255,22)
    LINE (PlayFieldMidX-(4/2)*(GridSize+1)-CameraX,PlayFieldStartY+GridSize+0*(GridSize+1)-CameraY)-(PlayFieldMidX+(4/2)*(GridSize+1)-CameraX,PlayFieldStartY+GridSize+0*(GridSize+1)-CameraY), Wall_Color
    IF countstart_level <80 AND Frame3 = 1 THEN InitiateParticle PlayFieldMidX-(GridSize+1)-(playfield_maxwidth/2)*(GridSize+1)+falling_block(4).Column*(GridSize+1)-CameraX,PlayFieldStartY+GridSize+0*(GridSize+1)-CameraY, 1, 20
    IF countstart_level = 1 THEN
    playsample (sample(1))
    falling_block(1).Row = - 1    
    FOR count_doorpart AS INTEGER = 1 TO 20
    InitiateParticle PlayFieldMidX-(4/2)*(GridSize+1)-CameraX+count_doorpart*2,PlayFieldStartY+GridSize+0*(GridSize+1)-CameraY,1, 20
    NEXT count_doorpart
    END IF
END IF
IF countstart_level > 0 THEN EXIT SUB
' ****************

IF MULTIKEY(SC_UP) AND KeyFree = TRUE THEN
    KeyFree = FALSE
    current_block_position = current_block_position + 1
    IF current_block_position > current_block_max_position THEN current_block_position = 1
    UpdateBlocks
    FOR count_fblock AS INTEGER = 1 TO 4
        IF field_block(falling_block(count_fblock).Column, falling_block(count_fblock).Row).Status<>FREE THEN 
            current_block_position = current_block_position - 1
            IF current_block_position <=0 THEN current_block_position = current_block_max_position
            UpdateBlocks
            EXIT FOR
        END IF
    NEXT count_fblock 
END IF

IF (NOT MULTIKEY(SC_UP) AND NOT MULTIKEY(SC_RIGHT) AND NOT MULTIKEY(SC_LEFT)) THEN KeyFree = TRUE

IF (MULTIKEY(SC_RIGHT) AND KeyFree = TRUE) OR (MULTIKEY(SC_RIGHT) AND KeyFree = FALSE AND Frame5 = 1) THEN
    IF KeyFree = TRUE THEN Frame5 = 2
    KeyFree = FALSE
    falling_block(1).Column = falling_block(1).Column + 1
    UpdateBlocks
    FOR count_fblock AS INTEGER = 1 TO 4
        ' Loop through 4 falling pieces and if any collides with a hard
        ' block nullify movement.
        IF field_block(falling_block(count_fblock).Column, falling_block(count_fblock).Row).Status<>FREE THEN 
            falling_block(1).Column = falling_block(1).Column - 1
            UpdateBlocks
            EXIT FOR
        END IF
    NEXT count_fblock 
END IF

IF (MULTIKEY(SC_LEFT) AND KeyFree = TRUE) OR (MULTIKEY(SC_LEFT) AND KeyFree = FALSE AND Frame5 = 1) THEN
    IF KeyFree = TRUE THEN Frame5 = 2
    KeyFree = FALSE
    falling_block(1).Column = falling_block(1).Column - 1
    UpdateBlocks
    FOR count_fblock AS INTEGER = 1 TO 4
        IF field_block(falling_block(count_fblock).Column, falling_block(count_fblock).Row).Status<>FREE THEN 
            falling_block(1).Column = falling_block(1).Column + 1
            UpdateBlocks
            EXIT FOR
        END IF
    NEXT count_fblock 
END IF

'END IF

IF (Frame2 = 1) OR (MULTIKEY(SC_DOWN) AND Frame4 = 1) THEN falling_block(1).Row = falling_block(1).Row + 1
UpdateBlocks
FOR count_fblock AS INTEGER = 1 TO 4
    
    IF (GameOver = FALSE AND falling_block(count_fblock).Row = 1 AND field_block(falling_block(count_fblock).Column, falling_block(count_fblock).Row).Status<>FREE) THEN
        falling_block(1).Row = falling_block(1).Row - 1
        UpdateBlocks
        gameoverprompt:
        misc_random_number = INT(RND * 1) + 1
        IF misc_random_number = 1 THEN InitiateTextMessage 438, 230, "AARGH! STUPID SQUIDS!", 100
        IF misc_random_number = 2 THEN InitiateTextMessage 418, 230, "THERE GOES MY MASTERPLAN.", 100
        IF misc_random_number = 3 THEN InitiateTextMessage 461, 230, "I BLAME YOU.", 100
        
        FOR count_fblock2 AS INTEGER = 1 TO 4
            field_block(falling_block(count_fblock2).Column, falling_block(count_fblock2).Row).Status = OCCUPIED
            field_block(falling_block(count_fblock2).Column, falling_block(count_fblock2).Row).DColor = 1 
            FOR init_part AS INTEGER = 1 TO 8
                InitiateParticle PlayFieldMidX-(GridSize+1)-(playfield_maxwidth/2)*(GridSize+1)+falling_block(count_fblock2).Column*(GridSize+1)+4, falling_block(count_fblock2).Row*(GridSize+1)+PlayFieldStartY+4, 1, 100
            NEXT init_part
        NEXT count_fblock2
        GameOver = TRUE
        playsample (sample(1))
        playsample (sample(3))
        xZoom = 0
        yZoom = 0
        CountGameOver = 0
        EXIT SUB
    END IF
    
    IF falling_block(count_fblock).Row>0 AND field_block(falling_block(count_fblock).Column, falling_block(count_fblock).Row).Status<>FREE THEN 
        ' Loop through 4 falling pieces and if any collides with a hard
        ' block nullify movement and freez current falling pieces
        ' (turn them in OCCUPIED blocks).
        falling_block(1).Row = falling_block(1).Row - 1
        count_drop = count_drop + 1
        UpdateBlocks
        playsample (sample(2))
        ' Freez blocks that have collided with
        ' other blocks.
        FOR count_blocktofreez AS INTEGER = 1 TO 4
            field_block(falling_block(count_blocktofreez).Column, falling_block(count_blocktofreez).Row).Status = OCCUPIED
            field_block(falling_block(count_blocktofreez).Column, falling_block(count_blocktofreez).Row).DColor = 1
        NEXT count_blocktofreez
        
        ' If after freezing one block is pushed back
        ' above line 1 (off the playfield)
        ' end game.
        FOR count_blocktofreez AS INTEGER = 1 TO 4
        IF falling_block(count_blocktofreez).Row < 1 THEN GOTO gameoverprompt:
        NEXT count_blocktofreez

        LineClearingStatus = 1 ' Flags that lines for deletion should be checked.
        EXIT FOR
    END IF
NEXT count_fblock 


END SUB

SUB MoveBomb
    
' Sub for bomb movement and collision detection.

' After one bomb destroys a block movement is blocked for
' a certain amount of loops with this variable.
IF freez_movement>0 THEN freez_movement = freez_movement - 1

IF (NOT MULTIKEY(SC_UP) AND NOT MULTIKEY(SC_RIGHT) AND NOT MULTIKEY(SC_LEFT)) THEN KeyFree = TRUE

' Up key rotates bomb group. If a collision is detected during
' rotation, the rotation is reseted.
' current_block_position flags to group rotation status.
IF (MULTIKEY(SC_UP) AND KeyFree = TRUE AND freez_movement = 0) THEN
    KeyFree = FALSE
    current_block_position = current_block_position + 1
    IF current_block_position > current_block_max_position THEN current_block_position = 1
    UpdateBombs
    FOR count_fblock AS INTEGER = 1 TO 6
        IF falling_bomb(count_fblock).Status = ALIVE AND field_block(falling_bomb(count_fblock).Column, falling_bomb(count_fblock).Row).Status<>FREE THEN 
            current_block_position = current_block_position - 1
            IF current_block_position <=0 THEN current_block_position = current_block_max_position
            UpdateBombs
            EXIT FOR
        END IF
    NEXT count_fblock 
END IF

' Collision for bombs if you move them left or right.
' In case of occupied block it is destroyed with the bomb.
' In case of wall the movement is nullified (block movement).

IF (MULTIKEY(SC_RIGHT) AND KeyFree = TRUE AND freez_movement = 0) OR (MULTIKEY(SC_RIGHT) AND KeyFree = FALSE AND Frame5 = 1 AND freez_movement = 0) THEN
    IF KeyFree = TRUE THEN Frame5 = 2
    KeyFree = FALSE
    falling_bomb(1).Column = falling_bomb(1).Column + 1
    UpdateBombs
    FOR count_fblock AS INTEGER = 1 TO 6
        IF falling_bomb(count_fblock).Status = ALIVE AND field_block(falling_bomb(count_fblock).Column, falling_bomb(count_fblock).Row).Status=OCCUPIED THEN 
            freez_movement = 10
            falling_bomb(count_fblock).Status = DESTROYED
            
            FOR init_part AS INTEGER = 1 TO 4
            InitiateParticle PlayFieldMidX-(GridSize+1)-(playfield_maxwidth/2)*(GridSize+1)+falling_bomb(count_fblock).Column*(GridSize+1)+4, falling_bomb(count_fblock).Row*(GridSize+1)+PlayFieldStartY+4, 1, 100
            NEXT init_part
            InitiateExplosion PlayFieldMidX-(GridSize+1)-(playfield_maxwidth/2)*(GridSize+1)+falling_bomb(count_fblock).Column*(GridSize+1), falling_bomb(count_fblock).Row*(GridSize+1)+PlayFieldStartY, 1, 10
            
            field_block(falling_bomb(count_fblock).Column, falling_bomb(count_fblock).Row).Status = FREE
            'EXIT FOR
        END IF
        IF falling_bomb(count_fblock).Status = ALIVE AND field_block(falling_bomb(count_fblock).Column, falling_bomb(count_fblock).Row).Status=WALL THEN 
            falling_bomb(1).Column = falling_bomb(1).Column - 1
            UpdateBombs
            'EXIT FOR
        END IF
    NEXT count_fblock 
END IF

IF (MULTIKEY(SC_LEFT) AND KeyFree = TRUE AND freez_movement = 0) OR (MULTIKEY(SC_LEFT) AND KeyFree = FALSE AND Frame5 = 1 AND freez_movement = 0) THEN
    IF KeyFree = TRUE THEN Frame5 = 2
    KeyFree = FALSE
    falling_bomb(1).Column = falling_bomb(1).Column - 1
    UpdateBombs
    FOR count_fblock AS INTEGER = 1 TO 6
        IF falling_bomb(count_fblock).Status = ALIVE AND field_block(falling_bomb(count_fblock).Column, falling_bomb(count_fblock).Row).Status=OCCUPIED THEN 
            freez_movement = 10
            falling_bomb(count_fblock).Status = DESTROYED
            
            FOR init_part AS INTEGER = 1 TO 4
            InitiateParticle PlayFieldMidX-(GridSize+1)-(playfield_maxwidth/2)*(GridSize+1)+falling_bomb(count_fblock).Column*(GridSize+1)+4, falling_bomb(count_fblock).Row*(GridSize+1)+PlayFieldStartY+4, 1, 100
            NEXT init_part
            InitiateExplosion PlayFieldMidX-(GridSize+1)-(playfield_maxwidth/2)*(GridSize+1)+falling_bomb(count_fblock).Column*(GridSize+1), falling_bomb(count_fblock).Row*(GridSize+1)+PlayFieldStartY, 1, 10
            
            field_block(falling_bomb(count_fblock).Column, falling_bomb(count_fblock).Row).Status = FREE
            'EXIT FOR
        END IF
        IF falling_bomb(count_fblock).Status = ALIVE AND field_block(falling_bomb(count_fblock).Column, falling_bomb(count_fblock).Row).Status=WALL THEN 
            falling_bomb(1).Column = falling_bomb(1).Column + 1
            UpdateBombs
            'EXIT FOR
        END IF  
    NEXT count_fblock 
END IF


IF (Frame2 = 1 AND freez_movement = 0) OR (MULTIKEY(SC_DOWN) AND Frame4 = 1 AND freez_movement = 0) THEN falling_bomb(1).Row = falling_bomb(1).Row + 1

UpdateBombs

' If the bomb passes the playfiled destroy it.
FOR count_bomb AS INTEGER = 1 TO 6
    IF falling_bomb(count_bomb).Row > numofrows AND falling_bomb(count_bomb).Status = ALIVE THEN 
        falling_bomb(count_bomb).Status = DESTROYED
        falling_bomb(count_bomb).Row = falling_bomb(count_bomb).Row - 1
        'UpdateBombs
        freez_movement = 10
        FOR init_part AS INTEGER = 1 TO 4
            InitiateParticle PlayFieldMidX-(GridSize+1)-(playfield_maxwidth/2)*(GridSize+1)+falling_bomb(count_bomb).Column*(GridSize+1)+4, falling_bomb(count_bomb).Row*(GridSize+1)+PlayFieldStartY+4, 1, 100
        NEXT init_part
        InitiateExplosion PlayFieldMidX-(GridSize+1)-(playfield_maxwidth/2)*(GridSize+1)+falling_bomb(count_bomb).Column*(GridSize+1), falling_bomb(count_bomb).Row*(GridSize+1)+PlayFieldStartY, 1, 10
        IF count_bomb = 1 THEN falling_bomb(count_bomb).Row = falling_bomb(count_bomb).Row + 1    
    END IF
NEXT count_bomb


' Check for collision toward down (like with left and right movement).
FOR count_fblock AS INTEGER = 1 TO 6
    IF falling_bomb(count_fblock).Row <= numofrows THEN
    IF (falling_bomb(count_fblock).Status = ALIVE AND field_block(falling_bomb(count_fblock).Column, falling_bomb(count_fblock).Row).Status=OCCUPIED) THEN 
        freez_movement = 10
        falling_bomb(count_fblock).Status = DESTROYED
        FOR init_part AS INTEGER = 1 TO 4
            InitiateParticle PlayFieldMidX-(GridSize+1)-(playfield_maxwidth/2)*(GridSize+1)+falling_bomb(count_fblock).Column*(GridSize+1)+4, falling_bomb(count_fblock).Row*(GridSize+1)+PlayFieldStartY+4, 1, 100
        NEXT init_part
        InitiateExplosion PlayFieldMidX-(GridSize+1)-(playfield_maxwidth/2)*(GridSize+1)+falling_bomb(count_fblock).Column*(GridSize+1), falling_bomb(count_fblock).Row*(GridSize+1)+PlayFieldStartY, 1, 10
            
        field_block(falling_bomb(count_fblock).Column, falling_bomb(count_fblock).Row).Status = FREE
        'EXIT FOR
    END IF
    IF (falling_bomb(count_fblock).Status = ALIVE AND field_block(falling_bomb(count_fblock).Column, falling_bomb(count_fblock).Row).Status=WALL) OR (falling_bomb(count_fblock).Status = ALIVE AND field_block(falling_bomb(count_fblock).Column, falling_bomb(count_fblock).Row).Status=CLEARED) THEN 
        freez_movement = 10
        falling_bomb(count_fblock).Row = falling_bomb(count_fblock).Row - 1
        'UpdateBombs
        FOR init_part AS INTEGER = 1 TO 4
            InitiateParticle PlayFieldMidX-(GridSize+1)-(playfield_maxwidth/2)*(GridSize+1)+falling_bomb(count_fblock).Column*(GridSize+1), falling_bomb(count_fblock).Row*(GridSize+1)+PlayFieldStartY, 1, 100
        NEXT init_part
        InitiateExplosion PlayFieldMidX-(GridSize+1)-(playfield_maxwidth/2)*(GridSize+1)+falling_bomb(count_fblock).Column*(GridSize+1), falling_bomb(count_fblock).Row*(GridSize+1)+PlayFieldStartY, 1, 10
        
        IF count_fblock = 1 THEN falling_bomb(count_fblock).Row = falling_bomb(count_fblock).Row + 1
        
        falling_bomb(count_fblock).Status = DESTROYED
        'EXIT FOR
    END IF 
    END IF
NEXT count_fblock

' If any bomb is still present in the playfield exit sub.
' Instead, the LineClearingStatus would be equalized with
' 7 which calls for a new block or bomb in the playfield.
FOR count_bomb AS INTEGER = 1 TO 6
    IF falling_bomb(count_bomb).Status = ALIVE THEN EXIT SUB
NEXT count_bomb

LineClearingStatus = 7
    
END SUB

SUB UpdateBombs
    
' Place bombs around the starting according to
' the bomb group type and current position 
' (adjustable with the UP arrow key).

SELECT CASE current_block_type

CASE 1
    current_block_max_position = 2
    SELECT CASE current_block_position
    CASE 1
        falling_bomb(2).Column = falling_bomb(1).Column + 1
        falling_bomb(2).Row = falling_bomb(1).Row
    CASE 2
        falling_bomb(2).Column = falling_bomb(1).Column
        falling_bomb(2).Row = falling_bomb(1).Row + 1
    END SELECT
CASE 2
    current_block_max_position = 1
    SELECT CASE current_block_position
    CASE 1
        falling_bomb(2).Column = falling_bomb(1).Column + 1
        falling_bomb(2).Row = falling_bomb(1).Row
        falling_bomb(3).Column = falling_bomb(1).Column
        falling_bomb(3).Row = falling_bomb(1).Row + 1
        falling_bomb(4).Column = falling_bomb(1).Column + 1
        falling_bomb(4).Row = falling_bomb(1).Row + 1
    END SELECT
CASE 3
    current_block_max_position = 2
    SELECT CASE current_block_position
    CASE 1
        falling_bomb(2).Column = falling_bomb(1).Column + 1
        falling_bomb(2).Row = falling_bomb(1).Row
        falling_bomb(3).Column = falling_bomb(1).Column
        falling_bomb(3).Row = falling_bomb(1).Row - 1
        falling_bomb(4).Column = falling_bomb(1).Column + 1
        falling_bomb(4).Row = falling_bomb(1).Row - 1
        falling_bomb(5).Column = falling_bomb(1).Column
        falling_bomb(5).Row = falling_bomb(1).Row + 1
        falling_bomb(6).Column = falling_bomb(1).Column + 1
        falling_bomb(6).Row = falling_bomb(1).Row + 1
    CASE 2
        falling_bomb(2).Column = falling_bomb(1).Column - 1
        falling_bomb(2).Row = falling_bomb(1).Row
        falling_bomb(3).Column = falling_bomb(1).Column + 1
        falling_bomb(3).Row = falling_bomb(1).Row
        falling_bomb(4).Column = falling_bomb(1).Column
        falling_bomb(4).Row = falling_bomb(1).Row + 1
        falling_bomb(5).Column = falling_bomb(1).Column - 1
        falling_bomb(5).Row = falling_bomb(1).Row + 1
        falling_bomb(6).Column = falling_bomb(1).Column + 1
        falling_bomb(6).Row = falling_bomb(1).Row + 1
    END SELECT
END SELECT

END SUB

SUB ResetBomb
    
' A sub that resets the bomb after a block has
' fallen or all the bombs in a previous drop
' have disappeared.
    
FOR reset_bomb AS INTEGER = 1 TO 12
    falling_bomb(reset_bomb).Status = DESTROYED
NEXT reset_bomb

falling_bomb(1).Column = 25
falling_bomb(1).Row = -1

falling_bomb(7).Column = 25
falling_bomb(7).Row = -5

current_block_position = 1
' 3 possible types of bomb groups.
current_block_type = new_bomb_type
new_bomb_type = INT(RND * 3) + 1

IF current_block_type = 2 OR current_block_type = 6 THEN falling_block(1).Column = falling_block(1).Column+1
IF new_block_type = 2 OR new_block_type = 6 THEN falling_block(5).Column = falling_block(5).Column+1

UpdateBombs

FOR reset_bomb AS INTEGER = 1 TO current_block_type*2
    falling_bomb(reset_bomb).Status = ALIVE
NEXT reset_bomb

FOR reset_bomb AS INTEGER = 7 TO 6+new_bomb_type*2
    falling_bomb(reset_bomb).Status = ALIVE
NEXT reset_bomb

Frame2 = 2 

IF new_dropping_object = BLOCK THEN
    new_block_type = INT(RND * 7) + 1
    falling_block(5).Column = 25
    falling_block(5).Row = -5
END IF
    
END SUB

SUB DrawBombs
    
' A sub that draws the bombs if they are alive.
    
FOR count_fbomb AS INTEGER = 1 TO 6
        IF falling_bomb(count_fbomb).Status = ALIVE THEN PUT (PlayFieldMidX-(GridSize+1)-(playfield_maxwidth/2)*(GridSize+1)+falling_bomb(count_fbomb).Column*(GridSize+1)-CameraX,(falling_bomb(count_fbomb).Row*(GridSize+1))+PlayFieldStartY-CameraY), sprite(17), TRANS
NEXT count_fbomb
    
END SUB

SUB Convert8bit16bit
    
Dim As Integer i, y
    
ScreenRes 320, 200, 16, , GFX_NULL
img16 = ImageCreate(128, 64)
ScreenRes 320, 200, 8, , GFX_NULL
img8 = ImageCreate(128, 64)
BLOAD "graphics/graphics.bmp", img8

'' copy the image data into a 32-bit image
Dim As UByte Ptr p8 = CPtr(UByte Ptr, img8) + SizeOf(IMAGE)
Dim As UByte Ptr p32 = CPtr(UByte Ptr, img16) + SizeOf(IMAGE)
Dim As UInteger pitch8 = img8->pitch, pitch32 = img16->pitch
For y = 0 To 64 - 1
    ImageConvertRow(p8  + y * pitch8 ,  8, _
                    p32 + y * pitch32, 16, _
                    128)
Next y

END SUB

SUB InitiateParticle (pposx AS SINGLE, pposy AS SINGLE, ptyp AS INTEGER, plifetime AS INTEGER)

FOR countpart AS INTEGER = 1 TO numofParticles
    
    IF Particle(countpart).Locked = FALSE THEN
        Particle(countpart).Locked = TRUE
        Particle(countpart).X = pposx
        Particle(countpart).Y = pposy
        Particle(countpart).Typ = ptyp
        Particle(countpart).LifeTime = plifetime
        IF Particle(countpart).Typ = 1 THEN
            Particle(countpart).XSpeed = (INT(RND * 10) - 5)/8
            Particle(countpart).YSpeed = (INT(RND * 10) +1)/20
            Particle(countpart).YInertia = 0
            misc_random_number = INT(RND * 3) + 1
            IF misc_random_number = 1 THEN Particle(countpart).PColor = RGB(255,144,35)
            IF misc_random_number = 2 THEN Particle(countpart).PColor = RGB(227,86,1)
            IF misc_random_number = 3 THEN Particle(countpart).PColor = RGB(225,206,35)
        END IF
        IF Particle(countpart).Typ = 2 THEN
            Particle(countpart).XSpeed = 0
            Particle(countpart).YSpeed = 0.06
            Particle(countpart).YInertia = 0
        END IF
        EXIT SUB
    END IF
    
NEXT countpart
    
END SUB

SUB ParticleLayer
    
FOR countpart AS INTEGER = 1 TO numofParticles
    
IF Particle(countpart).Locked = TRUE THEN

Particle(countpart).X = Particle(countpart).X + Particle(countpart).XSpeed
Particle(countpart).Y = Particle(countpart).Y - Particle(countpart).YInertia
Particle(countpart).YInertia = Particle(countpart).YInertia + Particle(countpart).YSpeed

IF Particle(countpart).Typ = 1 THEN PSET (Particle(countpart).X-CameraX,Particle(countpart).Y-CameraY), Particle(countpart).PColor
IF Particle(countpart).Typ = 2 THEN 
    CIRCLE (Particle(countpart).X-CameraX,Particle(countpart).Y-CameraY), 2+Particle(countpart).LifeTime/6, RGB(150+Particle(countpart).LifeTime*3,66++Particle(countpart).LifeTime*3,35), , , , F
    Particle(countpart).LifeTime = Particle(countpart).LifeTime - 1
    IF Particle(countpart).LifeTime = 0 THEN Particle(countpart).Locked = FALSE
END IF

IF Particle(countpart).Y < 5 THEN Particle(countpart).Locked = FALSE

END IF

NEXT countpart

END SUB


SUB DrawStars  (mode AS INTEGER)
 
DIM Camera2X AS INTEGER
DIM Camera2Y AS INTEGER

Camera2X = 0
Camera2Y = 0
IF mode = 5 THEN
    Camera2X = CameraX
    Camera2Y = CameraY
END IF

' Loop through stars and draw them according to their type.
' Type 5 and type 6 are larger stars, and thus require more
' drawing primitives to be drawn.
FOR countstar AS INTEGER = 1 TO numofstars
    
    SELECT CASE Star(countstar).Typ
    CASE 1
        PSET (Star(countstar).X-Camera2X, Star(countstar).Y-Camera2Y), RGB(255,255,255)
    CASE 2
        PSET (Star(countstar).X-Camera2X, Star(countstar).Y-Camera2Y), RGB(205,205,205)
    CASE 3
        PSET (Star(countstar).X-Camera2X, Star(countstar).Y-Camera2Y), RGB(100,100,100)
    CASE 4
        PSET (Star(countstar).X-Camera2X, Star(countstar).Y-Camera2Y), RGB(150,150,150)
    CASE 5
        LINE (Star(countstar).X-1-Camera2X, Star(countstar).Y-Camera2Y)-(Star(countstar).X+1-Camera2X, Star(countstar).Y-Camera2Y), RGB(90,90,90)
        LINE (Star(countstar).X-Camera2X, Star(countstar).Y-1-Camera2Y)-(Star(countstar).X-Camera2X, Star(countstar).Y+1-Camera2Y), RGB(90,90,90)
        PSET (Star(countstar).X-Camera2X, Star(countstar).Y-Camera2Y), RGB(250,250,250)
    CASE 6
        LINE (Star(countstar).X-1-Camera2X, Star(countstar).Y-Camera2Y)-(Star(countstar).X+1-Camera2X, Star(countstar).Y-Camera2Y), RGB(50,50,50)
        LINE (Star(countstar).X-Camera2X, Star(countstar).Y-1-Camera2Y)-(Star(countstar).X-Camera2X, Star(countstar).Y+1-Camera2Y), RGB(50,50,50)
        PSET (Star(countstar).X-Camera2X, Star(countstar).Y-Camera2Y), RGB(170,170,170)
    END SELECT
    
    IF mode= 1 OR mode=3 OR mode = 4 THEN Star(countstar).Y = Star(countstar).Y-Star(countstar).YSpeed
    IF mode = 4 THEN Star(countstar).Y = Star(countstar).Y-Star(countstar).YSpeed*20
    
    IF mode= 2 or mode = 5 THEN Star(countstar).X = Star(countstar).X-Star(countstar).YSpeed
    
    IF Star(countstar).Y<5 AND mode<> 4 THEN
        Star(countstar).X = INT(RND * 640) + 1
        Star(countstar).Y = INT(RND * 20) +485
        Star(countstar).Typ = INT(RND * 6) + 1
        Star(countstar).YSpeed = (INT(RND * 20) +1)/10
    END IF
    IF Star(countstar).X<5 THEN
        Star(countstar).X = INT(RND * 40) + 642
        Star(countstar).Y = INT(RND * 480) + 1
        Star(countstar).Typ = INT(RND * 6) + 1
        Star(countstar).YSpeed = (INT(RND * 20) +1)/10
    END IF
    
NEXT countstar
    
END SUB

SUB MainMenu
    

startmenu1:

MenuPos = 1
IF GameMode = 2 THEN MenuPos = 2
MoveScreen = TRUE

startmenu2:
CameraX = 640

FOR countmenuzoom AS INTEGER = 1 TO 6
    MenuZoom(countmenuzoom) = 1
NEXT countmenuzoom
MoveScreen = FALSE

DO
    
'GETMOUSE mousex, mousey,,mbutton

starttimer = Timer

FPS = FPS + 1                 
if StartTime_FPSCount + 1 < timer then
 FPS2 = FPS
 FPS = 0
 StartTime_FPSCount = timer
end if

screenlock 
screenset workpage, workpage xor 1    

CLS

'LOCATE 1,1
'PRINT mousex, mousey

DrawStars 2

'MultiPut(,460-CameraX,80-CameraY,text_message(8), 4,4,0,0, @trans)
PUT (105-CameraX,61-CameraY), text_message(9), TRANS

PUT (-40-CameraX,50-CameraY), menu_image, TRANS

PrintFont 490-CameraX,471-CameraY, "VER.0.9 - L.D. NOV 07", Font1, 1, 1

IF MULTIKEY(SC_DOWN) AND KeyFree = TRUE THEN 
MenuPos = MenuPos + 1
KeyFree = FALSE
END IF
IF MULTIKEY(SC_UP) AND KeyFree = TRUE THEN 
MenuPos = MenuPos - 1
KeyFree = FALSE
END IF
IF MenuPos<1 THEN MenuPos = 5
IF MenuPos>5 THEN MenuPos = 1

IF NOT MULTIKEY(SC_UP) AND NOT MULTIKEY(SC_DOWN) THEN KeyFree = TRUE

FOR countmenuzoom AS INTEGER = 1 TO 6
IF MenuZoom(countmenuzoom)>1 AND countmenuzoom<>MenuPos THEN MenuZoom(countmenuzoom) = MenuZoom(countmenuzoom) - 0.08
NEXT countmenuzoom
IF MenuZoom(MenuPos)<2 THEN MenuZoom(MenuPos) = MenuZoom(MenuPos) + 0.08

Rotate = 0
FOR count_menu_line AS INTEGER = 1 TO 5
MultiPut(,370+MenuZoom(count_menu_line)*93-CameraX,181+count_menu_line*20-CameraY,text_message(count_menu_line), MenuZoom(count_menu_line),MenuZoom(count_menu_line),Rotate,0, @trans)
NEXT count_menu_line

IF MULTIKEY(SC_ENTER) AND MoveScreen = FALSE AND CameraX = 0 THEN MoveScreen = TRUE
IF MoveScreen = TRUE THEN CameraX = CameraX - 20
IF CameraX > 0 THEN CameraX = CameraX - 20

IF MoveScreen = TRUE AND CameraX < -660 THEN
SELECT CASE MenuPos
CASE 1
GameMode = 1
countend_game = 0
PlayFieldMidX = 329
PlayFieldStartY = 40
GridSize = 8
playfield_maxwidth = 50
MoveSaucerDirec = 1
MoveSaucer = 0
nebulastartx = 480
nebulamov = 0
CameraX = 0
CameraY = -490
CountGameOver = 0
GameOver = FALSE
MoveScreen = TRUE
cur_level = 1
Score = 0
count_cleared_lines_total = 0
FOR countpart AS INTEGER = 1 TO numofParticles
    Particle(countpart).Locked = FALSE
NEXT countpart
StartNewLevel
EXIT SUB

CASE 2
GameMode = 2
CameraX = 0
CameraY = 0
CountGameOver = 0
GameOver = FALSE
MoveScreen = TRUE
Score = 0
count_cleared_lines_total = 0
FOR countpart AS INTEGER = 1 TO numofParticles
    Particle(countpart).Locked = FALSE
NEXT countpart
StartNewClassicLevel
EXIT SUB

CASE 3
CameraX = 0
CameraY = 0
MoveScreen = TRUE
Options
MoveScreen = FALSE
MenuPos = 3
GOTO startmenu2:
CASE 4
CameraX = 0
CameraY = 0
MoveScreen = TRUE
ReadHighScore
MoveScreen = FALSE
MenuPos = 4
GOTO startmenu2:
CASE 5
FOR c_sprite AS INTEGER = 1 TO 26
    IMAGEDESTROY (sprite(c_sprite))
    IF c_sprite < 21 THEN IMAGEDESTROY (sprite(c_sprite))
NEXT c_sprite
FOR count_tm AS INTEGER = 1 TO 12
    IMAGEDESTROY (text_message(count_tm))
NEXT count_tm
IMAGEDESTROY menu_image
IMAGEDESTROY sidenebula(1)
IMAGEDESTROY sidenebula(2)
END
END SELECT
END IF

workpage xor = 1
screenunlock

' Frame limiter!
sleepintvl = Cint((starttimer + frameintvl - Timer)*1000.0)
If sleepintvl>1 Then 
    Sleep sleepintvl, 1
else 
    sleep 1, 1
end if
  
LOOP

END SUB

SUB InitiateExplosion (eposx AS SINGLE, eposy AS SINGLE, etyp AS INTEGER, elifetime AS INTEGER)

FOR couneexpl AS INTEGER = 1 TO numofExplosions
    
    IF Explosion(couneexpl).Locked = FALSE THEN
        playsample (sample(1))
        Explosion(couneexpl).Locked = TRUE
        Explosion(couneexpl).X = eposx
        Explosion(couneexpl).Y = eposy
        Explosion(couneexpl).Typ = etyp
        Explosion(couneexpl).LifeTime = elifetime
        EXIT SUB
    END IF
    
NEXT couneexpl
    
END SUB

SUB ExplosionLayer
    
FOR countexpl AS INTEGER = 1 TO numofExplosions
    
IF Explosion(countexpl).Locked = TRUE THEN

Explosion(countexpl).LifeTime =  Explosion(countexpl).LifeTime - 1
IF Explosion(countexpl).LifeTime < 0 THEN Explosion(countexpl).Locked = FALSE

PUT (Explosion(countexpl).X-CameraX,Explosion(countexpl).Y-CameraY), sprite(18), TRANS

END IF

NEXT countexpl

END SUB

SUB Recolorize_Normal ( img As ANY Ptr, col As UInteger, h As Integer, w As Integer)        

For iy AS INTEGER = 0 To h - 1
   For ix AS INTEGER = 0 To w - 1
      If Point (ix, iy, img) <> bgrcolor Then
         PSet img, (ix, iy), col
      End If
   Next ix
Next iy

End SUB

SUB Recolorize_Special1 ( img As ANY Ptr, col As UInteger, h As Integer, w As Integer)        

For iy AS INTEGER = 0 To h - 1
   For ix AS INTEGER = 0 To w - 1
      If Point (ix, iy, img) <> bgrcolor Then
         PSet img, (ix, iy), RGB(0,40-ix/7,70-ix/4)
      End If
   Next ix
Next iy

End SUB

SUB Recolorize_Special2 ( img As ANY Ptr, col As UInteger, h As Integer, w As Integer)        

For iy AS INTEGER = 0 To h - 1
   For ix AS INTEGER = 0 To w - 1
      If Point (ix, iy, img) <> bgrcolor Then
         IF iy<h/2 THEN PSet img, (ix, iy), RGB(200-iy*2,200-iy*2,200-iy*2)
         IF iy>=h/2 THEN PSet img, (ix, iy),  RGB(200+iy*2,200+iy*2,200+iy*2)     
      End If
   Next ix
Next iy

End SUB

SUB Recolorize_Special3 ( img As ANY Ptr, col As UInteger, h As Integer, w As Integer)        

For iy AS INTEGER = 0 To h - 1
   For ix AS INTEGER = 0 To w - 1
      If Point (ix, iy, img) <> bgrcolor Then
         SELECT CASE col
         CASE 1
             PSet img, (ix, iy), RGB(255-(iy+ix)*4,255-(iy+ix)*4,255-(iy+ix)*4)
         CASE 2
             PSet img, (ix, iy), RGB(255-(iy+ix)*4,255-(iy+ix)*4,255-(iy+ix)*4)
         CASE 3
             PSet img, (ix, iy), RGB(255-(iy+ix)*4,0,0)
         CASE 4
             PSet img, (ix, iy), RGB(0,255-(iy+ix)*4,0)
         CASE 5
             PSet img, (ix, iy), RGB(100-(iy+ix)*3,100-(iy+ix)*3,255-(iy+ix)*4)
         CASE 6
             PSet img, (ix, iy), RGB(0,255-(iy+ix)*4,255-(iy+ix)*4)
         CASE 7
             PSet img, (ix, iy), RGB(255-(iy+ix)*4,255-(iy+ix)*4,0)
         CASE 8
             PSet img, (ix, iy), RGB(240-(iy+ix)*4,0,240-(iy+ix)*4)
         CASE 9
             PSet img, (ix, iy), RGB(255-(iy+ix)*4,172-(iy+ix)*4,0)
         CASE 10
             PSet img, (ix, iy), RGB(255-(iy+ix)*4,0,0)
         CASE 11
             PSet img, (ix, iy), RGB(0,255-(iy+ix)*4,0)
         CASE 12
             PSet img, (ix, iy), RGB(100-(iy+ix)*4,100-(iy+ix)*4,255-(iy+ix)*4)
         CASE 13
             PSet img, (ix, iy), RGB(0,255-(iy+ix)*4,255-(iy+ix)*4)
         CASE 14
             PSet img, (ix, iy), RGB(255-(iy+ix)*4,255-(iy+ix)*4,0)
         CASE 15
             PSet img, (ix, iy), RGB(240-(iy+ix)*4,0,240-(iy+ix)*4)
         CASE 16
             PSet img, (ix, iy), RGB(255-(iy+ix)*4,172-(iy+ix)*4,0)
         
         END SELECT
      End If
   Next ix
Next iy

End SUB

SUB UpdateNextBlocks
    
SELECT CASE new_block_type

CASE 1
    new_blocksprite = 4
        falling_block(2+4).Column = falling_block(1+4).Column - 1
        falling_block(3+4).Column = falling_block(1+4).Column + 1
        falling_block(4+4).Column = falling_block(1+4).Column + 2
        FOR count_fblock AS INTEGER = 2 TO 4
            falling_block(count_fblock+4).Row = falling_block(1+4).Row
        NEXT count_fblock
CASE 2
    new_blocksprite = 3
    falling_block(2+4).Column = falling_block(1+4).Column - 1
    falling_block(2+4).Row = falling_block(1+4).Row
    falling_block(3+4).Column = falling_block(1+4).Column - 1
    falling_block(3+4).Row = falling_block(1+4).Row + 1
    falling_block(4+4).Column = falling_block(1+4).Column
    falling_block(4+4).Row = falling_block(1+4).Row + 1

CASE 3
    new_blocksprite = 8
    falling_block(2+4).Column = falling_block(1+4).Column - 1
    falling_block(2+4).Row = falling_block(1+4).Row
    falling_block(3+4).Column = falling_block(1+4).Column + 1
    falling_block(3+4).Row = falling_block(1+4).Row
    falling_block(4+4).Column = falling_block(1+4).Column
    falling_block(4+4).Row = falling_block(1+4).Row - 1

CASE 4
    new_blocksprite = 5
    falling_block(2+4).Column = falling_block(1+4).Column - 1
    falling_block(2+4).Row = falling_block(1+4).Row
    falling_block(3+4).Column = falling_block(1+4).Column + 1
    falling_block(3+4).Row = falling_block(1+4).Row
    falling_block(4+4).Column = falling_block(1+4).Column + 1
    falling_block(4+4).Row = falling_block(1+4).Row - 1

CASE 5
    new_blocksprite = 6
    falling_block(2+4).Column = falling_block(1+4).Column - 1
    falling_block(2+4).Row = falling_block(1+4).Row
    falling_block(3+4).Column = falling_block(1+4).Column + 1
    falling_block(3+4).Row = falling_block(1+4).Row
    falling_block(4+4).Column = falling_block(1+4).Column + 1
    falling_block(4+4).Row = falling_block(1+4).Row + 1

CASE 6
    new_blocksprite = 7
    falling_block(2+4).Column = falling_block(1+4).Column - 1
    falling_block(2+4).Row = falling_block(1+4).Row
    falling_block(3+4).Column = falling_block(1+4).Column - 1
    falling_block(3+4).Row = falling_block(1+4).Row - 1
    falling_block(4+4).Column = falling_block(1+4).Column
    falling_block(4+4).Row = falling_block(1+4).Row + 1

CASE 7
    new_blocksprite = 9
    falling_block(2+4).Column = falling_block(1+4).Column - 1
    falling_block(2+4).Row = falling_block(1+4).Row - 1
    falling_block(3+4).Column = falling_block(1+4).Column
    falling_block(3+4).Row = falling_block(1+4).Row - 1
    falling_block(4+4).Column = falling_block(1+4).Column + 1
    falling_block(4+4).Row = falling_block(1+4).Row

END SELECT

END SUB

SUB DrawNextBlocksBombs

IF new_dropping_object = BLOCK THEN
IF falling_block(5).Row < -1 THEN falling_block(5).Row = falling_block(5).Row + 0.01
UpdateNextBlocks
FOR count_fblock AS INTEGER = 5 TO 8
        IF GameMode = 1 THEN PUT (PlayFieldMidX-(GridSize+1)-(playfield_maxwidth/2)*(GridSize+1)+falling_block(count_fblock).Column*(GridSize+1)-CameraX,(falling_block(count_fblock).Row*(GridSize+1))+PlayFieldStartY-CameraY), sprite(new_blocksprite), TRANS
        IF GameMode = 2 THEN PUT (165+falling_block(count_fblock).Column*(GridSize+1)-CameraX,32+falling_block(count_fblock).Row*(GridSize+1)-CameraY), bigsprite(new_blocksprite), TRANS
NEXT count_fblock
END IF

IF new_dropping_object = BOMB AND GameMode = 1 THEN
IF falling_bomb(7).Row < -1 THEN falling_bomb(7).Row = falling_bomb(7).Row + 0.01
UpdateNextBombs
FOR count_fblock AS INTEGER = 7 TO 12
        IF falling_bomb(count_fblock).Status = ALIVE THEN PUT (PlayFieldMidX-(GridSize+1)-(playfield_maxwidth/2)*(GridSize+1)+falling_bomb(count_fblock).Column*(GridSize+1)-CameraX,(falling_bomb(count_fblock).Row*(GridSize+1))+PlayFieldStartY-CameraY), sprite(17), TRANS
NEXT count_fblock
END IF

END SUB

SUB UpdateNextBombs
    
SELECT CASE new_bomb_type

CASE 1
    falling_bomb(2+6).Column = falling_bomb(1+6).Column + 1
    falling_bomb(2+6).Row = falling_bomb(1+6).Row
  
CASE 2
    falling_bomb(2+6).Column = falling_bomb(1+6).Column + 1
    falling_bomb(2+6).Row = falling_bomb(1+6).Row
    falling_bomb(3+6).Column = falling_bomb(1+6).Column
    falling_bomb(3+6).Row = falling_bomb(1+6).Row + 1
    falling_bomb(4+6).Column = falling_bomb(1+6).Column + 1
    falling_bomb(4+6).Row = falling_bomb(1+6).Row + 1

CASE 3
    falling_bomb(2+6).Column = falling_bomb(1+6).Column + 1
    falling_bomb(2+6).Row = falling_bomb(1+6).Row
    falling_bomb(3+6).Column = falling_bomb(1+6).Column
    falling_bomb(3+6).Row = falling_bomb(1+6).Row - 1
    falling_bomb(4+6).Column = falling_bomb(1+6).Column + 1
    falling_bomb(4+6).Row = falling_bomb(1+6).Row - 1
    falling_bomb(5+6).Column = falling_bomb(1+6).Column
    falling_bomb(5+6).Row = falling_bomb(1+6).Row + 1
    falling_bomb(6+6).Column = falling_bomb(1+6).Column + 1
    falling_bomb(6+6).Row = falling_bomb(1+6).Row + 1

END SELECT

END SUB

SUB DrawShipOrnament (startx AS INTEGER, starty AS INTEGER, orn_type AS INTEGER, orn_color_border AS UINTEGER, orn_color_fill AS UINTEGER)
    
SELECT CASE orn_type

CASE 1
    LINE (startx, starty)-(startx+10,starty-10), orn_color_border
    LINE (startx+10,starty-10)-(startx+10,starty+40), orn_color_border
    LINE (startx+10,starty+40)-(startx,starty+30), orn_color_border
    LINE (startx,starty+30)-(startx,starty), orn_color_border
    PAINT (startx+5, starty+5), orn_color_fill, orn_color_border
CASE 2
    LINE (startx, starty)-(startx+10,starty+10), orn_color_border
    LINE (startx+10,starty+10)-(startx+10,starty+40), orn_color_border
    LINE (startx+10,starty+40)-(startx,starty+50), orn_color_border
    LINE (startx,starty+50)-(startx,starty), orn_color_border
    PAINT (startx+2, starty+15), orn_color_fill, orn_color_border
CASE 3
    LINE (startx, starty)-(startx+10,starty+20), orn_color_border
    LINE (startx+10,starty+20)-(startx+126-9,starty+20), orn_color_border
    LINE (startx+126-9,starty+20)-(startx+136-9,starty), orn_color_border
    LINE (startx+136-9,starty)-(startx,starty), orn_color_border
    PAINT (startx+12, starty+2), orn_color_fill, orn_color_border
    LINE (startx+20, starty+5)-(startx+126-20,starty+10), BackG_Color2,BF
    LINE (startx+20, starty+5)-(startx+126-20,starty+10), BackG_Color2,BF
CASE 4
    LINE (startx, starty)-(startx+5,starty-5), orn_color_border
    LINE (startx+5,starty-5)-(startx+15,starty-5), orn_color_border
    LINE (startx+15,starty-5)-(startx+20,starty), orn_color_border
    LINE (startx+20,starty)-(startx+20,starty+15), orn_color_border
    LINE (startx+20,starty+15)-(startx,starty+15), orn_color_border
    LINE (startx,starty+15)-(startx,starty), orn_color_border
    PAINT (startx+5, starty+12), orn_color_fill, orn_color_border
CASE 5
    LINE (startx, starty)-(startx,starty+16), orn_color_border
    LINE (startx,starty+16)-(startx+15,starty+8), orn_color_border
    LINE (startx+15,starty+8)-(startx, starty), orn_color_border
    PAINT (startx+5, starty+5), orn_color_fill, orn_color_border
CASE 6
    LINE (startx, starty)-(startx,starty+16), orn_color_border
    LINE (startx,starty+16)-(startx-15,starty+8), orn_color_border
    LINE (startx-15,starty+8)-(startx, starty), orn_color_border
    PAINT (startx-5, starty+5), orn_color_fill, orn_color_border
CASE 7
    LINE (startx, starty)-(startx+8,starty+40), orn_color_border, BF
    LINE (startx+2,starty+40)-(startx+6,starty+60), orn_color_border, BF
CASE 8
    LINE (startx, starty)-(startx+8,starty+40), orn_color_border, BF
    CIRCLE (startx+4,starty+60), 30, orn_color_border , , , , F
    CIRCLE (startx+4,starty+60), 10, BackG_Color2 , , , , F
CASE 9
    LINE (startx, starty)-(startx+10,starty+20), orn_color_border
    LINE (startx+10,starty+20)-(startx+126-9-18,starty+20), orn_color_border
    LINE (startx+126-9-18,starty+20)-(startx+136-9-18,starty), orn_color_border
    LINE (startx+136-9-18,starty)-(startx,starty), orn_color_border
    PAINT (startx+12, starty+2), orn_color_fill, orn_color_border
    LINE (startx+20, starty+5)-(startx+126-20-18,starty+8), BackG_Color2,BF
    LINE (startx+20, starty+10)-(startx+126-20-18,starty+13), BackG_Color2,BF

END SELECT

END SUB

SUB DrawLevelShips
    
SELECT CASE cur_level

CASE 1
DrawShipOrnament 254-CameraX, 230-CameraY, 1, Wall_Color, Wall_Color
DrawShipOrnament 393-CameraX, 220-CameraY, 2, Wall_Color, Wall_Color
DrawShipOrnament 265-CameraX, 301-CameraY-2*9, 3, Wall_Color, Wall_Color
DrawShipOrnament 249-CameraX, 32-CameraY, 4, Wall_Color, Wall_Color
DrawShipOrnament 388-CameraX, 32-CameraY, 4, Wall_Color, Wall_Color

IF Frame3=1 THEN InitiateParticle 260,20,2,30
IF Frame3=1 THEN InitiateParticle 399,20,2,30

CASE 2
DrawShipOrnament 233-CameraX, 122-CameraY, 7, Wall_Color, Wall_Color
DrawShipOrnament 414-CameraX, 122-CameraY, 7, Wall_Color, Wall_Color
DrawShipOrnament 265-CameraX, 319-CameraY, 3-2*9, Wall_Color, Wall_Color
DrawShipOrnament 228-CameraX, 33-CameraY, 4, Wall_Color, Wall_Color
DrawShipOrnament 408-CameraX, 33-CameraY, 4, Wall_Color, Wall_Color

IF Frame3=1 THEN InitiateParticle 239,20,2,30
IF Frame3=1 THEN InitiateParticle 419,20,2,30

CASE 3
DrawShipOrnament 265-CameraX, 319-CameraY-2*9, 3, Wall_Color, Wall_Color
DrawShipOrnament 323-CameraX, 335-CameraY-2*9, 8, Wall_Color, Wall_Color
DrawShipOrnament 393-CameraX, 178-CameraY, 2, Wall_Color, Wall_Color
DrawShipOrnament 254-CameraX, 178+15-CameraY, 1, Wall_Color, Wall_Color
'DrawShipOrnament 408-CameraX, 33-CameraY, 4, Wall_Color, Wall_Color

'IF Frame3=1 THEN InitiateParticle 239,20,2,30
'IF Frame3=1 THEN InitiateParticle 419,20,2,30

CASE 4
DrawShipOrnament 219-CameraX, 50-CameraY, 6, Wall_Color, Wall_Color
DrawShipOrnament 438-CameraX, 50-CameraY, 5, Wall_Color, Wall_Color
DrawShipOrnament 393-CameraX, 237-CameraY, 2, Wall_Color, Wall_Color
DrawShipOrnament 254-CameraX, 237+11-CameraY, 1, Wall_Color, Wall_Color
DrawShipOrnament 228-CameraX, 33-CameraY, 4, Wall_Color, Wall_Color
DrawShipOrnament 408-CameraX, 33-CameraY, 4, Wall_Color, Wall_Color
DrawShipOrnament 228+50-CameraX, 33-CameraY, 4, Wall_Color, Wall_Color
DrawShipOrnament 408-50-CameraX, 33-CameraY, 4, Wall_Color, Wall_Color

IF Frame3=1 THEN InitiateParticle 239,20,2,30
IF Frame3=1 THEN InitiateParticle 419,20,2,30
IF Frame3=1 THEN InitiateParticle 239+50,20,2,30
IF Frame3=1 THEN InitiateParticle 419-50,20,2,30

CASE 5
DrawShipOrnament 274-CameraX, 373-CameraY, 9-3*9, Wall_Color, Wall_Color
DrawShipOrnament 278-CameraX, 33-CameraY, 4, Wall_Color, Wall_Color
DrawShipOrnament 359-CameraX, 33-CameraY, 4, Wall_Color, Wall_Color
DrawShipOrnament 219-CameraX+54, 80-CameraY, 6, Wall_Color, Wall_Color
DrawShipOrnament 438-CameraX-54, 80-CameraY, 5, Wall_Color, Wall_Color
DrawShipOrnament 219-CameraX+54, 180-CameraY, 6, Wall_Color, Wall_Color
DrawShipOrnament 438-CameraX-54, 180-CameraY, 5, Wall_Color, Wall_Color
DrawShipOrnament 219-CameraX+54, 280-CameraY, 6, Wall_Color, Wall_Color
DrawShipOrnament 438-CameraX-54, 280-CameraY, 5, Wall_Color, Wall_Color

IF Frame3=1 THEN InitiateParticle 278+11,20,2,30
IF Frame3=1 THEN InitiateParticle 359+11,20,2,30

END SELECT

END SUB

SUB InputName (mode AS INTEGER, ypos AS INTEGER)

DIM countlet AS INTEGER ' A variable used to flag letters in the inputted name.
DIM inputted_letter AS STRING ' A variable used to flag currently inputted letter.
DIM blinker AS STRING ' A string used to hold the "_" to enable the blinking cursor effect.
DIM Frame AS INTEGER ' A variable used to enable the blinking cursor effect.
DIM AS INTEGER numofletters = 8
REDIM playerletter(numofletters) AS STRING ' A variable used to hold the name of the player.
DIM playername as string

' Reset the name to input and
' letters to input (might some
' be in memory from the
' last inputting.
playername=""
countlet=1
for count_letter AS INTEGER = 1 to 8
playerletter(count_letter)=""
next count_letter

WHILE INKEY$ <> "" ' Empty INKEY$ since the previous usage
SLEEP 1            ' of MULTIKEY might leave it filled with a
WEND               ' key entry.

DO 
    
starttimer = Timer

screenlock 
screenset workpage, workpage xor 1 

LINE (0,0)-(639,479), RGBA(0, 0, 0, 255), BF

DrawStars 3

IF GameMode = 2 THEN 

DrawLevel
    
        PrintFont 370+15 - CameraX, 40 - CameraY, "H I G H  S C O R E S", Font1, 1,1
    FOR tar AS INTEGER = 1 TO 10
        PrintFont 390+15-CameraX, 60 + tar * 15-CameraY, textarray(tar), Font1, 1,1
    NEXT tar
    FOR ar AS INTEGER = 11 TO 20
        PrintFont 460+15-CameraX, 60 + (ar - 10) * 15-CameraY, textarray(ar), Font1, 1,1
    NEXT ar
    
PrintFont 390+15-CameraX,280-CameraY, "SCORE: "+zeros+STR$(Score), Font1, 1, 1
PrintFont 390+15-CameraX,300-CameraY, "LINES CLEARED:"+STR$(count_cleared_lines_total), Font1, 1, 1
PrintFont 390+15-CameraX,320-CameraY, "LEVEL:"+STR$(cur_level), Font1, 1, 1
PrintFont 130+15-CameraX,12-CameraY, "NEXT PIECE:", Font1, 1, 1

END IF

blinker=" "
Frame2 = (Frame2 mod 16) + 1
if Frame2>8 then blinker="_"
inputted_letter = INKEY$   

if asc(ucase$(inputted_letter )) >= 65 and asc(ucase$(inputted_letter )) <= 90 and countlet<9 then
playerletter(countlet) = UCASE$(inputted_letter )
countlet=countlet+1
end if
if asc(inputted_letter ) = 8 and countlet > 1 then
countlet=countlet-1
playerletter(countlet) = ""
end if

playername=""
' Add each letter to the playername string.
FOR count_pname AS INTEGER = 1 to 8
playername = playername + playerletter(count_pname)
NEXT count_pname

IF GameMode = 1 THEN 
    PrintFont 360+15-CameraX, 220-CameraY, playername+blinker, Font1, 1, 1
    PrintFont 190+15-CameraX, 220-CameraY, "PLEASE INPUT YOUR NAME:", Font1, 1, 1
    IF MoveScreen = TRUE THEN CameraX = CameraX - 20
    IF MoveScreen = FALSE AND MULTIKEY(SC_ENTER) THEN MoveScreen = TRUE
END IF

IF GameMode = 2 THEN 
    PrintFont 390+15-CameraX, 60 + ypos * 15-CameraY, playername+blinker, Font1, 1, 1
    PrintFont 390+15-CameraX, 400, "PLEASE INPUT YOUR NAME", Font1, 1, 1
END IF

workpage xor = 1
screenunlock

' Frame limiter!
sleepintvl = Cint((starttimer + frameintvl - Timer)*1000.0)
If sleepintvl>1 Then 
    Sleep sleepintvl, 1
else 
    sleep 1, 1
end if

LOOP UNTIL (MULTIKEY(SC_ENTER) AND countlet > 1 AND GameMode = 2) OR (GameMode = 1 AND countlet > 1 AND MoveScreen = TRUE AND CameraX < -660)
' countlet > 1 condition forces to user to input at least 1 letter!

highname = playername

END SUB

SUB StartNewLevel

AddToScore = 0

count_cleared_lines_level = 0 ' Level lines cleared
count_current_cleared_lines = 0 ' Lines cleared in one drop
count_drop = 0 ' counts dropped blocks
countend_level = 0
countstart_level = 120
IF cur_level = 1 THEN countstart_level = 1200
falling_block(1).Column = 26
falling_block(1).Row = -5

falling_block(5).Column = 25
falling_block(5).Row = -5

current_block_type = 2
current_block_position = 1
dropping_object = BLOCK
new_dropping_object = BLOCK

InGame_Message.Locked = FALSE

misc_random_number = INT(RND * 12) + 1
IF misc_random_number = 10 THEN new_dropping_object = BOMB
falling_bomb(7).Column = 25
falling_bomb(7).Row = -5

new_block_type = INT(RND * 7) + 1
new_bomb_type = INT(RND * 3) + 1

IF new_block_type = 2 OR new_block_type = 6 THEN falling_block(5).Column = falling_block(5).Column+1

FOR reset_bomb AS INTEGER = 1 TO 12
    falling_bomb(reset_bomb).Status = DESTROYED
NEXT reset_bomb

FOR reset_bomb AS INTEGER = 7 TO 6+new_bomb_type*2
    falling_bomb(reset_bomb).Status = ALIVE
NEXT reset_bomb

LoadLevel cur_level
InitLevel

END SUB

SUB StartNewClassicLevel

AddToScore = 0
CameraX = - 650
MoveScreen = TRUE
countend_game = 0

OPEN "classic_score_file.dat" FOR INPUT AS #3
FOR tar AS INTEGER = 1 TO 20
INPUT #3, textarray(tar)
'neoENCdepass SADD(textarray(tar)), LEN(textarray(tar)), "scubby"
NEXT tar
CLOSE #3

PlayFieldMidX = 180
PlayFieldStartY = 80
GridSize = 16
numofrows = 20
playfield_maxwidth = 10

Wall_Color = RGB(0,0,70)
BackG_Color = RGB(20,65,180)
BackG_BorderColor = RGB(20,50,150)

FOR count_row AS INTEGER = 9 TO numofrows
row_size(count_row) = 10    
NEXT count_row

level_demarcation_line = 21
start_blocks = 0
DropBlock_FrameValue = 55
speedup_after_numrows = 9

cur_level = 1
count_cleared_lines_level = 0 ' Level lines cleared
count_current_cleared_lines = 0 ' Lines cleared in one drop
count_drop = 0 ' counts dropped blocks
countend_level = 0
countstart_level = 0
CountGameOver = 0

falling_block(1).Column = 5
falling_block(1).Row = 1

falling_block(5).Column = 0
falling_block(5).Row = 0

current_block_type = 2
current_block_position = 1
dropping_object = BLOCK
new_dropping_object = BLOCK

InGame_Message.Locked = FALSE

new_block_type = INT(RND * 7) + 1

IF current_block_type = 2 OR current_block_type = 6 THEN falling_block(1).Column = falling_block(1).Column+1
IF new_block_type > 2 AND new_block_type <> 5 THEN falling_block(5).Row = 1
IF new_block_type = 2 OR new_block_type = 6 THEN falling_block(5).Column = falling_block(5).Column+1

FOR reset_bomb AS INTEGER = 1 TO 12
    falling_bomb(reset_bomb).Status = DESTROYED
NEXT reset_bomb

FOR reset_bomb AS INTEGER = 7 TO 6+new_bomb_type*2
    falling_bomb(reset_bomb).Status = ALIVE
NEXT reset_bomb

InitLevel

END SUB

SUB Options ()
    
CameraX = 640
MenuPos = 1
    
DIM sfxv AS STRING
DIM grmode AS STRING
DIM bgrmode AS STRING
DIM MenuY AS INTEGER

DO
    
'GETMOUSE mousex, mousey,,mbutton

Frame1 = (Frame1 MOD 4) + 1

starttimer = Timer

FPS = FPS + 1                 
if StartTime_FPSCount + 1 < timer then
 FPS2 = FPS
 FPS = 0
 StartTime_FPSCount = timer
end if

screenlock 
screenset workpage, workpage xor 1 

CLS
DrawStars 2

'LOCATE 1,1
'PRINT mousex, mousey

sfxv = "0 %"
IF SFXVolume = 1 THEN sfxv = "25 %"
IF SFXVolume = 2 THEN sfxv = "50 %"
IF SFXVolume = 3 THEN sfxv = "75 %"
IF SFXVolume = 4 THEN sfxv = "100 %"
grmode = "NO"
IF GraphicMode = 2 THEN grmode = "YES"
bgrmode = "TRANSPARENT"
IF PlayField_Backg = TRUE THEN bgrmode = "FILLED"

PUT (233-CameraX,128-CameraY), text_message(10), TRANS

PrintFont 260-CameraX,190-CameraY, "PLAYFIELD: "+bgrmode, Font1, 2, 1
PrintFont 260-CameraX,200-CameraY, "SFX VOLUME: "+sfxv, Font1, 2, 1
PrintFont 260-CameraX,210-CameraY, "FULL SCREEN: "+grmode, Font1, 2, 1
PrintFont 260-CameraX,220-CameraY, "EXIT", Font1, 2, 1

PrintFont 230-CameraX,180+MenuY-CameraY, "->>", Font1, 2, 1

IF MULTIKEY(SC_DOWN) AND KeyFree = TRUE THEN 
MenuPos = MenuPos + 1
KeyFree = FALSE
END IF
IF MULTIKEY(SC_UP) AND KeyFree = TRUE THEN 
MenuPos = MenuPos - 1
KeyFree = FALSE
END IF
IF MenuPos > 4 THEN MenuPos = 4
IF MenuPos < 1 THEN MenuPos = 1
IF MenuY < MenuPos * 10 THEN MenuY = MenuY + 2
IF MenuY > MenuPos * 10 THEN MenuY = MenuY - 2

IF MULTIKEY(SC_ENTER) AND KeyFree = TRUE AND MoveScreen = FALSE THEN
KeyFree = FALSE
SELECT CASE MenuPos
CASE 1
IF PlayField_Backg = TRUE THEN
    PlayField_Backg = FALSE
ELSE
   PlayField_Backg = TRUE
END IF

CASE 2
SFXVolume = SFXVolume + 1
IF SFXVolume > 4 THEN SFXVolume = 0
IF SFXVolume = 0 THEN SetVol = 0
IF SFXVolume = 1 THEN SetVol = 63
IF SFXVolume = 2 THEN SetVol = 126
IF SFXVolume = 3 THEN SetVol = 190
IF SFXVolume = 4 THEN SetVol = 255
'IF PlaySound = TRUE THEN setSoundVolume
CASE 3
IF GraphicMode = 1 THEN
GraphicMode = 2
screenunlock
SCREENRES 640, 480, 16, 2, GFX_FULLSCREEN
screenlock
GOTO skipchoices:
END IF
IF GraphicMode = 2 THEN
GraphicMode = 1
screenunlock
SCREENRES 640, 480, 16, 2, GFX_WINDOWED
screenlock
GOTO skipchoices:
END IF
CASE 4
MoveScreen = TRUE
CameraX = -1
END SELECT
END IF

skipchoices:

IF CameraX > 0 AND MoveScreen = TRUE THEN 
    CameraX = CameraX - 20
    IF CameraX <= 0 THEN 
        CameraX = 0
        MoveScreen = FALSE
    END IF
END IF

IF MoveScreen = TRUE AND CameraX < 0 THEN CameraX = CameraX - 20
IF MoveScreen = TRUE AND CameraX < -640 THEN EXIT SUB

workpage xor = 1
screenunlock

' Frame limiter!
sleepintvl = Cint((starttimer + frameintvl - Timer)*1000.0)
If sleepintvl>1 Then 
    Sleep sleepintvl, 1
else 
    sleep 1, 1
end if

IF (NOT MULTIKEY(SC_UP) AND NOT MULTIKEY(SC_DOWN) AND NOT MULTIKEY(SC_ENTER)) THEN KeyFree = TRUE

LOOP

END SUB

SUB DisplayTextMessage

IF InGame_Message.Locked = TRUE THEN
    PrintFont InGame_Message.X-CameraX,InGame_Message.Y, InGame_Message.MText, Font1, 1, 1
    InGame_Message.LifeTime = InGame_Message.LifeTime - 1
    IF InGame_Message.LifeTime = 0 THEN InGame_Message.Locked = FALSE
END IF

END SUB

SUB InitiateTextMessage (tx AS INTEGER, ty AS INTEGER, tstring AS STRING, ttime AS INTEGER)
    
    InGame_Message.Locked = TRUE
    InGame_Message.LifeTime = ttime
    InGame_Message.X = tx
    InGame_Message.Y = ty
    InGame_Message.Mtext = tstring
        
END SUB

SUB ReadHighScore
    
CameraX = 640

OPEN "hi_score_file.dat" FOR INPUT AS #3
FOR tar AS INTEGER = 1 TO 8
INPUT #3, textarray(tar)
'neoENCdepass SADD(textarray(tar)), LEN(textarray(tar)), "scubby"
NEXT tar
CLOSE #3

DO

starttimer = Timer

FPS = FPS + 1                 
if StartTime_FPSCount + 1 < timer then
 FPS2 = FPS
 FPS = 0
 StartTime_FPSCount = timer
end if

screenlock
screenset workpage, workpage xor 1

CLS
DrawStars 2

PUT (240-CameraX,105-CameraY), text_message(11), TRANS

FOR tar AS INTEGER = 1 TO 4
PrintFont 270-CameraX, 140 + tar * 12-CameraY, textarray(tar), Font1, 1,1
NEXT tar
FOR ar AS INTEGER = 5 TO 8
PrintFont 340-CameraX, 140 + (ar - 4) * 12-CameraY, textarray(ar), Font1, 1,1
NEXT ar

PrintFont 205-CameraX, 270-CameraY, "PRESS ENTER TO RETURN TO MAIN MENU", Font1, 1, 1

IF CameraX > 0 AND MoveScreen = TRUE THEN 
    CameraX = CameraX - 20
    IF CameraX <= 0 THEN 
        CameraX = 0
        MoveScreen = FALSE
    END IF
END IF

IF MoveScreen = TRUE AND CameraX < 0 THEN CameraX = CameraX - 20
IF MoveScreen = TRUE AND CameraX < -640 THEN EXIT SUB

IF MULTIKEY(SC_ENTER) AND CameraX = 0 THEN
    MoveScreen = TRUE
    CameraX = -1
END IF

workpage xor = 1
screenunlock

' Frame limiter!
sleepintvl = Cint((starttimer + frameintvl - Timer)*1000.0)
If sleepintvl>1 Then 
    Sleep sleepintvl, 1
else 
    sleep 1, 1
end if

LOOP

END SUB

SUB WriteHighScore (mode AS INTEGER)

DIM scores(20) AS INTEGER
DIM startwrite AS INTEGER
DIM num_of_scores AS INTEGER
DIM hscore_file AS STRING

hscore_file = "hi_score_file.dat"
IF mode = 2 THEN hscore_file = "classic_score_file.dat"

num_of_scores = 4

IF mode = 2 THEN num_of_scores = 10

' Open the high score file and read
' high score entries from it.
OPEN hscore_file FOR INPUT AS #3
FOR tar AS INTEGER = 1 TO num_of_scores*2
INPUT #3, textarray(tar)
'neoENCdepass SADD(textarray(tar)), LEN(textarray(tar)), "scubby"
NEXT tar
CLOSE #3

' Scores are saved in textarray positions
' 5 to 8, but we need to save them
' in scores(1) to scores(4).
DIM ar2 AS INTEGER
FOR ar AS INTEGER = num_of_scores+1 TO num_of_scores*2
ar2 = ar - num_of_scores
scores(ar2) = VAL(textarray(ar))
NEXT ar

' If the player's score is higher
' that the lowest score in the
' high score table...
IF Score > scores(num_of_scores) THEN

' Loop through all 4 scores.
FOR nameloop AS INTEGER = 1 TO num_of_scores
    
IF Score > scores(nameloop) THEN

' Flag the inputted name from the
' InputName sub.
highname = ""
startwrite = nameloop
GOTO writescore:
END IF

NEXT nameloop

' The code that bumps down lower scores onto
' lower positions before the new table
' is saved. Example, if your score is
' second, the previous second needs to
' be bumped on the third position, while
' the one from the third position needs
' to be bumped on position 4.
writescore:
DIM n AS INTEGER
IF startwrite = num_of_scores THEN GOTO writescore2:
FOR m AS INTEGER = num_of_scores-1 TO startwrite STEP -1
n = m + 1
textarray(n) = textarray(m)
scores(n) = scores(m)
NEXT m
writescore2:
textarray(startwrite) = ""
scores(startwrite) = Score

FOR ar AS INTEGER = num_of_scores+1 TO num_of_scores*2
ar2 = ar - num_of_scores
textarray(ar) = LTRIM$(STR$(scores(ar2)))
NEXT ar

InputName GameMode, startwrite

textarray(startwrite) = highname

FOR ar AS INTEGER = num_of_scores+1 TO num_of_scores*2
ar2 = ar - num_of_scores
textarray(ar) = LTRIM$(STR$(scores(ar2)))
NEXT ar

OPEN hscore_file FOR OUTPUT AS #3
FOR tar AS INTEGER = 1 TO num_of_scores*2
'neoENCpass SADD(textarray(tar)), LEN(textarray(tar)), "scubby"
PRINT #3, textarray(tar)
NEXT tar
CLOSE #3

IF GameMode = 1 THEN 
    CameraX = 0
    CameraY = 0
    MoveScreen = TRUE
    ReadHighScore
END IF

END IF

IF GameMode = 2 THEN
    
playagain = FALSE
MoveScreen = FALSE

DO 
    
starttimer = Timer

screenlock 
screenset workpage, workpage xor 1 

LINE (0,0)-(639,479), RGBA(0, 0, 0, 255), BF

DrawStars 2

DrawLevel

    PrintFont 370+15 - CameraX, 40 - CameraY, "H I G H  S C O R E S", Font1, 1,1
    FOR tar AS INTEGER = 1 TO 10
        PrintFont 390+15-CameraX, 60 + tar * 15-CameraY, textarray(tar), Font1, 1,1
    NEXT tar
    FOR ar AS INTEGER = 11 TO 20
        PrintFont 460+15-CameraX, 60 + (ar - 10) * 15-CameraY, textarray(ar), Font1, 1,1
    NEXT ar
    
PrintFont 390+15-CameraX,280-CameraY, "SCORE: "+zeros+STR$(Score), Font1, 1, 1
PrintFont 390+15-CameraX,300-CameraY, "LINES CLEARED:"+STR$(count_cleared_lines_total), Font1, 1, 1
PrintFont 390+15-CameraX,320-CameraY, "LEVEL:"+STR$(cur_level), Font1, 1, 1
PrintFont 130+15-CameraX,12-CameraY, "NEXT PIECE:", Font1, 1, 1
PrintFont 390+15-CameraX, 400, "PLAY AGAIN(Y/N)", Font1, 1, 1

workpage xor = 1
screenunlock

' Frame limiter!
sleepintvl = Cint((starttimer + frameintvl - Timer)*1000.0)
If sleepintvl>1 Then 
    Sleep sleepintvl, 1
else 
    sleep 1, 1
end if

IF MULTIKEY(SC_Y) THEN 
    MoveScreen = TRUE
    playagain = TRUE
END IF
IF MULTIKEY(SC_N) THEN 
    MoveScreen = TRUE
    playagain = FALSE
END IF

IF MoveScreen = TRUE THEN CameraX = CameraX - 20

IF CameraX = - 640 AND playagain = TRUE THEN

GameMode = 2
CameraX = 0
CameraY = 0
CountGameOver = 0
GameOver = FALSE
MoveScreen = TRUE
Score = 7000
count_cleared_lines_total = 0
FOR countpart AS INTEGER = 1 TO numofParticles
    Particle(countpart).Locked = FALSE
NEXT countpart
StartNewClassicLevel
EXIT SUB
    
END IF

IF CameraX = - 660 AND playagain = FALSE THEN EXIT SUB

LOOP

END IF

END SUB

SUB neoENCdepass (Offsett AS ANY PTR, Lengthh AS INTEGER, passsword AS STRING)

' Subs used to encrypt and decrypt the high scores
' data.

DIM nowpos AS INTEGER, Bytee AS INTEGER, I AS INTEGER

   IF LEN(passsword) = 0 THEN EXIT SUB
   nowpos = 1

   FOR I = 0 TO Lengthh - 1
      Bytee = PEEK(Offsett + I)
      Bytee = Bytee - ASC(MID$(passsword, nowpos, 1))
      IF Bytee < 0 THEN Bytee = Bytee + 256
      POKE Offsett + I, Bytee
      nowpos = nowpos + 1
      IF nowpos > LEN(passsword) THEN nowpos = 1
   NEXT I

END SUB

SUB neoENCpass (Offset AS ANY PTR, Length AS INTEGER, password AS STRING)
   
DIM nowpos AS INTEGER, Bytee AS INTEGER, I AS INTEGER   
   
   IF LEN(password) = 0 THEN EXIT SUB

   nowpos = 1
   
   FOR I = 0 TO Length - 1
      Bytee = PEEK(Offset + I)
      Bytee = Bytee + ASC(MID$(password, nowpos, 1))
      IF Bytee > 255 THEN Bytee = Bytee - 256
      POKE Offset + I, Bytee
      nowpos = nowpos + 1
      IF nowpos > LEN(password) THEN nowpos = 1
   NEXT I

END SUB

Sub setSoundVolume
IF PlaySound = TRUE THEN
IF SFXVolume = 0 THEN SetVol = 0
IF SFXVolume = 1 THEN SetVol = 63
IF SFXVolume = 2 THEN SetVol = 126
IF SFXVolume = 3 THEN SetVol = 190
IF SFXVolume = 4 THEN SetVol = 255
FSOUND_SetSFXMasterVolume(SetVol)
FSOUND_SetVolumeAbsolute(1, SetVol)
END IF
End Sub

sub playsample(plsnd as integer ptr)
    IF SFXVolume = 0 THEN EXIT SUB
    If PlaySound = TRUE Then 
        'setSoundVolume
        FSOUND_PlaySound(FSOUND_FREE, plsnd)
        setSoundVolume
    END IF
end sub

