''
''
''PNG Custom Font creator - Creates the config file for a font to be used by PNGcustomfont
''
''

'Run this program, give it the input it desires.  It will create a config file for a font
'consisting of a grid of fixed-size characters.  If your characters have different sizes you
'will need to edit this file a bit before using it.

'Tip on using fonts with variable-size characters:  try to put your characters in a grid
'or at least have the same number of characters per row if not in a grid.  This will mean
'the file on-disk is larger than it need be, but will make it much easier to generate the
'config file for it.

'It is probable that not all of these variables are even used by the program...
'I'm just too lazy to get it right.
Dim As String fontfile, fontimage, fiformat, fdmode
Dim As Integer cdepth, nchars
Dim As Integer r, c, w, h, w1, h1, sc
Dim As Integer x1, y1, x2, y2, bx, by
Dim As Integer x0, y0, i0
Dim As Integer leftx, topy

Cls

Print "Please enter the name of the font you wish to create."
Input fontfile
Print "Please enter the name of the image you wish to use as a font."
Input fontimage
Print "Please enter the number of columns of characters in the image."
Input c
Print "Please enter the number of rows of characters in the image."
Input r
Print "There are " + Str(c*r) + " characters in total in your font."
Print "Please enter a colour depth (default 32 bits)"
Input cdepth
If cdepth = 0 Then cdepth = 32
Print "Please enter the default drawing mode (pset, alpha, or trans):"
Input fdmode
Print "What is the ASCII value of the FIRST character (recommend 32 = space)?"
Input sc
Print "Please enter the width (in pixels) of each character."
Input w
Print "Please enter the height (in pixels) of each character."
Input h
Print "Some fonts may have a grid you don't want included."
Print "If not, enter 0 for the following two values."
Print "How many pixels buffer between each character horizontally?"
Input bx
Print "How many pixels buffer between each character vertically?"
Input by
Print "Perhaps the first character in your font does not start at (0,0)."
Print "What is the x of the leftmost edge of the grid? (0 is default)"
Input leftx
Print "What is the y of the topmost edge of the grid? (0 is default)"
Input topy

fiformat = "png"
If LCase(Left(fontimage,3)) = "png" Then fiformat = "png"
If LCase(Left(fontimage,3)) = "bmp" Then fiformat = "bmp"

If fdmode = "" Then
  If fiformat = "png" Then
    fdmode = "Alpha"
  Else
    fdmode = "Trans"
  End If
End If

Open fontfile For Output As #1
  Print #1, "# Version:"
  Print #1, "1"
  Print #1, ""
  Print #1, "# Font Image:"
  Print #1, fontimage
  Print #1, ""
  Print #1, "# Format:"
  Print #1, fiformat
  Print #1, ""
  Print #1, "# Font colour depth:"
  Print #1, cdepth
  Print #1, ""
  Print #1, "#Default drawing mode:"
  Print #1, fdmode
  Print #1, ""
  Print #1, "#Default spacing:"
  Print #1, "0"
  Print #1, ""
  Print #1, "# Number of characters in the font:"
  Print #1, Str((c*r))
  Print #1, ""
  Print #1, "# Number of lines per character (always 4 when version is 0):"
  Print #1, "4"
  Print #1, ""
  Print #1, "# The first character in the set (ASCII number - normally 32)"
  Print #1, Str(sc)
  Print #1, ""
  Print #1, ""
  For y0 = 0 To (r-1)
    For x0 = 0 To (c-1)
      Print #1, "# Character #" + Str(i0) + " (= '" + Chr(i0+sc) + "'):  (x1, y1)-(x2, y2)="
      Print #1, Str((x0*w)+(x0*bx)+leftx)
      Print #1, Str((y0*h)+(y0*by)+topy)
      Print #1, Str((((x0+1)*w)-1)+(x0*bx)+leftx)
      Print #1, Str((((y0+1)*h)-1)+(y0*by)+topy)
      Print #1, ""
      i0 += 1
    Next x0
  Next y0
Close #1