
'font_demo2.bas from Lachie's customfont_ver2, modified to work with PNGcustomfont.

' Custom font printing demo with scrolling text and a background.

' We include our font printing module.
#Include "..\Include\PNGcustomfont.bi"
#Include Once "\fbpng\fbpng.bi"
#Include Once "\fbpng\png_image.bi"

#include "fbgfx.bi"

const fpslimit = 60

' We declare 3 font arrays since we are going to load
' 3 fonts.
DIM SHARED Font1 AS FontType
DIM SHARED Font2 AS FontType
DIM SHARED Font3 AS FontType
Dim Shared As FB.Image Ptr bimage
                                    
DIM SHARED xmov AS INTEGER, sblender AS INTEGER
DIM SHARED workpage AS INTEGER

DIM SHARED frameintvl As Double = 1.0/fpslimit
DIM SHARED sleepintvl As Integer, st AS DOUBLE

' Sets a graphic mode and 32-bit color depth.
Screen 18,32,2,0

' This loads the background onto the screen and
' then into the bimage array.
bimage = png_load( "demobgr1.png", PNG_TARGET_FBOLD )

'Load the fonts...
ChDir "..\Fonts\"
LoadFont "font1.ini", Font1
LoadFont "font2.ini", Font2
LoadFont "font4.ini", Font3

' Deafult scrolling text position(+320).
xmov = 0

' A simple loop that ends when the user pushes the
' ESCAPE key.
DO
    
st = Timer

screenlock
screenset workpage, workpage xor 1
 
' This moves the scrolling text. 
xmov -= 5
If xmov<=-1024 Then xmov=1024

CLS

' This pastes the background.
Put (0,0), bimage, Alpha

'Font printing calls.  Spacing is font-specific, not a parameter any more.
PrintFont 80,20, "LET'S GET CRAZY! %&/)=?:;", Font1, FONT_DEFAULT, defaultDC
PrintFont 30,40, "EVIL SPACING!!!", Font3, FONT_DEFAULT, defaultDC
PrintFont xmov,100, "BIG SCROLLING TEXT!!", Font2, FONT_DEFAULT, defaultDC

' The next line prints the following text in FONT 3 with TRANS.
PrintFont 100,170, "PRESS ESCAPE TO EXIT", Font3, FONT_TRANS, defaultDC

workpage xor = 1
screenunlock

sleepintvl = Cint((st + frameintvl - Timer)*1000.0)
If sleepintvl>1 Then 
    Sleep sleepintvl
else 
    sleep 1
end if

LOOP UNTIL MULTIKEY(SC_ESCAPE)

END
