
'font_demo3.bas from Lachie's customfont_ver2, modified to work with PNGcustomfont.

' Custom font printing demo.

'Includes...
#Include "..\Include\PNGcustomfont.bi"
#Include Once "\fbpng\fbpng.bi"
#Include Once "\fbpng\png_image.bi"

#include "fbgfx.bi"
Using FB

const fpslimit = 40

'Declare font and image storage.
Dim Shared Font1 As FontType
DIM SHARED Font2 AS FontType
DIM SHARED Font3 AS FontType
DIM SHARED Font4 AS FontType
Dim Shared As FB.Image Ptr bimage

Dim Shared xmov As Integer, sblender As Integer
DIM SHARED workpage AS INTEGER

DIM SHARED frameintvl As Double = 1.0/fpslimit
DIM SHARED sleepintvl As Integer, st AS DOUBLE

' Sets a graphic mode (640*480) and 24 bit color depth mode.
Screen 20,24,2,0

' This loads the background onto the screen and
' then into the bimage array.
'Notice I put it before the font-loading, so I don't have to
'change directories again.  Of course, you can change directories
'back if you want to load an image after loading the fonts.
'ExePath() can be helpful in these circumstances.
bimage = png_load( "demobgr2.png", PNG_TARGET_FBOLD )

'And we load our fonts again...
ChDir "..\Fonts\"
LoadFont "font7.ini", Font1
LoadFont "fontB.ini", Font2
LoadFont "font4.ini", Font3
LoadFont "font2.ini", Font4

Font3.drawmode = FONT_TRANS

' Deafult scrolling text position (+320).
xmov = 0
' Deafult alpha blender (the equation text).
sblender = 200


' A simple loop that ends when the user pushes the
' ESCAPE key.
DO
    
st = Timer

screenlock
screenset workpage, workpage xor 1
 
' This moves the scrolling text. 
xmov = xmov + 5
IF xmov=1500 THEN xmov=0

' This changes the alpha blender used with the equation
' text if the user pushes PGUP or PGDOWN.
IF MULTIKEY(SC_PAGEUP) THEN sblender = sblender + 5
If MultiKey(SC_PAGEDOWN) THEN
  sblender = sblender - 5
  If sblender <= 5 Then sblender = 0
End If
If sblender>=255 Then sblender = 255
If sblender<=0 Then sblender = 0

' This pastes the background.
Put (0,0), bimage, PSet

' Font printing calls. First 2 parameters are the
' string's starting coordinates. Second last parameter
' sets the spacing while the last parameter sets 
' the mode of printing (1 - TRANS; 2 - PSET). 
' If you input any other number as the last parameter 
' the characters will be printed with TRANS.
PrintFont 120,20, "THIS DEMO ROCKS.", Font2, FONT_DEFAULT, defaultDC
PrintFont 120,40, "NEAT, EH?", Font1, FONT_DEFAULT, defaultDC
PrintFont 640-xmov,140, "HUGE SCROLLING TEXT!!", Font4, FONT_DEFAULT, defaultDC

' The next line prints text with translucency.
' The last parameter sets the alpha blender (ratio of translucency).
' Alpha blender in the next line is connected with a
' variable you can change by pressing PGUP or PGDOWN.
PrintUAlphaFont 135,240, "(5*2)=(7+3)", Font4, sblender, defaultDC
PrintUAlphaFont 135,540, Str(sblender), Font4, sblender, defaultDC

PrintFont 10,310, "Press PGUP and PGDN", Font2, FONT_DEFAULT, defaultDC
PrintFont 10,360, "to change the", Font2, FONT_DEFAULT, defaultDC
PrintFont 10,410, "translucency of the", Font2, FONT_DEFAULT, defaultDC
PrintFont 10,460, "equation above.", Font2, FONT_DEFAULT, defaultDC
PrintFont 20,510, "PRESS ESCAPE TO EXIT", Font3, FONT_DEFAULT, defaultDC

workpage xor = 1
screenunlock

sleepintvl = Cint((st + frameintvl - Timer)*1000.0)
If sleepintvl>1 Then 
    Sleep sleepintvl
else 
    sleep 1
end if

LOOP UNTIL MULTIKEY(SC_ESCAPE)

END