'
'PNGcustomfont v1.1 - A heavily modified bit of code, taken from the original:
'
' *****************************************************************
' Custom Font Printing Routine ver.1 by Lachie Dazdarian; Aug.2007.
' For 8bit color depth mode. Refer to readme.txt for more details.
' Attach this module on your source code with #include "24bitcustomfont.bi"
' *****************************************************************
'(which can be downloaded at http://lachie.phatcode.net/download/customfont_ver2.zip)
'
'Modified by notthecheatr between August 12 and September 7, 2007
'
'Please see readme.txt in the Docs folder for more information about this.
'
'Note:  As you look through this code, you'll see a lot of things.  I recommend NOT
'       messing with any undocumented variables or functions - if it's not in the
'       manual, do not mess with it as the results could be bad.  This library
'       has some unfinished bits, and some support for future editions, that is best
'       not to mess with.


#IfNDef NO_PNG
  #Include Once "\fbpng\fbpng.bi"
  #Include Once "\fbpng\png_image.bi"
#EndIf

#Include Once "fbgfx.bi"
Using FB


'---------------------------------------------------------------------------------------------------------------
'Begin declarations

Const FONT_DEFAULT = 0
Const FONT_TRANS = 1
Const FONT_PSET = 2
Const FONT_ALPHA = 3

Const FONT_NONE = 0
Const FONT_BOLD = 1
Const FONT_UNDERLINE = 2
Const FONT_ITALICS = 4
Const FONT_STRIKE = 8
Const FONT_OVERLINE = 16
Const FONT_3D = 32

Const FONT_LEFT = &h01
Const FONT_RIGHT = &h02
Const FONT_CENTERXONLY = &h03
Const FONT_TOP = &h04
Const FONT_BOTTOM = &h08
Const FONT_CENTERYONLY = &h0c
Const FONT_CENTER = &h0f

Const FONT_CLIPPING = -1
Const FONT_NOCLIPPING = 0

Const FONT_LOADED = 1
Const FONT_NOTLOADED = 0
Const FONT_LOADEDDEFAULT = -1
Const FONT_ERROR_WRONGDEPTH = -2
Const FONT_ERROR_NO_PNGSUPPORT = -3
Const FONT_ERROR_NOCHARS = -4
Const FONT_ERROR_EOF = -5
Const FONT_ERROR_UNKNOWNFORMAT = -6
Const FONT_ERROR_UNKNOWN = -64


Type FChar
  As Integer CWidth, CHeight
  As Any Ptr CImage
End Type

' The font data type
Type FontType
'FontBuffer(97, 9250) AS INTEGER  ' Memory buffer for each character.
'FontBuffer As Integer Ptr
'FontWidth(97) AS INTEGER         ' Will store width of each character.
  As FChar Ptr FontChars
  As Integer cdepth
  As Integer NChars
  As Integer StartChar
  As Integer Ver
  As String Imgfilename
  As String Cfgfilename
  As Integer fheight, fwidth, defspacing
  As Integer drawmode
  As Integer loaded
End Type

Type DrawContext
  As Integer x, y
  As Integer w, h
  As Integer csrx, csry
  As Integer vertspacing
  As FontType Ptr CurFont
  As Integer justify
  As Integer inited
  As Integer clipping
  As Integer buffered, buffercreated
  As Integer wrapped
  As IMAGE Ptr buffer
End Type 

' The sub declarations.
Declare Sub PrintFont (xx As Integer, yy As Integer, CT As String, ByRef PrintSFont As FontType, PMode As Integer, ByRef drawDC As DrawContext)
Declare Sub PrintFAlphaFont (xx As Integer, yy As Integer, CT As String, ByRef PrintSFont As FontType, ByRef drawDC As DrawContext)
Declare Sub PrintUAlphaFont (xx As Integer, yy As Integer, CText As String, ByRef PrintTFont As FontType, pblender As Integer, ByRef drawDC As DrawContext)
Declare Sub LoadFont (fontfile As String, ByRef ImportFont As FontType)
Declare Sub UnloadFont(ByRef FontT As FontType)
Declare Sub FSetDefaultMode (ByRef Fontt As FontType, mode As Integer)
Declare Sub FPrint (CText As String)
Declare Sub FLocate (x As Integer, y As Integer)
Declare Sub FLocateStep (x As Integer, y As Integer)
Declare Sub FGetLocate (ByRef x As Integer, ByRef y As Integer)
Declare Sub FSetCursor (x As Integer, y As Integer)
Declare Sub FSetCursorStep (x As Integer, y As Integer)
Declare Sub FGetCursor (ByRef x As Integer, ByRef y As Integer)
Declare Sub FSetFont (ByRef DefFont As FontType)
Declare Sub FSetSpacing (spac As Integer)
Declare Sub FSetFontDimen (fw As Integer, fh As Integer)
Declare Sub FCls ( )
Declare Sub FResetCursor ( )
Declare Sub FSetCurrentDC (ByRef cdc As DrawContext)
Declare Sub FInitContext (ByRef tdc As DrawContext, ByRef dfnt As FontType)

Declare Function FGetReqDepth (fontname As String) As Integer

Declare Function FGetWidth (CText As String, ByRef tfont As FontType, s1 As Integer) As Integer
Declare Function FGetHeight (CText As String, ByRef tfont As FontType) As Integer
Declare Function FWordWrap(ByRef CText As String, ByRef TFont As FontType, wrapmode As Integer, maxwidth As Integer) As Integer

Dim Shared As FontType defaultFont
defaultFont.loaded = -1
defaultFont.Cfgfilename = "%DEFAULT%"
defaultFont.fheight = 9
defaultFont.fwidth = 8
defaultFont.defspacing = 0
defaultFont.StartChar = 0
defaultFont.drawmode = 0
defaultFont.Ver = -1

Dim Shared As FontType Ptr CurrentFont = @defaultFont
Dim Shared As Integer csrx, csry
Dim Shared As Integer jmode = FONT_NONE

Dim Shared As DrawContext defaultDC
defaultDC.x = 0
defaultDC.y = 0
ScreenInfo(defaultDC.w, defaultDC.h)
defaultDC.csrx = 0
defaultDC.csry = 0
defaultDC.CurFont = @defaultFont
defaultDC.justify = FONT_NONE

Dim Shared As DrawContext Ptr currentDC = @defaultDC







'End declarations
'---------------------------------------------------------------------------------------------------------------
'Begin procedures







Function GetFileStr (filenum As Integer) As String
   Dim As String tstr
   Do
     Line Input #filenum, tstr
     If tstr <> "" Then
       If Left(tstr,1) <> "#" Then Exit Do
     End If
   Loop Until Eof(filenum)
   Return tstr
 End Function                                    
 
 Function GetFileVal (filenum As Integer) As Integer
   Return Val(GetFileStr(filenum))
 End Function

' Declare your font arrays with 'DIM SHARED FontName AS FontType'

' Load fonts with 'LoadFont FontFile$, FontType
'FontFile$ is a string indicating the file to load config information about the font from.

' Print text in a specific font with 
' 'PrintFont xpos, ypos, "Your Text", FontName, spacing, PMode'
' FontName - name of the font array(you can declare more of them)
' PMode = 1 => print with TRANS
' PMode = 2 => print with PSET
'' NEW:  PMode = 3 => print with ALPHA
' spacing - spacing between characters

Sub LoadFont (fontfile As String, ByRef ImportFont As FontType)
  Dim As Integer ver
  Dim As String fontimage, fontformat, fdrawmode
  Dim As Integer fdepth
  Dim As Integer nchars, nlines, i0, i1, flines
  Dim As Integer frf, throwaway
  Dim As Any Ptr tmpload
  Dim As Integer strx, stry, stpx, stpy
  Dim As Image Ptr scrsave
  Dim As Integer scrh,scrw,cold
  Dim As String tststr
  
  ScreenInfo(scrw,scrh,cold)
  
  If ImportFont.loaded <> 0 Then Exit Sub
  
  ImportFont.Cfgfilename = fontfile
  
  'This simply sets the flag so PrintFont recognizes it.
  'The "default font" really just means we call Draw String instead of using a font.
  If fontfile = "%DEFAULT%" Then
    ScreenInfo(scrw,scrh,cold)
    ImportFont.loaded = -1
    ImportFont.fheight = 9
    ImportFont.fwidth = 8
    If cold = 32 Or cold = 24 Then
      ImportFont.drawmode = &hffffff
    ElseIf cold = 16 Then
      ImportFont.drawmode = &hffffff
    Else
      ImportFont.drawmode = 15
    End If
    Exit Sub
  End If

''Loads fonts based on a text file which identifies the image to load them from
''
frf = FreeFile
Open fontfile For Input As #frf
  'Font file format version
  ver = GetFileVal(frf)
  'PNG file to load characters from
  fontimage = GetFileStr(frf)
  'Font format
  fontformat = GetFileStr(frf)
  'Font colour depth
  fdepth = GetFileVal(frf)
  'Font default drawing mode
  fdrawmode = GetFileStr(frf)
  
  ImportFont.drawmode = Val(fdrawmode)
  If LCase(Left(fdrawmode,5)) = "trans" Then ImportFont.drawmode = FONT_TRANS
  If LCase(Left(fdrawmode,5)) = "alpha" Then ImportFont.drawmode = FONT_ALPHA
  If LCase(Left(fdrawmode,4)) = "pset" Then ImportFont.drawmode = FONT_PSET
  If ImportFont.drawmode = 0 Then ImportFont.drawmode = FONT_ALPHA
  
  'Default spacing
  ImportFont.defspacing = GetFileVal(frf)
  
  'Number of characters in image
  nchars = GetFileVal(frf)
  ImportFont.FontChars = Allocate((SizeOf(FChar)+1)*nchars)
  'Lines (in this file) used to describe each character
  nlines = GetFileVal(frf)
  'First character in set...
  ImportFont.StartChar = GetFileVal(frf)
  
  ImportFont.cdepth = fdepth
  
  If cold <> fdepth Then
    ImportFont.Loaded = FONT_ERROR_WRONGDEPTH
    Exit Sub
  End If
  
  ImportFont.Ver = ver
  ImportFont.Imgfilename = fontimage
  'If ver <= 1 Then ImportFont.StartChar = 32
  
  'Test for EOF - we do this before we try to load the image so we don't cause any errors then.
  If Eof(frf) Then
    ImportFont.loaded = FONT_ERROR_EOF
    Exit Sub
  End If
  
  If LCase(Left(fontformat,3)) = "bmp" Then
    ScreenInfo(scrw,scrh,cold)
    scrsave = ImageCreate(scrw,scrh,,cold)
    Get (0,0)-(scrw-1,scrh-1), scrsave
    Bload fontimage, tmpload
  ElseIf fontimage = "%DEFAULT%" Or fontformat = "%DEFAULT%" Then
    ScreenInfo(scrw,scrh,cold)
    ImportFont.loaded = -1
    ImportFont.fheight = 9
    ImportFont.fwidth = 8
    If cold = 32 Or cold = 24 Then
      ImportFont.drawmode = &hffffff
    ElseIf cold = 16 Then
      ImportFont.drawmode = &hffffff
    Else
      ImportFont.drawmode = 15
    End If
    Exit Sub
  ElseIf LCase(Left(fontformat,3)) = "png" Then
  #IfNDef NO_PNG
    tmpload = png_load( fontimage, PNG_TARGET_FBOLD )
  #Else
    ImportFont.loaded = FONT_ERROR_NO_PNGSUPPORT
  #Endif
  Else
    ImportFont.loaded = FONT_ERROR_UNKNOWNFORMAT
    Exit Sub
  End If
  
  If Eof(frf) Then
    ImportFont.loaded = FONT_ERROR_EOF
    Exit Sub
  End If
  

  
  For i0 = 0 To nchars-1
    'Test for EOF - if we have an EOF condition before we've found the last character, then we know
    'it's a problem.
    If Eof(frf) Then
      ImportFont.loaded = FONT_ERROR_EOF
      ImportFont.nchars = i0+1
      Exit Sub
    End If

    'Starting x, y
    strx = GetFileVal(frf)
    stry = GetFileVal(frf)
    'Stopping x, y
    stpx = GetFileVal(frf)
    stpy = GetFileVal(frf)
    
    ImportFont.FontChars[i0].CWidth = (stpx - strx)+1
    ImportFont.FontChars[i0].CHeight = (stpy - stry)+1
    If (stpx - strx)+1 > ImportFont.fwidth Then ImportFont.fwidth = Abs((stpx - strx))+1
    If (stpy - stry)+1 > ImportFont.fheight Then ImportFont.fheight = Abs((stpy - stry))+1
    
    ImportFont.FontChars[i0].CImage = ImageCreate(Abs((stpx - strx))+1, Abs((stpy - stry))+1, , fdepth)
    Get tmpload, (strx, stry)-(stpx, stpy), ImportFont.FontChars[i0].CImage

  Next i0
  
  If nchars = 0 Then ImportFont.loaded = FONT_ERROR_NOCHARS

Close #frf


Deallocate tmpload

If fontformat = "bmp" Then Put (0,0), scrsave

ImportFont.loaded = 1
ImportFont.nchars = nchars

End Sub

'If you have a font loaded FontT and you wish to load a different font
'without creating a new font variable - or if you need to free up some memory -
'use UnloadFont to clean everything up.
Sub UnloadFont(ByRef FontT As FontType)

  'Deallocates memory for a font type so the type can be re-used to load a different font.
  Dim As Integer i0
  
  If FontT.loaded = 0 Then Exit Sub
  If FontT.loaded = -1 Then
    FontT.loaded = 0
    FontT.Cfgfilename = ""
    Exit Sub
  End If
  
  For i0 = 0 To FontT.NChars
    Deallocate FontT.FontChars[i0].CImage
    FontT.FontChars[i0].CWidth = 0
    FontT.FontChars[i0].CHeight = 0
  Next i0
  Deallocate FontT.FontChars
  FontT.NChars = 0
  FontT.Ver = -1
  FontT.Imgfilename = ""
  FontT.Cfgfilename = ""
  FontT.drawmode = 0
  FontT.loaded = 0
End Sub

Sub PrintFont (xx As Integer, yy As Integer, CT As String, ByRef PrintSFont As FontType, PMode As Integer, ByRef drawDC As DrawContext)
  Dim As Integer MessLen, CharNo, CharWidth, nn
  Dim As Integer scrwidth, scrheight
  Dim As Integer spacing = PrintSFont.defspacing
  Dim As Integer justify = drawDC.justify
  Dim As Integer sx, sy
  Dim As Integer thispos, wrappos
  Dim As String wrapstr
  Dim As String CText = CT
  Dim As Integer cd, oxx, oyy
  Dim As FB.Image Ptr tbuff
  
' This sub prints CText$ with font saved in PrintSFont 
' array, on coordinates xx and yy, with inputted spacing and
' with TRANS(PMode=1) or PSET(PMode=2).

' If inexistent print mode is defined we flag 
' the default mode => Alpha
'Print "PrintFont " + CText
If PrintSFont.loaded = 0 Then Exit Sub
If drawDC.Inited = 0 Then FInitContext(drawDC, defaultFont)

ScreenInfo(,,cd)
If PrintSFont.loaded = 1 Then If cd <> PrintSFont.cdepth Then Exit Sub

drawDC.wrapped = 0

/'If PrintSFont.loaded = -1 Then
  nn = FreeFile
  Open "c:\c.txt" For Append As #nn
  Print #nn, "Length = " + Str(Len(CText))
  For thispos = 1 To Len(CText)
    Print #nn, Str(Asc(Mid(CText, thispos, 1)))
  Next thispos
  thispos = 0
  nn = 0
  Close #nn
End If'/

'Justification
  scrwidth = drawDC.w
  scrheight = drawDC.h
  If (justify And FONT_LEFT)=FONT_LEFT Then xx = 0
  If (justify And FONT_RIGHT)=FONT_RIGHT Then xx = scrwidth-FGetWidth(CText,PrintSFont,spacing)
  If (justify And FONT_CENTERXONLY)=FONT_CENTERXONLY Then xx = (scrwidth\2)-((FGetWidth(CText,PrintSFont,spacing))\2)
  If (justify And FONT_TOP)=FONT_TOP Then yy = 0
  If (justify And FONT_BOTTOM)=FONT_BOTTOM Then yy = scrheight-FGetHeight(CText,PrintSFont)
  If (justify And FONT_CENTERYONLY)=FONT_CENTERYONLY Then yy = (scrheight\2)-((FGetHeight(CText,PrintSFont))\2)
  
  'Shift the coordinates - UNLESS we are printing to a buffer, in which case we don't want
  'to shift the coordinates.
  If drawDC.buffered = 0 Then
    xx += drawDC.x
    yy += drawDC.y
  Else
    'While we're here, we may as well figure out how much image to create, and create it.
    If drawDC.buffercreated = 0 Then
        If PMode = FONT_TRANS Then
          drawDC.buffer = ImageCreate(drawDC.w, drawDC.h,,cd)
        Else
          drawDC.buffer = ImageCreate(drawDC.w, drawDC.h,0,cd)
        End If
        drawDC.buffercreated = 1
    End If
  End If
  
  If drawDC.clipping = FONT_CLIPPING Then
    If drawDC.buffered = 0 Then
      View Screen (drawDC.x, drawDC.y)-(drawDC.x+drawDC.w, drawDC.y+drawDC.h)
    End If
  End If

'Default font
If PrintSFont.loaded = -1 Then
  'oxx = xx
  'oyy = yy
  MessLen = Len(CText)
  For nn As Integer = 1 To MessLen
    CharNo = Asc(Mid$(CText, nn, 1))
    If (CharNo = 13) Or (CharNo = 10) Then
      yy += PrintSFont.fheight + drawDC.vertspacing
      drawDC.wrapped += 1
    Else
      If drawDC.buffered = 0 Then
        Draw String (xx-oxx, yy-oyy), Chr(CharNo), PMode
      Else
        Draw String drawDC.buffer, (xx-oxx, yy-oyy), Chr(CharNo), PMode
      End If
    End If
    xx += spacing + 8
  Next nn
  drawDC.wrapped += 2
  Exit Sub
End If

If PMode = FONT_DEFAULT Then PMode = PrintSFont.drawmode

' Get the number of characters in the string.
MessLen = Len(CText)

thispos = 0
CharWidth = 0
CharNo = 0

' Loop to display each character of CText$.
For nn As Integer = 1 To MessLen
    CharNo = Asc(Mid$(CText, nn, 1))
    CharNo -= PrintSFont.StartChar
      
    'Print "Character:  " + Chr(CharNo+32) + " (=" + Str(CharNo+32) + ")"
    ' Get character's width

    If CharNo >= 0 And CharNo < PrintSFont.NChars Then ' A precaution measure
      CharWidth = PrintSFont.FontChars[CharNo].CWidth
      thispos += CharWidth
      
      If drawDC.buffered = 0 Then
        If PMode=FONT_TRANS Then Put (xx, yy), PrintSFont.FontChars[CharNo].CImage, Trans
        If PMode=FONT_PSET Then Put (xx, yy), PrintSFont.FontChars[CharNo].CImage, PSet
        If PMode=FONT_ALPHA Then Put (xx, yy), PrintSFont.FontChars[CharNo].CImage, Alpha
      Else
        If PMode=FONT_TRANS Then Put drawDC.buffer, (xx, yy), PrintSFont.FontChars[CharNo].CImage, Trans
        If PMode=FONT_PSET Then Put drawDC.buffer, (xx, yy), PrintSFont.FontChars[CharNo].CImage, PSet
        If PMode=FONT_ALPHA Then Put drawDC.buffer, (xx, yy), PrintSFont.FontChars[CharNo].CImage, Alpha
      End If
    End If
    
    'If we encounter a carriage return or linefeed...
    If (CharNo = 13 - PrintSFont.StartChar) Or (CharNo = 10 - PrintSFont.StartChar) Then
      yy += PrintSFont.fheight + drawDC.vertspacing
      drawDC.wrapped += 1
    End If
    
    ' Add horizontal space according to inputted spacing
    ' and last character's width.
    xx += CharWidth + spacing
        
Next nn

If drawDC.clipping = FONT_CLIPPING Then
  ScreenInfo (sx, sy)
  View Screen (0,0)-(sx,sy)
End If

'Newline
drawDC.wrapped += 1

End Sub

Sub PrintUAlphaFont (xx As Integer, yy As Integer, CT As String, ByRef PrintTFont As FontType, pblender As Integer, ByRef drawDC As DrawContext)

' This sub prints CText with font saved in PrintSFont 
' array, on coordinates xx and yy, with ALPHA pblender.

' If blender is out of bounds set it to 255.

Dim MessLen As Integer
Dim CharNo As Integer
Dim CharWidth As Integer
Dim As Integer scrwidth, scrheight, sx, sy
Dim As Integer spacing = PrintTFont.defspacing
Dim As Integer justify = drawDC.justify
Dim As String wrapstr
Dim As Integer wrappos, thispos
Dim As String CText = CT
Dim As FB.Image Ptr tbuff
Dim As Integer oxx, oyy
Dim As Integer cd

If PrintTFont.loaded = 0 Then Exit Sub
If drawDC.Inited = 0 Then FInitContext(drawDC, defaultFont)

ScreenInfo(,,cd)
If PrintTFont.loaded = 1 Then If cd <> PrintTFont.cdepth Then Exit Sub

drawDC.wrapped = 0

'Justification
  scrwidth = drawDC.w
  scrheight = drawDC.h
  If (justify And FONT_LEFT)=FONT_LEFT Then xx = 0
  If (justify And FONT_RIGHT)=FONT_RIGHT Then xx = scrwidth-FGetWidth(CText,PrintTFont,spacing)
  If (justify And FONT_CENTERXONLY)=FONT_CENTERXONLY Then xx = (scrwidth\2)-((FGetWidth(CText,PrintTFont,spacing))\2)
  If (justify And FONT_TOP)=FONT_TOP Then yy = 0
  If (justify And FONT_BOTTOM)=FONT_BOTTOM Then yy = scrheight-FGetHeight(CText,PrintTFont)
  If (justify And FONT_CENTERYONLY)=FONT_CENTERYONLY Then yy = (scrheight\2)-((FGetHeight(CText,PrintTFont))\2)
  
  'Shift the coordinates - UNLESS we are printing to a buffer, in which case we don't want
  'to shift the coordinates.
  If drawDC.buffered = 0 Then
    xx += drawDC.x
    yy += drawDC.y
  Else
    'While we're here, we may as well figure out how much image to create, and create it.
      drawDC.buffer = ImageCreate(drawDC.w, drawDC.h, &hffff00ff, cd)
      drawDC.buffercreated = 1
  End If
  
  If drawDC.clipping = FONT_CLIPPING Then
    If drawDC.buffered = 0 Then
      View Screen (drawDC.x, drawDC.y)-(drawDC.x+drawDC.w, drawDC.y+drawDC.h)
    End If
  End If

If pblender >= 255 Then pblender = 255
'For some impossible to understand reason if pblender is 0 then it will look as though pblender is 255.
'Thus we set it to 1 and that seems to solve the problem, though I have no idea why this is.
If pblender <= 0 Then pblender = 1

'Default font
If PrintTFont.loaded = -1 Then
  oxx = xx
  oyy = yy
  MessLen = Len(CText)
  tbuff = ImageCreate(drawDC.w, drawDC.h,, cd)
  For nn As Integer = 1 To MessLen
    CharNo = Asc(Mid$(CText, nn, 1))-PrintTFont.StartChar
    If (CharNo = 13-PrintTFont.StartChar) Or (CharNo = 10-PrintTFont.StartChar) Then
      yy += PrintTFont.fheight + drawDC.vertspacing
      drawDC.wrapped += 1
    Else
      Draw String tbuff, (xx-oxx, yy-oyy), Chr(CharNo), PrintTFont.drawmode
    End If
    xx += spacing + 8
  Next nn
  If drawDC.buffered = 0 Then
    Put (oxx,oyy), tbuff, Alpha, pblender
  Else
    Put drawDC.buffer, (oxx,oyy), tbuff, Alpha, pblender
  End If
  ImageDestroy(tbuff)
  drawDC.wrapped += 1
  Exit Sub
End If

' Get the number of characters in the string.
MessLen = Len(CText)

thispos = 0
CharWidth = 0
CharNo = 0

' Loop to display each character of CText$.
For nn As Integer = 1 To MessLen
    CharNo = Asc(Mid$(CText, nn, 1))
    CharNo -= PrintTFont.StartChar
      
    If CharNo >= 0 And CharNo < PrintTFont.NChars Then ' A precaution measure
      CharWidth = PrintTFont.FontChars[CharNo].CWidth
    
      Put (xx, yy), PrintTFont.FontChars[CharNo].CImage, Alpha, pblender
    End If
    
    'If we encounter a carriage return or linefeed...
    If (CharNo = 13 - PrintTFont.StartChar) Or (CharNo = 10 - PrintTFont.StartChar) Then
      yy += PrintTFont.fheight + drawDC.vertspacing
      drawDC.wrapped += 1
    End If
    
    ' Add horizontal space according to inputted spacing
    ' and last character's width.
    xx += CharWidth + spacing
        
Next nn

If drawDC.clipping = FONT_CLIPPING Then
  ScreenInfo (sx, sy)
  View Screen (0,0)-(sx,sy)
End If

'Newline
drawDC.wrapped += 1

End Sub
    
Sub FSetDefaultMode (ByRef Fontt As FontType, mode As Integer)
  If mode = 0 Then
    If Fontt.loaded = -1 Then
      Fontt.drawmode = 0
    End If
  Else
    Fontt.drawmode = mode
  End If
End Sub

Sub PrintFAlphaFont (xx As Integer, yy As Integer, CText As String, ByRef PrintSFont As FontType, ByRef drawDC As DrawContext)
  PrintFont (xx, yy, CText, PrintSFont, FONT_ALPHA, drawDC)
End Sub

Sub FPrint (CText As String)
  'Hack to ensure the defaultFont is given white as it's default colour.  This hack is not
  'present in the other font printing routines;  presumably the user would load a regular font
  'to use those, but this is merely to allow FPrint to be used without any setup whatsoever beforehand.
  'Since the default screencolour is black, we need to find out what the screendepth is so we can set
  'the font colour to white, which is different depending upon your screenmode.
  'Note that this is only done once, and only if the colour is currently black.  If the user
  'chooses to set their own colour, then it won't be done.  After the first time, it won't be done
  'again, so if the user changes screenmodes they could be in trouble.
  'To remove the hack simply change the '/ to /' or define NO_DEFAULT_FONT_HACK
  
  'BEGIN HACK
  '/
  #IfNDef NO_DEFAULT_FONT_HACK
  If (CurrentFont) = @defaultFont Then
    If (*CurrentFont).Ver = -1 And (*CurrentFont).drawmode = 0 Then
      ScreenInfo(,,(*CurrentFont).cdepth)
      If (*CurrentFont).cdepth = 8 Then (*CurrentFont).drawmode = 15
      If (*CurrentFont).cdepth = 16 Then (*CurrentFont).drawmode = &hffffff
      If (*CurrentFont).cdepth = 24 Then (*CurrentFont).drawmode = &hffffff
      If (*CurrentFont).cdepth = 32 Then (*CurrentFont).drawmode = &hffffff
      (*CurrentFont).Ver = 0
    End If
  End If
  #EndIf
  '/
  'END HACK
  
  
  PrintFont (csrx, csry, CText, *CurrentFont, (*CurrentFont).drawmode, *currentDC)
  csrx = 0
  csry += ((*currentDC).wrapped)*((*CurrentFont).fheight+(*currentDC).vertspacing)
End Sub

Sub FPrintUAlpha (CText As String, pblender As Integer)
  PrintUAlphaFont (csrx, csry, CText, *CurrentFont, pblender, *currentDC)
  csrx = (*CurrentFont).defspacing
  csry += ((*currentDC).wrapped)*((*CurrentFont).fheight+(*currentDC).vertspacing)
End Sub

Sub FPrintAttribute (CText As String, attrib As Integer)
  Dim As Integer w, h, h1, s1, i0, tn, nn
  PrintFont (csrx, csry, CText, *CurrentFont, (*CurrentFont).drawmode, *currentDC)
  If attrib And FONT_BOLD Then
    PrintFont (csrx+1, csry, CText, *CurrentFont, (*CurrentFont).drawmode, *currentDC)
    PrintFont (csrx-1, csry, CText, *CurrentFont, (*CurrentFont).drawmode, *currentDC)
  End If
  If attrib And FONT_3D Then
    If (*CurrentFont).loaded = -1 And (*CurrentFont).Cfgfilename = "%DEFAULT%" Then
      'Special mode for %DEFAULT fonts
      PrintFont (csrx+2, csry+2, CText, *CurrentFont, (((*CurrentFont).drawmode+&h808080)\4), *currentDC)
      PrintFont (csrx+1, csry+1, CText, *CurrentFont, (((*CurrentFont).drawmode+&h808080)\2), *currentDC)
      PrintFont (csrx, csry, CText, *CurrentFont, (*CurrentFont).drawmode, *currentDC)
    Else
    'Regular fonts are not quite as interesting...
      PrintFont (csrx+1, csry+1, CText, *CurrentFont, (*CurrentFont).drawmode, *currentDC)
      PrintFont (csrx+2, csry+2, CText, *CurrentFont, (*CurrentFont).drawmode, *currentDC)
    End If
  End If
  csrx = 0
  csry += ((*currentDC).wrapped)*((*CurrentFont).fheight+(*currentDC).vertspacing)
End Sub

Function FGetWidth (CText As String, ByRef tfont As FontType, s1 As Integer) As Integer
  Dim As Integer w, i0
  w = 0                    
  For i0 = 1 To Len(CText)
    w += tfont.FontChars[Asc(Mid(CText,i0,1))-tfont.StartChar].CWidth + s1
  Next i0
  Return w
End Function

Function FGetHeight (CText As String, ByRef tfont As FontType) As Integer
  Dim As Integer h, h1, i0
  For i0 = 1 To Len(CText)
    h1 = tfont.FontChars[Asc(Mid(CText,i0,1))-tfont.StartChar].CHeight
    If h1 > h Then h = h1
  Next i0
  Return h
End Function

Sub FLocate (x As Integer, y As Integer)
  csrx = x*(*CurrentFont).fwidth
  csry = y*(*CurrentFont).fheight
End Sub

Sub FGetLocate (ByRef x As Integer, ByRef y As Integer)
  x = csrx\(*CurrentFont).fwidth
  y = csry\(*CurrentFont).fheight
End Sub

Sub FLocateStep (x As Integer, y As Integer)
  csrx += x*(*CurrentFont).fwidth
  csry += y*(*CurrentFont).fheight
End Sub

Sub FSetCursor (x As Integer, y As Integer)
  csrx = x
  csry = y
End Sub

Sub FGetCursor (ByRef x As Integer, ByRef y As Integer)
  x = csrx
  y = csry
End Sub

Sub FSetCursorStep (x As Integer, y As Integer)
  csrx += x
  csry += y
End Sub

Sub FSetFont (ByRef DefFont As FontType)
  CurrentFont = @DefFont
  (*currentDC).CurFont = @DefFont
End Sub

Sub FSetSpacing (spac As Integer)
  (*CurrentFont).defspacing = spac
End Sub

Sub FSetFontDimen (fw As Integer, fh As Integer)
  (*CurrentFont).fwidth = fw
  (*CurrentFont).fheight = fh
End Sub

Sub FSetVerticalSpacing (vs As Integer)
  (*currentDC).vertspacing = vs
End Sub

Sub FSetJustify (justify As Integer)
  (*currentDC).justify = justify
End Sub

Sub FSetClipping (x As Integer, y As Integer, w As Integer, h As Integer)
  'Setup clipping window
  (*currentDC).x = x
  (*currentDC).y = y
  (*currentDC).w = w
  (*currentDC).h = h
  'Turn clipping on
  (*currentDC).clipping = FONT_CLIPPING
End Sub

Sub FClippingOn ()
  (*currentDC).clipping = FONT_CLIPPING
End Sub

Sub FClippingOff ()
  (*currentDC).clipping = FONT_NOCLIPPING
End Sub

Sub FCls ( )
  Cls
  csrx = 0
  csry = 0
End Sub

Sub FResetCursor ( )
  csrx = 0
  csry = 0
End Sub

Sub FSetCurrentDC (ByRef cdc As DrawContext)
  'Store cursor location to the Drawing Context...
  (*currentDC).csrx = csrx
  (*currentDC).csry = csry
  
  'Then switch to the new context
  currentDC = @cdc
  'And take the current font and cursor location from it.
  CurrentFont = (cdc.CurFont)
  csrx = (*currentDC).csrx
  csry = (*currentDC).csry
End Sub

Sub FInitContext (ByRef tdc As DrawContext, ByRef dfnt As FontType)
  tdc.x = 0
  tdc.y = 0
  ScreenInfo(tdc.w, tdc.h)
  tdc.csrx = 0
  tdc.csry = 0
  tdc.vertspacing = 0
  tdc.CurFont = @dfnt
  tdc.justify = FONT_NONE
  tdc.clipping = FONT_CLIPPING
  tdc.Inited = 1
End Sub

Sub FBufferCreate (ByRef drawDC As DrawContext, w As Integer, h As Integer, fval As Integer, cdepth As Integer)
  drawDC.buffer = ImageCreate(w,h,fval,cdepth)
  drawDC.buffercreated = 1
End Sub

Sub FBufferDestroy (ByRef drawDC As DrawContext)
  ImageDestroy(drawDC.buffer)
  drawDC.buffercreated = 0
End Sub



Function FGetReqDepth (fontname As String) As Integer
  Dim As Integer cd, frf
  Dim As String throwaway1, throwaway2, throwaway3
  
  'Open the file
  frf = FreeFile()
  Open fontname For Input As #frf
  If Eof(frf) Then
    Return FONT_ERROR_EOF
    Exit Function
  End If
  
  'Grab the first four lines, the last of which should be the colour depth for this font...
  throwaway1 = GetFileStr(frf)
  throwaway2 = GetFileStr(frf)
  throwaway3 = GetFileStr(frf)
  cd = GetFileVal(frf)
  
  'Close the file...
  Close #frf
  
  'And return the colour depth.  
  Return cd
End Function

'End procedures
'---------------------------------------------------------------------------------------------------------------
'End PNGcustomfont.bi
