
' **************************************************
'               PolyDraw FreeBASIC code
' By Lachie Dazdarian (c) 2010 (lachie13@yahoo.com)
' Original polylib code by Vincent DeCampo
' **************************************************
' Not to be used for commercial purposes.

'/
#Include "Polylib.bas"

#Define SCR_W  640
#Define SCR_H  480

CONST TRUE = 1, FALSE = 0

declare Sub Load_Polygon (p_filename as string, loaded_p as _polygon)
declare sub Save_Polygon (p_filename as string, saved_p as _polygon)
declare sub Load_BMPSprite (bmp_filename as string, l_sprite_buffer as any ptr)

ScreenRes SCR_W,SCR_H,32,2,FB.GFX_ALPHA_PRIMITIVES
Setmouse SCR_W/2, SCR_H/2,0

Dim As _polygon Working_Polygon, Secondary_Polygon, Undo_Redo_Polygon(30)
Dim As _vertex_2d Temp_Vertex
Dim sprite_buffer As Any Ptr

Dim As double gridx, gridy, sint, cost, tempgridx, tempgridy, active_x, active_y, alpha_value = 255, text_time, scale_factor = 1
Dim As uinteger d_color = RGB(255,255,255), font_color, cursor_color
Dim as integer color_sheme = 1, grid_factor = 1, current_icon = 0, ver_on_snap, current_undo = 1, num_of_undos = 0, change_made = FALSE, show_bmp, insert_vertex_mode, shift_center_mode, bmp_sprite_width, bmp_sprite_height
Dim As Integer hide_interface = FALSE, mx, my, mclick, press_release2 = TRUE, press_release = TRUE, newpoint = 0, Camera_X = 0, Camera_Y = 0, selected_vertex = 0, OnSnap = FALSE, ShowVertices = TRUE
Dim as string filename_being_loaded, loaded_shape_filename, confirm, icon_text, bmp_filename_being_loaded, temp_text

dim as integer frames_per_sec = 0
dim as integer fps = 0
dim as single time_start = 0
dim demosecs as integer
demosecs = 0


'Load_Polygon "dean1.txt", Working_Polygon

Working_Polygon.zoom = 1
Working_Polygon.x = SCR_W\2-Camera_X
Working_Polygon.y = SCR_H\2-Camera_Y

Dim DrawIt As _render_poly
Dim As Double tilt = 4*PI/360

sprite_buffer = ImageCreate (5,5)
DIM icons_1 AS ANY PTR
DIM icons_2 AS ANY PTR
icons_1 = ImageCreate( 306, 57 )
icons_2 = ImageCreate( 30, 138 )
BLOAD "pdicons1.bmp", icons_1
BLOAD "pdicons2.bmp", icons_2

Do
   
    frames_per_sec += 1
    
    Getmouse mx, my,, mclick
   
    ' Camera movement
    If Multikey(FB.SC_W)  Then Camera_Y = Camera_Y - 1
    If Multikey(FB.SC_S) Then Camera_Y = Camera_Y + 1
    If Multikey(FB.SC_A)  Then Camera_X = Camera_X - 1
    If Multikey(FB.SC_D) Then Camera_X = Camera_X + 1
    
    IF Multikey(FB.SC_PLUS) Then
        alpha_value = alpha_value + 0.28
        IF alpha_value > 255 THEN alpha_value = 255
        d_color = (d_color and &hFFFFFF) or (alpha_value shl 24)
    End If
    IF Multikey(&h4a) Then
        alpha_value = alpha_value - 0.28
        IF alpha_value < 0 THEN alpha_value = 0
        d_color = (d_color and &hFFFFFF) or (alpha_value shl 24)
    End If
   
    ' Set polygon position according to camera
    Working_Polygon.x = SCR_W\2-Camera_X
    Working_Polygon.y = SCR_H\2-Camera_Y
    Secondary_Polygon.x = mx
    Secondary_Polygon.y = my
    Secondary_Polygon.zoom = Working_Polygon.zoom
    
    ' Rotation and zoom control
    If Multikey(FB.SC_LEFT) AND shift_center_mode = FALSE Then 
        OnSnap = FALSE
        Working_Polygon.rot  += tilt
        press_release = FALSE
    End If
    If Multikey(FB.SC_RIGHT) AND shift_center_mode = FALSE Then 
        OnSnap = FALSE
        Working_Polygon.rot  -= tilt
        press_release = FALSE
    End If
    If Multikey(FB.SC_UP) Then 
        Working_Polygon.zoom += 0.4
        press_release = FALSE
    End If
    If Multikey(FB.SC_DOWN) AND Working_Polygon.zoom > 1 Then 
        Working_Polygon.zoom -= 0.4
        IF Working_Polygon.Zoom < 1 Then Working_Polygon.Zoom = 1
        press_release = FALSE
    End If
   
    ScreenLock
   
    Cls
    
    font_color = RGBA(200,200,200,255)
    cursor_color = RGBA(255,255,255,255)
    If color_sheme = 2 THEN
    Line (0,0)-(SCR_W-1, SCR_H-1), RGBA(255,255,255,255), BF
    font_color = RGBA(20,20,20,255)
    cursor_color = RGBA(0,0,0,255)
    End If

    If insert_vertex_mode = TRUE THEN Draw String (2, 90), "Click on the position to insert vertex.", font_color
    If shift_center_mode = TRUE THEN Draw String (2, 90), "Click where to shift the polyline center.", font_color
    If hide_interface = TRUE THEN Draw String (2, SCR_H-20), "F9 to unhide interface", font_color
    
    If hide_interface = FALSE THEN
        ' Print interface  
        If Working_Polygon.rot = 0 Then Draw String (1,0), "Vertex position: " + STR(INT((mx-Working_Polygon.x)/Working_Polygon.zoom)) + "," + STR(INT((my-Working_Polygon.Y)/Working_Polygon.zoom)), font_color
 
        Draw String (1,10), "Angle: " + STR(Working_Polygon.rot*360\(PI*2)), font_color
        Draw String (1,20), "Zoom: " + STR(INT(Working_Polygon.zoom)), font_color
        Draw String (1,30), "Currently selected vertex: " + STR(selected_vertex), font_color
        Draw String (1,40), "Num. of vertices: " + STR(Working_Polygon.num_vert), font_color
        Draw String (1,50),  "Working file: " + loaded_shape_filename, font_color
        IF d_color = RGBA(0,0,0,0) THEN 
            Draw String (1,60), "Selected color: None (new point)", font_color
        Else
            Line (123, 57+4)-(133, 63+3), d_color, BF
            Draw String (1,60), "Selected color:", font_color
        End If
        Draw String (1,70),  "Alpha value: " + STR(INT(alpha_value)) + " (+/-) ", font_color
        If OnSnap = TRUE Then Draw String (1,80),  "Grid factor: " + STR(INT(grid_factor)) + " x " + STR(INT(grid_factor)) + " (1/2) ", font_color
        
        'Draw String (SCR_W-200,1),  "Mouse: " + STR(INT(mx)) + " , " + STR(INT(my))
        'Draw String (SCR_W-200,20),  "FPS: " + STR(FPS)
        
        'Draw String (1,120),  "BMP W x H: " + STR(INT(bmp_sprite_Width)) + " X " + STR(INT(bmp_sprite_height))
        
        If text_time > 0 Then
            text_time= text_time - 1
            Draw String (SCR_W/2-(LEN(temp_text)*4),SCR_H-120),  temp_text, font_color
        End If
        
        ' Draw palette  
        Line (SCR_W - 13, 5)-(SCR_W-3, 15), RGBA(255,0,0, 255), BF
        Line (SCR_W - 13, 16)-(SCR_W-3, 26), RGBA(0,255,0, 255), BF
        Line (SCR_W - 13, 27)-(SCR_W-3, 37), RGBA(0,0,255, 255), BF
        Line (SCR_W - 13, 38)-(SCR_W-3,49), RGBA(255,0,255, 255), BF
        Line (SCR_W - 13, 50)-(SCR_W-3, 60), RGBA(0,255,255, 255), BF
        Line (SCR_W - 13, 61)-(SCR_W-3, 71), RGBA(255,255,0, 255), BF
        Line (SCR_W - 13, 72)-(SCR_W-3, 82), RGBA(255,120,120, 255), BF
        Line (SCR_W - 13, 83)-(SCR_W-3, 93), RGBA(120,255,120, 255), BF
        Line (SCR_W - 13, 94)-(SCR_W-3, 104), RGBA(120,120,255, 255), BF
        Line (SCR_W - 13, 105)-(SCR_W-3, 115), RGBA(255,255,255, 255), BF
        Line (SCR_W - 13, 116)-(SCR_W-3, 126), font_color, B
        Line (SCR_W - 13, 116)-(SCR_W-3, 126), font_color
        Line (SCR_W - 13, 126)-(SCR_W-3, 116), font_color
        
        Draw String (140-LEN(icon_text)*8/2, SCR_H-67), icon_text, font_color
        
        ' Check for click on the palette  
        If mclick = 1 AND mx > SCR_W-14 AND my < 116 Then d_color = POINT(mx,my)
        If mclick = 1 AND mx > SCR_W-14 AND my < 127 AND my > 115 Then d_color = RGBA(0,0,0,0)
        IF d_color <> RGBA(0,0,0,0) THEN d_color = (d_color and &hFFFFFF) or (alpha_value shl 24)
    
    End If
    
    icon_text = ""
    
    If mx > 1 And mx < 306 And my > SCR_H-55 And my < SCR_H-1 And hide_interface = FALSE Then
    
        'icon_text = ""
        For count_rows As Integer = 0 To 1
            For count_columns As Integer = 0 To 10
                If mx > ((count_columns * 27) + 1) And mx < ((count_columns * 27) + 28) And my > ((count_rows * 27) + (SCR_H-55)) And my < ((count_rows * 27) + (SCR_H-55) + 27) Then
                    Line (count_columns * 27 + 1, count_rows * 27 + (SCR_H-55))-(count_columns * 27 + 28, count_rows * 27 + (SCR_H-55) + 27), RGB (255,255,0), B
                    current_icon = 11 * (count_rows) + (count_columns + 1)
                End If
            Next count_columns
        Next count_rows
        
                    Select Case current_icon
                    Case 1
                        icon_text = "Remo(V)e vertex"
                    Case 2
                        icon_text = "(I)nsert new vertex"
                    Case 3
                        icon_text = "(C)enter polyline"
                    Case 4
                        icon_text = "(0) rotate"
                    Case 5
                        icon_text = "No (Z)oom"
                    Case 6
                        icon_text = "(H)ome camera"
                    Case 7
                        icon_text = "Vertex up (PGUP)"
                    Case 8
                        icon_text = "Vertex down (PGDOWN)"
                    Case 9
                        If OnSnap = TRUE Then icon_text = "Turn off (O)n snap"
                        If OnSnap = FALSE Then icon_text = "Turn on (O)n snap"
                    Case 10
                        If ver_on_snap = TRUE Then icon_text = "Turn off snap to verte(X)"
                        If ver_on_snap = FALSE Then icon_text = "Turn on snap to verte(X)"
                    Case 11
                        If ShowVertices = TRUE Then icon_text = "(T)urn off vertices"
                        If ShowVertices = FALSE Then icon_text = "(T)urn on vertices"
                    Case 12
                        icon_text = "Clos(E) polyline"
                    Case 13
                        icon_text = "(M)irror polyline"
                    Case 14
                        icon_text = "Load compare polygon (F5)"
                    Case 15
                        icon_text = "Unload compare polygon (F6)"
                    Case 16
                        icon_text = "Load bitmap sprite (F7)"
                    Case 17
                        icon_text = "On/off bitmap sprite (F8)"
                    Case 18
                        icon_text = "Undo (ALT + U)"
                    Case 19
                        icon_text = "Redo (ALT + R)"
                    Case 20
                        icon_text = "Hide interface (F9)" 
                    Case 21
                        icon_text = "Sca(L)e polyline"
                    Case 22
                        icon_text = "Shi(F)t center"     
                    End Select
                    
    End if
    
    If mx > SCR_W - 31 And mx < SCR_W + 1 And my > SCR_H-138 And my < SCR_H-1 And hide_interface = FALSE Then
    
        icon_text = ""
        For count_rows As Integer = 0 To 4
                If mx > SCR_W - 31 And mx < SCR_W + 1 And my > ((count_rows * 27) + (SCR_H-137)) And my < ((count_rows * 27) + (SCR_H-137) + 27) Then
                    Line (SCR_W - 31, count_rows * 27 + (SCR_H-137))-(SCR_W - 4, count_rows * 27 + (SCR_H-137) + 27), RGB (255,255,0), B
                    current_icon = 22 + (count_rows + 1)
                End If
        Next count_rows
        
                    Select Case current_icon
                    Case 23
                        icon_text = "(N)ew polyline"
                    Case 24
                        icon_text = "Load polyline (F3)"
                    Case 25
                        icon_text = "Save polyline (F1)"
                    Case 26
                        icon_text = "Save as polyline (F2)"
                    Case 27
                        icon_text = "(Q)uit"    
                    End Select
                    
    End if
      
    ' If X has been picked on the palette, flag that new point is active (don't draw the line with the new vertex)  
    If d_color = RGBA(0,0,0,0) Then 
        newpoint = 1
        Else newpoint = 0
    End If
      
    'grid_factor = 4  
    ' On snap grid calculation based on camera and zoom
    ' Rotation is disabled
    tempgridx = Working_Polygon.x + ( ((mx-Working_Polygon.x)\ (Working_Polygon.zoom * grid_factor)) * Working_Polygon.zoom * grid_factor) '* grid_factor
    tempgridy = Working_Polygon.y + ( ((my-Working_Polygon.y)\ (Working_Polygon.zoom * grid_factor)) * Working_Polygon.zoom * grid_factor) '* grid_factor
    IF mx<>Working_Polygon.x Then tempgridx = tempgridx + (SGN(mx-Working_Polygon.x)*Working_Polygon.zoom/2) * grid_factor 
    IF my<>Working_Polygon.y Then tempgridy = tempgridy + (SGN(my-Working_Polygon.y)*Working_Polygon.zoom/2) * grid_factor
    IF mx=Working_Polygon.x Then tempgridx = tempgridx + (1*Working_Polygon.zoom/2) * grid_factor 
    IF my=Working_Polygon.y Then tempgridy = tempgridy + (1*Working_Polygon.zoom/2) * grid_factor
    'sint = Sin(Working_Polygon.rot)
    'cost = Cos(Working_Polygon.rot)
    gridx   = tempgridx'-Working_Polygon.x) * grid_factor
    gridy   = tempgridy'-Working_Polygon.y) * grid_factor

    If show_bmp = TRUE THEN PUT (SCR_W/2-bmp_sprite_width/2,SCR_H/2-bmp_sprite_height/2), sprite_buffer, TRANS
    
    ' Draw polygon and vertices
    DrawIt.renderPoly(Working_Polygon)
    DrawIt.renderPoly(Secondary_Polygon)
    If ShowVertices = TRUE Then 
        DrawIt.renderVertices(Working_Polygon, RGB(255,0,0))
        DrawIt.renderSingleVertex(Working_Polygon, selected_vertex, RGB(0,255,0))
    End If
    
    If hide_interface = FALSE THEN
        PUT (1,SCR_H-55), icons_1, TRANS
        PUT (SCR_W-31,SCR_H-137), icons_2, TRANS
    End If
    
    
    ' Set active cursor position.
    ' It's always mx and my, unless the user turns on "snap to vertex", where, if
    ' close to a vertex, active position switches to the position of that vertex.
    active_x = mx
    active_y = my
    For count_hl_vertex As Integer = 0 To Working_Polygon.num_vert-1
        Temp_Vertex = Working_Polygon.ReadVertexRealPosition(count_hl_vertex)
        If ABS(mx-Temp_Vertex.x) < 9 And ABS(my-Temp_Vertex.y) < 9 And ver_on_snap = TRUE Then
            Circle (Temp_Vertex.x, Temp_Vertex.y), 4, RGB(255,255,0)
            active_x = Temp_Vertex.x
            active_y = Temp_Vertex.y
        End If
    Next count_hl_vertex
    
    ' Mouse controlled draw vertex code.
    ' ==================================
    If (my < SCR_H - 54 And hide_interface = FALSE And insert_vertex_mode = FALSE And shift_center_mode = FALSE And current_icon < 23) Or (hide_interface = TRUE And insert_vertex_mode = FALSE AND shift_center_mode = FALSE And current_icon < 23) Then
        
        ' If left mouse b. is clicked add new vertex and move the current vertex If the user keeps holding left click
        If mclick = 1 AND active_x < SCR_W-13 Then
            If press_release = TRUE Then 
                If OnSnap = FALSE Then Working_Polygon.AddVertex((active_x-Working_Polygon.x)/Working_Polygon.zoom,(active_y-Working_Polygon.y)/Working_Polygon.zoom, d_color, newpoint)
                If OnSnap = TRUE Then Working_Polygon.AddVertex((gridx-Working_Polygon.x)/Working_Polygon.zoom,(gridy-Working_Polygon.y)/Working_Polygon.zoom, d_color, newpoint)
                press_release = FALSE
                selected_vertex = Working_Polygon.num_vert-1
            End If
            If press_release = FALSE AND OnSnap = FALSE Then MoveVertex (Working_Polygon, (active_x-Working_Polygon.x)/Working_Polygon.zoom, (active_y-Working_Polygon.y)/Working_Polygon.zoom,selected_vertex, d_color, newpoint)
            If press_release = FALSE AND OnSnap = TRUE Then MoveVertex (Working_Polygon, (gridx-Working_Polygon.x)/Working_Polygon.zoom, (gridy-Working_Polygon.y)/Working_Polygon.zoom,selected_vertex, d_color, newpoint)
        End If
        
        ' If right mouse b. is clicked move the currently selected vertex
        If mclick = 2 Then
            press_release = FALSE
            If OnSnap = FALSE Then MoveVertex (Working_Polygon, (active_x-Working_Polygon.x)/Working_Polygon.zoom, (active_y-Working_Polygon.y)/Working_Polygon.zoom,selected_vertex, d_color, newpoint)
            If OnSnap = TRUE Then MoveVertex (Working_Polygon, (gridx-Working_Polygon.x)/Working_Polygon.zoom, (gridy-Working_Polygon.y)/Working_Polygon.zoom,selected_vertex, d_color, newpoint)
        End If
    
    End If
    ' =================================
    
    ' Vertex scroll control
    If Multikey(FB.SC_PAGEUP And press_release2 = TRUE) Or (mclick = 1 And press_release2 = TRUE And current_icon = 7) Then 
        press_release2 = FALSE
        selected_vertex +=1
        If selected_vertex > Working_Polygon.num_vert-1 Then selected_vertex = 0
    End If
    If Multikey(FB.SC_PAGEDOWN And press_release2 = TRUE) Or (mclick = 1 And press_release2 = TRUE And current_icon = 8) Then 
        press_release2 = FALSE
        selected_vertex -=1
        If selected_vertex < 0 Then selected_vertex = Working_Polygon.num_vert-1
    End If
    
    ' Vertex scroll control
    If (Multikey(FB.SC_1) And press_release2 = TRUE) Then 
        press_release2 = FALSE
        If grid_factor = 10 Then 
            grid_factor = 1
           ElseIf grid_factor = 5 Then 
            grid_factor = 10
           ElseIf grid_factor = 1 Then 
            grid_factor = 5
        End If
    End If
    If (Multikey(FB.SC_2) And press_release2 = TRUE) Then 
        press_release2 = FALSE
        If grid_factor = 10 Then 
            grid_factor = 5
           ElseIf grid_factor = 5 Then 
            grid_factor = 1
           ElseIf grid_factor = 1 Then 
            grid_factor = 10
        End If
    End If
    
    ' Close polyline code (add a new vertex on the position of the first one)
    If (Multikey(FB.SC_E) And press_release = TRUE) Or (mclick = 1 And press_release = TRUE And current_icon = 12) Then
        Working_Polygon.AddVertex(Working_Polygon.vert_list[0].x, Working_Polygon.vert_list[0].y, d_color)
        press_release = FALSE
        insert_vertex_mode = FALSE
        shift_center_mode = FALSE
    End If
    
    ' Mirror object code (loops through vertices and creates new ones with x offset of all vertices from the last vertex)
    If (Multikey(FB.SC_M) And press_release = TRUE) Or (mclick = 1 And press_release = TRUE And current_icon = 13) Then
        For count_vertex AS INTEGER = Working_Polygon.num_vert - 1 TO 1 STEP -1
            Dim As Double difx = Working_Polygon.vert_list[Working_Polygon.num_vert-1].x - Working_Polygon.vert_list[count_vertex-1].x
            Working_Polygon.AddVertex(Working_Polygon.vert_list[count_vertex].x + difx, Working_Polygon.vert_list[count_vertex-1].y, Working_Polygon.vert_list[count_vertex].clr)
        Next count_vertex
        press_release = FALSE
        insert_vertex_mode = FALSE
        shift_center_mode = FALSE

    End If
    
    ' If V is pressed remove the currently selected vertex
    If (Multikey(FB.SC_V) And press_release = TRUE) Or (mclick = 1 And press_release = TRUE And current_icon = 1) Then
        press_release = FALSE
        Working_Polygon.RemoveVertex(selected_vertex)
        selected_vertex = selected_vertex - 1
        If selected_vertex < 0 Then selected_vertex = Working_Polygon.num_vert-1
        insert_vertex_mode = FALSE
        shift_center_mode = FALSE
    End If
    
    ' If I is pressed switch to insert_vertex mode
    If (Multikey(FB.SC_I) And press_release = TRUE) Or (mclick = 1 And press_release = TRUE And current_icon = 2) Then
        press_release = FALSE
        insert_vertex_mode = TRUE
        shift_center_mode = FALSE
    End If
    
    ' If insert vertex mode is active, insert a new vertex to current active position if the user mouse clicks again
    If (insert_vertex_mode = TRUE And press_release = TRUE And mclick = 1 And hide_interface = TRUE) Or (insert_vertex_mode = TRUE And press_release = TRUE And mclick = 1 And hide_interface = FALSE And my < SCR_H-55) Then
        press_release = FALSE
        insert_vertex_mode = FALSE
        Working_Polygon.InsertVertex(selected_vertex,(active_x-Working_Polygon.x)/Working_Polygon.zoom,(active_y-Working_Polygon.y)/Working_Polygon.zoom, d_color)
    End If
    
    ' If F is pressed activate shift center mode
    If (Multikey(FB.SC_F) And press_release = TRUE) Or (mclick = 1 And press_release = TRUE And current_icon = 22) Then
        press_release = FALSE
        insert_vertex_mode = FALSE
        shift_center_mode = TRUE
        Working_Polygon.rot = 0
    End If
    
    ' If shift center mode is active offset all the position of vertices around the new center
    If (shift_center_mode = TRUE And press_release = TRUE And mclick = 1 And hide_interface = TRUE) Or (shift_center_mode = TRUE And press_release = TRUE And mclick = 1 And hide_interface = FALSE And my < SCR_H-55) Then
        press_release = FALSE
        shift_center_mode = FALSE
        For count_v As Integer = 0 To Working_Polygon.num_vert - 1
            Working_Polygon.vert_list[count_v].x = Working_Polygon.vert_list[count_v].x - ((active_x-Working_Polygon.x)/Working_Polygon.zoom)
            Working_Polygon.vert_list[count_v].y = Working_Polygon.vert_list[count_v].y - ((active_y-Working_Polygon.y)/Working_Polygon.zoom)
        Next count_v
        current_icon = 28
    End If
    
    ' On snap toggle (If on snap is set to on, angle must be set to 0)
    If (Multikey(FB.SC_O) And press_release = TRUE)  Or (mclick = 1 And press_release = TRUE And current_icon = 9) Then
        press_release = FALSE
        If OnSnap = TRUE Then
            OnSnap = FALSE
        ElseIf OnSnap = FALSE Then
            Onsnap = TRUE
            If Working_Polygon.rot <> 0 Then Working_Polygon.rot = 0
        End If
    End If
    
    ' Snap to vertex toggle on/off
    If (Multikey(FB.SC_X) And press_release = TRUE) Or (mclick = 1 And press_release = TRUE And current_icon = 10) Then
        press_release = FALSE
        If ver_on_snap = TRUE Then
            ver_on_snap = FALSE
        ElseIf ver_on_snap = FALSE Then
            ver_on_snap = TRUE
        End If
    End If
    
    
    ' Toggle on/off draw vertices
    If (Multikey(FB.SC_T) And press_release2 = TRUE) Or (mclick = 1 And press_release2 = TRUE And current_icon = 11) Then
        press_release2 = FALSE
        If ShowVertices = TRUE Then
            ShowVertices = FALSE
        ElseIf ShowVertices = FALSE Then
            ShowVertices = TRUE
        End If
    End If
    
    ' remove all vertices (new shape)
    If (Multikey(FB.SC_N) And press_release = TRUE) Or (mclick = 1 And current_icon = 23 And press_release = TRUE) Then
        press_release = FALSE
        ScreenUnLock
        DO
            ScreenLock
             Draw String (SCR_W/2-(8*10),SCR_H-100),  "Are you sure (Y/N)?", font_color
            ScreenUnLock
            Sleep 1,1
        Loop UNTIL MULTIKEY(FB.SC_N) Or Multikey(FB.SC_Y)

        If Multikey(FB.SC_Y) Then 
            FOR count_vertices AS Integer = 0 TO Working_Polygon.num_vert - 1
                Working_Polygon.RemoveVertex(count_vertices)
            NEXT count_vertices
            current_undo = 1
            num_of_undos = 0
            Working_Polygon.zoom = 1
            Working_Polygon.rot = 0
        End If
    End If
    
    ' quit designer
    If (Multikey(FB.SC_Q) And press_release = TRUE) Or (mclick = 1 And current_icon = 27 And press_release = TRUE) Then
        press_release = FALSE
        ScreenUnLock
        DO
            ScreenLock
             Draw String (SCR_W/2-(8*4),SCR_H-100),  "Quit (Y/N)?", font_color
            ScreenUnLock
            Sleep 1,1
        Loop UNTIL MULTIKEY(FB.SC_N) Or Multikey(FB.SC_Y)

        If Multikey(FB.SC_Y) Then
            CLS
            IMAGEDESTROY (sprite_buffer)
            IMAGEDESTROY (icons_1)
            IMAGEDESTROY (icons_2)
            End
        End If
    End If
    
    ' Additional keyboard controls
    If Multikey(FB.SC_0) Or (mclick = 1 And current_icon = 4) Then Working_Polygon.rot = 0
    If Multikey(FB.SC_C) Or (mclick = 1 And current_icon = 3) Then CenterVertices Working_Polygon
    If Multikey(FB.SC_Z) Or (mclick = 1 And current_icon = 5) Then Working_Polygon.zoom = 1
    If Multikey(FB.SC_H) Or (mclick = 1 And current_icon = 6) Then 
        Camera_X = 0
        Camera_Y = 0
    End If
    
    ' Toggle interface on/off
    If (Multikey(FB.SC_F9) And press_release = TRUE) Or (mclick = 1 And press_release = TRUE And current_icon = 20) Then
        press_release = FALSE
        current_icon = 28
        If hide_interface = TRUE Then
            hide_interface = FALSE
        ElseIf hide_interface = FALSE Then
            hide_interface = TRUE
        End If
    End If
    
    ' Toggle bmp image on/off
    If (Multikey(FB.SC_TAB) And press_release2 = TRUE) Then
        press_release2 = FALSE
        If color_sheme = 1 Then
            color_sheme = 2
        ElseIf color_sheme = 2 Then
            color_sheme = 1
        End If
    End If
    
    ' Toggle bmp image on/off
    If (Multikey(FB.SC_F8) And press_release2 = TRUE) Or (mclick = 1 And press_release2 = TRUE And current_icon = 17) Then
        press_release2 = FALSE
        If show_bmp = TRUE Then
            show_bmp = FALSE
        ElseIf show_bmp = FALSE Then
            show_bmp = TRUE
        End If
    End If
    
    ' Load bmp/image
    If Multikey(FB.SC_F7) Or (mclick = 1 And current_icon = 16) Then
        dim As Integer file_num
        file_num = FreeFile( ) 
        press_release = FALSE
        Locate 14,1
        COLOR font_color
        bmp_filename_being_loaded = ""
        ScreenUnLock
        DO
            INPUT ; "Please enter BMP file to load: ", bmp_filename_being_loaded
            If Multikey(FB.SC_ENTER) Then Exit Do
        LOOP
        If dir$(bmp_filename_being_loaded)<>"" Then
            Open bmp_filename_being_loaded For Binary As #file_num
                Get #file_num, 19, bmp_sprite_width
                Get #file_num, 23, bmp_sprite_height
            Close #file_num
            sprite_buffer = ImageCreate(bmp_sprite_width + 1, bmp_sprite_height + 1)
            BLOAD bmp_filename_being_loaded, sprite_buffer
            show_bmp = TRUE
        End If
    End If
    
    ' Controls for loading and turning off the secondary vertex
    If (Multikey(FB.SC_F6) And Secondary_Polygon.num_vert > 0) Or (mclick = 1 And current_icon = 15 And Secondary_Polygon.num_vert > 0) Then
        FOR count_vertices AS Integer = 0 TO Secondary_Polygon.num_vert - 1
            Secondary_Polygon.RemoveVertex(count_vertices)
        NEXT count_vertices
    End If
    
    If Multikey(FB.SC_F5) Or (mclick = 1 And current_icon = 14) Then
        press_release = FALSE
        Locate 14,1
        COLOR font_color
        filename_being_loaded = ""
        ScreenUnLock
        DO
            INPUT ; "Please enter file to load (secondary shape): ", filename_being_loaded
            If Multikey(FB.SC_ENTER) Then Exit Do
        LOOP
        If filename_being_loaded <> "" Then 
            Load_Polygon filename_being_loaded, Secondary_Polygon
            filename_being_loaded = ""
        End If
    End If
    
    ' Load polygon code
    If Multikey(FB.SC_F3) Or (mclick = 1 And current_icon = 24) Then
        press_release = FALSE
        Locate 14,1
        COLOR font_color
        filename_being_loaded=""
        ScreenUnLock
        DO
            INPUT ; "Please enter file to load: ", filename_being_loaded
            If Multikey(FB.SC_ENTER) Then Exit Do
        LOOP
        If filename_being_loaded <> "" Then 
            Working_Polygon.rot = 0
            Working_Polygon.zoom = 1
            Load_Polygon filename_being_loaded, Working_Polygon
            loaded_shape_filename = filename_being_loaded
            text_time = 360
            temp_text = "Loaded file " + filename_being_loaded
        End If
    End If
      
    ' Save as polygon code  
    If Multikey(FB.SC_F2) Or (mclick = 1 And current_icon = 26) Then
        press_release = FALSE
        Locate 14,1
        COLOR font_color
        filename_being_loaded=""
        ScreenUnLock
        DO
            INPUT ; "Please enter file name to save to: ", filename_being_loaded
            If Multikey(FB.SC_ENTER) Then Exit Do
        LOOP
        If filename_being_loaded <> "" Then 
            Save_Polygon filename_being_loaded, Working_Polygon
            loaded_shape_filename = filename_being_loaded
            text_time = 360
            temp_text = "Polyline saved in " + filename_being_loaded
        End If
    End If
      
    ' Save polygon code (note how input file name is called If a file hasn't been
    ' previously loaded or saved = flagged with loaded_shape_filename)
    If Multikey(FB.SC_F1) Or (mclick = 1 And current_icon = 25) Then
        press_release = FALSE
        Locate 14,1
        COLOR font_color
        filename_being_loaded = ""
        ScreenUnLock
        If loaded_shape_filename = "" Then
        DO
            INPUT ; "Please enter file name to save to: ", filename_being_loaded
            If Multikey(FB.SC_ENTER) Then Exit Do
        LOOP
        End If
        If filename_being_loaded <> "" Then loaded_shape_filename = filename_being_loaded 
            
        Save_Polygon loaded_shape_filename, Working_Polygon
        text_time = 360
        temp_text = "Polyline saved in " + loaded_shape_filename

    End If
    
    ' Save as polygon code  
    If Multikey(FB.SC_L) Or (mclick = 1 And current_icon = 21) Then
        press_release = FALSE
        Locate 14,1
        COLOR font_color
        ScreenUnLock
        DO
            INPUT ; "Please input the scale factor: ", scale_factor
            If Multikey(FB.SC_ENTER) Then Exit Do
        LOOP
        
        If scale_factor <> 0 and scale_factor > 0 Then 
            For count_v As Integer = 0 To Working_Polygon.num_vert - 1
                Working_Polygon.vert_list[count_v].x = Working_Polygon.vert_list[count_v].x * scale_factor
                Working_Polygon.vert_list[count_v].y = Working_Polygon.vert_list[count_v].y * scale_factor
            Next count_v
        End If
    End If
    
    ' If the user presses ALT + U and the user had at least one activity (num_of_undos > 0)
    ' pass the values of undo polygon (current_undo) to the working polygon
    ' Eg. the user made an action, current_undo is reset to 1, and the value of the working
    ' polygon is passed to undo polygon (1). Now, the user presses ALT + U, we add 1 to current_undo 
    ' (it's now 2) and pass the value of Undo_Redo_Polygon(2) to the Working_Polygon
    If (Multikey(FB.SC_ALT) And Multikey(FB.SC_U) And press_release2 = TRUE And num_of_undos > 0) Or (mclick = 1 AND current_icon = 18 And press_release2 = TRUE And num_of_undos > 0) Then
        press_release2 = FALSE
        IF current_undo < num_of_undos THEN current_undo = current_undo + 1
        FOR count_vertices AS Integer = 0 TO Working_Polygon.num_vert-1
            Working_Polygon.RemoveVertex(count_vertices)
        NEXT count_vertices
        Working_Polygon.num_vert = 0
        Working_Polygon.rot = Undo_Redo_Polygon(current_undo).rot
        Working_Polygon.zoom = Undo_Redo_Polygon(current_undo).zoom
        For count_vert As Integer = 0 TO Undo_Redo_Polygon(current_undo).num_vert-1
            Working_Polygon.AddVertex(Undo_Redo_Polygon(current_undo).vert_list[count_vert].x, Undo_Redo_Polygon(current_undo).vert_list[count_vert].y, Undo_Redo_Polygon(current_undo).vert_list[count_vert].clr, Undo_Redo_Polygon(current_undo).vert_list[count_vert].newpoint, 1)
        Next count_vert
        If selected_vertex > Working_Polygon.num_vert-1 Then selected_vertex = Working_Polygon.num_vert-1
        Working_Polygon.x = Undo_Redo_Polygon(current_undo).x
        Working_Polygon.x = Undo_Redo_Polygon(current_undo).y
        'IF current_undo < num_of_undos THEN current_undo = current_undo + 1
    End If
    
    
    ' If the user pressed ALT + R and the current_undo is > 1 then reduce current_undo by 1 and
    ' pass the value of the value of Undo_Redo_Polygon(current_undo) to the Working_Polygon
    If (Multikey(FB.SC_ALT) And Multikey(FB.SC_R) And press_release2 = TRUE) Or (mclick = 1 AND current_icon = 19 And press_release2 = TRUE And num_of_undos > 0) Then
        press_release2 = FALSE
        IF current_undo > 1 THEN 
            current_undo = current_undo - 1
            FOR count_vertices AS Integer = 0 TO Working_Polygon.num_vert-1
                Working_Polygon.RemoveVertex(count_vertices)
            NEXT count_vertices
            Working_Polygon.num_vert = 0
            Working_Polygon.rot = Undo_Redo_Polygon(current_undo).rot
            Working_Polygon.zoom = Undo_Redo_Polygon(current_undo).zoom
            For count_vert As Integer = 0 TO Undo_Redo_Polygon(current_undo).num_vert-1 
                Working_Polygon.AddVertex(Undo_Redo_Polygon(current_undo).vert_list[count_vert].x, Undo_Redo_Polygon(current_undo).vert_list[count_vert].y, Undo_Redo_Polygon(current_undo).vert_list[count_vert].clr, Undo_Redo_Polygon(current_undo).vert_list[count_vert].newpoint, 1)
            Next count_vert
            Working_Polygon.x = Undo_Redo_Polygon(current_undo).x
            Working_Polygon.x = Undo_Redo_Polygon(current_undo).y
        End If
    End If

    If current_icon > 0 And press_release = TRUE Then current_icon = 0
    
    ' click/keypress reset
    If press_release = FALSE AND mclick <> 1 AND mclick <> 2 AND NOT Multikey(FB.SC_F) AND NOT Multikey(FB.SC_LEFT) AND NOT Multikey(FB.SC_RIGHT) AND NOT Multikey(FB.SC_UP) AND NOT Multikey(FB.SC_DOWN) AND NOT Multikey(FB.SC_F1) AND NOT Multikey(FB.SC_F3) AND NOT Multikey(FB.SC_F2) AND NOT Multikey(FB.SC_Q) AND NOT Multikey(FB.SC_N) AND NOT Multikey(FB.SC_X) AND NOT Multikey(FB.SC_F9) AND NOT Multikey(FB.SC_V) AND NOT Multikey(FB.SC_E) AND NOT Multikey(FB.SC_M) AND NOT Multikey(FB.SC_I) AND NOT Multikey(FB.SC_O) Then 
        press_release = TRUE
        change_made = TRUE
    End If
    If press_release2 = FALSE AND NOT Multikey(FB.SC_1) AND NOT Multikey(FB.SC_TAB) AND NOT Multikey(FB.SC_T) AND NOT Multikey(FB.SC_2) AND NOT Multikey(FB.SC_U) AND NOT Multikey(FB.SC_F8) AND NOT Multikey(FB.SC_R) AND mclick <> 1 AND mclick <> 2 AND NOT Multikey(FB.SC_PAGEDOWN) AND NOT Multikey(FB.SC_PAGEUP) Then 
        press_release2 = TRUE
    End If
    
    ' If the user made an action execute the code related to the undo_polygon array.
    If change_made = TRUE And Not Multikey(FB.SC_ALT) Then
        'goto skip_stuff:
        ' Increase the number of undos by 1.
        If num_of_undos < 30 Then num_of_undos = num_of_undos + 1 
        
        ' count undo polyline from number of undo polygons saved to the current undo value
        ' eg. you are on 7th undo out of 14 saved undo. count from 14 to 8 undo polyline, passing the
        ' values of 14 to 15, values of 13 to 14, till values of 7 to 8.
        If current_undo < 30 And num_of_undos > current_undo Then
            For count_ur_poly AS INTEGER = num_of_undos To current_undo + 1 Step -1 
                FOR count_vertices AS Integer = 0 TO Undo_Redo_Polygon(count_ur_poly).num_vert-1
                    Undo_Redo_Polygon(count_ur_poly).RemoveVertex(count_vertices)
                NEXT count_vertices
                
                Undo_Redo_Polygon(count_ur_poly).num_vert = 0
                Undo_Redo_Polygon(count_ur_poly).rot = Undo_Redo_Polygon(count_ur_poly-1).rot
                Undo_Redo_Polygon(count_ur_poly).zoom = Undo_Redo_Polygon(count_ur_poly-1).zoom

                For count_vert As Integer = 0 TO Undo_Redo_Polygon(count_ur_poly-1).num_vert-1 
                    Undo_Redo_Polygon(count_ur_poly).AddVertex(Undo_Redo_Polygon(count_ur_poly-1).vert_list[count_vert].x, Undo_Redo_Polygon(count_ur_poly-1).vert_list[count_vert].y, Undo_Redo_Polygon(count_ur_poly-1).vert_list[count_vert].clr, Undo_Redo_Polygon(count_ur_poly-1).vert_list[count_vert].newpoint, 1)
                Next count_vert
                Undo_Redo_Polygon(count_ur_poly).x = Undo_Redo_Polygon(count_ur_poly-1).x
                Undo_Redo_Polygon(count_ur_poly).x = Undo_Redo_Polygon(count_ur_poly-1).y
            Next count_ur_poly
        End If

        ' Passed the working_polygon to the current undo_polygon. Eg. if current polygon is 7, and we have 14 activities
        ' saved in the undo polygons (num_of_undos = 14), we move above values from the undo polygon array one
        ' position down, and the values from undo_polygon(7) become undo_polygon (8), while here we finally pass the values
        ' of the working_polygon to undo_polygon(7). But now we have our undos saved from 7 till 15. undo_polygon values from
        ' 1 till 6 can't be used anymore because the user had an activity (no redos should be allowed after an activity).
        For count_vertices AS Integer = 0 TO Undo_Redo_Polygon(current_undo).num_vert-1
            Undo_Redo_Polygon(current_undo).RemoveVertex(count_vertices)
        Next count_vertices
        Undo_Redo_Polygon(current_undo).num_vert = 0
        Undo_Redo_Polygon(current_undo).rot = Working_Polygon.rot
        Undo_Redo_Polygon(current_undo).zoom = Working_Polygon.zoom
        For count_vert As Integer = 0 TO Working_Polygon.num_vert-1 
            Undo_Redo_Polygon(current_undo).AddVertex(Working_Polygon.vert_list[count_vert].x, Working_Polygon.vert_list[count_vert].y, Working_Polygon.vert_list[count_vert].clr, Working_Polygon.vert_list[count_vert].newpoint, 1)
        Next count_vert
        Undo_Redo_Polygon(current_undo).x = Working_Polygon.x
        Undo_Redo_Polygon(current_undo).x = Working_Polygon.y
        
        ' If the current undo is 7, and number of undos is 15, the new number of undos after a new activity must
        ' become 9 (7,8,9,10,11,12,13,14,15)
        num_of_undos = num_of_undos - current_undo + 1
        
        
        ' Move the undos from the current_undo to a range from 1 to new num_of_undos.
        ' In this case undo_polygons 7 to 15 become undo_polygons 1 to 9. If current_polygon is 1, this
        ' for loop is not neccesary as the for loop above did all the neccessary shifting.
        If current_undo > 1 Then
            For count_ur_poly AS INTEGER = 1 TO num_of_undos
                FOR count_vertices AS Integer = 0 TO Undo_Redo_Polygon(count_ur_poly).num_vert-1
                    Undo_Redo_Polygon(count_ur_poly).RemoveVertex(count_vertices)
                NEXT count_vertices
                Undo_Redo_Polygon(count_ur_poly).num_vert = 0
                Undo_Redo_Polygon(count_ur_poly).rot = Undo_Redo_Polygon(current_undo+count_ur_poly-1).rot
                Undo_Redo_Polygon(count_ur_poly).zoom = Undo_Redo_Polygon(current_undo+count_ur_poly-1).zoom
                For count_vert As Integer = 0 TO Undo_Redo_Polygon(current_undo+count_ur_poly-1).num_vert-1
                    Undo_Redo_Polygon(count_ur_poly).AddVertex(Undo_Redo_Polygon(current_undo+count_ur_poly-1).vert_list[count_vert].x, Undo_Redo_Polygon(current_undo+count_ur_poly-1).vert_list[count_vert].y, Undo_Redo_Polygon(current_undo+count_ur_poly-1).vert_list[count_vert].clr, Undo_Redo_Polygon(current_undo+count_ur_poly-1).vert_list[count_vert].newpoint, 1)
                Next count_vert
                Undo_Redo_Polygon(count_ur_poly).x = Undo_Redo_Polygon(current_undo+count_ur_poly-1).x
                Undo_Redo_Polygon(count_ur_poly).x = Undo_Redo_Polygon(current_undo+count_ur_poly-1).y
            Next count_ur_poly
        End If

        change_made = FALSE
        current_undo = 1 ' set the current undo to 1 after each activity
        
    End If ' if the user made a change on the polygon do the undo/redo related code
    
    ' If on snap is active draw the blue cross indicating the currently selected sector
    If (OnSnap = TRUE And hide_interface = TRUE) or (OnSnap = TRUE And hide_interface = FALSE And my<SCR_H-138 And mx<620) Then
        Line (gridx-5, gridy-5)-(gridx+5,gridy+5), RGB(0,0,255)
        Line (gridx+5, gridy-5)-(gridx-5,gridy+5), RGB(0,0,255)
    End If
    
    ' draw cursor
    Line (mx-15,my)-(mx+15,my), cursor_color
    Line (mx,my+15)-(mx,my-15), cursor_color
    PSET (mx,my), RGB(0,0,0)
    
    dim as single timer_elapsed = (timer - demosecs)
	time_start =  timer
	if timer_elapsed > 1 then 
		fps = frames_per_sec/timer_elapsed
		frames_per_sec = 0
	    demosecs = timer
	end if
    
    ScreenSync
    ScreenUnLock
   
    Sleep 1,1
   
Loop


Sub Load_BMPSprite (bmp_filename as string, l_sprite_buffer as any ptr)

IMAGEDESTROY (l_sprite_buffer)

Dim as integer sprite_width, sprite_height
Dim As Integer file_num
file_num = FreeFile( ) 

If dir$(bmp_filename)<>"" Then

Open bmp_filename For Binary As #file_num
Get #file_num, 19, sprite_width
Get #file_num, 23, sprite_height
Close #file_num

l_sprite_buffer = ImageCreate(sprite_width + 1, sprite_height + 1)
BLOAD bmp_filename, l_sprite_buffer

End If

End Sub

Sub Load_Polygon (p_filename as string, loaded_p as _polygon)

dim as double px,py
dim as uinteger clr
Dim As Integer file_num, newpoint
file_num = FreeFile( )    

If dir$(p_filename)<>"" Then
    
OPEN p_filename FOR INPUT AS #file_num

FOR count_vertices AS Integer = 0 TO loaded_p.num_vert - 1
    loaded_p.RemoveVertex(count_vertices)
NEXT count_vertices
DO
INPUT #file_num, px
INPUT #file_num, py
INPUT #file_num, clr
INPUT #file_num, newpoint
loaded_p.AddVertex(px,py,clr,newpoint)
LOOP UNTIL EOF(file_num)

CLOSE #file_num

End If
    
End sub

Sub Save_Polygon (p_filename as string, saved_p as _polygon)

dim as double px,py
dim as uinteger clr
Dim As Integer file_num
file_num = FreeFile( )    

OPEN p_filename FOR OUTPUT AS #file_num

FOR count_v AS INTEGER = 0 TO saved_p.num_vert-1
Print #file_num, saved_p.vert_list[count_v].x 
Print #file_num, saved_p.vert_list[count_v].y
Print #file_num, saved_p.vert_list[count_v].clr
IF saved_p.vert_list[count_v].clr = RGBA(0,0,0,0) THEN saved_p.vert_list[count_v].newpoint = 1
Print #file_num, saved_p.vert_list[count_v].newpoint
NEXT count_v

CLOSE #file_num
    
End sub
