

/'
   Polylib Graphics Engine
   by Vincent DeCampo (c) 2010
'/

#Include Once "fbgfx.bi"
#Include Once "crt.bi"

#Ifndef PI
Const PI As Double = Atn(1)*4
#EndIf
#Define RNDCLR    RGB(Rnd*256,Rnd*256,Rnd*256)

/'
   Type _vertex_2d
'/
Type _vertex_2d
   Declare Constructor()
   Declare Constructor(vx As Double, vy As Double, clr As Uinteger = &hFFFFFF, newpoint As Integer = 0)
   As Double   x,y
   As Uinteger clr = &hFFFFFF
   As Integer  newpoint 
End Type

Constructor _vertex_2d()
   this.x = 0
   this.y = 0
End Constructor

Constructor _vertex_2d(vx As Double, vy As Double, clr As Uinteger = &hFFFFFF, newpoint As Integer = 0)
   this.x        = vx
   this.y        = vy
   this.clr      = clr
   this.newpoint = newpoint
End Constructor
/'
   Type _polygon
'/
Type _polygon
   '
   Enum BOOLEAN
      NO  = 0
      YES = Not NO
   End Enum
   '
   Declare Destructor()
   Declare Sub AddVertex    OverLoad (vt As _vertex_2d, rotate_flag As Integer = 0)
   Declare Sub AddVertex    OverLoad (vx As Double, vy As Double, clr As Uinteger = &hFFFFFF, newpoint As Integer = 0, rotate_flag As Integer = 0)
   Declare Sub InsertVertex OverLoad (index As Integer, vt As _vertex_2d)
   Declare Sub InsertVertex OverLoad (index As Integer, vx As Double, vy As Double, clr As Uinteger = &hFFFFFF, newpoint As Integer = 0)
   Declare Sub RemoveVertex          (index As Integer)
   Declare Sub MoveVertex (m_poly as _polygon, m_x as Double, m_y as Double, vertex_num as Integer, m_clr As Uinteger = &hFFFFFF, rotate_flag As Integer = 0)
   Declare Function ApplyTransformation(Offset As Integer = 1) As _vertex_2d Ptr
   Declare Function RotateVertex(pt As _vertex_2d, rot As Double,sint As Double, cost As Double) As _vertex_2d
   Declare Function ReadVertexRealPosition(vertex_num As Integer) As _vertex_2d
   '
   As Integer            num_vert
   As _vertex_2d Ptr     vert_list
   As Double             x,y
   As Double             rot,zoom=1
   /'
      Collision Info
   '/
   Declare Function      TestCollision        (poly As _polygon) As Integer
   Declare Function      PlumbLineIntersection(poly As _polygon) As Integer
   Declare Function      PointInPolygon       (pt As _vertex_2d) As Integer
   Declare Function      InPoly               (pt As _vertex_2d) As Integer   
   Declare Sub           UpdatePlumblines()
   '
   As Double             minx,maxx
   As Double             miny,maxy
   As Integer            Convex = 1
   '
End Type

Destructor _polygon
   If vert_list Then
      Delete[] vert_list
   Endif
End Destructor

Sub _polygon.AddVertex OverLoad (vt As _vertex_2d, rotate_flag As Integer = 0)
   Dim As _vertex_2d Ptr tmp_list
   Dim As Double sint,cost
   
   this.num_vert+=1
   
   sint = Sin(-this.rot)
   cost = Cos(-this.rot)
   
   If rotate_flag = 1 Then
    sint = 0
    cost = 1
   End if
   

   tmp_list = New _vertex_2d[this.num_vert]
   tmp_list[this.num_vert-1].x   = vt.x  * cost - vt.y * sint
   tmp_list[this.num_vert-1].y   = vt.x  * sint + vt.y * cost
   
   tmp_list[this.num_vert-1].clr = vt.clr

   If this.vert_list Then
      memcpy tmp_list, this.vert_list, SizeOf(_vertex_2d)*(this.num_vert-1)
      Delete[] vert_list
   Endif

   vert_list = tmp_list

End Sub


Sub _polygon.AddVertex OverLoad (vx As Double, vy As Double, clr As Uinteger = &hFFFFFF, newpoint As Integer = 0, rotate_flag As Integer = 0)
Dim As _vertex_2d newvt

   newvt.x        = vx
   newvt.y        = vy
   newvt.clr      = clr
   newvt.newpoint = newpoint
   
   this.AddVertex(newvt, rotate_flag)

End Sub

Sub _polygon.InsertVertex OverLoad (index As Integer, vt As _vertex_2d)
    
   Dim As _vertex_2d tmpvt  
            
   Select Case index
      
      Case Is > this.num_vert-1  'Add to end
         this.AddVertex(vt)
         
      Case this.num_vert-1 
         this.AddVertex(vt)
         tmpvt = this.vert_list[index] 
         this.vert_list[index]   = vt
         this.vert_list[index+1] = tmpvt
         
      Case Else
         this.AddVertex(vt)
         For v As Integer = this.num_vert-1 To index+1 Step -1
            this.vert_list[v] = this.vert_list[v-1]            
         Next
         this.vert_list[index] = vt
         
   End Select
      
   this.vert_list[index] = vt
         
End Sub

Sub _polygon.InsertVertex OverLoad (index As Integer, vx As Double, vy As Double, clr As Uinteger = &hFFFFFF, newpoint As Integer = 0)
Dim As _vertex_2d newvt

   newvt.x        = vx
   newvt.y        = vy
   newvt.clr      = clr
   newvt.newpoint = newpoint
   
   this.InsertVertex(index, newvt)
   
End Sub

Sub _polygon.RemoveVertex (index As Integer)
Dim As _vertex_2d Ptr tmp_list
   
   If this.num_vert > 1 Then
 
      this.num_vert-=1
      tmp_list = New _vertex_2d[this.num_vert]
   
      Select Case index
         Case 0
            memcpy tmp_list, @this.vert_list[1], SizeOf(_vertex_2d)*(this.num_vert)
         Case Is >= this.num_vert
            memcpy tmp_list, this.vert_list, SizeOf(_vertex_2d)*(this.num_vert)
         Case Else
            memcpy tmp_list, this.vert_list, SizeOf(_vertex_2d)*(index)
            memcpy @tmp_list[index], @this.vert_list[index+1], SizeOf(_vertex_2d)*(this.num_vert-index)
      End Select
   
      Delete[] vert_list
      vert_list = tmp_list
   
   Else
      
      Delete[] vert_list
      vert_list = 0
      this.num_vert = 0
      
   Endif
   
End Sub

Function _polygon.ReadVertexRealPosition(vertex_num As Integer) As _vertex_2d
Dim As _vertex_2d Ptr tmp_list
Dim As _vertex_2d vert

   tmp_list = this.ApplyTransformation()
  
   vert = tmp_list[vertex_num]
  
   Delete[] tmp_list

   Return vert
  
End Function


Function _polygon.ApplyTransformation(Offset As Integer = 1) As _vertex_2d Ptr
Dim As _vertex_2d Ptr tmp_list
Dim As Double sint,cost

   sint = Sin(this.rot)
   cost = Cos(this.rot)

   tmp_list = New _vertex_2d[this.num_vert]
   For i As Integer = 0 To this.num_vert-1
      tmp_list[i].x   = this.vert_list[i].x * cost - this.vert_list[i].y * sint
      tmp_list[i].y   = this.vert_list[i].x * sint + this.vert_list[i].y * cost
      tmp_list[i].x   = tmp_list[i].x * this.zoom + this.x
      tmp_list[i].y   = tmp_list[i].y * this.zoom + this.y
      tmp_list[i].clr = this.vert_list[i].clr
      tmp_list[i].newpoint = this.vert_list[i].newpoint
   Next

   Return tmp_list

End Function

Function _polygon.RotateVertex(pt As _vertex_2d, rot As Double, sint As Double, cost As Double) As _vertex_2d
Dim newpt As _vertex_2d

   newpt.x   = pt.x * cost - pt.y * sint
   newpt.y   = pt.x * sint + pt.y * cost
   newpt.clr = pt.clr
   newpt.newpoint = pt.newpoint

   Return newpt

End Function

Function _polygon.TestCollision(poly As _polygon) As Integer
Dim As _vertex_2d Ptr tvert_list

   If this.PlumbLineIntersection(poly) Then
      tvert_list = poly.ApplyTransformation()
      For i As Integer = 0 To poly.num_vert-1
         'If this.InPoly(tvert_list[i]) Then
         If this.pointInPolygon(tvert_list[i]) Then
            Delete[] tvert_list
            Return 1
         Endif
      Next
      Delete[] tvert_list
   Endif

End Function

Sub _polygon.UpdatePlumblines()
Dim As _vertex_2d Ptr tvert_list

   tvert_list = this.ApplyTransformation()

   this.minx = tvert_list[0].x
   this.miny = tvert_list[0].y
   this.maxx = tvert_list[0].x
   this.maxy = tvert_list[0].y

   For i As Integer = 1 To this.num_vert-1
      If tvert_list[i].x < this.minx Then this.minx = tvert_list[i].x
      If tvert_list[i].x > this.maxx Then this.maxx = tvert_list[i].x
      If tvert_list[i].y < this.miny Then this.miny = tvert_list[i].y
      If tvert_list[i].y > this.maxy Then this.maxy = tvert_list[i].y
   Next

   Delete[] tvert_list

End Sub

Function _Polygon.pointInPolygon(pt As _vertex_2d) As Integer
Dim As Integer j = this.num_vert-1
Dim As BOOLEAN oddNodes = NO
Dim As _vertex_2d Ptr tvert_list

   tvert_list = this.ApplyTransformation()

   For i As Integer =0 To this.num_vert-1

      If (tvert_list[i].y < pt.y And tvert_list[j].y >= pt.y) _
         Or  (tvert_list[j].y < pt.y And tvert_list[i].y >= pt.y) Then

         If (tvert_list[i].x + (pt.y-tvert_list[i].y) / (tvert_list[j].y-tvert_list[i].y)*(tvert_list[j].x-tvert_list[i].x) < pt.x) Then
            oddNodes Xor= YES
         End If
      Endif

      j=i

   Next

   Delete[] tvert_list

   Return oddNodes

End Function
/'
   Function derived from original code by dodicat
'/
Function _polygon.inpoly(pt As _vertex_2d) As Integer
Dim As Double y1,y2,x1,x2, ix, slope
Dim As Integer count, inter_count
Dim As _vertex_2d Ptr tvert_list

   tvert_list = this.ApplyTransformation()

   'test each segment in the polygon
   For count = 0 To this.num_vert-1
      
      'set x1,y1,x2,y2 = to the endpoints of the segment we are testing
      x1 = tvert_list[count].x
      y1 = tvert_list[count].y

      If count = this.num_vert-1 Then
         x2 = tvert_list[0].x
         y2 = tvert_list[0].y
      Else
         x2 = tvert_list[count+1].x
         y2 = tvert_list[count+1].y
      Endif

      'make x1, y1 have lowest value on the y axis
      If y1 > y2 Then
         Swap y1, y2
         Swap x1, x2
      Endif

      'Now test for intersection With a horizontal line
      'originating at pt and extending to the right
      If ((y1 <= pt.y) And (y2 >= pt.y)) And _
         ((x1 > pt.x) Or (x2 > pt.x)) Then
         'could be an intersection
         'is segment vertical
         If x2 = x1 Then
            inter_count += 1
         Else
            'find the ix, the x value of the intesection point
            slope = (y2-y1)/(x2-x1)
            ix = ((pt.y - y1) / slope) + x1
            'if it is to the right of pt then intersection
            If ix > pt.x Then
               inter_count += 1
            Endif
         Endif
      Endif
   
   Next
   
   Return inter_count Mod 2
   
End Function

Function _polygon.PlumbLineIntersection(poly As _polygon) As Integer
Dim As Integer xflag,yflag

   'Offset plumblines with poly x,y,zoom
   this.UpdatePlumblines()
   poly.UpdatePlumblines()

   If this.minx >= poly.minx And this.minx <= poly.maxx Then
      xflag = 1
   Endif
      
   If this.maxx >= poly.minx And this.maxx <= poly.maxx Then
      xflag = 1
   Endif

   If poly.minx >= this.minx And poly.minx <= this.maxx Then
      xflag = 1
   Endif
      
   If poly.maxx >= this.minx And poly.maxx <= this.maxx Then
      xflag = 1
   Endif
   '---------------------------------------------
   If this.miny >= poly.miny And this.miny <= poly.maxy Then
      yflag = 1
   Endif
   
   If this.maxy >= poly.miny And this.maxy <= poly.maxy Then
      yflag = 1
   Endif

   If poly.miny >= this.miny And poly.miny <= this.maxy Then
      yflag = 1
   Endif
   
   If poly.maxy >= this.miny And poly.maxy <= this.maxy Then
      yflag = 1
   Endif

   Return xflag And yflag

End Function

/'
   Type _render_poly
'/
Type _render_poly
   '
   Declare Sub RenderList      (polylist As _polygon Ptr, polycount As Integer)
   Declare Sub RenderPoly      (polygon As _polygon)
   Declare Sub RenderVertices  (polygon As _polygon, vertices_color as Uinteger)
   Declare Sub RenderSingleVertex (polygon As _polygon, vertex_num As Integer, vertex_color as Uinteger)
   Declare Sub RenderPlumlines (polygon As _polygon)
   '
   As FB.IMAGE Ptr dst
   As Integer scr_width, scr_height
   As Integer global_zoom, global_rot
   '
   As Integer apply_global_zoom = 0
   As Integer apply_global_rot  = 0
   '
End Type

Sub _render_poly.RenderList(polylist As _polygon Ptr, polycount As Integer)

   For p As Integer = 0 To polycount-1
      this.RenderPoly( polylist[p] )
   Next

End Sub

Sub _render_poly.RenderPoly(polygon As _polygon)
Dim As Uinteger drawclr
Dim As _vertex_2d Ptr vert_list
Dim As Double tx,ty,sint,cost

   If polygon.num_vert > 0 Then

      vert_list = polygon.ApplyTransformation()
      drawclr = vert_list[0].clr

      Pset this.dst,(vert_list[0].x, vert_list[0].y),drawclr

      For v As Integer = 1 To polygon.num_vert-1
          drawclr = vert_list[v].clr
         If vert_list[v].newpoint Then
            Pset this.dst,(vert_list[v].x, vert_list[v].y),drawclr
         Else
            Line this.dst,-(vert_list[v].x, vert_list[v].y),drawclr   
         Endif         
         
      Next

   End If

   Delete[] vert_list

End Sub

Sub _render_poly.RenderVertices(polygon As _polygon, vertices_color as Uinteger)

Dim As _vertex_2d Ptr vert_list


   If polygon.num_vert > 0 Then

      vert_list = polygon.ApplyTransformation()
      'drawclr = vert_list[0].clr

      For v As Integer = 0 To polygon.num_vert-1
            Circle this.dst,(vert_list[v].x, vert_list[v].y),4, vertices_color   
      Next
   End If

   Delete[] vert_list

End Sub

Sub _render_poly.RenderSingleVertex(polygon As _polygon, vertex_num As Integer, vertex_color  as Uinteger)

Dim As _vertex_2d Ptr vert_list


   If polygon.num_vert > 0 Then
      vert_list = polygon.ApplyTransformation()
      Circle this.dst,(vert_list[vertex_num].x, vert_list[vertex_num].y),4, vertex_color    
   End If

   Delete[] vert_list

End Sub

Sub _render_poly.RenderPlumlines(polygon As _polygon)
   With polygon
      Line this.dst,(.minx,.miny)-(.minx,.maxy),RNDCLR
      Line this.dst,(.minx,.miny)-(.maxx,.miny),RNDCLR
   End With
End Sub

Sub CenterVertices(center_polyline as _polygon)
    
Dim As Double nx,ny

   For count As Integer = 0 To center_polyline.num_vert-1
      nx += center_polyline.vert_list[count].x
      ny += center_polyline.vert_list[count].y      
   Next
   
   nx /= center_polyline.num_vert
   ny /= center_polyline.num_vert

   For count As Integer = 0 To center_polyline.num_vert-1
      center_polyline.vert_list[count].x -= nx
      center_polyline.vert_list[count].y -= ny
   Next
   
End Sub


Sub MoveVertex (m_poly as _polygon, m_x as Double, m_y as Double, vertex_num as Integer, m_clr As Uinteger = &hFFFFFF, rotate_flag As Integer = 0)
       
   Dim As Double sint,cost
   
   sint = Sin(-m_poly.rot)
   cost = Cos(-m_poly.rot)
   
   If rotate_flag = 1 Then
    sint = 0
    cost = 1
   End if

   'tmp_list = New _vertex_2d[vertex_num]
   m_poly.vert_list[vertex_num].x   = m_x  * cost - m_y * sint
   m_poly.vert_list[vertex_num].y   = m_x  * sint + m_y * cost
   
   if m_clr = RGBA(0,0,0,0) THEN m_poly.vert_list[vertex_num].newpoint = 1
   if m_clr <> RGBA(0,0,0,0) THEN m_poly.vert_list[vertex_num].newpoint = 0
   
   m_poly.vert_list[vertex_num].clr = m_clr

   
End Sub
 