' All AFlib 2 subs and functions used with Star Cage
' are placed in a separate .bi file(this file!). 
' libAFlib2.a is not used since it includes the subs and
' functions Star Cage doesn't use and therefore results
' in a 4 MB executable.

'$dynamic

Type ImageType
   m_size	     as uinteger
   m_pitch	     as uinteger
   m_maxindex    as uinteger
   m_filename    as string
   p_data	     as ushort ptr
   p_dataindex   as uinteger ptr
   init	     as sub ( byref image as ImageType )
   load	     as sub ( byref image as ImageType )
   load_BMP      as sub ( byref image as ImageType, byval wid as integer, byval hei as integer)
   index	     as sub ( byref image as ImageType )
   destroy 	     as sub ( byref image as ImageType )
End Type
                       
Declare Sub AF2.InitSpr_BMP (Byref BMP_array as ImageType, _
                             Byval x_size as Integer, _
                             Byval y_size as Integer, _
                             Byref Filename as String)
Declare Sub AF2.InitSpr_PP256 (Byref PP256_array as ImageType, _
                               Byref Filename as String)
                             
Declare Sub image_index ( byref image as ImageType )
Declare Sub image_destroy ( byref image as ImageType )
Declare Sub image_init ( byref image as ImageType )
Declare Sub image_load ( byref image as ImageType )
Declare Sub image_load_BMP ( byref image as ImageType, byval wid as integer, byval hei as integer)

Declare Sub AF2.InitPP256pal ( Byref Filename as String )
Declare Sub AF2.ClearScreen (Byval col as Integer, Byval buffer as any PTR = 0 )

Declare Sub AF2.SprBlit_rotate ( Byval sx1 as Integer, _
                                 Byval sy1 as Integer, _
                                 Byval image as ushort ptr,_ 
                                 Byval rotation.angle as double, _
                                 Byval buffer as any ptr = 0 )

Declare Sub AF2.SprBlit_scale.solid ( Byval sx1 as Integer, _
                                      Byval sy1 as Integer, _
                                      Byval image as ushort ptr,_ 
                                      Byval scale.x as single, _
                                      Byval scale.y as single, _
                                      Byval buffer as any ptr = 0 )


Declare Sub AF2.SprBlit_rotate.solid ( Byval sx1 as Integer, _
                                       Byval sy1 as Integer, _
                                       Byval image as ushort ptr,_ 
                                       Byval rotation.angle as double, _
                                       Byval buffer as any ptr = 0 )
Declare Sub AF2.SprBlit_scale.rotate ( Byval sx1 as Integer, _
                                       Byval sy1 as Integer, _
                                       Byval image as ushort ptr,_ 
                                       Byval scale.x as single, _
                                       Byval scale.y as single, _
                                       Byval rotation.angle as double, _
                                       Byval buffer as any ptr = 0 )
Declare Sub AF2.SprBlit_scale.rotate.solid ( Byval sx1 as Integer, _
                                             Byval sy1 as Integer, _
                                             Byval image as ushort ptr,_ 
                                             Byval scale.x as single, _
                                             Byval scale.y as single, _
                                             Byval rotation.angle as double, _
                                             Byval buffer as any ptr = 0 )

Declare Sub AF2.SprBlit ( Byval sx1 as Integer, Byval sy1 as Integer, _
                          Byval image as ushort ptr,_ 
                          Byval SCREEN_WID as integer, _
                          Byval SCREEN_HEI as integer )

Declare Sub AF2.SprBlit_color ( Byval sx1 as integer, Byval sy1 as integer, _
                                Byval scol as integer, Byval image as ushort ptr, _
                                Byval SCREEN_WID as integer, _
                                Byval SCREEN_HEI as integer )

Declare Sub AF2.SprBlit_trans ( Byval sx1 as Integer, Byval sy1 as Integer, _
                                Byval image as ushort ptr,_ 
                                Byval SCREEN_WID as integer, _
                                Byval SCREEN_HEI as integer )

Declare Sub AF2.SprBlit_tr.dark ( Byval sx1 as Integer, Byval sy1 as Integer, _
                                  Byval image as ushort ptr,_ 
                                  Byval SCREEN_WID as integer, _
                                  Byval SCREEN_HEI as integer )

Declare Sub AF2.SprBlit_tr.darker ( Byval sx1 as Integer, Byval sy1 as Integer, _
                                    Byval image as ushort ptr, _ 
                                    Byval SCREEN_WID as integer, _
                                    Byval SCREEN_HEI as integer )

Declare Sub AF2.SprBlit_tr.darkest ( Byval sx1 as Integer, Byval sy1 as Integer, _
                                     Byval image as ushort ptr, _ 
                                     Byval SCREEN_WID as integer, _
                                     Byval SCREEN_HEI as integer )

Declare Sub AF2.SprBlit_null ( Byval sx1 as Integer, Byval sy1 as Integer, _
                               Byval image as ushort ptr, _ 
                               Byval SCREEN_WID as integer, _
                               Byval SCREEN_HEI as integer )

Declare Sub AF2.SprBlit_brightness ( Byval sx1 as Integer, Byval sy1 as Integer, _
                                     Byval bright.level as Integer, _
                                     Byval image as ushort ptr, _ 
                                     Byval SCREEN_WID as integer, _
                                     Byval SCREEN_HEI as integer )

Declare Sub AF2.PP256fntSP_brightness (Byref text as String, _
                                       Byval x as Single, Byval y as Single, _
                                       Byval spacing as Single, _
                                       Byval centered as Integer, _
                                       Byval bright.level as Integer, _
                                       Byref PP256font as ImageType, _
                                       Byval SCREEN_WID as Integer, _
                                       Byval SCREEN_HEI as Integer )

Declare Sub AF2.SprBlit_tr.fadecust ( Byval sx1 as Integer, Byval sy1 as Integer, _
                                      Byval fade_lvl as Integer, _
                                      Byval image as ushort ptr, _ 
                                      Byval SCREEN_WID as integer, _
                                      Byval SCREEN_HEI as integer )


Declare Function AF2.SprCollide ( Byval sx1 as Integer, _
                                  Byval sy1 as Integer, _
                                  Byval image1 as Ushort Ptr, _
                                  Byval sx2 as Integer, _
                                  Byval sy2 as Integer, _
                                  Byval image2 as Ushort Ptr ) as Integer


Declare Sub AF2.PP256fntSP_tr.fadecust (Byref text as String, _
                                        Byval x as Single, Byval y as Single, _
                                        Byval spacing as Single, _
                                        Byval centered as Integer, _
                                        Byval fade_lvl as Integer, _
                                        Byref PP256font as ImageType, _
                                        Byval SCREEN_WID as Integer, _
                                        Byval SCREEN_HEI as Integer )

Declare Sub AF2.PP256fnt_brightness (Byref text as String, _
                                     Byval x as Single, Byval y as Single, _
                                     Byval centered as Integer, _
                                     Byval bright.level as Integer, _
                                     Byref PP256font as ImageType, _
                                     Byval SCREEN_WID as Integer, _
                                     Byval SCREEN_HEI as Integer )

Declare Sub AF2.Globe (Byval Xcenter as Single, Byval Ycenter as single, _
                       Byval size as Integer, _
                       Byval basecolor as Integer, _
                       Byval start.brightness as Single, _
                       Byval glow.increment as Single, _
                       Byval radius as Single, _
                       Byval buffer as any PTR = 0 )

Declare Sub AF2.RemoveSpr (Byref Sprite_array as ImageType)

Declare Sub AF2.Scale2x_320x240

Sub AF2.InitSpr_BMP (Byref BMP_array as ImageType, _
                     Byval x_size as Integer, _
                     Byval y_size as Integer, _
                     Byref Filename as String)

BMP_array.init = @Image_init
BMP_array.init( BMP_array )
BMP_array.m_filename = Filename
BMP_array.load_BMP( BMP_array, x_size, y_size )
BMP_array.index ( BMP_array )

End Sub

Sub image_init ( byref image as ImageType )
	image.load = @image_load
      image.load_BMP = @image_load_BMP
	image.index = @image_index
	image.destroy = @image_destroy
end sub

'************************************************************************

Sub image_load ( byref image as ImageType )

	dim filesize as uinteger
	dim filenum as ushort

	filenum = freefile

	open image.m_filename for binary as #filenum
	image.m_size = (lof(filenum) - 7) \ 2
	close #filenum
	image.p_data = callocate(len(ushort) * image.m_size)

	bload image.m_filename, image.p_data

end sub

Sub image_index ( byref image as ImageType )

	dim temparray as uinteger ptr
	dim lastint as uinteger
	dim currentimage as uinteger
	dim arraysize as uinteger
	dim indexnum as uinteger
	dim x as integer, y as integer
	temparray = callocate(len(uinteger) * 1000)
	indexnum  = 0
	currentimage = 0
	lastint = image.m_size
	do
	   x = image.p_data[currentimage] \ 8
	   y = image.p_data[currentimage + 1]
	   temparray[indexnum] = currentimage
	   arraysize = (x * y) + 4
	   if arraysize mod 2 then arraysize = arraysize + 1
	   arraysize = arraysize \ 2
	   currentimage = currentimage + arraysize
	   indexnum = indexnum + 1
	loop until lastint < currentimage

	indexnum = indexnum - 1

	image.p_dataindex = callocate(len(uinteger) * indexnum )

	image.m_maxindex = indexnum - 1
	for x = 0 to indexnum - 1
	   image.p_dataindex[x] = temparray[x]
	next
	deallocate temparray

end sub

'************************************************************************

Sub image_destroy ( byref image as ImageType )

	deallocate image.p_data
	deallocate image.p_dataindex

end sub

Sub image_load_BMP ( byref image as ImageType, byval wid as integer, byval hei as integer )

    Image.m_size = ( (wid * hei) \ 2 ) + 2
    Image.p_data = callocate ( len(ushort) * image.m_size )
    bload image.m_filename, image.p_data
    
end sub

Sub AF2.InitPP256pal ( Byref filename as String )

    'size array to hold all 256 colours.
    dim palette_array(0 to 255) as uinteger
    dim colour as uinteger
    dim i as integer
    dim fileno as ushort

    if filename$ <> "" then
        '*** read palette data from file ***
        fileno = freefile
        open filename$ for binary as #fileno
        for i = 0 to 255
            get #fileno, , colour
            palette_array(i) = colour
        next i
        close #fileno
        for i = 0 to 255
           palette i, palette_array(i)
        next i
    else
        '*** read palette data from data statements ***
        for i = 0 to 255
            read colour
        next i
        for i = 0 to 255
           palette i, palette_array(i)
        next i

    end if

end sub

Sub AF2.ClearScreen (Byval col as Integer, Byval buffer as any PTR = 0 )

Dim as Integer Gfx_horiz, Gfx_vert

If col < 0 then col = 0
If col > 255 then col = 255
ScreenInfo Gfx_horiz, Gfx_vert

If (buffer) then
  Line buffer, (0, 0)-(Gfx_horiz - 1, Gfx_vert - 1), col, BF
else
  Line (0, 0)-(Gfx_horiz - 1, Gfx_vert - 1), col, BF
End if

End Sub

Sub AF2.InitSpr_PP256 (Byref PP256_array as ImageType, _
                       Byref Filename as String)

PP256_array.init = @Image_init
PP256_array.init( PP256_array )
PP256_array.m_filename = Filename
PP256_array.load ( PP256_array )
PP256_array.index ( PP256_array )

End Sub

Sub AF2.SprBlit_scale.rotate ( Byval sx1 as Integer, _
                               Byval sy1 as Integer, _
                               Byval image as ushort ptr,_ 
                               Byval scale.x as single, _
                               Byval scale.y as single, _
                               Byval rotation.angle as double, _
                               Byval buffer as any ptr = 0 )

'----------------------------------------------------------------------
' Special thanks to D.J.Peters for this ABSOLUTELY AWESOME sprite
' scaling/rotation routine!!!   d=^-^=b !!
'
' Default scale ratio parameters for a normal-sized sprite
' (for "scale.x" and "scale.y"): ---- 1, 1 ----
'
'----------------------------------------------------------------------

'#define UseRad 'if not then rotation.angle are in degres 
If (screenptr = 0) or (image = 0) then exit sub 

If scale.x < 0.001 then scale.x = 0.001 
If scale.y < 0.001 then scale.y = 0.001 

Dim as integer MustLock, Mustrotate

If not (buffer) then MustLock = 1 
If rotation.angle <> 0 then Mustrotate = 1 

Dim as byte  ptr TargetPtr,SourcePtr 
Dim as short ptr ptr16 
Dim as short     val16 
Dim as byte      val8 
Dim as integer   TargetWidth,TargetHeight,TargetBytes 

If MustLock then 
  screeninfo TargetWidth,TargetHeight,TargetBytes 
  TargetPtr = screenptr: TargetBytes = TargetBytes shr 3 
else 
  ptr16 = cptr(short ptr, buffer): TargetPtr = cptr(byte ptr, buffer) 
  val16 = ptr16[0]: TargetBytes = val16 and &H0007: TargetWidth = val16 shr 3 
  val16 = ptr16[1]: TargetHeight = val16: TargetPtr += 4 
End if 

If (TargetWidth < 4) or (TargetHeight < 4) then exit sub 

Dim as integer SourceWidth, SourceHeight, SourceBytes 
ptr16 = cptr(ushort ptr, image): SourcePtr = cptr(byte ptr, image) 
val16 = ptr16[0]: SourceBytes = val16 and &H0007: SourceWidth = val16 shr 3 
val16 = ptr16[1]: SourceHeight = val16: SourcePtr += (4 * len(byte)) 
If (SourceWidth < 2) or (SourceHeight < 2) then exit sub 

#define xs 0 'screen 
#define ys 1 
#define xt 2 'texture 
#define yt 3 
#define xx 4 'integer part 
#define yy 5 

Dim as single Points(4, 5) 
points(0, xs) = -SourceWidth / 2 * scale.x 
points(1, xs) =  SourceWidth / 2 * scale.x 
points(2, xs) =  points(1, xs) 
points(3, xs) =  points(0, xs) 

points(0, ys) = -SourceHeight / 2 * scale.y 
points(1, ys) =  points(0, ys) 
points(2, ys) =  SourceHeight / 2 * scale.y 
points(3, ys) =  points(2, ys) 

points(1, xt) = SourceWidth - 1 
points(2, xt) = points(1, xt) 
points(2, yt) = SourceHeight - 1 
points(3, yt) = points(2, yt) - 1 

Dim as uinteger i 
Dim as single x,y 
If Mustrotate then 
  #ifndef UseRad 
  rotation.angle *= 0.017453292 'degre 2 rad 
  #endif 
  while rotation.angle < 0: rotation.angle += 6.2831853: wend 
  while rotation.angle >= 6.2831853: rotation.angle -= 6.2831853: wend 
  For i = 0 to 3 
    x = points(i, xs) * cos(rotation.angle) - points(i, ys) * sin(rotation.angle) 
    y = points(i, xs) * sin(rotation.angle) + points(i, ys) * cos(rotation.angle) 
    points(i, xs) = x: points(i, ys) = y 
  Next 
End if 

Dim as integer yStart, yEnd, xStart, xEnd 
yStart = 100000: yEnd = -yStart: xStart = yStart: xEnd = yEnd 

#define LI 0     'LeftIndex 
#define RI 1     'RightIndex 
#define IND 0    'Index 
#define NIND 1   'NextIndex 

Dim as Integer CNS(2, 2) 'Counters 

For i = 0 to 3 
  points(i, xs) = int(points(i, xs) + sx1) 
  points(i, ys) = int(points(i, ys) + sy1) 
  if points(i, ys) < yStart then yStart= points(i, ys): CNS(LI, IND) = i 
  if points(i, ys) > yEnd then yEnd = points(i, ys) 
  if points(i, xs) < xStart then xStart= points(i, xs) 
  if points(i, xs) > xEnd then xEnd = points(i, xs) 
next 

if yStart = yEnd then exit sub 
if yStart >= TargetHeight then exit sub 
if yEnd < 0 then exit sub 
if xStart = xEnd then exit sub 
if xStart >= TargetWidth then exit sub 
if xEnd <0 then exit sub 

Dim as byte ptr t1,s1 
Dim as short ptr t2,s2 
Dim as integer ptr t4,s4 

#define ADD 0 
#define CMP 1 
#define SET 2 

Dim as integer ACS(2, 3) 'add compare and set 
ACS(LI, ADD) = -1: ACS(LI, CMP) = -1: ACS(LI, SET) = 3 
ACS(RI, ADD) = 1: ACS(RI, CMP) = 4: ACS(RI, SET) = 0 

#define EX  0 
#define EU  1 
#define EV  2 
#define EXS 3 
#define EUS 4 
#define EVS 5 

Dim as single E(2, 6), S(6), Length, uSlope, vSlope 
Dim as integer U, UV, UA, UN, V, VV, VA, VN 

' share the same highest point 
CNS(RI, IND) = CNS(LI, IND) 

If MustLock then ScreenLock 
  ' loop from Top to Bottom 
  While yStart < yEnd 
    'Scan Left and Right sides together 
    For i = LI to RI 
      ' bad to read but fast and short ;-) 
      If yStart = points(CNS(i, IND), ys) then 
        CNS(i, NIND) = CNS(i, IND) + ACS(i, Add) 
        If CNS(i, NIND)= ACS(i, CMP) then CNS(i, NIND) = ACS(i, SET) 
        While points(CNS(i, IND), ys) = points(CNS(i, NIND), ys) 
          CNS(i, IND) = CNS(i, NIND) 
          CNS(i, NIND) = CNS(i, IND) + ACS(i, Add) 
          If CNS(i, NIND) = ACS(i, CMP) then CNS(i, NIND) = ACS(i, SET) 
        Wend 
        E(i, EX) = points(CNS(i, IND), xs) 
        E(i, EU) = points(CNS(i, IND), xt) 
        E(i, EV) = points(CNS(i, IND), yt) 
        Length = points(CNS(i, NIND), ys) 
        Length -= points(CNS(i, IND), ys) 
        If Length <> 0.0 then 
          E(i, EXS) = points(CNS(i, NIND), xs) - E(i, EX): E(i, EXS) /= Length 
          E(i, EUS) = points(CNS(i, NIND), xt) - E(i, EU): E(i, EUS) /= Length 
          E(i, EVS) = points(CNS(i, NIND), yt) - E(i, EV): E(i, EVS) /= Length 
        End if 
        CNS(i, IND) = CNS(i, NIND) 
      end if 
    next 

    If yStart< 0 then goto SkipScanLine.scalerotate
    xStart = E(LI, EX) + 0.5: If xStart >= TargetWidth then goto SkipScanLine.scalerotate
    xEnd = E(RI, EX) - 0.5: If xEnd < 0 then goto SkipScanLine.scalerotate
    If xStart = xEnd then goto SkipScanLine.scalerotate

    Length = xEnd - xStart 
    uSlope = E(RI, EU) - E(LI, EU): uSlope /= Length 
    vSlope = E(RI, EV) - E(LI, EV): vSlope /= Length 

    If xstart<0 then 
      Length=abs(xStart) 
      U = int(E(LI, EU) + uSlope * Length) 
      V = int(E(LI, EV) + vSlope * Length) 
      xStart = 0 
    else 
      U = int(E(LI, EU)): V = int(E(LI, EV)) 
    End if 

    If xEnd >= TargetWidth then xEnd = TargetWidth 
    UV = int(uSlope): UA = (uSlope - UV) * 10000: UN = 0 
    VV = int(vSlope): VA = (vSlope - VV) * 10000: VN = 0 
    xEnd -= xStart 

    t1 = TargetPtr: t1 += yStart * TargetWidth: t1 += xStart: xStart = 0 

    val8 = 0 and &HFF 
    While xStart < xEnd 
      s1 = SourcePtr: s1 += V * SourceWidth: s1 += U 
      if s1[0]<>val8 then t1[xStart]=s1[0] 
      U+=UV:UN+=UA:if UN>=10000 then U+=1:UN-=10000 
      V+=VV:VN+=VA:if VN>=10000 then V+=1:VN-=10000 
      if u<0 then u=0 
      if v<0 then v=0 
      xStart+=1 
    Wend 

SkipScanLine.scalerotate: 
    E(LI, EX) += E(LI, EXS): E(LI, EU) += E(LI, EUS): E(LI, EV) += E(LI, EVS) 
    E(RI, EX) += E(RI, EXS): E(RI, EU) += E(RI, EUS): E(RI, EV) += E(RI, EVS) 
    yStart += 1: if yStart = TargetHeight then yStart = yEnd    'exit loop 
  Wend 
If MustLock then ScreenUnlock 

End Sub 

Sub AF2.SprBlit ( Byval sx1 as Integer, Byval sy1 as Integer, _
                  Byval image as ushort ptr,_ 
                  Byval SCREEN_WID as integer, _
                  Byval SCREEN_HEI as integer )

	dim vpage as byte ptr
	dim x1 as integer, y1 as integer
	dim x2 as integer, y2 as integer
	dim wid1 as integer
	dim hei1 as integer
	dim wid2 as integer
	dim hei2 as integer
	dim wid2_clip as integer
	dim offset_add as integer
	dim retval as ushort

	x1 = sx1
	y1 = sy1
	x2 = 0
	y2 = 0

	'esi          =image1
	'edi          =vpage

	'ebx=width
	'edx=height

	vpage = SCREENPTR
	SCREENLOCK

  asm
	 		   	  		 	  'calculate the coordinates
	mov eax, [x1]    		  'x1
	mov ebx, [x2]  			  'x2
	sub eax, ebx    		  'x1-x2
	mov [x1], eax

	mov ecx, [y1]  			  'y1
	mov edx, [y2]  			  'y2
	sub ecx, edx       		  'x1-x2
	mov [y1], ecx

	mov esi, [image]  		  'we are now on the width of the spr1 w=(array(0)/8)-1
	mov edi, [vpage]   	      'vpage
	xor ebx, ebx			  'zero out ebx
	mov bx,  [esi]  		  'width*8 of  spr1

	shr ebx,3        		  'div width by 8
	xor edx, edx			  'zero out edx
	mov dx,  [esi+2]   		  'save height spr1
	mov [wid1], ebx			  'save wid1
	add esi,4        		  'si now points to 1st color of spr1 array
	mov [hei1], edx			  'save height

	xor ecx, ecx
	mov cx, [SCREEN_WID]		  'spr2 width*8
	xor eax, eax
	mov ax, [SCREEN_HEI]		  'spr2 height
	dec ecx          		  'correct it
	dec eax
	mov [wid2], ecx			  'wid 2
	mov [hei2], eax			  'hei 2

	'note!!!!  after the clips
	'eax=x     clipped
	'ecx=y     clipped
	'ebx=width   new
	'edx=height  new

	        mov eax, [x1]            'x1 value
	        cmp eax, [wid2]          'get out if x1 > spr2w
			jg L_normal_lbl_end_it            'else

	        cmp eax, 0               'x<0 then
	        jl L_normal_lbl_clip_left         'clip our x value

	L_normal_lbl_post_clip_left:

	        mov ecx, [y1]          	 'y1 value
	        cmp ecx, [hei2]          'get out if y1 > spr2h
			jg L_normal_lbl_end_it            'else

	        cmp ecx, 0               'y<0 then
	        jl L_normal_lbl_clip_top          'clip our y value

	L_normal_lbl_post_clip_top:

	'ok here's the score: eax=x,ecx=y,edx=height,ebx=width
	'all clipped top and left
	'now lets clip it to the right

	        add ebx, eax               'add x to width and see if its over  *bx is destroyed
	        cmp ebx, [wid2]            'if x+width > destw 'too right then crop it
	        jg  L_normal_lbl_clip_right         'else continue
	        sub ebx, eax               'restore bx since it was destroyed

	L_normal_lbl_post_clip_right:

	'now lets clip it down

	        add edx, ecx               'add y to height and see if its over  *dx is destroyed
	        cmp edx,[hei2]             'if y+height > desth 'too low then crop it
	        jg  L_normal_lbl_clip_down          'else continue
	        sub edx, ecx               'restore dx since it was destroyed

	L_normal_lbl_post_clip_down:


	'whew!!!!!!!!! that was disorienting!!!!!!!!
	'but all variables are either clipped or cropped now   '-)
	'eax=x,ecx=y,ebx=width,edx=height
	'edi=y*destwidth+1+x


	mov [hei1], ebx   'damn full of agi's here :(    save bx/clippped width
	mov ebx, [wid2]
	inc ebx
	imul ecx, ebx
	sub ebx, [hei1]
	mov [wid2_clip], ebx   'save destw+1-width to stack


	'let us now calculate  the offset normally

	add edi, ecx       'save y value to dx
	add edi, eax       'dest offset(x,y)=y*destw+1+x


	mov ebx, [hei1]   'restore bx

	L_normal_lbl_main_spr_loop:

	mov ecx, ebx               	 		'put clipped width to counter

	L_normal_lbl_sprite_loop:                	'x loop

	        mov al, [esi]          		'mov color

	        or al, al                	'if c<>0 then

	        jz L_normal_lbl_skip_0           	'else
               and al,0             'get color grad offset from sprite
               mov ah,[edi]         'get color from layer
               and ah,0             'color grad offset
               add ah,al            'add them together
               shr ah, 1            
               sub al,[esi]         'get negative base color
               neg al               'bas color
               add al,ah            'add grad color to base color
               mov [edi], al			'put pixel
	        L_normal_lbl_skip_0:

			inc esi                  	'next offset
	        inc edi

	        dec ecx

	jnz   L_normal_lbl_sprite_loop

	add edi, [wid2_clip]                'add to di our destw+1-clp_width
	add esi, [offset_add]               'corrector point to next row

	dec edx

	jnz  L_normal_lbl_main_spr_loop

	jmp L_normal_lbl_end_it

	L_normal_lbl_clip_left:
	        neg eax          			'negate ax ax=-ax=+ax
	        sub ebx, eax       			'subract clipped width to real width
	        jle L_normal_lbl_end_it  			'if ax<=0 then endit since its tooleft to see a col of pix ')
	        add esi, eax       			'add our ax to si(point to clipped x offset
	                        			'bx is our new clipped width
	        mov [offset_add], eax   	'save it to stack for skipping check purposes

	        xor eax, eax       			'zero is our x coord
	jmp L_normal_lbl_post_clip_left



	L_normal_lbl_clip_top:
	        neg ecx          			'negate cx cx=-cx=+cx
	        sub edx, ecx       			'subract clipped height to real height
	                        			'dx is our new clipped height
	        jle L_normal_lbl_end_it  			'if cx<=0 then endit since its tooleft to see a row of pix ')

	     L_normal_lbl_height_loop:
	        add esi, [wid1]   			'add our real width to si(point to clipped y offset)
	        dec ecx
	     jnz L_normal_lbl_height_loop        	'loop it until we get to right y offset
	                                	'cx=0 zero is our y coord
	jmp L_normal_lbl_post_clip_top


	L_normal_lbl_clip_right:
	       sub ebx, [wid2]   			'subtract x+width with destw  trust me no negs here :)
	       dec ebx           			'bx now is clipped right
	       add [offset_add], ebx    	'add it to the checker as our spr data is in column major order
	       mov ebx,[wid2]    			'correct bx to  clipx2+1
	       inc ebx
	       sub ebx, eax        			'subtract ax to bx to correct width (0 to destw)
	jmp L_normal_lbl_post_clip_right

	L_normal_lbl_clip_down:
	       add ecx, edx        			'add the height to y
	       sub ecx, [hei2]   			'correct it
	       dec ecx
	       sub edx, ecx        			'crop our height
	       mov ecx, [y1]   				'restore y
	jmp L_normal_lbl_post_clip_down

	L_normal_lbl_end_it:


  end asm


  SCREENUNLOCK

end sub


'__________________________________________________________________________
Sub AF2.SprBlit_color ( Byval sx1 as integer, Byval sy1 as integer, _
                        Byval scol as integer, Byval image as ushort ptr, _
                        Byval SCREEN_WID as integer, _
                        Byval SCREEN_HEI as integer )

	dim vpage as byte ptr
	dim x1 as integer, y1 as integer
	dim x2 as integer, y2 as integer
	dim wid1 as integer
	dim hei1 as integer
	dim wid2 as integer
	dim hei2 as integer
	dim wid2_clip as integer
	dim offset_add as integer
	dim colour as ubyte

      If scol < 0 then scol = 0
      If scol > 255 then scol = 255

	x1 = sx1
	y1 = sy1
	x2 = 0	   	  			 'change this to clip x1 and clipx 2
	y2 = 0
	colour = scol

	'esi          =image
	'edi          =vpage

	'ebx=width
	'edx=height

	vpage = SCREENPTR
	SCREENLOCK

  asm
	 		   	  		 	  'calculate the coordinates
	mov eax, [x1]    		  'x1
	mov ebx, [x2]  			  'x2
	sub eax, ebx    		  'x1-x2
	mov [x1], eax

	mov ecx, [y1]  			  'y1
	mov edx, [y2]  			  'y2
	sub ecx, edx       		  'x1-x2
	mov [y1], ecx

	mov esi, [image]  		  'we are now on the width of the spr1 w=(array(0)/8)-1
	mov edi, [vpage]   	      'vpage
	xor ebx, ebx			  'zero out ebx
	mov bx,  [esi]  		  'width*8 of  spr1

	shr ebx,3        		  'div width by 8
	xor edx, edx			  'zero out edx
	mov dx,  [esi+2]   		  'save height spr1
	mov [wid1], ebx			  'save wid1
	add esi,4        		  'si now points to 1st color of spr1 array
	mov [hei1], edx			  'save height

	xor ecx, ecx
	mov cx, [SCREEN_WID]		  'spr2 width*8
	xor eax, eax
	mov ax, [SCREEN_HEI]		  'spr2 height
	dec ecx          		  'correct it
	dec eax
	mov [wid2], ecx			  'wid 2
	mov [hei2], eax			  'hei 2

	'note!!!!  after the clips
	'eax=x     clipped
	'ecx=y     clipped
	'ebx=width   new
	'edx=height  new

	        mov eax, [x1]            'x1 value
	        cmp eax, [wid2]          'get out if x1 > spr2w
			jg L_color_lbl_end_it            'else

	        cmp eax, 0               'x<0 then
	        jl L_color_lbl_clip_left         'clip our x value

	L_color_lbl_post_clip_left:

	        mov ecx, [y1]          	 'y1 value
	        cmp ecx, [hei2]          'get out if y1 > spr2h
			jg L_color_lbl_end_it            'else

	        cmp ecx, 0               'y<0 then
	        jl L_color_lbl_clip_top          'clip our y value

	L_color_lbl_post_clip_top:

	'ok here's the score: eax=x,ecx=y,edx=height,ebx=width
	'all clipped top and left
	'now lets clip it to the right

	        add ebx, eax               'add x to width and see if its over  *bx is destroyed
	        cmp ebx, [wid2]            'if x+width > destw 'too right then crop it
	        jg  L_color_lbl_clip_right         'else continue
	        sub ebx, eax               'restore bx since it was destroyed

	L_color_lbl_post_clip_right:

	'now lets clip it down

	        add edx, ecx               'add y to height and see if its over  *dx is destroyed
	        cmp edx,[hei2]             'if y+height > desth 'too low then crop it
	        jg  L_color_lbl_clip_down          'else continue
	        sub edx, ecx               'restore dx since it was destroyed

	L_color_lbl_post_clip_down:


	'whew!!!!!!!!! that was disorienting!!!!!!!!
	'but all variables are either clipped or cropped now   '-)
	'eax=x,ecx=y,ebx=width,edx=height
	'edi=y*destwidth+1+x


	mov [hei1], ebx   'damn full of agi's here :(    save bx/clippped width
	mov ebx, [wid2]
	inc ebx
	imul ecx, ebx
	sub ebx, [hei1]
	mov [wid2_clip], ebx   'save destw+1-width to stack


	'let us now calculate  the offset normally

	add edi, ecx       'save y value to dx
	add edi, eax       'dest offset(x,y)=y*destw+1+x


	mov ebx, [hei1]   'restore bx

	L_color_lbl_main_spr_loop:

	mov ecx, ebx               	 		'put clipped width to counter

	mov ah, [colour]
	L_color_lbl_sprite_loop:                	'x loop

	        mov al, [esi]          		'mov color
	        inc esi                  	'next offset

	        or al, al                	'if c<>0 then

	        jz L_color_lbl_skip_0           	'else
	           mov [edi], ah			'put pixel
	        L_color_lbl_skip_0:

	        inc edi

	        dec ecx

	jnz   L_color_lbl_sprite_loop

	add edi, [wid2_clip]                'add to di our destw+1-clp_width
	add esi, [offset_add]               'corrector point to next row

	dec edx

	jnz  L_color_lbl_main_spr_loop


	jmp L_color_lbl_end_it


	L_color_lbl_clip_left:
	        neg eax          			'negate ax ax=-ax=+ax
	        sub ebx, eax       			'subract clipped width to real width
	        jle L_color_lbl_end_it  			'if ax<=0 then endit since its tooleft to see a col of pix ')
	        add esi, eax       			'add our ax to si(point to clipped x offset
	                        			'bx is our new clipped width
	        mov [offset_add], eax   	'save it to stack for skipping check purposes

	        xor eax, eax       			'zero is our x coord
	jmp L_color_lbl_post_clip_left



	L_color_lbl_clip_top:
	        neg ecx          			'negate cx cx=-cx=+cx
	        sub edx, ecx       			'subract clipped height to real height
	                        			'dx is our new clipped height
	        jle L_color_lbl_end_it  			'if cx<=0 then endit since its tooleft to see a row of pix ')

	     L_color_lbl_height_loop:
	        add esi, [wid1]   			'add our real width to si(point to clipped y offset)
	        dec ecx
	     jnz L_color_lbl_height_loop        	'loop it until we get to right y offset
	                                	'cx=0 zero is our y coord
	jmp L_color_lbl_post_clip_top


	L_color_lbl_clip_right:
	       sub ebx, [wid2]   			'subtract x+width with destw  trust me no negs here :)
	       dec ebx           			'bx now is clipped right
	       add [offset_add], ebx    	'add it to the checker as our spr data is in column major order
	       mov ebx,[wid2]    			'correct bx to  clipx2+1
	       inc ebx
	       sub ebx, eax        			'subtract ax to bx to correct width (0 to destw)
	jmp L_color_lbl_post_clip_right

	L_color_lbl_clip_down:
	       add ecx, edx        			'add the height to y
	       sub ecx, [hei2]   			'correct it
	       dec ecx
	       sub edx, ecx        			'crop our height
	       mov ecx, [y1]   				'restore y
	jmp L_color_lbl_post_clip_down

	L_color_lbl_end_it:


  end asm


  SCREENUNLOCK

end sub


'__________________________________________________________________________
Sub AF2.SprBlit_trans ( Byval sx1 as Integer, Byval sy1 as Integer, _
                        Byval image as ushort ptr,_ 
                        Byval SCREEN_WID as integer, _
                        Byval SCREEN_HEI as integer )

	dim vpage as byte ptr
	dim x1 as integer, y1 as integer
	dim x2 as integer, y2 as integer
	dim wid1 as integer
	dim hei1 as integer
	dim wid2 as integer
	dim hei2 as integer
	dim wid2_clip as integer
	dim offset_add as integer
	dim retval as ushort

	x1 = sx1
	y1 = sy1
	x2 = 0
	y2 = 0

	'esi          =image1
	'edi          =vpage

	'ebx=width
	'edx=height

	vpage = SCREENPTR
	SCREENLOCK

  asm
	 		   	  		 	  'calculate the coordinates
	mov eax, [x1]    		  'x1
	mov ebx, [x2]  			  'x2
	sub eax, ebx    		  'x1-x2
	mov [x1], eax

	mov ecx, [y1]  			  'y1
	mov edx, [y2]  			  'y2
	sub ecx, edx       		  'x1-x2
	mov [y1], ecx

	mov esi, [image]  		  'we are now on the width of the spr1 w=(array(0)/8)-1
	mov edi, [vpage]   	      'vpage
	xor ebx, ebx			  'zero out ebx
	mov bx,  [esi]  		  'width*8 of  spr1

	shr ebx,3        		  'div width by 8
	xor edx, edx			  'zero out edx
	mov dx,  [esi+2]   		  'save height spr1
	mov [wid1], ebx			  'save wid1
	add esi,4        		  'si now points to 1st color of spr1 array
	mov [hei1], edx			  'save height

	xor ecx, ecx
	mov cx, [SCREEN_WID]		  'spr2 width*8
	xor eax, eax
	mov ax, [SCREEN_HEI]		  'spr2 height
	dec ecx          		  'correct it
	dec eax
	mov [wid2], ecx			  'wid 2
	mov [hei2], eax			  'hei 2

	'note!!!!  after the clips
	'eax=x     clipped
	'ecx=y     clipped
	'ebx=width   new
	'edx=height  new

	        mov eax, [x1]            'x1 value
	        cmp eax, [wid2]          'get out if x1 > spr2w
			jg L_trans_lbl_end_it            'else

	        cmp eax, 0               'x<0 then
	        jl L_trans_lbl_clip_left         'clip our x value

	L_trans_lbl_post_clip_left:

	        mov ecx, [y1]          	 'y1 value
	        cmp ecx, [hei2]          'get out if y1 > spr2h
			jg L_trans_lbl_end_it            'else

	        cmp ecx, 0               'y<0 then
	        jl L_trans_lbl_clip_top          'clip our y value

	L_trans_lbl_post_clip_top:

	'ok here's the score: eax=x,ecx=y,edx=height,ebx=width
	'all clipped top and left
	'now lets clip it to the right

	        add ebx, eax               'add x to width and see if its over  *bx is destroyed
	        cmp ebx, [wid2]            'if x+width > destw 'too right then crop it
	        jg  L_trans_lbl_clip_right         'else continue
	        sub ebx, eax               'restore bx since it was destroyed

	L_trans_lbl_post_clip_right:

	'now lets clip it down

	        add edx, ecx               'add y to height and see if its over  *dx is destroyed
	        cmp edx,[hei2]             'if y+height > desth 'too low then crop it
	        jg  L_trans_lbl_clip_down          'else continue
	        sub edx, ecx               'restore dx since it was destroyed

	L_trans_lbl_post_clip_down:


	'whew!!!!!!!!! that was disorienting!!!!!!!!
	'but all variables are either clipped or cropped now   '-)
	'eax=x,ecx=y,ebx=width,edx=height
	'edi=y*destwidth+1+x


	mov [hei1], ebx   'damn full of agi's here :(    save bx/clippped width
	mov ebx, [wid2]
	inc ebx
	imul ecx, ebx
	sub ebx, [hei1]
	mov [wid2_clip], ebx   'save destw+1-width to stack


	'let us now calculate  the offset normally

	add edi, ecx       'save y value to dx
	add edi, eax       'dest offset(x,y)=y*destw+1+x


	mov ebx, [hei1]   'restore bx

	L_trans_lbl_main_spr_loop:

	mov ecx, ebx               	 		'put clipped width to counter

	L_trans_lbl_sprite_loop:                	'x loop

	        mov al, [esi]          		'mov color

	        or al, al                	'if c<>0 then

	        jz L_trans_lbl_skip_0           	'else
               and al,15            'get color grad offset from sprite
               mov ah,[edi]       'get color from layer
               and ah,15            'color grad offset
               add ah,al            'add them together
               shr ah,1             'average
               sub al,[esi]    'get negative base color
               neg al               'bas color
               add al,ah            'add grad color to base color
               mov [edi], al			'put pixel
	        L_trans_lbl_skip_0:

			inc esi                  	'next offset
	        inc edi

	        dec ecx

	jnz   L_trans_lbl_sprite_loop

	add edi, [wid2_clip]                'add to di our destw+1-clp_width
	add esi, [offset_add]               'corrector point to next row

	dec edx

	jnz  L_trans_lbl_main_spr_loop

	jmp L_trans_lbl_end_it

	L_trans_lbl_clip_left:
	        neg eax          			'negate ax ax=-ax=+ax
	        sub ebx, eax       			'subract clipped width to real width
	        jle L_trans_lbl_end_it  			'if ax<=0 then endit since its tooleft to see a col of pix ')
	        add esi, eax       			'add our ax to si(point to clipped x offset
	                        			'bx is our new clipped width
	        mov [offset_add], eax   	'save it to stack for skipping check purposes

	        xor eax, eax       			'zero is our x coord
	jmp L_trans_lbl_post_clip_left



	L_trans_lbl_clip_top:
	        neg ecx          			'negate cx cx=-cx=+cx
	        sub edx, ecx       			'subract clipped height to real height
	                        			'dx is our new clipped height
	        jle L_trans_lbl_end_it  			'if cx<=0 then endit since its tooleft to see a row of pix ')

	     L_trans_lbl_height_loop:
	        add esi, [wid1]   			'add our real width to si(point to clipped y offset)
	        dec ecx
	     jnz L_trans_lbl_height_loop        	'loop it until we get to right y offset
	                                	'cx=0 zero is our y coord
	jmp L_trans_lbl_post_clip_top


	L_trans_lbl_clip_right:
	       sub ebx, [wid2]   			'subtract x+width with destw  trust me no negs here :)
	       dec ebx           			'bx now is clipped right
	       add [offset_add], ebx    	'add it to the checker as our spr data is in column major order
	       mov ebx,[wid2]    			'correct bx to  clipx2+1
	       inc ebx
	       sub ebx, eax        			'subtract ax to bx to correct width (0 to destw)
	jmp L_trans_lbl_post_clip_right

	L_trans_lbl_clip_down:
	       add ecx, edx        			'add the height to y
	       sub ecx, [hei2]   			'correct it
	       dec ecx
	       sub edx, ecx        			'crop our height
	       mov ecx, [y1]   				'restore y
	jmp L_trans_lbl_post_clip_down

	L_trans_lbl_end_it:


  end asm


  SCREENUNLOCK

end sub

Function AF2.SprCollide ( Byval sx1 as Integer, _
                          Byval sy1 as Integer, _
                          Byval image1 As Ushort Ptr, _
                          Byval sx2 as Integer, _
                          Byval sy2 as Integer, _
                          Byval image2 As Ushort Ptr ) as Integer

'This pixel-perfect sprite collision method checks to see if a sprite
'collides with another sprite, very simply.  ^-^ !


	Dim x1 As Integer, y1 As Integer
	Dim x2 As Integer, y2 As Integer
	Dim wid1 As Integer
	Dim hei1 As Integer
	Dim wid2 As Integer
	Dim hei2 As Integer
	Dim wid2_clip As Integer
	Dim offset_add As Integer
	Dim retval As Ushort

	x1 = sx1
	y1 = sy1
	x2 = sx2
	y2 = sy2

	'esi          =image1
	'edi          =image2

	'ebx=width
	'edx=height

  Asm
	 		   	  		 	  'calculate the coordinates
	mov eax, [x1]    		  'x1
	mov ebx, [x2]  			  'x2
	Sub eax, ebx    		  'x1-x2
	mov [x1], eax

	mov ecx, [y1]  			  'y1
	mov edx, [y2]  			  'y2
	Sub ecx, edx       		  'x1-x2
	mov [y1], ecx

	mov esi, [image1]  		  'we are now on the width of the spr1 w=(array(0)/8)-1
	mov edi, [image2]   	  'spr2 off
	xor ebx, ebx			  'zero out ebx
	mov bx,  [esi]  		  'width*8 of  spr1

	Shr ebx,3        		  'div width by 8
	xor edx, edx			  'zero out edx
	mov dx,  [esi+2]   		  'save height spr1
	mov [wid1], ebx			  'save wid1
	add esi,4        		  'si now points to 1st color of spr1 array
	mov [hei1], edx			  'save height

	xor ecx, ecx
	mov cx, [edi]  			  'spr2 width*8
	xor eax, eax
	mov ax, [edi+2]			  'spr2 height
	Shr ecx, 3        		  'div 8
	dec ecx          		  'correct it
	dec eax
	mov [wid2], ecx			  'wid 2
	mov [hei2], eax			  'hei 2
	add edi, 4

	'note!!!!  after the clips
	'eax=x     clipped
	'ecx=y     clipped
	'ebx=width   new
	'edx=height  new

	        mov eax, [x1]            'x1 value
	        cmp eax, [wid2]          'get out if x1 > spr2w
			jg lbl_sprcollide_end_it            'else

	        cmp eax, 0               'x<0 then
	        jl lbl_sprcollide_clip_left         'clip our x value

	lbl_sprcollide_post_clip_left:

	        mov ecx, [y1]          	 'y1 value
	        cmp ecx, [hei2]          'get out if y1 > spr2h
			jg lbl_sprcollide_end_it            'else

	        cmp ecx, 0               'y<0 then
	        jl lbl_sprcollide_clip_top          'clip our y value

	lbl_sprcollide_post_clip_top:

	'ok here's the score: eax=x,ecx=y,edx=height,ebx=width
	'all clipped top and left
	'now lets clip it to the right

	        add ebx, eax               'add x to width and see if its over  *bx is destroyed
	        cmp ebx, [wid2]            'if x+width > destw 'too right then crop it
	        jg  lbl_sprcollide_clip_right         'else continue
	        Sub ebx, eax               'restore bx since it was destroyed

	lbl_sprcollide_post_clip_right:

	'now lets clip it down

	        add edx, ecx               'add y to height and see if its over  *dx is destroyed
	        cmp edx,[hei2]             'if y+height > desth 'too low then crop it
	        jg  lbl_sprcollide_clip_down          'else continue
	        Sub edx, ecx               'restore dx since it was destroyed

	lbl_sprcollide_post_clip_down:


	'whew!!!!!!!!! that was disorienting!!!!!!!!
	'but all variables are either clipped or cropped now   '-)
	'eax=x,ecx=y,ebx=width,edx=height
	'edi=y*destwidth+1+x


	mov [hei1], ebx   'damn full of agi's here :(    save bx/clippped width
	mov ebx, [wid2]
	inc ebx
	imul ecx, ebx
	Sub ebx, [hei1]
	mov [wid2_clip], ebx   'save destw+1-width to stack


	'let us now calculate  the offset normally

	add edi, ecx       'save y value to dx
	add edi, eax       'dest offset(x,y)=y*destw+1+x


	mov ebx, [hei1]   'restore bx

	lbl_sprcollide_main_spr_loop:

	mov ecx, ebx               	 		'put clipped width to counter

	lbl_sprcollide_sprite_loop:                	'x loop

	        mov al, [esi]          		'mov color
	        inc esi                  	'next offset

	        or al, al                	'if c<>0 then

	        jz lbl_sprcollide_skip_0           	'else
	           mov ah, [edi]       		'store spr2 color to ah
	           cmp ah, 0             	'check if its zero
	           jne lbl_sprcollide_collide_true 	'collide if not zero
	        lbl_sprcollide_skip_0:

	        inc edi

	        dec ecx

	jnz   lbl_sprcollide_sprite_loop

	add edi, [wid2_clip]                'add to di our destw+1-clp_width
	add esi, [offset_add]               'corrector point to next row

	dec edx

	jnz  lbl_sprcollide_main_spr_loop


	lbl_sprcollide_end_it:
	Sub eax, eax
	jmp lbl_sprcollide_get_out

	lbl_sprcollide_collide_true:
	xchg ah,al
	Sub ah,ah
	jmp lbl_sprcollide_get_out


	lbl_sprcollide_clip_left:
	        neg eax          			'negate ax ax=-ax=+ax
	        Sub ebx, eax       			'subract clipped width to real width
	        jle lbl_sprcollide_end_it  			'if ax<=0 then endit since its tooleft to see a col of pix ')
	        add esi, eax       			'add our ax to si(point to clipped x offset
	                        			'bx is our new clipped width
	        mov [offset_add], eax   	'save it to stack for skipping check purposes

	        xor eax, eax       			'zero is our x coord
	jmp lbl_sprcollide_post_clip_left



	lbl_sprcollide_clip_top:
	        neg ecx          			'negate cx cx=-cx=+cx
	        Sub edx, ecx       			'subract clipped height to real height
	                        			'dx is our new clipped height
	        jle lbl_sprcollide_end_it  			'if cx<=0 then endit since its tooleft to see a row of pix ')

	     lbl_sprcollide_height_loop:
	        add esi, [wid1]   			'add our real width to si(point to clipped y offset)
	        dec ecx
	     jnz lbl_sprcollide_height_loop        	'loop it until we get to right y offset
	                                	'cx=0 zero is our y coord
	jmp lbl_sprcollide_post_clip_top


	lbl_sprcollide_clip_right:
	       Sub ebx, [wid2]   			'subtract x+width with destw  trust me no negs here :)
	       dec ebx           			'bx now is clipped right
	       add [offset_add], ebx    	'add it to the checker as our spr data is in column major order
	       mov ebx,[wid2]    			'correct bx to  clipx2+1
	       inc ebx
	       Sub ebx, eax        			'subtract ax to bx to correct width (0 to destw)
	jmp lbl_sprcollide_post_clip_right

	lbl_sprcollide_clip_down:
	       add ecx, edx        			'add the height to y
	       Sub ecx, [hei2]   			'correct it
	       dec ecx
	       Sub edx, ecx        			'crop our height
	       mov ecx, [y1]   				'restore y
	jmp lbl_sprcollide_post_clip_down

	lbl_sprcollide_get_out:
	  	  mov [retval], ax

  End Asm

  AF2.SprCollide = retval

End Function

Sub AF2.Scale2x_320x240

'=====================================================================
'Note: You *must* be in a 640x480x256 graphics mode in order for this
'      command to work!
'=====================================================================

Dim as Integer Gfx_horiz, Gfx_vert, Gfx_depth
ScreenInfo Gfx_horiz, Gfx_vert, Gfx_depth

If Gfx_horiz <> 640 or Gfx_vert <> 480 then Exit Sub
If not Gfx_depth = 8 then Exit Sub

Dim AFlib2_screenbuffer as ubyte ptr
Dim AFlib2_screenbuffer_ptr as ubyte ptr

Dim Target_the_Page(320 * 240 + 4) as ubyte

Get (0, 0)-(319, 239), Target_the_Page
AFlib2_screenbuffer = @Target_the_Page(0)
AFlib2_screenbuffer_ptr = AFlib2_screenbuffer + 4

Dim as Integer x, y

Dim offs as ubyte ptr
offs = AFlib2_screenbuffer
offs = AFlib2_screenbuffer + 4
Dim voff as ubyte ptr
voff = screenptr

screenlock
'edi = vpage
'esi = image

asm
  mov esi, [offs]
  mov edi, [voff]
  mov dword ptr[y], 240
  L_lbl_y_loop_320x240:

    mov dword ptr[x], 320
    L_lbl_x_loop_320x240:

      'al = b
      'ah = d
      'bl = e
      'bh = f
      'cl = h
      mov al, [esi - 320]         'B= *(offset - wid)

      mov ah, [esi - 1]           'D= *(offset - 1)

      mov bl, [esi]               'E= *(offset)

      mov bh, [esi + 1]           'F= *(offset + 1)

      mov cl, [esi + 320]         'H= *(offset + wid)

	jumper_320x240:
        'if B <> H and D <> F then
        cmp al, cl
        je  L_equal_320x240
        cmp al, bh
        je  L_equal_320x240
        'ch = e0
        'dl = e1
        'dh = e2
        'al = e3
        cmp ah, al  'if D = B then E0 = D else E0 = E
        jne L_E0E_320x240
        mov ch, ah
        jmp L_E1F_320x240
        L_E0E_320x240:
        mov ch, bl
                    'if B = F then E1 = F else E1 = E
        L_E1F_320x240:
        cmp al, bh
        jne L_E1E_320x240
        mov dl, bh
        jmp L_E2D_320x240
        L_E1E_320x240:
        mov dl, bl
                    'if D = H then E2 = D else E2 = E
        L_E2D_320x240:
        cmp ah, cl
        jne L_E2E_320x240
           mov dh, ah
        jmp L_E3F_320x240
        L_E2E_320x240:
        mov dh, bl
                    'if H = F then E3 = F else E3 = E
        L_E3F_320x240:
        cmp cl, bh
        jne L_E3E_320x240
           mov al,bh
        jmp L_draw_320x240
        L_E3E_320x240:
           mov al, bl
        jmp L_draw_320x240
        'else
        L_equal_320x240:
        'E0 = E
        'E1 = E
        'E2 = E
        'E3 = E
        mov ch, bl
        mov dl, bl
        mov dh, bl
        mov al, bl

        'end if
        L_draw_320x240:

        '*voff = e0
        '*(voff+1) = e1
        '*(voff+640) = e2
        '*(voff+641) = e3
        mov [edi], ch
        mov [edi + 1], dl
        mov [edi + 640], dh
        mov [edi + 641], al
        inc esi                         'offset += 1
        add edi, 2                      'voff += 2
      dec dword ptr[x]
      jnz L_lbl_x_loop_320x240

    add edi,640
    dec dword ptr[y]
    jnz L_lbl_y_loop_320x240

  end asm

screenunlock

End Sub

Sub AF2.SprBlit_rotate.solid ( Byval sx1 as Integer, _
                               Byval sy1 as Integer, _
                               Byval image as ushort ptr,_ 
                               Byval rotation.angle as double, _
                               Byval buffer as any ptr = 0 )

'----------------------------------------------------------------------
' Special thanks to D.J.Peters for this ABSOLUTELY AWESOME sprite
' rotation routine!!!   d=^-^=b !!
'----------------------------------------------------------------------

'#define UseRad 'if not then rotation.angle are in degres 
If (screenptr = 0) or (image = 0) then exit sub 

Dim as integer MustLock, Mustrotate

If not (buffer) then MustLock = 1 
If rotation.angle <> 0 then Mustrotate = 1 

Dim as byte  ptr TargetPtr,SourcePtr 
Dim as short ptr ptr16 
Dim as short     val16 
Dim as byte      val8 
Dim as integer   TargetWidth,TargetHeight,TargetBytes 

If MustLock then 
  screeninfo TargetWidth,TargetHeight,TargetBytes 
  TargetPtr = screenptr: TargetBytes = TargetBytes shr 3 
else 
  ptr16 = cptr(short ptr, buffer): TargetPtr = cptr(byte ptr, buffer) 
  val16 = ptr16[0]: TargetBytes = val16 and &H0007: TargetWidth = val16 shr 3 
  val16 = ptr16[1]: TargetHeight = val16: TargetPtr += 4 
End if 

If (TargetWidth < 4) or (TargetHeight < 4) then exit sub 

Dim as integer SourceWidth, SourceHeight, SourceBytes 
ptr16 = cptr(ushort ptr, image): SourcePtr = cptr(byte ptr, image) 
val16 = ptr16[0]: SourceBytes = val16 and &H0007: SourceWidth = val16 shr 3 
val16 = ptr16[1]: SourceHeight = val16: SourcePtr += (4 * len(byte)) 
If (SourceWidth < 2) or (SourceHeight < 2) then exit sub 

#define xs 0 'screen 
#define ys 1 
#define xt 2 'texture 
#define yt 3 
#define xx 4 'integer part 
#define yy 5 

Dim as single Points(4, 5) 
points(0, xs) = -SourceWidth / 2
points(1, xs) =  SourceWidth / 2
points(2, xs) =  points(1, xs) 
points(3, xs) =  points(0, xs) 

points(0, ys) = -SourceHeight / 2
points(1, ys) =  points(0, ys) 
points(2, ys) =  SourceHeight / 2
points(3, ys) =  points(2, ys) 

points(1, xt) = SourceWidth - 1 
points(2, xt) = points(1, xt) 
points(2, yt) = SourceHeight - 1 
points(3, yt) = points(2, yt) - 1 

Dim as uinteger i 
Dim as single x,y 
If Mustrotate then 
  #ifndef UseRad 
  rotation.angle *= 0.017453292 'degre 2 rad 
  #endif 
  while rotation.angle < 0: rotation.angle += 6.2831853: wend 
  while rotation.angle >= 6.2831853: rotation.angle -= 6.2831853: wend 
  For i = 0 to 3 
    x = points(i, xs) * cos(rotation.angle) - points(i, ys) * sin(rotation.angle) 
    y = points(i, xs) * sin(rotation.angle) + points(i, ys) * cos(rotation.angle) 
    points(i, xs) = x: points(i, ys) = y 
  Next 
End if 

Dim as integer yStart, yEnd, xStart, xEnd 
yStart = 100000: yEnd = -yStart: xStart = yStart: xEnd = yEnd 

#define LI 0     'LeftIndex 
#define RI 1     'RightIndex 
#define IND 0    'Index 
#define NIND 1   'NextIndex 

Dim as Integer CNS(2, 2) 'Counters 

For i = 0 to 3 
  points(i, xs) = int(points(i, xs) + sx1) 
  points(i, ys) = int(points(i, ys) + sy1) 
  if points(i, ys) < yStart then yStart= points(i, ys): CNS(LI, IND) = i 
  if points(i, ys) > yEnd then yEnd = points(i, ys) 
  if points(i, xs) < xStart then xStart= points(i, xs) 
  if points(i, xs) > xEnd then xEnd = points(i, xs) 
next 

if yStart = yEnd then exit sub 
if yStart >= TargetHeight then exit sub 
if yEnd < 0 then exit sub 
if xStart = xEnd then exit sub 
if xStart >= TargetWidth then exit sub 
if xEnd <0 then exit sub 

Dim as byte ptr t1,s1 
Dim as short ptr t2,s2 
Dim as integer ptr t4,s4 

#define ADD 0 
#define CMP 1 
#define SET 2 

Dim as integer ACS(2, 3) 'add compare and set 
ACS(LI, ADD) = -1: ACS(LI, CMP) = -1: ACS(LI, SET) = 3 
ACS(RI, ADD) = 1: ACS(RI, CMP) = 4: ACS(RI, SET) = 0 

#define EX  0 
#define EU  1 
#define EV  2 
#define EXS 3 
#define EUS 4 
#define EVS 5 

Dim as single E(2, 6), S(6), Length, uSlope, vSlope 
Dim as integer U, UV, UA, UN, V, VV, VA, VN 

' share the same highest point 
CNS(RI, IND) = CNS(LI, IND) 

If MustLock then ScreenLock 
  ' loop from Top to Bottom 
  While yStart < yEnd 
    'Scan Left and Right sides together 
    For i = LI to RI 
      ' bad to read but fast and short ;-) 
      If yStart = points(CNS(i, IND), ys) then 
        CNS(i, NIND) = CNS(i, IND) + ACS(i, Add) 
        If CNS(i, NIND)= ACS(i, CMP) then CNS(i, NIND) = ACS(i, SET) 
        While points(CNS(i, IND), ys) = points(CNS(i, NIND), ys) 
          CNS(i, IND) = CNS(i, NIND) 
          CNS(i, NIND) = CNS(i, IND) + ACS(i, Add) 
          If CNS(i, NIND) = ACS(i, CMP) then CNS(i, NIND) = ACS(i, SET) 
        Wend 
        E(i, EX) = points(CNS(i, IND), xs) 
        E(i, EU) = points(CNS(i, IND), xt) 
        E(i, EV) = points(CNS(i, IND), yt) 
        Length = points(CNS(i, NIND), ys) 
        Length -= points(CNS(i, IND), ys) 
        If Length <> 0.0 then 
          E(i, EXS) = points(CNS(i, NIND), xs) - E(i, EX): E(i, EXS) /= Length 
          E(i, EUS) = points(CNS(i, NIND), xt) - E(i, EU): E(i, EUS) /= Length 
          E(i, EVS) = points(CNS(i, NIND), yt) - E(i, EV): E(i, EVS) /= Length 
        End if 
        CNS(i, IND) = CNS(i, NIND) 
      end if 
    next 

    If yStart< 0 then goto SkipScanLine.rotatesolid
    xStart = E(LI, EX) + 0.5: If xStart >= TargetWidth then goto SkipScanLine.rotatesolid
    xEnd = E(RI, EX) - 0.5: If xEnd < 0 then goto SkipScanLine.rotatesolid
    If xStart = xEnd then goto SkipScanLine.rotatesolid

    Length = xEnd - xStart 
    uSlope = E(RI, EU) - E(LI, EU): uSlope /= Length 
    vSlope = E(RI, EV) - E(LI, EV): vSlope /= Length 

    If xstart<0 then 
      Length=abs(xStart) 
      U = int(E(LI, EU) + uSlope * Length) 
      V = int(E(LI, EV) + vSlope * Length) 
      xStart = 0 
    else 
      U = int(E(LI, EU)): V = int(E(LI, EV)) 
    End if 

    If xEnd >= TargetWidth then xEnd = TargetWidth 
    UV = int(uSlope): UA = (uSlope - UV) * 10000: UN = 0 
    VV = int(vSlope): VA = (vSlope - VV) * 10000: VN = 0 
    xEnd -= xStart 

    t1 = TargetPtr: t1 += yStart * TargetWidth: t1 += xStart: xStart = 0 

    While xStart < xEnd 
      s1 = SourcePtr: s1 += V * SourceWidth: s1 += U 
      t1[xStart] = s1[0] 
      U += UV: UN += UA: If UN >= 10000 then U += 1: UN -= 10000 
      V += VV: VN += VA: If VN >= 10000 then V += 1: VN -= 10000 
      If u < 0 then u = 0 
      If v < 0 then v = 0 
      xStart += 1 
    Wend 

SkipScanLine.rotatesolid: 
    E(LI, EX) += E(LI, EXS): E(LI, EU) += E(LI, EUS): E(LI, EV) += E(LI, EVS) 
    E(RI, EX) += E(RI, EXS): E(RI, EU) += E(RI, EUS): E(RI, EV) += E(RI, EVS) 
    yStart += 1: if yStart = TargetHeight then yStart = yEnd    'exit loop 
  Wend 
If MustLock then ScreenUnlock 

End Sub 

Sub AF2.SprBlit_rotate ( Byval sx1 as Integer, _
                         Byval sy1 as Integer, _
                         Byval image as ushort ptr,_ 
                         Byval rotation.angle as double, _
                         Byval buffer as any ptr = 0 )

'----------------------------------------------------------------------
' Special thanks to D.J.Peters for this ABSOLUTELY AWESOME sprite
' rotation routine!!!   d=^-^=b !!
'
'----------------------------------------------------------------------

'#define UseRad 'if not then rotation.angle are in degres 
If (screenptr = 0) or (image = 0) then exit sub 

Dim as integer MustLock, Mustrotate

If not (buffer) then MustLock = 1 
If rotation.angle <> 0 then Mustrotate = 1 

Dim as byte  ptr TargetPtr,SourcePtr 
Dim as short ptr ptr16 
Dim as short     val16 
Dim as byte      val8 
Dim as integer   TargetWidth,TargetHeight,TargetBytes 

If MustLock then 
  screeninfo TargetWidth,TargetHeight,TargetBytes 
  TargetPtr = screenptr: TargetBytes = TargetBytes shr 3 
else 
  ptr16 = cptr(short ptr, buffer): TargetPtr = cptr(byte ptr, buffer) 
  val16 = ptr16[0]: TargetBytes = val16 and &H0007: TargetWidth = val16 shr 3 
  val16 = ptr16[1]: TargetHeight = val16: TargetPtr += 4 
End if 

If (TargetWidth < 4) or (TargetHeight < 4) then exit sub 

Dim as integer SourceWidth, SourceHeight, SourceBytes 
ptr16 = cptr(ushort ptr, image): SourcePtr = cptr(byte ptr, image) 
val16 = ptr16[0]: SourceBytes = val16 and &H0007: SourceWidth = val16 shr 3 
val16 = ptr16[1]: SourceHeight = val16: SourcePtr += (4 * len(byte)) 
If (SourceWidth < 2) or (SourceHeight < 2) then exit sub 

#define xs 0 'screen 
#define ys 1 
#define xt 2 'texture 
#define yt 3 
#define xx 4 'integer part 
#define yy 5 

Dim as single Points(4, 5) 
points(0, xs) = -SourceWidth / 2
points(1, xs) =  SourceWidth / 2
points(2, xs) =  points(1, xs) 
points(3, xs) =  points(0, xs) 

points(0, ys) = -SourceHeight / 2
points(1, ys) =  points(0, ys) 
points(2, ys) =  SourceHeight / 2
points(3, ys) =  points(2, ys) 

points(1, xt) = SourceWidth - 1 
points(2, xt) = points(1, xt) 
points(2, yt) = SourceHeight - 1 
points(3, yt) = points(2, yt) - 1 

Dim as uinteger i 
Dim as single x,y 
If Mustrotate then 
  #ifndef UseRad 
  rotation.angle *= 0.017453292 'degre 2 rad 
  #endif 
  while rotation.angle < 0: rotation.angle += 6.2831853: wend 
  while rotation.angle >= 6.2831853: rotation.angle -= 6.2831853: wend 
  For i = 0 to 3 
    x = points(i, xs) * cos(rotation.angle) - points(i, ys) * sin(rotation.angle) 
    y = points(i, xs) * sin(rotation.angle) + points(i, ys) * cos(rotation.angle) 
    points(i, xs) = x: points(i, ys) = y 
  Next 
End if 

Dim as integer yStart, yEnd, xStart, xEnd 
yStart = 100000: yEnd = -yStart: xStart = yStart: xEnd = yEnd 

#define LI 0     'LeftIndex 
#define RI 1     'RightIndex 
#define IND 0    'Index 
#define NIND 1   'NextIndex 

Dim as Integer CNS(2, 2) 'Counters 

For i = 0 to 3 
  points(i, xs) = int(points(i, xs) + sx1) 
  points(i, ys) = int(points(i, ys) + sy1) 
  if points(i, ys) < yStart then yStart= points(i, ys): CNS(LI, IND) = i 
  if points(i, ys) > yEnd then yEnd = points(i, ys) 
  if points(i, xs) < xStart then xStart= points(i, xs) 
  if points(i, xs) > xEnd then xEnd = points(i, xs) 
next 

if yStart = yEnd then exit sub 
if yStart >= TargetHeight then exit sub 
if yEnd < 0 then exit sub 
if xStart = xEnd then exit sub 
if xStart >= TargetWidth then exit sub 
if xEnd <0 then exit sub 

Dim as byte ptr t1,s1 
Dim as short ptr t2,s2 
Dim as integer ptr t4,s4 

#define ADD 0 
#define CMP 1 
#define SET 2 

Dim as integer ACS(2, 3) 'add compare and set 
ACS(LI, ADD) = -1: ACS(LI, CMP) = -1: ACS(LI, SET) = 3 
ACS(RI, ADD) = 1: ACS(RI, CMP) = 4: ACS(RI, SET) = 0 

#define EX  0 
#define EU  1 
#define EV  2 
#define EXS 3 
#define EUS 4 
#define EVS 5 

Dim as single E(2, 6), S(6), Length, uSlope, vSlope 
Dim as integer U, UV, UA, UN, V, VV, VA, VN 

' share the same highest point 
CNS(RI, IND) = CNS(LI, IND) 

If MustLock then ScreenLock 
  ' loop from Top to Bottom 
  While yStart < yEnd 
    'Scan Left and Right sides together 
    For i = LI to RI 
      ' bad to read but fast and short ;-) 
      If yStart = points(CNS(i, IND), ys) then 
        CNS(i, NIND) = CNS(i, IND) + ACS(i, Add) 
        If CNS(i, NIND)= ACS(i, CMP) then CNS(i, NIND) = ACS(i, SET) 
        While points(CNS(i, IND), ys) = points(CNS(i, NIND), ys) 
          CNS(i, IND) = CNS(i, NIND) 
          CNS(i, NIND) = CNS(i, IND) + ACS(i, Add) 
          If CNS(i, NIND) = ACS(i, CMP) then CNS(i, NIND) = ACS(i, SET) 
        Wend 
        E(i, EX) = points(CNS(i, IND), xs) 
        E(i, EU) = points(CNS(i, IND), xt) 
        E(i, EV) = points(CNS(i, IND), yt) 
        Length = points(CNS(i, NIND), ys) 
        Length -= points(CNS(i, IND), ys) 
        If Length <> 0.0 then 
          E(i, EXS) = points(CNS(i, NIND), xs) - E(i, EX): E(i, EXS) /= Length 
          E(i, EUS) = points(CNS(i, NIND), xt) - E(i, EU): E(i, EUS) /= Length 
          E(i, EVS) = points(CNS(i, NIND), yt) - E(i, EV): E(i, EVS) /= Length 
        End if 
        CNS(i, IND) = CNS(i, NIND) 
      end if 
    next 

    If yStart< 0 then goto SkipScanLine.rotate
    xStart = E(LI, EX) + 0.5: If xStart >= TargetWidth then goto SkipScanLine.rotate
    xEnd = E(RI, EX) - 0.5: If xEnd < 0 then goto SkipScanLine.rotate
    If xStart = xEnd then goto SkipScanLine.rotate

    Length = xEnd - xStart 
    uSlope = E(RI, EU) - E(LI, EU): uSlope /= Length 
    vSlope = E(RI, EV) - E(LI, EV): vSlope /= Length 

    If xstart<0 then 
      Length=abs(xStart) 
      U = int(E(LI, EU) + uSlope * Length) 
      V = int(E(LI, EV) + vSlope * Length) 
      xStart = 0 
    else 
      U = int(E(LI, EU)): V = int(E(LI, EV)) 
    End if 

    If xEnd >= TargetWidth then xEnd = TargetWidth 
    UV = int(uSlope): UA = (uSlope - UV) * 10000: UN = 0 
    VV = int(vSlope): VA = (vSlope - VV) * 10000: VN = 0 
    xEnd -= xStart 

    t1 = TargetPtr: t1 += yStart * TargetWidth: t1 += xStart: xStart = 0 

    val8 = 0 and &HFF 
    While xStart < xEnd 
      s1 = SourcePtr: s1 += V * SourceWidth: s1 += U 
      if s1[0]<>val8 then t1[xStart]=s1[0] 
      U+=UV:UN+=UA:if UN>=10000 then U+=1:UN-=10000 
      V+=VV:VN+=VA:if VN>=10000 then V+=1:VN-=10000 
      if u<0 then u=0 
      if v<0 then v=0 
      xStart+=1 
    Wend 

SkipScanLine.rotate: 
    E(LI, EX) += E(LI, EXS): E(LI, EU) += E(LI, EUS): E(LI, EV) += E(LI, EVS) 
    E(RI, EX) += E(RI, EXS): E(RI, EU) += E(RI, EUS): E(RI, EV) += E(RI, EVS) 
    yStart += 1: if yStart = TargetHeight then yStart = yEnd    'exit loop 
  Wend 
If MustLock then ScreenUnlock 

End Sub 

Sub AF2.SprBlit_scale.solid ( Byval sx1 as Integer, _
                              Byval sy1 as Integer, _
                              Byval image as ushort ptr,_ 
                              Byval scale.x as single, _
                              Byval scale.y as single, _
                              Byval buffer as any ptr = 0 )

'----------------------------------------------------------------------
' Special thanks to D.J.Peters for this ABSOLUTELY AWESOME sprite
' scaling routine!!!   d=^-^=b !!
'
' Default scale ratio parameters for a normal-sized sprite
' (for "scale.x" and "scale.y"): ---- 1, 1 ----
'
'----------------------------------------------------------------------

'#define UseRad 'if not then rotation.angle are in degres 
If (screenptr = 0) or (image = 0) then exit sub 

If scale.x < 0.001 then scale.x = 0.001 
If scale.y < 0.001 then scale.y = 0.001 

Dim as integer MustLock, Mustrotate

If not (buffer) then MustLock = 1 

Dim as byte  ptr TargetPtr,SourcePtr 
Dim as short ptr ptr16 
Dim as short     val16 
Dim as byte      val8 
Dim as integer   TargetWidth,TargetHeight,TargetBytes 

If MustLock then 
  screeninfo TargetWidth,TargetHeight,TargetBytes 
  TargetPtr = screenptr: TargetBytes = TargetBytes shr 3 
else 
  ptr16 = cptr(short ptr, buffer): TargetPtr = cptr(byte ptr, buffer) 
  val16 = ptr16[0]: TargetBytes = val16 and &H0007: TargetWidth = val16 shr 3 
  val16 = ptr16[1]: TargetHeight = val16: TargetPtr += 4 
End if 

If (TargetWidth < 4) or (TargetHeight < 4) then exit sub 

Dim as integer SourceWidth, SourceHeight, SourceBytes 
ptr16 = cptr(ushort ptr, image): SourcePtr = cptr(byte ptr, image) 
val16 = ptr16[0]: SourceBytes = val16 and &H0007: SourceWidth = val16 shr 3 
val16 = ptr16[1]: SourceHeight = val16: SourcePtr += (4 * len(byte)) 
If (SourceWidth < 2) or (SourceHeight < 2) then exit sub 

#define xs 0 'screen 
#define ys 1 
#define xt 2 'texture 
#define yt 3 
#define xx 4 'integer part 
#define yy 5 

Dim as single Points(4, 5) 
points(0, xs) = -SourceWidth / 2 * scale.x 
points(1, xs) =  SourceWidth / 2 * scale.x 
points(2, xs) =  points(1, xs) 
points(3, xs) =  points(0, xs) 

points(0, ys) = -SourceHeight / 2 * scale.y 
points(1, ys) =  points(0, ys) 
points(2, ys) =  SourceHeight / 2 * scale.y 
points(3, ys) =  points(2, ys) 

points(1, xt) = SourceWidth - 1 
points(2, xt) = points(1, xt) 
points(2, yt) = SourceHeight - 1 
points(3, yt) = points(2, yt) - 1 

Dim as uinteger i 
Dim as single x,y 

Dim as integer yStart, yEnd, xStart, xEnd 
yStart = 100000: yEnd = -yStart: xStart = yStart: xEnd = yEnd 

#define LI 0     'LeftIndex 
#define RI 1     'RightIndex 
#define IND 0    'Index 
#define NIND 1   'NextIndex 

Dim as Integer CNS(2, 2) 'Counters 

For i = 0 to 3 
  points(i, xs) = int(points(i, xs) + sx1) 
  points(i, ys) = int(points(i, ys) + sy1) 
  if points(i, ys) < yStart then yStart= points(i, ys): CNS(LI, IND) = i 
  if points(i, ys) > yEnd then yEnd = points(i, ys) 
  if points(i, xs) < xStart then xStart= points(i, xs) 
  if points(i, xs) > xEnd then xEnd = points(i, xs) 
next 

if yStart = yEnd then exit sub 
if yStart >= TargetHeight then exit sub 
if yEnd < 0 then exit sub 
if xStart = xEnd then exit sub 
if xStart >= TargetWidth then exit sub 
if xEnd <0 then exit sub 

Dim as byte ptr t1,s1 
Dim as short ptr t2,s2 
Dim as integer ptr t4,s4 

#define ADD 0 
#define CMP 1 
#define SET 2 

Dim as integer ACS(2, 3) 'add compare and set 
ACS(LI, ADD) = -1: ACS(LI, CMP) = -1: ACS(LI, SET) = 3 
ACS(RI, ADD) = 1: ACS(RI, CMP) = 4: ACS(RI, SET) = 0 

#define EX  0 
#define EU  1 
#define EV  2 
#define EXS 3 
#define EUS 4 
#define EVS 5 

Dim as single E(2, 6), S(6), Length, uSlope, vSlope 
Dim as integer U, UV, UA, UN, V, VV, VA, VN 

' share the same highest point 
CNS(RI, IND) = CNS(LI, IND) 

If MustLock then ScreenLock 
  ' loop from Top to Bottom 
  While yStart < yEnd 
    'Scan Left and Right sides together 
    For i = LI to RI 
      ' bad to read but fast and short ;-) 
      If yStart = points(CNS(i, IND), ys) then 
        CNS(i, NIND) = CNS(i, IND) + ACS(i, Add) 
        If CNS(i, NIND)= ACS(i, CMP) then CNS(i, NIND) = ACS(i, SET) 
        While points(CNS(i, IND), ys) = points(CNS(i, NIND), ys) 
          CNS(i, IND) = CNS(i, NIND) 
          CNS(i, NIND) = CNS(i, IND) + ACS(i, Add) 
          If CNS(i, NIND) = ACS(i, CMP) then CNS(i, NIND) = ACS(i, SET) 
        Wend 
        E(i, EX) = points(CNS(i, IND), xs) 
        E(i, EU) = points(CNS(i, IND), xt) 
        E(i, EV) = points(CNS(i, IND), yt) 
        Length = points(CNS(i, NIND), ys) 
        Length -= points(CNS(i, IND), ys) 
        If Length <> 0.0 then 
          E(i, EXS) = points(CNS(i, NIND), xs) - E(i, EX): E(i, EXS) /= Length 
          E(i, EUS) = points(CNS(i, NIND), xt) - E(i, EU): E(i, EUS) /= Length 
          E(i, EVS) = points(CNS(i, NIND), yt) - E(i, EV): E(i, EVS) /= Length 
        End if 
        CNS(i, IND) = CNS(i, NIND) 
      end if 
    next 

    If yStart< 0 then goto SkipScanLine.scalesolid
    xStart = E(LI, EX) + 0.5: If xStart >= TargetWidth then goto SkipScanLine.scalesolid
    xEnd = E(RI, EX) - 0.5: If xEnd < 0 then goto SkipScanLine.scalesolid
    If xStart = xEnd then goto SkipScanLine.scalesolid

    Length = xEnd - xStart 
    uSlope = E(RI, EU) - E(LI, EU): uSlope /= Length 
    vSlope = E(RI, EV) - E(LI, EV): vSlope /= Length 

    If xstart<0 then 
      Length=abs(xStart) 
      U = int(E(LI, EU) + uSlope * Length) 
      V = int(E(LI, EV) + vSlope * Length) 
      xStart = 0 
    else 
      U = int(E(LI, EU)): V = int(E(LI, EV)) 
    End if 

    If xEnd >= TargetWidth then xEnd = TargetWidth 
    UV = int(uSlope): UA = (uSlope - UV) * 10000: UN = 0 
    VV = int(vSlope): VA = (vSlope - VV) * 10000: VN = 0 
    xEnd -= xStart 

    t1 = TargetPtr: t1 += yStart * TargetWidth: t1 += xStart: xStart = 0 

    While xStart < xEnd 
      s1 = SourcePtr: s1 += V * SourceWidth: s1 += U 
      t1[xStart] = s1[0] 
      U += UV: UN += UA: If UN >= 10000 then U += 1: UN -= 10000 
      V += VV: VN += VA: If VN >= 10000 then V += 1: VN -= 10000 
      If u < 0 then u = 0 
      If v < 0 then v = 0 
      xStart += 1 
    Wend 

SkipScanLine.scalesolid: 
    E(LI, EX) += E(LI, EXS): E(LI, EU) += E(LI, EUS): E(LI, EV) += E(LI, EVS) 
    E(RI, EX) += E(RI, EXS): E(RI, EU) += E(RI, EUS): E(RI, EV) += E(RI, EVS) 
    yStart += 1: if yStart = TargetHeight then yStart = yEnd    'exit loop 
  Wend 
If MustLock then ScreenUnlock 

End Sub 

Sub AF2.SprBlit_scale.rotate.solid ( Byval sx1 as Integer, _
                                     Byval sy1 as Integer, _
                                     Byval image as ushort ptr,_ 
                                     Byval scale.x as single, _
                                     Byval scale.y as single, _
                                     Byval rotation.angle as double, _
                                     Byval buffer as any ptr = 0 )

'----------------------------------------------------------------------
' Special thanks to D.J.Peters for this ABSOLUTELY AWESOME sprite
' scaling/rotation routine!!!   d=^-^=b !!
'
' Default scale ratio parameters for a normal-sized sprite
' (for "scale.x" and "scale.y"): ---- 1, 1 ----
'
'----------------------------------------------------------------------

'#define UseRad 'if not then rotation.angle are in degres 
If (screenptr = 0) or (image = 0) then exit sub 

If scale.x < 0.001 then scale.x = 0.001 
If scale.y < 0.001 then scale.y = 0.001 

Dim as integer MustLock, Mustrotate

If not (buffer) then MustLock = 1 
If rotation.angle <> 0 then Mustrotate = 1 

Dim as byte  ptr TargetPtr,SourcePtr 
Dim as short ptr ptr16 
Dim as short     val16 
Dim as byte      val8 
Dim as integer   TargetWidth,TargetHeight,TargetBytes 

If MustLock then 
  screeninfo TargetWidth,TargetHeight,TargetBytes 
  TargetPtr = screenptr: TargetBytes = TargetBytes shr 3 
else 
  ptr16 = cptr(short ptr, buffer): TargetPtr = cptr(byte ptr, buffer) 
  val16 = ptr16[0]: TargetBytes = val16 and &H0007: TargetWidth = val16 shr 3 
  val16 = ptr16[1]: TargetHeight = val16: TargetPtr += 4 
End if 

If (TargetWidth < 4) or (TargetHeight < 4) then exit sub 

Dim as integer SourceWidth, SourceHeight, SourceBytes 
ptr16 = cptr(ushort ptr, image): SourcePtr = cptr(byte ptr, image) 
val16 = ptr16[0]: SourceBytes = val16 and &H0007: SourceWidth = val16 shr 3 
val16 = ptr16[1]: SourceHeight = val16: SourcePtr += (4 * len(byte)) 
If (SourceWidth < 2) or (SourceHeight < 2) then exit sub 

#define xs 0 'screen 
#define ys 1 
#define xt 2 'texture 
#define yt 3 
#define xx 4 'integer part 
#define yy 5 

Dim as single Points(4, 5) 
points(0, xs) = -SourceWidth / 2 * scale.x 
points(1, xs) =  SourceWidth / 2 * scale.x 
points(2, xs) =  points(1, xs) 
points(3, xs) =  points(0, xs) 

points(0, ys) = -SourceHeight / 2 * scale.y 
points(1, ys) =  points(0, ys) 
points(2, ys) =  SourceHeight / 2 * scale.y 
points(3, ys) =  points(2, ys) 

points(1, xt) = SourceWidth - 1 
points(2, xt) = points(1, xt) 
points(2, yt) = SourceHeight - 1 
points(3, yt) = points(2, yt) - 1 

Dim as uinteger i 
Dim as single x,y 
If Mustrotate then 
  #ifndef UseRad 
  rotation.angle *= 0.017453292 'degre 2 rad 
  #endif 
  while rotation.angle < 0: rotation.angle += 6.2831853: wend 
  while rotation.angle >= 6.2831853: rotation.angle -= 6.2831853: wend 
  For i = 0 to 3 
    x = points(i, xs) * cos(rotation.angle) - points(i, ys) * sin(rotation.angle) 
    y = points(i, xs) * sin(rotation.angle) + points(i, ys) * cos(rotation.angle) 
    points(i, xs) = x: points(i, ys) = y 
  Next 
End if 

Dim as integer yStart, yEnd, xStart, xEnd 
yStart = 100000: yEnd = -yStart: xStart = yStart: xEnd = yEnd 

#define LI 0     'LeftIndex 
#define RI 1     'RightIndex 
#define IND 0    'Index 
#define NIND 1   'NextIndex 

Dim as Integer CNS(2, 2) 'Counters 

For i = 0 to 3 
  points(i, xs) = int(points(i, xs) + sx1) 
  points(i, ys) = int(points(i, ys) + sy1) 
  if points(i, ys) < yStart then yStart= points(i, ys): CNS(LI, IND) = i 
  if points(i, ys) > yEnd then yEnd = points(i, ys) 
  if points(i, xs) < xStart then xStart= points(i, xs) 
  if points(i, xs) > xEnd then xEnd = points(i, xs) 
next 

if yStart = yEnd then exit sub 
if yStart >= TargetHeight then exit sub 
if yEnd < 0 then exit sub 
if xStart = xEnd then exit sub 
if xStart >= TargetWidth then exit sub 
if xEnd <0 then exit sub 

Dim as byte ptr t1,s1 
Dim as short ptr t2,s2 
Dim as integer ptr t4,s4 

#define ADD 0 
#define CMP 1 
#define SET 2 

Dim as integer ACS(2, 3) 'add compare and set 
ACS(LI, ADD) = -1: ACS(LI, CMP) = -1: ACS(LI, SET) = 3 
ACS(RI, ADD) = 1: ACS(RI, CMP) = 4: ACS(RI, SET) = 0 

#define EX  0 
#define EU  1 
#define EV  2 
#define EXS 3 
#define EUS 4 
#define EVS 5 

Dim as single E(2, 6), S(6), Length, uSlope, vSlope 
Dim as integer U, UV, UA, UN, V, VV, VA, VN 

' share the same highest point 
CNS(RI, IND) = CNS(LI, IND) 

If MustLock then ScreenLock 
  ' loop from Top to Bottom 
  While yStart < yEnd 
    'Scan Left and Right sides together 
    For i = LI to RI 
      ' bad to read but fast and short ;-) 
      If yStart = points(CNS(i, IND), ys) then 
        CNS(i, NIND) = CNS(i, IND) + ACS(i, Add) 
        If CNS(i, NIND)= ACS(i, CMP) then CNS(i, NIND) = ACS(i, SET) 
        While points(CNS(i, IND), ys) = points(CNS(i, NIND), ys) 
          CNS(i, IND) = CNS(i, NIND) 
          CNS(i, NIND) = CNS(i, IND) + ACS(i, Add) 
          If CNS(i, NIND) = ACS(i, CMP) then CNS(i, NIND) = ACS(i, SET) 
        Wend 
        E(i, EX) = points(CNS(i, IND), xs) 
        E(i, EU) = points(CNS(i, IND), xt) 
        E(i, EV) = points(CNS(i, IND), yt) 
        Length = points(CNS(i, NIND), ys) 
        Length -= points(CNS(i, IND), ys) 
        If Length <> 0.0 then 
          E(i, EXS) = points(CNS(i, NIND), xs) - E(i, EX): E(i, EXS) /= Length 
          E(i, EUS) = points(CNS(i, NIND), xt) - E(i, EU): E(i, EUS) /= Length 
          E(i, EVS) = points(CNS(i, NIND), yt) - E(i, EV): E(i, EVS) /= Length 
        End if 
        CNS(i, IND) = CNS(i, NIND) 
      end if 
    next 

    If yStart< 0 then goto SkipScanLine.scalerotatesolid
    xStart = E(LI, EX) + 0.5: If xStart >= TargetWidth then goto SkipScanLine.scalerotatesolid
    xEnd = E(RI, EX) - 0.5: If xEnd < 0 then goto SkipScanLine.scalerotatesolid
    If xStart = xEnd then goto SkipScanLine.scalerotatesolid

    Length = xEnd - xStart 
    uSlope = E(RI, EU) - E(LI, EU): uSlope /= Length 
    vSlope = E(RI, EV) - E(LI, EV): vSlope /= Length 

    If xstart<0 then 
      Length=abs(xStart) 
      U = int(E(LI, EU) + uSlope * Length) 
      V = int(E(LI, EV) + vSlope * Length) 
      xStart = 0 
    else 
      U = int(E(LI, EU)): V = int(E(LI, EV)) 
    End if 

    If xEnd >= TargetWidth then xEnd = TargetWidth 
    UV = int(uSlope): UA = (uSlope - UV) * 10000: UN = 0 
    VV = int(vSlope): VA = (vSlope - VV) * 10000: VN = 0 
    xEnd -= xStart 

    t1 = TargetPtr: t1 += yStart * TargetWidth: t1 += xStart: xStart = 0 

    While xStart < xEnd 
      s1 = SourcePtr: s1 += V * SourceWidth: s1 += U 
      t1[xStart] = s1[0] 
      U += UV: UN += UA: If UN >= 10000 then U += 1: UN -= 10000 
      V += VV: VN += VA: If VN >= 10000 then V += 1: VN -= 10000 
      If u < 0 then u = 0 
      If v < 0 then v = 0 
      xStart += 1 
    Wend 

SkipScanLine.scalerotatesolid: 
    E(LI, EX) += E(LI, EXS): E(LI, EU) += E(LI, EUS): E(LI, EV) += E(LI, EVS) 
    E(RI, EX) += E(RI, EXS): E(RI, EU) += E(RI, EUS): E(RI, EV) += E(RI, EVS) 
    yStart += 1: if yStart = TargetHeight then yStart = yEnd    'exit loop 
  Wend 
If MustLock then ScreenUnlock 

End Sub 

Sub AF2.PP256fntSP_tr.fadecust (Byref text as String, _
                                Byval x as Single, Byval y as Single, _
                                Byval spacing as Single, _
                                Byval centered as Integer, _
                                Byval fade_lvl as Integer, _
                                Byref PP256font as ImageType, _
                                Byval SCREEN_WID as Integer, _
                                Byval SCREEN_HEI as Integer )

Dim as Integer FontChar, i, GFX_width
Dim as Single Centered_length, width_result
Dim as byte ptr CharacterWidth

If centered > 0 or centered = -1 then
  x = 0
  ScreenInfo GFX_width
  For i = 1 TO LEN(text)
    FontChar = ASC(MID$(text, i, 1)) - 32
    CharacterWidth = cptr(byte ptr, @PP256font.p_data[PP256font.p_dataindex[FontChar]])
    width_result = CharacterWidth[0] \ 8
    Centered_length += (width_result + spacing)
  Next
  x = (GFX_width - Centered_length) \ 2
End if

ScreenLock
For i = 1 TO LEN(text)
  FontChar = ASC(MID$(text, i, 1)) - 32
  AF2.SprBlit_tr.fadecust x, y, fade_lvl, @PP256font.p_data[PP256font.p_dataindex[FontChar]], SCREEN_WID, SCREEN_HEI
  CharacterWidth = cptr(byte ptr, @PP256font.p_data[PP256font.p_dataindex[FontChar]])
  width_result = CharacterWidth[0] \ 8
  x += (width_result + spacing)
Next
ScreenUnlock

End Sub

Sub AF2.SprBlit_tr.dark ( Byval sx1 as Integer, Byval sy1 as Integer, _
                          Byval image as ushort ptr, _ 
                          Byval SCREEN_WID as integer, _
                          Byval SCREEN_HEI as integer )

	dim vpage as byte ptr
	dim x1 as integer, y1 as integer
	dim x2 as integer, y2 as integer
	dim wid1 as integer
	dim hei1 as integer
	dim wid2 as integer
	dim hei2 as integer
	dim wid2_clip as integer
	dim offset_add as integer
	dim retval as ushort

	x1 = sx1
	y1 = sy1
	x2 = 0
	y2 = 0

	'esi          =image1
	'edi          =vpage

	'ebx=width
	'edx=height

	vpage = SCREENPTR
	SCREENLOCK

  asm
	 		   	  		 	  'calculate the coordinates
	mov eax, [x1]    		  'x1
	mov ebx, [x2]  			  'x2
	sub eax, ebx    		  'x1-x2
	mov [x1], eax

	mov ecx, [y1]  			  'y1
	mov edx, [y2]  			  'y2
	sub ecx, edx       		  'x1-x2
	mov [y1], ecx

	mov esi, [image]  		  'we are now on the width of the spr1 w=(array(0)/8)-1
	mov edi, [vpage]   	      'vpage
	xor ebx, ebx			  'zero out ebx
	mov bx,  [esi]  		  'width*8 of  spr1

	shr ebx,3        		  'div width by 8
	xor edx, edx			  'zero out edx
	mov dx,  [esi+2]   		  'save height spr1
	mov [wid1], ebx			  'save wid1
	add esi,4        		  'si now points to 1st color of spr1 array
	mov [hei1], edx			  'save height

	xor ecx, ecx
	mov cx, [SCREEN_WID]		  'spr2 width*8
	xor eax, eax
	mov ax, [SCREEN_HEI]		  'spr2 height
	dec ecx          		  'correct it
	dec eax
	mov [wid2], ecx			  'wid 2
	mov [hei2], eax			  'hei 2

	'note!!!!  after the clips
	'eax=x     clipped
	'ecx=y     clipped
	'ebx=width   new
	'edx=height  new

	        mov eax, [x1]            'x1 value
	        cmp eax, [wid2]          'get out if x1 > spr2w
			jg L_trdark_lbl_end_it            'else

	        cmp eax, 0               'x<0 then
	        jl L_trdark_lbl_clip_left         'clip our x value

	L_trdark_lbl_post_clip_left:

	        mov ecx, [y1]          	 'y1 value
	        cmp ecx, [hei2]          'get out if y1 > spr2h
			jg L_trdark_lbl_end_it            'else

	        cmp ecx, 0               'y<0 then
	        jl L_trdark_lbl_clip_top          'clip our y value

	L_trdark_lbl_post_clip_top:

	'ok here's the score: eax=x,ecx=y,edx=height,ebx=width
	'all clipped top and left
	'now lets clip it to the right

	        add ebx, eax               'add x to width and see if its over  *bx is destroyed
	        cmp ebx, [wid2]            'if x+width > destw 'too right then crop it
	        jg  L_trdark_lbl_clip_right         'else continue
	        sub ebx, eax               'restore bx since it was destroyed

	L_trdark_lbl_post_clip_right:

	'now lets clip it down

	        add edx, ecx               'add y to height and see if its over  *dx is destroyed
	        cmp edx,[hei2]             'if y+height > desth 'too low then crop it
	        jg  L_trdark_lbl_clip_down          'else continue
	        sub edx, ecx               'restore dx since it was destroyed

	L_trdark_lbl_post_clip_down:


	'whew!!!!!!!!! that was disorienting!!!!!!!!
	'but all variables are either clipped or cropped now   '-)
	'eax=x,ecx=y,ebx=width,edx=height
	'edi=y*destwidth+1+x


	mov [hei1], ebx   'damn full of agi's here :(    save bx/clippped width
	mov ebx, [wid2]
	inc ebx
	imul ecx, ebx
	sub ebx, [hei1]
	mov [wid2_clip], ebx   'save destw+1-width to stack


	'let us now calculate  the offset normally

	add edi, ecx       'save y value to dx
	add edi, eax       'dest offset(x,y)=y*destw+1+x


	mov ebx, [hei1]   'restore bx

	L_trdark_lbl_main_spr_loop:

	mov ecx, ebx               	 		'put clipped width to counter

	L_trdark_lbl_sprite_loop:                	'x loop

	        mov al, [esi]          		'mov color

	        or al, al                	'if c<>0 then

	        jz L_trdark_lbl_skip_0           	'else
               and al,15   'get color grad offset from sprite
               mov ah,[edi]       'get color from layer
               and ah,15   'color grad offset
               add ah,al            'add them together
               shr ah, 2             'dark translucency state
               sub al,[esi]     'get negative base color
               neg al               'bas color
               add al,ah            'add grad color to base color
               mov [edi], al			'put pixel
	        L_trdark_lbl_skip_0:

			inc esi                  	'next offset
	        inc edi

	        dec ecx

	jnz   L_trdark_lbl_sprite_loop

	add edi, [wid2_clip]                'add to di our destw+1-clp_width
	add esi, [offset_add]               'corrector point to next row

	dec edx

	jnz  L_trdark_lbl_main_spr_loop

	jmp L_trdark_lbl_end_it

	L_trdark_lbl_clip_left:
	        neg eax          			'negate ax ax=-ax=+ax
	        sub ebx, eax       			'subract clipped width to real width
	        jle L_trdark_lbl_end_it  			'if ax<=0 then endit since its tooleft to see a col of pix ')
	        add esi, eax       			'add our ax to si(point to clipped x offset
	                        			'bx is our new clipped width
	        mov [offset_add], eax   	'save it to stack for skipping check purposes

	        xor eax, eax       			'zero is our x coord
	jmp L_trdark_lbl_post_clip_left



	L_trdark_lbl_clip_top:
	        neg ecx          			'negate cx cx=-cx=+cx
	        sub edx, ecx       			'subract clipped height to real height
	                        			'dx is our new clipped height
	        jle L_trdark_lbl_end_it  			'if cx<=0 then endit since its tooleft to see a row of pix ')

	     L_trdark_lbl_height_loop:
	        add esi, [wid1]   			'add our real width to si(point to clipped y offset)
	        dec ecx
	     jnz L_trdark_lbl_height_loop        	'loop it until we get to right y offset
	                                	'cx=0 zero is our y coord
	jmp L_trdark_lbl_post_clip_top


	L_trdark_lbl_clip_right:
	       sub ebx, [wid2]   			'subtract x+width with destw  trust me no negs here :)
	       dec ebx           			'bx now is clipped right
	       add [offset_add], ebx    	'add it to the checker as our spr data is in column major order
	       mov ebx,[wid2]    			'correct bx to  clipx2+1
	       inc ebx
	       sub ebx, eax        			'subtract ax to bx to correct width (0 to destw)
	jmp L_trdark_lbl_post_clip_right

	L_trdark_lbl_clip_down:
	       add ecx, edx        			'add the height to y
	       sub ecx, [hei2]   			'correct it
	       dec ecx
	       sub edx, ecx        			'crop our height
	       mov ecx, [y1]   				'restore y
	jmp L_trdark_lbl_post_clip_down

	L_trdark_lbl_end_it:


  end asm


  SCREENUNLOCK

end sub


'__________________________________________________________________________
Sub AF2.SprBlit_tr.darker ( Byval sx1 as Integer, Byval sy1 as Integer, _
                            Byval image as ushort ptr, _ 
                            Byval SCREEN_WID as integer, _
                            Byval SCREEN_HEI as integer )

	dim vpage as byte ptr
	dim x1 as integer, y1 as integer
	dim x2 as integer, y2 as integer
	dim wid1 as integer
	dim hei1 as integer
	dim wid2 as integer
	dim hei2 as integer
	dim wid2_clip as integer
	dim offset_add as integer
	dim retval as ushort

	x1 = sx1
	y1 = sy1
	x2 = 0
	y2 = 0

	'esi          =image1
	'edi          =vpage

	'ebx=width
	'edx=height

	vpage = SCREENPTR
	SCREENLOCK

  asm
	 		   	  		 	  'calculate the coordinates
	mov eax, [x1]    		  'x1
	mov ebx, [x2]  			  'x2
	sub eax, ebx    		  'x1-x2
	mov [x1], eax

	mov ecx, [y1]  			  'y1
	mov edx, [y2]  			  'y2
	sub ecx, edx       		  'x1-x2
	mov [y1], ecx

	mov esi, [image]  		  'we are now on the width of the spr1 w=(array(0)/8)-1
	mov edi, [vpage]   	      'vpage
	xor ebx, ebx			  'zero out ebx
	mov bx,  [esi]  		  'width*8 of  spr1

	shr ebx,3        		  'div width by 8
	xor edx, edx			  'zero out edx
	mov dx,  [esi+2]   		  'save height spr1
	mov [wid1], ebx			  'save wid1
	add esi,4        		  'si now points to 1st color of spr1 array
	mov [hei1], edx			  'save height

	xor ecx, ecx
	mov cx, [SCREEN_WID]		  'spr2 width*8
	xor eax, eax
	mov ax, [SCREEN_HEI]		  'spr2 height
	dec ecx          		  'correct it
	dec eax
	mov [wid2], ecx			  'wid 2
	mov [hei2], eax			  'hei 2

	'note!!!!  after the clips
	'eax=x     clipped
	'ecx=y     clipped
	'ebx=width   new
	'edx=height  new

	        mov eax, [x1]            'x1 value
	        cmp eax, [wid2]          'get out if x1 > spr2w
			jg L_trdarker_lbl_end_it            'else

	        cmp eax, 0               'x<0 then
	        jl L_trdarker_lbl_clip_left         'clip our x value

	L_trdarker_lbl_post_clip_left:

	        mov ecx, [y1]          	 'y1 value
	        cmp ecx, [hei2]          'get out if y1 > spr2h
			jg L_trdarker_lbl_end_it            'else

	        cmp ecx, 0               'y<0 then
	        jl L_trdarker_lbl_clip_top          'clip our y value

	L_trdarker_lbl_post_clip_top:

	'ok here's the score: eax=x,ecx=y,edx=height,ebx=width
	'all clipped top and left
	'now lets clip it to the right

	        add ebx, eax               'add x to width and see if its over  *bx is destroyed
	        cmp ebx, [wid2]            'if x+width > destw 'too right then crop it
	        jg  L_trdarker_lbl_clip_right         'else continue
	        sub ebx, eax               'restore bx since it was destroyed

	L_trdarker_lbl_post_clip_right:

	'now lets clip it down

	        add edx, ecx               'add y to height and see if its over  *dx is destroyed
	        cmp edx,[hei2]             'if y+height > desth 'too low then crop it
	        jg  L_trdarker_lbl_clip_down          'else continue
	        sub edx, ecx               'restore dx since it was destroyed

	L_trdarker_lbl_post_clip_down:


	'whew!!!!!!!!! that was disorienting!!!!!!!!
	'but all variables are either clipped or cropped now   '-)
	'eax=x,ecx=y,ebx=width,edx=height
	'edi=y*destwidth+1+x


	mov [hei1], ebx   'damn full of agi's here :(    save bx/clippped width
	mov ebx, [wid2]
	inc ebx
	imul ecx, ebx
	sub ebx, [hei1]
	mov [wid2_clip], ebx   'save destw+1-width to stack


	'let us now calculate  the offset normally

	add edi, ecx       'save y value to dx
	add edi, eax       'dest offset(x,y)=y*destw+1+x


	mov ebx, [hei1]   'restore bx

	L_trdarker_lbl_main_spr_loop:

	mov ecx, ebx               	 		'put clipped width to counter

	L_trdarker_lbl_sprite_loop:                	'x loop

	        mov al, [esi]          		'mov color

	        or al, al                	'if c<>0 then

	        jz L_trdarker_lbl_skip_0           	'else
               and al,15   'get color grad offset from sprite
               mov ah,[edi]       'get color from layer
               and ah,15   'color grad offset
               add ah,al            'add them together
               shr ah, 3             'darker translucency state
               sub al,[esi]     'get negative base color
               neg al               'bas color
               add al,ah            'add grad color to base color
               mov [edi], al			'put pixel
	        L_trdarker_lbl_skip_0:

			inc esi                  	'next offset
	        inc edi

	        dec ecx

	jnz   L_trdarker_lbl_sprite_loop

	add edi, [wid2_clip]                'add to di our destw+1-clp_width
	add esi, [offset_add]               'corrector point to next row

	dec edx

	jnz  L_trdarker_lbl_main_spr_loop

	jmp L_trdarker_lbl_end_it

	L_trdarker_lbl_clip_left:
	        neg eax          			'negate ax ax=-ax=+ax
	        sub ebx, eax       			'subract clipped width to real width
	        jle L_trdarker_lbl_end_it  			'if ax<=0 then endit since its tooleft to see a col of pix ')
	        add esi, eax       			'add our ax to si(point to clipped x offset
	                        			'bx is our new clipped width
	        mov [offset_add], eax   	'save it to stack for skipping check purposes

	        xor eax, eax       			'zero is our x coord
	jmp L_trdarker_lbl_post_clip_left



	L_trdarker_lbl_clip_top:
	        neg ecx          			'negate cx cx=-cx=+cx
	        sub edx, ecx       			'subract clipped height to real height
	                        			'dx is our new clipped height
	        jle L_trdarker_lbl_end_it  			'if cx<=0 then endit since its tooleft to see a row of pix ')

	     L_trdarker_lbl_height_loop:
	        add esi, [wid1]   			'add our real width to si(point to clipped y offset)
	        dec ecx
	     jnz L_trdarker_lbl_height_loop        	'loop it until we get to right y offset
	                                	'cx=0 zero is our y coord
	jmp L_trdarker_lbl_post_clip_top


	L_trdarker_lbl_clip_right:
	       sub ebx, [wid2]   			'subtract x+width with destw  trust me no negs here :)
	       dec ebx           			'bx now is clipped right
	       add [offset_add], ebx    	'add it to the checker as our spr data is in column major order
	       mov ebx,[wid2]    			'correct bx to  clipx2+1
	       inc ebx
	       sub ebx, eax        			'subtract ax to bx to correct width (0 to destw)
	jmp L_trdarker_lbl_post_clip_right

	L_trdarker_lbl_clip_down:
	       add ecx, edx        			'add the height to y
	       sub ecx, [hei2]   			'correct it
	       dec ecx
	       sub edx, ecx        			'crop our height
	       mov ecx, [y1]   				'restore y
	jmp L_trdarker_lbl_post_clip_down

	L_trdarker_lbl_end_it:


  end asm


  SCREENUNLOCK

end sub


'__________________________________________________________________________
Sub AF2.SprBlit_tr.darkest ( Byval sx1 as Integer, Byval sy1 as Integer, _
                             Byval image as ushort ptr, _ 
                             Byval SCREEN_WID as integer, _
                             Byval SCREEN_HEI as integer )

	dim vpage as byte ptr
	dim x1 as integer, y1 as integer
	dim x2 as integer, y2 as integer
	dim wid1 as integer
	dim hei1 as integer
	dim wid2 as integer
	dim hei2 as integer
	dim wid2_clip as integer
	dim offset_add as integer
	dim retval as ushort

	x1 = sx1
	y1 = sy1
	x2 = 0
	y2 = 0

	'esi          =image1
	'edi          =vpage

	'ebx=width
	'edx=height

	vpage = SCREENPTR
	SCREENLOCK

  asm
	 		   	  		 	  'calculate the coordinates
	mov eax, [x1]    		  'x1
	mov ebx, [x2]  			  'x2
	sub eax, ebx    		  'x1-x2
	mov [x1], eax

	mov ecx, [y1]  			  'y1
	mov edx, [y2]  			  'y2
	sub ecx, edx       		  'x1-x2
	mov [y1], ecx

	mov esi, [image]  		  'we are now on the width of the spr1 w=(array(0)/8)-1
	mov edi, [vpage]   	      'vpage
	xor ebx, ebx			  'zero out ebx
	mov bx,  [esi]  		  'width*8 of  spr1

	shr ebx,3        		  'div width by 8
	xor edx, edx			  'zero out edx
	mov dx,  [esi+2]   		  'save height spr1
	mov [wid1], ebx			  'save wid1
	add esi,4        		  'si now points to 1st color of spr1 array
	mov [hei1], edx			  'save height

	xor ecx, ecx
	mov cx, [SCREEN_WID]		  'spr2 width*8
	xor eax, eax
	mov ax, [SCREEN_HEI]		  'spr2 height
	dec ecx          		  'correct it
	dec eax
	mov [wid2], ecx			  'wid 2
	mov [hei2], eax			  'hei 2

	'note!!!!  after the clips
	'eax=x     clipped
	'ecx=y     clipped
	'ebx=width   new
	'edx=height  new

	        mov eax, [x1]            'x1 value
	        cmp eax, [wid2]          'get out if x1 > spr2w
			jg L_trdarkest_lbl_end_it            'else

	        cmp eax, 0               'x<0 then
	        jl L_trdarkest_lbl_clip_left         'clip our x value

	L_trdarkest_lbl_post_clip_left:

	        mov ecx, [y1]          	 'y1 value
	        cmp ecx, [hei2]          'get out if y1 > spr2h
			jg L_trdarkest_lbl_end_it            'else

	        cmp ecx, 0               'y<0 then
	        jl L_trdarkest_lbl_clip_top          'clip our y value

	L_trdarkest_lbl_post_clip_top:

	'ok here's the score: eax=x,ecx=y,edx=height,ebx=width
	'all clipped top and left
	'now lets clip it to the right

	        add ebx, eax               'add x to width and see if its over  *bx is destroyed
	        cmp ebx, [wid2]            'if x+width > destw 'too right then crop it
	        jg  L_trdarkest_lbl_clip_right         'else continue
	        sub ebx, eax               'restore bx since it was destroyed

	L_trdarkest_lbl_post_clip_right:

	'now lets clip it down

	        add edx, ecx               'add y to height and see if its over  *dx is destroyed
	        cmp edx,[hei2]             'if y+height > desth 'too low then crop it
	        jg  L_trdarkest_lbl_clip_down          'else continue
	        sub edx, ecx               'restore dx since it was destroyed

	L_trdarkest_lbl_post_clip_down:


	'whew!!!!!!!!! that was disorienting!!!!!!!!
	'but all variables are either clipped or cropped now   '-)
	'eax=x,ecx=y,ebx=width,edx=height
	'edi=y*destwidth+1+x


	mov [hei1], ebx   'damn full of agi's here :(    save bx/clippped width
	mov ebx, [wid2]
	inc ebx
	imul ecx, ebx
	sub ebx, [hei1]
	mov [wid2_clip], ebx   'save destw+1-width to stack


	'let us now calculate  the offset normally

	add edi, ecx       'save y value to dx
	add edi, eax       'dest offset(x,y)=y*destw+1+x


	mov ebx, [hei1]   'restore bx

	L_trdarkest_lbl_main_spr_loop:

	mov ecx, ebx               	 		'put clipped width to counter

	L_trdarkest_lbl_sprite_loop:                	'x loop

	        mov al, [esi]          		'mov color

	        or al, al                	'if c<>0 then

	        jz L_trdarkest_lbl_skip_0           	'else
               and al,15   'get color grad offset from sprite
               mov ah,[edi]       'get color from layer
               and ah,15   'color grad offset
               add ah,al            'add them together
               shr ah, 4             'darkest translucency state
               sub al,[esi]     'get negative base color
               neg al               'bas color
               add al,ah            'add grad color to base color
               mov [edi], al			'put pixel
	        L_trdarkest_lbl_skip_0:

			inc esi                  	'next offset
	        inc edi

	        dec ecx

	jnz   L_trdarkest_lbl_sprite_loop

	add edi, [wid2_clip]                'add to di our destw+1-clp_width
	add esi, [offset_add]               'corrector point to next row

	dec edx

	jnz  L_trdarkest_lbl_main_spr_loop

	jmp L_trdarkest_lbl_end_it

	L_trdarkest_lbl_clip_left:
	        neg eax          			'negate ax ax=-ax=+ax
	        sub ebx, eax       			'subract clipped width to real width
	        jle L_trdarkest_lbl_end_it  			'if ax<=0 then endit since its tooleft to see a col of pix ')
	        add esi, eax       			'add our ax to si(point to clipped x offset
	                        			'bx is our new clipped width
	        mov [offset_add], eax   	'save it to stack for skipping check purposes

	        xor eax, eax       			'zero is our x coord
	jmp L_trdarkest_lbl_post_clip_left



	L_trdarkest_lbl_clip_top:
	        neg ecx          			'negate cx cx=-cx=+cx
	        sub edx, ecx       			'subract clipped height to real height
	                        			'dx is our new clipped height
	        jle L_trdarkest_lbl_end_it  			'if cx<=0 then endit since its tooleft to see a row of pix ')

	     L_trdarkest_lbl_height_loop:
	        add esi, [wid1]   			'add our real width to si(point to clipped y offset)
	        dec ecx
	     jnz L_trdarkest_lbl_height_loop        	'loop it until we get to right y offset
	                                	'cx=0 zero is our y coord
	jmp L_trdarkest_lbl_post_clip_top


	L_trdarkest_lbl_clip_right:
	       sub ebx, [wid2]   			'subtract x+width with destw  trust me no negs here :)
	       dec ebx           			'bx now is clipped right
	       add [offset_add], ebx    	'add it to the checker as our spr data is in column major order
	       mov ebx,[wid2]    			'correct bx to  clipx2+1
	       inc ebx
	       sub ebx, eax        			'subtract ax to bx to correct width (0 to destw)
	jmp L_trdarkest_lbl_post_clip_right

	L_trdarkest_lbl_clip_down:
	       add ecx, edx        			'add the height to y
	       sub ecx, [hei2]   			'correct it
	       dec ecx
	       sub edx, ecx        			'crop our height
	       mov ecx, [y1]   				'restore y
	jmp L_trdarkest_lbl_post_clip_down

	L_trdarkest_lbl_end_it:


  end asm


  SCREENUNLOCK

end sub


'__________________________________________________________________________
Sub AF2.SprBlit_null ( Byval sx1 as Integer, Byval sy1 as Integer, _
                       Byval image as ushort ptr, _ 
                       Byval SCREEN_WID as integer, _
                       Byval SCREEN_HEI as integer )

	dim vpage as byte ptr
	dim x1 as integer, y1 as integer
	dim x2 as integer, y2 as integer
	dim wid1 as integer
	dim hei1 as integer
	dim wid2 as integer
	dim hei2 as integer
	dim wid2_clip as integer
	dim offset_add as integer
	dim retval as ushort

	x1 = sx1
	y1 = sy1
	x2 = 0
	y2 = 0

	'esi          =image1
	'edi          =vpage

	'ebx=width
	'edx=height

	vpage = SCREENPTR
	SCREENLOCK

  asm
	 		   	  		 	  'calculate the coordinates
	mov eax, [x1]    		  'x1
	mov ebx, [x2]  			  'x2
	sub eax, ebx    		  'x1-x2
	mov [x1], eax

	mov ecx, [y1]  			  'y1
	mov edx, [y2]  			  'y2
	sub ecx, edx       		  'x1-x2
	mov [y1], ecx

	mov esi, [image]  		  'we are now on the width of the spr1 w=(array(0)/8)-1
	mov edi, [vpage]   	      'vpage
	xor ebx, ebx			  'zero out ebx
	mov bx,  [esi]  		  'width*8 of  spr1

	shr ebx,3        		  'div width by 8
	xor edx, edx			  'zero out edx
	mov dx,  [esi+2]   		  'save height spr1
	mov [wid1], ebx			  'save wid1
	add esi,4        		  'si now points to 1st color of spr1 array
	mov [hei1], edx			  'save height

	xor ecx, ecx
	mov cx, [SCREEN_WID]		  'spr2 width*8
	xor eax, eax
	mov ax, [SCREEN_HEI]		  'spr2 height
	dec ecx          		  'correct it
	dec eax
	mov [wid2], ecx			  'wid 2
	mov [hei2], eax			  'hei 2

	'note!!!!  after the clips
	'eax=x     clipped
	'ecx=y     clipped
	'ebx=width   new
	'edx=height  new

	        mov eax, [x1]            'x1 value
	        cmp eax, [wid2]          'get out if x1 > spr2w
			jg L_null_lbl_end_it            'else

	        cmp eax, 0               'x<0 then
	        jl L_null_lbl_clip_left         'clip our x value

	L_null_lbl_post_clip_left:

	        mov ecx, [y1]          	 'y1 value
	        cmp ecx, [hei2]          'get out if y1 > spr2h
			jg L_null_lbl_end_it            'else

	        cmp ecx, 0               'y<0 then
	        jl L_null_lbl_clip_top          'clip our y value

	L_null_lbl_post_clip_top:

	'ok here's the score: eax=x,ecx=y,edx=height,ebx=width
	'all clipped top and left
	'now lets clip it to the right

	        add ebx, eax               'add x to width and see if its over  *bx is destroyed
	        cmp ebx, [wid2]            'if x+width > destw 'too right then crop it
	        jg  L_null_lbl_clip_right         'else continue
	        sub ebx, eax               'restore bx since it was destroyed

	L_null_lbl_post_clip_right:

	'now lets clip it down

	        add edx, ecx               'add y to height and see if its over  *dx is destroyed
	        cmp edx,[hei2]             'if y+height > desth 'too low then crop it
	        jg  L_null_lbl_clip_down          'else continue
	        sub edx, ecx               'restore dx since it was destroyed

	L_null_lbl_post_clip_down:


	'whew!!!!!!!!! that was disorienting!!!!!!!!
	'but all variables are either clipped or cropped now   '-)
	'eax=x,ecx=y,ebx=width,edx=height
	'edi=y*destwidth+1+x


	mov [hei1], ebx   'damn full of agi's here :(    save bx/clippped width
	mov ebx, [wid2]
	inc ebx
	imul ecx, ebx
	sub ebx, [hei1]
	mov [wid2_clip], ebx   'save destw+1-width to stack


	'let us now calculate  the offset normally

	add edi, ecx       'save y value to dx
	add edi, eax       'dest offset(x,y)=y*destw+1+x


	mov ebx, [hei1]   'restore bx

	L_null_lbl_main_spr_loop:

	mov ecx, ebx               	 		'put clipped width to counter

	L_null_lbl_sprite_loop:                	'x loop

	        mov al, [esi]          		'mov color

	        or al, al                	'if c<>0 then

	        jz L_null_lbl_skip_0           	'else
               and al,15   'get color grad offset from sprite
               mov ah,[edi]       'get color from layer
               and ah,15   'color grad offset
               add ah,al            'add them together
               shr ah, 6            'nullify all sprite color
               sub al,[esi]         'get negative base color
               neg al               'bas color
               add al,ah            'add grad color to base color
               mov [edi], al			'put pixel
	        L_null_lbl_skip_0:

			inc esi                  	'next offset
	        inc edi

	        dec ecx

	jnz   L_null_lbl_sprite_loop

	add edi, [wid2_clip]                'add to di our destw+1-clp_width
	add esi, [offset_add]               'corrector point to next row

	dec edx

	jnz  L_null_lbl_main_spr_loop

	jmp L_null_lbl_end_it

	L_null_lbl_clip_left:
	        neg eax          			'negate ax ax=-ax=+ax
	        sub ebx, eax       			'subract clipped width to real width
	        jle L_null_lbl_end_it  			'if ax<=0 then endit since its tooleft to see a col of pix ')
	        add esi, eax       			'add our ax to si(point to clipped x offset
	                        			'bx is our new clipped width
	        mov [offset_add], eax   	'save it to stack for skipping check purposes

	        xor eax, eax       			'zero is our x coord
	jmp L_null_lbl_post_clip_left



	L_null_lbl_clip_top:
	        neg ecx          			'negate cx cx=-cx=+cx
	        sub edx, ecx       			'subract clipped height to real height
	                        			'dx is our new clipped height
	        jle L_null_lbl_end_it  			'if cx<=0 then endit since its tooleft to see a row of pix ')

	     L_null_lbl_height_loop:
	        add esi, [wid1]   			'add our real width to si(point to clipped y offset)
	        dec ecx
	     jnz L_null_lbl_height_loop        	'loop it until we get to right y offset
	                                	'cx=0 zero is our y coord
	jmp L_null_lbl_post_clip_top


	L_null_lbl_clip_right:
	       sub ebx, [wid2]   			'subtract x+width with destw  trust me no negs here :)
	       dec ebx           			'bx now is clipped right
	       add [offset_add], ebx    	'add it to the checker as our spr data is in column major order
	       mov ebx,[wid2]    			'correct bx to  clipx2+1
	       inc ebx
	       sub ebx, eax        			'subtract ax to bx to correct width (0 to destw)
	jmp L_null_lbl_post_clip_right

	L_null_lbl_clip_down:
	       add ecx, edx        			'add the height to y
	       sub ecx, [hei2]   			'correct it
	       dec ecx
	       sub edx, ecx        			'crop our height
	       mov ecx, [y1]   				'restore y
	jmp L_null_lbl_post_clip_down

	L_null_lbl_end_it:


  end asm


  SCREENUNLOCK

end sub

Sub AF2.SprBlit_tr.fadecust ( Byval sx1 as Integer, Byval sy1 as Integer, _
                              Byval fade_lvl as Integer, _
                              Byval image as ushort ptr, _ 
                              Byval SCREEN_WID as integer, _
                              Byval SCREEN_HEI as integer )

	dim vpage as byte ptr
	dim x1 as integer, y1 as integer
	dim x2 as integer, y2 as integer
	dim wid1 as integer
	dim hei1 as integer
	dim wid2 as integer
	dim hei2 as integer
	dim wid2_clip as integer
	dim offset_add as integer
	dim retval as ushort

	x1 = sx1
	y1 = sy1
	x2 = 0
	y2 = 0

	'esi          =image1
	'edi          =vpage

	'ebx=width
	'edx=height

	vpage = SCREENPTR

ScreenLock

Dim Repeat as Integer

Select Case as const fade_lvl
  Case 0:
    AF2.SprBlit sx1, sy1, image, SCREEN_WID, SCREEN_HEI
  Case 1:
    AF2.SprBlit_trans sx1, sy1, image, SCREEN_WID, SCREEN_HEI
  Case 2:
    AF2.SprBlit_tr.dark sx1, sy1, image, SCREEN_WID, SCREEN_HEI
    AF2.SprBlit_trans sx1, sy1, image, SCREEN_WID, SCREEN_HEI
  Case 3:
    GOTO Trans_to_Normaltrans:
  Case 4:
    AF2.SprBlit_tr.dark sx1, sy1, image, SCREEN_WID, SCREEN_HEI
  Case 5:
    AF2.SprBlit_tr.darker sx1, sy1, image, SCREEN_WID, SCREEN_HEI
    AF2.SprBlit_tr.dark sx1, sy1, image, SCREEN_WID, SCREEN_HEI
  Case 6:
    AF2.SprBlit_tr.darker sx1, sy1, image, SCREEN_WID, SCREEN_HEI
  Case 7:
    AF2.SprBlit_tr.darkest sx1, sy1, image, SCREEN_WID, SCREEN_HEI
    AF2.SprBlit_tr.darker sx1, sy1, image, SCREEN_WID, SCREEN_HEI
  Case 8:
    AF2.SprBlit_tr.darkest sx1, sy1, image, SCREEN_WID, SCREEN_HEI
  Case 9:
    AF2.SprBlit_null sx1, sy1, image, SCREEN_WID, SCREEN_HEI
    AF2.SprBlit_tr.darkest sx1, sy1, image, SCREEN_WID, SCREEN_HEI
  Case Else:
    AF2.SprBlit_null sx1, sy1, image, SCREEN_WID, SCREEN_HEI
End Select

ScreenUnlock
Exit Sub

Trans_to_Normaltrans:
  asm
	 		   	  		 	  'calculate the coordinates
	mov eax, [x1]    		  'x1
	mov ebx, [x2]  			  'x2
	sub eax, ebx    		  'x1-x2
	mov [x1], eax

	mov ecx, [y1]  			  'y1
	mov edx, [y2]  			  'y2
	sub ecx, edx       		  'x1-x2
	mov [y1], ecx

	mov esi, [image]  		  'we are now on the width of the spr1 w=(array(0)/8)-1
	mov edi, [vpage]   	      'vpage
	xor ebx, ebx			  'zero out ebx
	mov bx,  [esi]  		  'width*8 of  spr1

	shr ebx,3        		  'div width by 8
	xor edx, edx			  'zero out edx
	mov dx,  [esi+2]   		  'save height spr1
	mov [wid1], ebx			  'save wid1
	add esi,4        		  'si now points to 1st color of spr1 array
	mov [hei1], edx			  'save height

	xor ecx, ecx
	mov cx, [SCREEN_WID]		  'spr2 width*8
	xor eax, eax
	mov ax, [SCREEN_HEI]		  'spr2 height
	dec ecx          		  'correct it
	dec eax
	mov [wid2], ecx			  'wid 2
	mov [hei2], eax			  'hei 2

	'note!!!!  after the clips
	'eax=x     clipped
	'ecx=y     clipped
	'ebx=width   new
	'edx=height  new

	        mov eax, [x1]            'x1 value
	        cmp eax, [wid2]          'get out if x1 > spr2w
			jg L_transnorm_lbl_end_it            'else

	        cmp eax, 0               'x<0 then
	        jl L_transnorm_lbl_clip_left         'clip our x value

	L_transnorm_lbl_post_clip_left:

	        mov ecx, [y1]          	 'y1 value
	        cmp ecx, [hei2]          'get out if y1 > spr2h
			jg L_transnorm_lbl_end_it            'else

	        cmp ecx, 0               'y<0 then
	        jl L_transnorm_lbl_clip_top          'clip our y value

	L_transnorm_lbl_post_clip_top:

	'ok here's the score: eax=x,ecx=y,edx=height,ebx=width
	'all clipped top and left
	'now lets clip it to the right

	        add ebx, eax               'add x to width and see if its over  *bx is destroyed
	        cmp ebx, [wid2]            'if x+width > destw 'too right then crop it
	        jg  L_transnorm_lbl_clip_right         'else continue
	        sub ebx, eax               'restore bx since it was destroyed

	L_transnorm_lbl_post_clip_right:

	'now lets clip it down

	        add edx, ecx               'add y to height and see if its over  *dx is destroyed
	        cmp edx,[hei2]             'if y+height > desth 'too low then crop it
	        jg  L_transnorm_lbl_clip_down          'else continue
	        sub edx, ecx               'restore dx since it was destroyed

	L_transnorm_lbl_post_clip_down:


	'whew!!!!!!!!! that was disorienting!!!!!!!!
	'but all variables are either clipped or cropped now   '-)
	'eax=x,ecx=y,ebx=width,edx=height
	'edi=y*destwidth+1+x


	mov [hei1], ebx   'damn full of agi's here :(    save bx/clippped width
	mov ebx, [wid2]
	inc ebx
	imul ecx, ebx
	sub ebx, [hei1]
	mov [wid2_clip], ebx   'save destw+1-width to stack


	'let us now calculate  the offset transnormly

	add edi, ecx       'save y value to dx
	add edi, eax       'dest offset(x,y)=y*destw+1+x


	mov ebx, [hei1]   'restore bx

	L_transnorm_lbl_main_spr_loop:

	mov ecx, ebx               	 		'put clipped width to counter

	L_transnorm_lbl_sprite_loop:                	'x loop

	        mov al, [esi]          		'mov color

	        or al, al                	'if c<>0 then

	        jz L_transnorm_lbl_skip_0           	'else
               and al,15  
               mov ah,[edi]         'get color from layer
               and ah,12   
               add ah,al            'add them together
               shr ah, 1            'average
               sub al,[esi]         'get negative base color
               neg al               'bas color
               add al,ah            'add grad color to base color
               mov [edi], al			'put pixel
	        L_transnorm_lbl_skip_0:

			inc esi                  	'next offset
	        inc edi

	        dec ecx

	jnz   L_transnorm_lbl_sprite_loop

	add edi, [wid2_clip]                'add to di our destw+1-clp_width
	add esi, [offset_add]               'corrector point to next row

	dec edx

	jnz  L_transnorm_lbl_main_spr_loop

	jmp L_transnorm_lbl_end_it

	L_transnorm_lbl_clip_left:
	        neg eax          			'negate ax ax=-ax=+ax
	        sub ebx, eax       			'subract clipped width to real width
	        jle L_transnorm_lbl_end_it  			'if ax<=0 then endit since its tooleft to see a col of pix ')
	        add esi, eax       			'add our ax to si(point to clipped x offset
	                        			'bx is our new clipped width
	        mov [offset_add], eax   	'save it to stack for skipping check purposes

	        xor eax, eax       			'zero is our x coord
	jmp L_transnorm_lbl_post_clip_left



	L_transnorm_lbl_clip_top:
	        neg ecx          			'negate cx cx=-cx=+cx
	        sub edx, ecx       			'subract clipped height to real height
	                        			'dx is our new clipped height
	        jle L_transnorm_lbl_end_it  			'if cx<=0 then endit since its tooleft to see a row of pix ')

	     L_transnorm_lbl_height_loop:
	        add esi, [wid1]   			'add our real width to si(point to clipped y offset)
	        dec ecx
	     jnz L_transnorm_lbl_height_loop        	'loop it until we get to right y offset
	                                	'cx=0 zero is our y coord
	jmp L_transnorm_lbl_post_clip_top


	L_transnorm_lbl_clip_right:
	       sub ebx, [wid2]   			'subtract x+width with destw  trust me no negs here :)
	       dec ebx           			'bx now is clipped right
	       add [offset_add], ebx    	'add it to the checker as our spr data is in column major order
	       mov ebx,[wid2]    			'correct bx to  clipx2+1
	       inc ebx
	       sub ebx, eax        			'subtract ax to bx to correct width (0 to destw)
	jmp L_transnorm_lbl_post_clip_right

	L_transnorm_lbl_clip_down:
	       add ecx, edx        			'add the height to y
	       sub ecx, [hei2]   			'correct it
	       dec ecx
	       sub edx, ecx        			'crop our height
	       mov ecx, [y1]   				'restore y
	jmp L_transnorm_lbl_post_clip_down

	L_transnorm_lbl_end_it:


  end asm

ScreenUnlock

End Sub

Sub AF2.RemoveSpr (Byref Sprite_array as ImageType)

Sprite_array.destroy ( Sprite_array )

End Sub

Sub AF2.SprBlit_brightness ( Byval sx1 as Integer, Byval sy1 as Integer, _
                             Byval bright.level as Integer, _
                             Byval image as ushort ptr, _ 
                             Byval SCREEN_WID as integer, _
                             Byval SCREEN_HEI as integer )

'---------------------------------------------------------------------------
' Brightness Level 0 is the absolute darkest colored point of the sprite;
' Brightness Level 31 is the point of the default-colored sprite;
'   and
' Brightness Level 42 is the absolute lightest colored point of the sprite!
'---------------------------------------------------------------------------

	dim vpage as byte ptr
	dim x1 as integer, y1 as integer
	dim x2 as integer, y2 as integer
	dim wid1 as integer
	dim hei1 as integer
	dim wid2 as integer
	dim hei2 as integer
	dim wid2_clip as integer
	dim offset_add as integer
	dim retval as ushort
	dim impose as integer

	x1 = sx1
	y1 = sy1
	x2 = 0
	y2 = 0

	'esi          =image1
	'edi          =vpage

	'ebx=width
	'edx=height

	vpage = SCREENPTR

ScreenLock
If bright.level >= 42 then bright.level = 42

If bright.level <= 0 then
  bright.level = 0 
  AF2.SprBlit_null sx1, sy1, image, SCREEN_WID, SCREEN_HEI
End if
If bright.level > 0 and bright.level <= 11 then
  AF2.SprBlit_color sx1, sy1, bright.level, image, SCREEN_WID, SCREEN_HEI
  AF2.SprBlit_tr.darkest sx1, sy1, image, SCREEN_WID, SCREEN_HEI
End if
If bright.level >= 12 and bright.level <= 23 then
  AF2.SprBlit_color sx1, sy1, bright.level + 8, image, SCREEN_WID, SCREEN_HEI
  AF2.SprBlit_tr.darker sx1, sy1, image, SCREEN_WID, SCREEN_HEI
End if
If bright.level >= 24 and bright.level <= 30 then
  AF2.SprBlit_color sx1, sy1, bright.level - 16, image, SCREEN_WID, SCREEN_HEI
  AF2.SprBlit_tr.dark sx1, sy1, image, SCREEN_WID, SCREEN_HEI
  If bright.level >= 28 then
    AF2.SprBlit_trans sx1, sy1, image, SCREEN_WID, SCREEN_HEI
  End if
End if
If bright.level = 31 then
  AF2.SprBlit sx1, sy1, image, SCREEN_WID, SCREEN_HEI
End if
If bright.level >= 32 and bright.level <= 42 then
  AF2.SprBlit_color sx1, sy1, bright.level - 26, image, SCREEN_WID, SCREEN_HEI
  AF2.SprBlit_trans sx1, sy1, image, SCREEN_WID, SCREEN_HEI
  If bright.level <= 34 then
    AF2.SprBlit_trans sx1, sy1, image, SCREEN_WID, SCREEN_HEI
    GOTO Trans_MaxColor:
  End if
End if
If bright.level >= 42 then
  AF2.SprBlit_color sx1, sy1, 15, image, SCREEN_WID, SCREEN_HEI
  GoTO Trans_MaxColor:
End if
ScreenUnlock

Exit Sub

Trans_MaxColor:
  asm
	 		   	  		 	  'calculate the coordinates
	mov eax, [x1]    		  'x1
	mov ebx, [x2]  			  'x2
	sub eax, ebx    		  'x1-x2
	mov [x1], eax

	mov ecx, [y1]  			  'y1
	mov edx, [y2]  			  'y2
	sub ecx, edx       		  'x1-x2
	mov [y1], ecx

	mov esi, [image]  		  'we are now on the width of the spr1 w=(array(0)/8)-1
	mov edi, [vpage]   	          'vpage
	xor ebx, ebx			  'zero out ebx
	mov bx,  [esi]  		  'width*8 of  spr1

	shr ebx,3        		  'div width by 8
	xor edx, edx			  'zero out edx
	mov dx,  [esi+2]   		  'save height spr1
	mov [wid1], ebx			  'save wid1
	add esi,4        		  'si now points to 1st color of spr1 array
	mov [hei1], edx			  'save height

	xor ecx, ecx
	mov cx, [SCREEN_WID]		  'spr2 width*8
	xor eax, eax
	mov ax, [SCREEN_HEI]		  'spr2 height
	dec ecx          		  'correct it
	dec eax
	mov [wid2], ecx			  'wid 2
	mov [hei2], eax			  'hei 2

	'note!!!!  after the clips
	'eax=x     clipped
	'ecx=y     clipped
	'ebx=width   new
	'edx=height  new

	        mov eax, [x1]            'x1 value
	        cmp eax, [wid2]          'get out if x1 > spr2w
			jg L_transmaxcolor_lbl_end_it            'else

	        cmp eax, 0               'x<0 then
	        jl L_transmaxcolor_lbl_clip_left         'clip our x value

	L_transmaxcolor_lbl_post_clip_left:

	        mov ecx, [y1]          	 'y1 value
	        cmp ecx, [hei2]          'get out if y1 > spr2h
			jg L_transmaxcolor_lbl_end_it            'else

	        cmp ecx, 0               'y<0 then
	        jl L_transmaxcolor_lbl_clip_top          'clip our y value

	L_transmaxcolor_lbl_post_clip_top:

	'ok here's the score: eax=x,ecx=y,edx=height,ebx=width
	'all clipped top and left
	'now lets clip it to the right

	        add ebx, eax               'add x to width and see if its over  *bx is destroyed
	        cmp ebx, [wid2]            'if x+width > destw 'too right then crop it
	        jg  L_transmaxcolor_lbl_clip_right         'else continue
	        sub ebx, eax               'restore bx since it was destroyed

	L_transmaxcolor_lbl_post_clip_right:

	'now lets clip it down

	        add edx, ecx               'add y to height and see if its over  *dx is destroyed
	        cmp edx,[hei2]             'if y+height > desth 'too low then crop it
	        jg  L_transmaxcolor_lbl_clip_down          'else continue
	        sub edx, ecx               'restore dx since it was destroyed

	L_transmaxcolor_lbl_post_clip_down:


	'whew!!!!!!!!! that was disorienting!!!!!!!!
	'but all variables are either clipped or cropped now   '-)
	'eax=x,ecx=y,ebx=width,edx=height
	'edi=y*destwidth+1+x


	mov [hei1], ebx   'damn full of agi's here :(    save bx/clippped width
	mov ebx, [wid2]
	inc ebx
	imul ecx, ebx
	sub ebx, [hei1]
	mov [wid2_clip], ebx   'save destw+1-width to stack


	'let us now calculate  the offset normally

	add edi, ecx       'save y value to dx
	add edi, eax       'dest offset(x,y)=y*destw+1+x


	mov ebx, [hei1]   'restore bx

	L_transmaxcolor_lbl_main_spr_loop:

	mov ecx, ebx               	 		'put clipped width to counter

	L_transmaxcolor_lbl_sprite_loop:                	'x loop

	        mov al, [esi]          		'mov color

	        or al, al                	'if c<>0 then

	        jz L_transmaxcolor_lbl_skip_0           	'else
               and al,15   'get color grad offset from sprite
               mov ah,[edi]       'get color from layer
               and ah,15   'color grad offset
               sub al,[esi]         'get negative base color
               neg al               'bas color
               add al,ah            'add grad color to base color
               mov [edi], al			'put pixel
	        L_transmaxcolor_lbl_skip_0:

			inc esi                  	'next offset
	        inc edi

	        dec ecx

	jnz   L_transmaxcolor_lbl_sprite_loop

	add edi, [wid2_clip]                'add to di our destw+1-clp_width
	add esi, [offset_add]               'corrector point to next row

	dec edx

	jnz  L_transmaxcolor_lbl_main_spr_loop

	jmp L_transmaxcolor_lbl_end_it

	L_transmaxcolor_lbl_clip_left:
	        neg eax          			'negate ax ax=-ax=+ax
	        sub ebx, eax       			'subract clipped width to real width
	        jle L_transmaxcolor_lbl_end_it  	'if ax<=0 then endit since its tooleft to see a col of pix ')
	        add esi, eax       			'add our ax to si(point to clipped x offset
	                        			'bx is our new clipped width
	        mov [offset_add], eax   	      'save it to stack for skipping check purposes

	        xor eax, eax       			'zero is our x coord
	jmp L_transmaxcolor_lbl_post_clip_left



	L_transmaxcolor_lbl_clip_top:
	        neg ecx          			'negate cx cx=-cx=+cx
	        sub edx, ecx       			'subract clipped height to real height
	                        			'dx is our new clipped height
	        jle L_transmaxcolor_lbl_end_it  	'if cx<=0 then endit since its tooleft to see a row of pix ')

	     L_transmaxcolor_lbl_height_loop:
	        add esi, [wid1]   			'add our real width to si(point to clipped y offset)
	        dec ecx
	     jnz L_transmaxcolor_lbl_height_loop  'loop it until we get to right y offset
	                                          'cx=0 zero is our y coord
	jmp L_transmaxcolor_lbl_post_clip_top


	L_transmaxcolor_lbl_clip_right:
	       sub ebx, [wid2]   			'subtract x+width with destw  trust me no negs here :)
	       dec ebx           			'bx now is clipped right
	       add [offset_add], ebx    		'add it to the checker as our spr data is in column major order
	       mov ebx,[wid2]    			'correct bx to  clipx2+1
	       inc ebx
	       sub ebx, eax        			'subtract ax to bx to correct width (0 to destw)
	jmp L_transmaxcolor_lbl_post_clip_right

	L_transmaxcolor_lbl_clip_down:
	       add ecx, edx        			'add the height to y
	       sub ecx, [hei2]   			'correct it
	       dec ecx
	       sub edx, ecx        			'crop our height
	       mov ecx, [y1]   				'restore y
	jmp L_transmaxcolor_lbl_post_clip_down

	L_transmaxcolor_lbl_end_it:


  end asm

ScreenUnlock

End Sub

Sub AF2.PP256fnt_brightness (Byref text as String, _
                             Byval x as Single, Byval y as Single, _
                             Byval centered as Integer, _
                             Byval bright.level as Integer, _
                             Byref PP256font as ImageType, _
                             Byval SCREEN_WID as Integer, _
                             Byval SCREEN_HEI as Integer )

Dim as Integer FontChar, i, width_result, GFX_width, Centered_length
Dim as byte ptr CharacterWidth

If centered > 0 or centered = -1 then
  x = 0
  ScreenInfo GFX_width
  For i = 1 TO LEN(text)
    FontChar = ASC(MID$(text, i, 1)) - 32
    CharacterWidth = cptr(byte ptr, @PP256font.p_data[PP256font.p_dataindex[FontChar]])
    width_result = CharacterWidth[0] \ 8
    Centered_length += width_result
  Next
  x = (GFX_width - Centered_length) \ 2
End if

ScreenLock
For i = 1 TO LEN(text)
  FontChar = ASC(MID$(text, i, 1)) - 32
  AF2.SprBlit_brightness x, y, bright.level, @PP256font.p_data[PP256font.p_dataindex[FontChar]], SCREEN_WID, SCREEN_HEI
  CharacterWidth = cptr(byte ptr, @PP256font.p_data[PP256font.p_dataindex[FontChar]])
  width_result = CharacterWidth[0] \ 8
  x += width_result
Next
ScreenUnlock

End Sub

Sub AF2.Globe (Byval Xcenter as Single, Byval Ycenter as single, _
               Byval size as Integer, _
               Byval basecolor as Integer, _
               Byval start.brightness as Single, _
               Byval glow.increment as Single, _
               Byval radius as Single, _
               Byval buffer as any PTR = 0 )

Dim as Single Circ_col, Circ_col.min, Circ_col.max
Dim as Integer CircWrite

Circ_col = (basecolor * 16)
Circ_col.min = Circ_col
Circ_col.max = (Circ_col + 15)
Circ_col += start.brightness
If Circ_col <= Circ_col.min then Circ_col = Circ_col.min
If Circ_col >= Circ_col.max then Circ_col = Circ_col.max

For CircWrite = size to 0 step -1 
  If (buffer) then
    Circle buffer, (Xcenter, Ycenter), CircWrite, Circ_col, , , radius, F
  else
    Circle (Xcenter, Ycenter), CircWrite, Circ_col, , , radius, F
  End if
  Circ_col += glow.increment
  If Circ_col <= Circ_col.min then Circ_col = Circ_col.min
  If Circ_col >= Circ_col.max then Circ_col = Circ_col.max
Next

End Sub

Sub AF2.PP256fntSP_brightness (Byref text as String, _
                               Byval x as Single, Byval y as Single, _
                               Byval spacing as Single, _
                               Byval centered as Integer, _
                               Byval bright.level as Integer, _
                               Byref PP256font as ImageType, _
                               Byval SCREEN_WID as Integer, _
                               Byval SCREEN_HEI as Integer )

Dim as Integer FontChar, i, GFX_width
Dim as Single Centered_length, width_result
Dim as byte ptr CharacterWidth

If centered > 0 or centered = -1 then
  x = 0
  ScreenInfo GFX_width
  For i = 1 TO LEN(text)
    FontChar = ASC(MID$(text, i, 1)) - 32
    CharacterWidth = cptr(byte ptr, @PP256font.p_data[PP256font.p_dataindex[FontChar]])
    width_result = CharacterWidth[0] \ 8
    Centered_length += (width_result + spacing)
  Next
  x = (GFX_width - Centered_length) \ 2
End if

ScreenLock
For i = 1 TO LEN(text)
  FontChar = ASC(MID$(text, i, 1)) - 32
  AF2.SprBlit_brightness x, y, bright.level, @PP256font.p_data[PP256font.p_dataindex[FontChar]], SCREEN_WID, SCREEN_HEI
  CharacterWidth = cptr(byte ptr, @PP256font.p_data[PP256font.p_dataindex[FontChar]])
  width_result = CharacterWidth[0] \ 8
  x += (width_result + spacing)
Next
ScreenUnlock

End Sub



