#include "fbgfx.bi"
#include "customAFLib.bi"

CONST FALSE = 0
CONST TRUE = 1
const GFX_v = 640
const GFX_h = 480

DIM SHARED FullScreen, FMODStatus
DIM SHARED optionfade(4) AS INTEGER
DIM SHARED workpage
DIM SHARED Font1 AS ImageType
DIM SHARED st AS DOUBLE

OPEN "data/setup.dat" FOR INPUT AS #2
INPUT #2, FullScreen
INPUT #2, FMODStatus
CLOSE #2

'3D space screen related variables
' ---------------------------------------------
TYPE Point3D
        x       AS SINGLE           '3d x coord
        y       AS SINGLE           'ditto
        z       AS SINGLE           'ditto
        zvel    AS SINGLE           'ZVelocity
END TYPE

CONST LENS = 256                    'camera lens(FOV)
CONST XCENTER = 160                 'middle coords of screen 13
CONST YCENTER = 100                 'our center of projection
CONST MAXSTARS = 200                'number of stars
CONST MAXVEL = 2                    'Maximum speed of star

DIM SHARED Stars(MAXSTARS) AS Point3D           'the stars
' ---------------------------------------------

RANDOMIZE TIMER

FOR i = 0 TO UBOUND(Stars)
    Stars(i).x = -60 + INT(RND * 120)           'x
    Stars(i).y = -60 + INT(RND * 120)           'y
    Stars(i).z = INT(RND * 255)                 'z
    Stars(i).zvel = .3 + RND * MAXVEL           'speed of each star
NEXT i

screenres 640,480,8,2,0
SCREENSET 1, 0
SETMOUSE 50,50,0 ' Hides the mouse cursor.

AF2.InitSpr_PP256 Font1, "Graphics/charset1.fnt" 

AF2.InitPP256pal "Graphics/normal.pal" 

menupos = 1
KeyFree = FALSE

FOR copt = 1 TO 3
optionfade(copt) = 10
NEXT copt

DO
    
IF MULTIKEY(SC_UP) AND KeyFree = TRUE THEN 
menupos = menupos - 1
IF menupos<1 THEN menupos = 1
KeyFree = FALSE
END IF
IF MULTIKEY(SC_DOWN) AND KeyFree = TRUE THEN 
menupos = menupos + 1
IF menupos>3 THEN menupos = 3
KeyFree = FALSE
END IF

IF MULTIKEY(SC_ENTER) AND KeyFree = TRUE THEN
KeyFree = FALSE
SELECT CASE menupos
CASE 1
IF FullScreen = TRUE THEN
FullScreen = FALSE
ELSEIF FullScreen = FALSE THEN
FullScreen = TRUE
END IF
CASE 2
IF FMODStatus = TRUE THEN
FMODStatus = FALSE
ELSEIF FMODStatus = FALSE THEN
FMODStatus = TRUE
END IF
CASE 3
OPEN "data/setup.dat" FOR OUTPUT AS #2
PRINT #2, FullScreen
PRINT #2, FMODStatus
CLOSE #2
AF2.RemoveSpr Font1
END    
END SELECT
END IF

FOR copt = 1 TO 3
IF menupos<>copt THEN 
IF optionfade(copt)>10 THEN optionfade(copt) = optionfade(copt) - 5
IF optionfade(copt)<10 THEN optionfade(copt) = 10
END IF
' On the option where you currently are
' flag full brightness.
IF menupos=copt THEN
IF optionfade(copt)<42 THEN optionfade(copt) = optionfade(copt) + 5
IF optionfade(copt)>42 THEN optionfade(copt) = 42
END IF
NEXT copt

screenset workpage, workpage xor 1

AF2.ClearScreen 0 

        FOR i = 0 TO UBOUND(Stars)
            Stars(i).z = Stars(i).z + Stars(i).zvel     'move it
            
            IF Stars(i).z > 255 THEN                'check for camera LENS
                Stars(i).z = 0                      'ReInit Z value
            END IF

            sx! = Stars(i).x                        'StarX
            sy! = Stars(i).y                        'cleans the projectioon
            sz! = Stars(i).z                        'algo. ;*)
            Distance% = (LENS - sz!)                'get Distance
            IF Distance% THEN                       'if dist>0 then
                'Projection formula
                x% = XCENTER + (LENS * sx! / Distance%)
                y% = YCENTER - (LENS * sy! / Distance%)

            ELSE
                                        'do nothing
                                        'you wouldn't wan't to
                                        'divide by 0 would ya? :*)
            END IF
            clr% = sz!/24+164           ' modified sky blue color
                                        ' birghtness change according
                                        ' to the z distance(needs
                                        ' a gradient palette to work).
                                        'z=0 is the farthest
                                        'z=255 is the nearest
            PSET (x%, y%), clr%         'Draw each star

        NEXT i
        
flscr$ = "YES"
IF FullScreen = FALSE THEN flscr$ = "NO"
shut$ = "NO"
IF FMODStatus = FALSE THEN shut$ = "YES"

AF2.PP256fnt_brightness "* STAR CAGE SETUP *", 82, 65, 0, 22, Font1, GFX_v, GFX_h 

AF2.PP256fnt_brightness "FULL SCREEN MODE: "+flscr$, 73, 90, 0, optionfade(1), Font1, GFX_v, GFX_h 
AF2.PP256fnt_brightness "DISABLE SOUND&MUSIC: "+shut$, 73, 100, 0, optionfade(2), Font1, GFX_v, GFX_h 
AF2.PP256fnt_brightness "EXIT AND SAVE", 73, 110, 0, optionfade(3), Font1, GFX_v, GFX_h 

AF2.Scale2x_320x240

workpage xor = 1

do 
loop until timer& - st >= (1/65) 
st = timer& 

SLEEP 1 

IF MULTIKEY(SC_ENTER) OR MULTIKEY(SC_UP) OR MULTIKEY(SC_DOWN) THEN GOTO skipkeyrestore:
KeyFree = TRUE
skipkeyrestore:

    
LOOP