' Test program for proper ATN, COS and SIN
' adjustment in ship control.

#include "fbgfx.bi"
#include "customAFLib.bi"

DIM SHARED ShipSprite AS ImageType
DIM SHARED st as double

screenres 640,480,8,2,0
SCREENSET 1, 0
SETMOUSE 50,50,0 ' Hides the mouse cursor.

AF2.InitPP256pal "Graphics/normal.pal" 
AF2.InitSpr_PP256 ShipSprite, "Graphics/ships.spr"


' Starting values of the misc. target(emulates
' player's ship).
targetx = 170
targety = 170

' Ship's position.
shipx = 250
shipy = 200

' Ship sprite(4 - long ship with front laser
'             5 - spider like with double
'                 side lasers)
shipspr = 5

' Angle of the rotate ship sprite.
shipangle! = 135

DO

CLS

' Calculate the angle between the target
' and the ship in a fashion it's coherent
' with the 0 angle value in the sprite 
' rotation routine.
targetradangle! = ATN((targetx-shipx)/(targety-shipy))
' Convert this angle into degrees.
targetangle! = (targetradangle!* 180)/3.14159
' Bunch of "angle value fix" IF clauses due the 
' nature of the ATN function in BASIC.
' They were constructed by trial and error.
IF targetx > shipx THEN
IF targety < shipy THEN targetangle! = targetangle!*-1
IF targety > shipy THEN targetangle! = 180-targetangle!
END IF
IF targetx < shipx THEN 
IF targety < shipy THEN targetangle! = 360 - targetangle!
IF targety > shipy THEN targetangle! = 180 - targetangle!
END IF
IF targetangle! < 0 THEN targetangle! = 270
IF targetangle! = 0 AND targety>shipy THEN targetangle!=180

' The next lines tell the ship to rotate toward 
' the target. This is a stupid code but enough 
' for this test program.
IF shipangle!>targetangle! THEN shipangle!=shipangle!-1
IF shipangle!<targetangle! THEN shipangle!=shipangle!+1
IF shipangle!>359 THEN shipangle! = 0
IF shipangle!<0 THEN shipangle! = shipangle!+360

' Switch the ship and target angle back to
' radians(we'll only need the ship's angle).
shipradangle! = (shipangle! * 3.14159)/180
targeradangle! = (targetangle!* 3.14159)/180

sinang! = sin(shipradangle!)
cosang! = cos(shipradangle!)

LOCATE 2,1
PRINT "Target to ship angle:"; targetangle!
PRINT "Sin and cos of target angle:"; sinang!; cosang!

' Paste the sprite on position shipx and shipy.
AF2.SprBlit_rotate shipx, shipy, @ShipSprite.p_data[ShipSprite.p_dataindex[shipspr-1]], shipangle!

' Paste the target.
LINE (targetx-1, targety-1)-(targetx+1,targety+1), 47, B

' Paste the exit of a vertically up or down 
' cannon(s) - needed to test the exact
' starting positions of initiated projectiles.
'LINE (shipx+20*sin(shipradangle!)-1,shipy-20*cos(shipradangle!)-1)-(shipx+20*sin(shipradangle!)+1,shipy-20*cos(shipradangle!)+1), 79, B

' Paste the exit of a horizontally left or right 
' cannon(s).
LINE (shipx+6*COS(shipradangle!)-1,shipy+6*SIN(shipradangle!)-1)-(shipx+6*COS(shipradangle!)+1,shipy+6*SIN(shipradangle!)+1), 79, B
LINE (shipx-6*COS(shipradangle!)-1,shipy-6*SIN(shipradangle!)-1)-(shipx-6*COS(shipradangle!)+1,shipy-6*SIN(shipradangle!)+1), 79, B

' Paste the center of the rotated sprite.
LINE (shipx-1, shipy-1)-(shipx+1,shipy+1), 47, BF

' Move the target if a direction key is 
' pressed.
IF MULTIKEY(SC_LEFT) THEN targetx = targetx-1
IF MULTIKEY(SC_RIGHT) THEN targetx = targetx+1
IF MULTIKEY(SC_UP) THEN targety = targety-1
IF MULTIKEY(SC_DOWN) THEN targety = targety+1

do 
loop until timer& - st >= (1/35) 
st = timer& 

SLEEP 1

SCREENCOPY

LOOP UNTIL MULTIKEY(SC_ESCAPE)