
' Custom font printing demo with scrolling text, extra large
' font and a background all in 24 bit color depth mode.

' We include our font printing module for 24 bit color 
' depth mode.
#include "24bitcustomfont.bi"

#include "fbgfx.bi"
Using FB

const fpslimit = 40

' We declare 4 font arrays since we are going to load
' 4 fonts.
DIM SHARED Font1 AS FontType
DIM SHARED Font2 AS FontType
DIM SHARED Font3 AS FontType
DIM SHARED Font4 AS FontType
DIM SHARED bimage(1228900) AS INTEGER ' Memory buffer for our 
                                      ' background image.
DIM SHARED xmov AS INTEGER, sblender AS INTEGER
DIM SHARED workpage AS INTEGER

DIM SHARED frameintvl As Double = 1.0/fpslimit
DIM SHARED sleepintvl As Integer, st AS DOUBLE

' Sets a graphic mode (640*480) and 24 bit color depth mode.
SCREEN 18,24,2,0

' The following 4 lines load 4 24 bit fonts. The last
' line loads a font saved in 48*48 grid thus LoadBFont.
LoadFont "Fonts/24bitFNT3.bmp", Font1, 1
LoadFont "Fonts/24bitFNT2.bmp", Font2, 2
LoadFont "Fonts/24bitFNT52.bmp", Font3, 2
LoadBFont "Fonts/24bitBFNT1.BMP", Font4, 1

' This loads the background onto the screen and
' then into the bimage array.
BLOAD "DEMOBGR2.BMP",0
GET (0,0)-(639,479), bimage(0)

' Deafult scrolling text position (+320).
xmov = 0
' Deafult alpha blender (the equation text).
sblender = 200


' A simple loop that ends when the user pushes the
' ESCAPE key.
DO
    
st = Timer

screenlock
screenset workpage, workpage xor 1
 
' This moves the scrolling text. 
xmov = xmov + 5
IF xmov=1500 THEN xmov=0

' This changes the alpha blender used with the equation
' text if the user pushes PGUP or PGDOWN.
IF MULTIKEY(SC_PAGEUP) THEN sblender = sblender + 5
IF MULTIKEY(SC_PAGEDOWN) THEN sblender = sblender - 5
IF sblender>255 THEN sblender = 255
IF sblender<0 THEN sblender = 0

' This pastes the background.
PUT (0,0), bimage(0), PSET

' Font printing calls. First 2 parameters are the
' string's starting coordinates. Second last parameter
' sets the spacing while the last parameter sets 
' the mode of printing (1 - TRANS; 2 - PSET). 
' If you input any other number as the last parameter 
' the characters will be printed with TRANS.
PrintFont 120,20, "This demo uses the big font loading routine.", Font2, 1, 1
PrintFont 220,40, "Neat, eh?", Font1, 15, 1
PrintFont 640-xmov,140, "HUGE SCROLLING TEXT!!", Font4, 3, 1

' The next line prints text with translucency.
' The last parameter sets the alpha blender (ratio of translucency).
' Alpha blender in the next line is connected with a
' variable you can change by pressing PGUP or PGDOWN.
PrintAlphaFont 135,240, "(5*2)=(7+3)", Font4, 10, sblender

PrintFont 145,310, "Press PGUP and PGDOWN to change the", Font2, 1, 1
PrintFont 145,320, "translucency of the equation above.", Font2, 1, 1
PrintFont 270,430, "Press ESC to exit", Font3, 0, 1

workpage xor = 1
screenunlock

sleepintvl = Cint((st + frameintvl - Timer)*1000.0)
If sleepintvl>1 Then 
    Sleep sleepintvl
else 
    sleep 1
end if

LOOP UNTIL MULTIKEY(SC_ESCAPE)

END