''=============================================================================
''
''    Easy GL2D (FB.IMAGE compatible version)
''
''    By Relminator (Richard Eric M. Lope)
''    http://rel.betterwebber.com
''    
''    FAST Pixel Perfect Collision Detection
''    Uses the sofware surface to detect collisions
''    While using the hardware to draw
''
''=============================================================================

#pragma once





'' include needed libs
#include once "fbgfx.bi"
#include once "/gl/gl.bi" 
#include once "/gl/glu.bi"   

#include once "fbgl2d.bi"   
#include once "fbgl2d.bas" 


'' MYSOFT'S collision detection
'' Modified the 32 bit pixel check so account for
'' the way GL2D stores sprites in alpha mode
''
function Collide_sprites(OAX as integer, OAY as integer,OBJA as any ptr,  OBX as integer, OBY as integer, OBJB as any ptr) as integer
  dim as integer COLLI,TX,TY,RESULT,IBPP
  dim as integer OASX,OASY,OBSX,OBSY
  dim as integer OAXX,OAYY,OBXX,OBYY
  dim as integer APIT,BPIT,XCNT,YCNT
  dim as any ptr ASTRT,BSTRT,CSTRT
  OASX = cptr(fb.image ptr,OBJA)->width-1
  OASY = cptr(fb.image ptr,OBJA)->height-1
  OBSX = cptr(fb.image ptr,OBJB)->width-1
  OBSY = cptr(fb.image ptr,OBJB)->height-1
  OAXX = OAX+OASX:OAYY = OAY+OASY
  OBXX = OBX+OBSX:OBYY = OBY+OBSY
  APIT = cptr(fb.image ptr,OBJA)->PITCH
  BPIT = cptr(fb.image ptr,OBJB)->PITCH
  IBPP = cptr(fb.image ptr,OBJA)->BPP
  if IBPP = 1 then 
    IBPP = 0
  elseif IBPP = 2 then
    IBPP = 1
  elseif IBPP = 4 then
    IBPP = 2
  else
    return 0
  end if
  
  do    
    if OAX >= OBX and OAX <= OBXX then
      ' ********** 11 ***********
      if OAY >= OBY and OAY <= OBYY then 
        if OBXX > OAXX then TX = OAXX else TX = OBXX
        if OBYY > OAYY then TY = OAYY else TY = OBYY        
        ASTRT = OBJA + sizeof(fb.image) 
        BSTRT = OBJB + sizeof(fb.image) + _
        ((OAX-OBX) shl IBPP) + ((OAY-OBY)*BPIT)
        XCNT = (TX-OAX)+1:YCNT = (TY-OAY)+1
        APIT -= ((TX-OAX) shl IBPP)+(1 shl IBPP)
        BPIT -= ((TX-OAX) shl IBPP)+(1 shl IBPP)        
        RESULT = 11: exit do
      end if
      ' ********** >12< ***********
      if OAYY >= OBY and OAYY <= OBYY then 
        if OBXX > OAXX then TX = OAXX else TX = OBXX        
        ASTRT = OBJA + sizeof(fb.image) + ((OBY-OAY)*APIT)
        BSTRT = OBJB + sizeof(fb.image) + ((OAX-OBX) shl IBPP)
        XCNT = (TX-OAX)+1:YCNT = (OAYY-OBY)+1
        APIT -= ((TX-OAX) shl IBPP)+(1 shl IBPP)
        BPIT -= ((TX-OAX) shl IBPP)+(1 shl IBPP)        
        RESULT = 12: exit do
      end if
      ' *********** 13 *************
      if OAY <= OBY and OAYY >= OBYY then
        ASTRT = OBJA + sizeof(fb.image) + ((OBY-OAY)*APIT)
        BSTRT = OBJB + sizeof(fb.image) + ((OAX-OBX) shl IBPP)
        XCNT = (OBXX-OAX)+1:YCNT = OBSY+1
        APIT -= ((OBXX-OAX) shl IBPP)+(1 shl IBPP)
        BPIT -= ((OBXX-OAX) shl IBPP)+(1 shl IBPP)        
        RESULT = 13: exit do
      end if
    end if
    
    if OAXX >= OBX and OAXX <= OBXX then
      ' *********** <21> *************
      if OAY >= OBY and OAY <= OBYY then 
        if OBYY > OAYY then TY = OAYY else TY = OBYY        
        ASTRT = OBJA + sizeof(fb.image) + ((OBX-OAX) shl IBPP)
        BSTRT = OBJB + sizeof(fb.image) + ((OAY-OBY)*BPIT)
        XCNT = (OAXX-OBX)+1:YCNT = (TY-OAY)+1
        APIT -= ((OAXX-OBX) shl IBPP)+(1 shl IBPP)
        BPIT -= ((OAXX-OBX) shl IBPP)+(1 shl IBPP)        
        RESULT = 21: exit do
      end if
      ' *********** <22> ************
      if OAYY >= OBY and OAYY <= OBYY then
        ASTRT = OBJA + sizeof(fb.image) + _
        ((OASY-(OAYY-OBY))*APIT) + _
        ((OASX-(OAXX-OBX)) shl IBPP)
        BSTRT = OBJB + sizeof(fb.image)
        XCNT = (OAXX-OBX)+1:YCNT = (OAYY-OBY)+1
        APIT -= ((OAXX-OBX) shl IBPP)+(1 shl IBPP)
        BPIT -= ((OAXX-OBX) shl IBPP)+(1 shl IBPP)        
        RESULT = 22: exit do
        ' *********** <23> ************
      end if
      if OAY <= OBY and OAYY >= OBYY then
        ASTRT = OBJA + sizeof(fb.image) + _
        ((OBY-OAY)*APIT) + ((OBX-OAX) shl IBPP)
        BSTRT = OBJB + sizeof(fb.image)
        XCNT = (OAXX-OBX)+1:YCNT = OBSY+1
        APIT -= ((OAXX-OBX) shl IBPP)+(1 shl IBPP)
        BPIT -= ((OAXX-OBX) shl IBPP)+(1 shl IBPP)        
        RESULT = 23: exit do
      end if
    end if
    
    if OAX <= OBX and OAXX >= OBXX then
      ' ********** <31> *************
      if OAY >= OBY and OAY <= OBYY then
        ASTRT = OBJA + sizeof(fb.image) + ((OBX-OAX) shl IBPP)
        BSTRT = OBJB + sizeof(fb.image)  + ((OAY-OBY)*BPIT)
        XCNT = OBSX+1:YCNT = (OBYY-OAY)+1
        APIT -= ((OBSX) shl IBPP)+(1 shl IBPP)
        BPIT -= ((OBSX) shl IBPP)+(1 shl IBPP)        
        RESULT = 31: exit do
      end if
      ' ********** <32> *************
      if OAYY >= OBY and OAYY <= OBYY then 
        ASTRT = OBJA + sizeof(fb.image) + _
        ((OBY-OAY)*APIT) + ((OBX-OAX) shl IBPP)
        BSTRT = OBJB + sizeof(fb.image)
        XCNT = OBSX+1:YCNT = (OAYY-OBY)+1
        APIT -= ((OBSX) shl IBPP)+(1 shl IBPP)
        BPIT -= ((OBSX) shl IBPP)+(1 shl IBPP)        
        RESULT = 32: exit do
      end if
      ' ********** <33> *************
      if OAY <= OBY and OAYY >= OBYY then
        ASTRT = OBJA + sizeof(fb.image) + _
        ((OBY-OAY)*APIT) + ((OBX-OAX) shl IBPP)
        BSTRT = OBJB + sizeof(fb.image)
        XCNT = OBSX+1:YCNT = OBSY+1
        APIT -= ((OBSX) shl IBPP)+(1 shl IBPP)
        BPIT -= ((OBSX) shl IBPP)+(1 shl IBPP)        
        RESULT = 33: exit do
      end if
    end if
    return 0    
  loop 
  
  if XCNT then    
    select case IBPP
    case 0
      ' ******** 8 bpp pixel check ******
      asm      
        mov ESI,[ASTRT]
        mov EDI,[BSTRT]
        mov EAX,[APIT]
        mov EBX,[XCNT]
        mov EDX,[YCNT]      
        _CPNEXTLINE8_:
        mov ECX,EBX
        _CPNEXTPIXEL8_:
        cmp byte ptr [ESI],0        
        je _CPSKIPPIXEL8_
        cmp byte ptr [EDI],0        
        je _CPSKIPPIXEL8_
        jmp _CPENDCOLISION8_
        _CPSKIPPIXEL8_:
        inc ESI
        inc EDI
        dec ECX
        jnz _CPNEXTPIXEL8_
        add ESI,EAX
        add EDI,[BPIT]
        dec EDX
        jnz _CPNEXTLINE8_     
        neg dword ptr [RESULT]
        _CPENDCOLISION8_:
      end asm
    case 1
      ' ******** 16 bpp pixel check ******
      asm      
        mov ESI,[ASTRT]
        mov EDI,[BSTRT]        
        mov EBX,[XCNT]
        mov EDX,[YCNT]
        mov EAX,[APIT]
        _CPNEXTLINE16_:
        mov ECX,EBX        
        _CPNEXTPIXEL16_:        
        cmp word ptr [ESI],0xF81F
        je _CPSKIPPIXEL16_
        cmp word ptr [EDI],0xF81F
        je _CPSKIPPIXEL16_              
        jmp _CPENDCOLISION16_
        _CPSKIPPIXEL16_:
        add ESI,2
        add EDI,2
        dec ECX
        jnz _CPNEXTPIXEL16_
        add ESI,EAX        
        add EDI,[BPIT]
        dec EDX
        jnz _CPNEXTLINE16_     
        neg dword ptr [RESULT]
        _CPENDCOLISION16_:
      end asm
    case 2
      ' ******** 32 bpp pixel check ******
      asm      
        mov ESI,[ASTRT]
        mov EDI,[BSTRT]
        mov EBX,[XCNT]
        mov EDX,[YCNT]
        mov EAX,[APIT]
        _CPNEXTLINE32_:
        mov ECX,EBX
        _CPNEXTPIXEL32_:
        cmp dword ptr [ESI],0x00FF00FF
        je _CPSKIPPIXEL32_
        cmp dword ptr [EDI],0x00FF00FF
        je _CPSKIPPIXEL32_      
        jmp _CPENDCOLISION32_
        _CPSKIPPIXEL32_:      
        add ESI,4
        add EDI,4
        dec ECX
        jnz _CPNEXTPIXEL32_
        add ESI,EAX
        add EDI,[BPIT]
        dec EDX
        jnz _CPNEXTLINE32_     
        neg dword ptr [RESULT]
        _CPENDCOLISION32_:
      end asm    
    end select
  end if
  
  return RESULT
  
end function

#ifndef FALSE 
const as integer FALSE = 0
const as integer TRUE = not FALSE
#endif

dim as integer limit_fps = FALSE

print "Limit FPS? Y/N"

dim as string k = ucase(input(1))

select case k
	case "Y"
		limit_fps = TRUE
	case "N"
		limit_fps = FALSE
End Select

const SCR_WIDTH = 640
const SCR_HEIGHT = 480

const as single PI = atn(1)*4
'' set up textures

dim as single time_start = 0
dim demosecs as integer
demosecs = 0

'' initialize gl2d
gl2d.screen_init( SCR_WIDTH, SCR_HEIGHT )

using FB



screencontrol ( SET_WINDOW_TITLE  , "FB.IMAGE compatible Easy GL2D by Relminator" )

dim as integer frames_per_sec = 0
dim as integer fps = 0

'' UNREM Enable antialias
'  GL2D.enable_antialias()



if limit_fps then
	gl2d.vsync_on()
end if


''===================== FB EXAMPLE FILE TEST ===============================================
'' Got this sprite in the CHM examples
	
	'' make a standard FB image
	dim as any ptr bg = imagecreate(SCR_WIDTH, SCR_HEIGHT, RGBA(0,0,0,255))
	
	dim img as fb.image ptr = imagecreate( 32, 32, rgb(255, 0, 255), 32 )
	circle img, (16, 16), 15, rgb(255, 255, 0),     ,     , 1, f
	circle img, (10, 10), 3,  rgb(  0,   0, 0),     ,     , 2, f
	circle img, (23, 10), 3,  rgb(  0,   0, 0),     ,     , 2, f
	circle img, (16, 18), 10, rgb(  0,   0, 0), 3.14, 6.28

	'' load the sprite to HW (SW data still remains for whatever purposes you want)
	'' Pixel perfect collision FTW!!!
	gl2d.load_image_to_HW(cast(gl2d.image ptr, img))
''================= END FB EXAMPLE FILE TEST ===============================================



dim as integer xa, ya, xb, yb

xa = 100
ya = 100

xb = 200
yb = 100

do
	
	frames_per_sec += 1
	
	'' clear buffer
	gl2d.clear_screen()
	
	'' normal color
	glColor4ub(255,255,255,255)

	
	
	glColor4ub(255,255,255,255)
	
	
	
	gl2d.set_blend_mode(GL2D.E_TRANS)
	
	gl2d.sprite(xb,yb,cast(gl2d.image ptr,img))

	gl2d.sprite(xa,ya,cast(gl2d.image ptr,img))


	'gl2d.box(xa,ya,xa+img->width,ya+img->height, GL2D_RGBA(255,255,255,255))


	dim as single timer_elapsed = (timer - demosecs)
	time_start =  timer
	if timer_elapsed > 1 then 
		fps = frames_per_sec/timer_elapsed
		frames_per_sec = 0
	    demosecs = timer
	end if
	
	
	'' Test print
	gl2d.set_blend_mode(GL2D.E_TRANS)   '' blended
	glColor4ub(255,255,255,255)  '' no transluceny
	gl2d.print_scale(0, 10,1.5, "Fast Pixel-Perfect Collision FPS = " + str(fps))
	
	gl2d.print_scale(0, 25,2, "Use arrow keys to move")
	
	dim as integer collide = collide_sprites( xa, ya, img, xb,yb, img) > 0
	
	gl2d.print_scale(0, 50,2, "collision = " + str(collide))
	
	
	if multikey(SC_LEFT ) and xa >   0 then xa = xa - 1
    if multikey(SC_RIGHT) and xa < 639 then xa = xa + 1
    if multikey(SC_UP   ) and ya >   0 then ya = ya - 1
    if multikey(SC_DOWN ) and ya < 479 then ya = ya + 1

    flip
    
    
	sleep 1,1
Loop Until Multikey( FB.SC_ESCAPE ) 



'' destroy da happy face
gl2d.destroy_image(cast(gl2d.image ptr,img))
gl2d.destroy()


'' Reset screen and test the sprite in
'' FBGFX mode
screenres 640, 480, 32

cls

Print "Back in FBGFX"
put(100,100), img, trans

sleep
sleep

end


