''=============================================================================
''
''    Easy GL2D
''    By Relminator (Richard Eric M. Lope)
''    http://rel.betterwebber.com
''    
''    An easy to use OpenGL 2d lib
''    As easy as fbgfx (easier IMHO if you use my Texture packer)
''    
''    Can automatically load BMP's supported by BLOAD
''    Adds alpha transparency if you want
''    No external dependencies (only uses OpenGL/GLU and FBGFX)
''    Source license is "use or abuse"
''
''=============================================================================


#pragma once

'' include needed libs
#include once "fbgfx.bi"
#include once "/gl/gl.bi" 
#include once "/gl/glu.bi"   


'' safety
namespace GL2D

'' enums for blending options
enum E_BLEND_MODE

	E_TRANS = 0,
	E_SOLID,
	E_BLENDED,
	E_GLOW,
	E_BLACK

end enum

enum E_FLIP_MODE

	E_NONE = 0,
	E_V,
	E_H,
	E_VH
	
end enum

''=============================================================================
''
''    Some helpful macros for FB.IMAGE type
''    For GL2D primitives that accepts color(GLuint)
''    Use GL2D_RGBA( r, g, b, a ) as FB is and GL are reversed endians
''
''=============================================================================	
#define ARGB_A(u) (((u) shr 24) and &H000000FF)
#define ARGB_R(u) (((u) shr 16) and &H000000FF)
#define ARGB_G(u) (((u) shr 8)  and &H000000FF)
#define ARGB_B(u) (((u) shr 0)  and &H000000FF)
#define ARGB( r, g, b, a )   rgba( (b), (g), (r), (a) )
#define GL2D_RGBA( r, g, b, a )   rgba( (b), (g), (r), (a) )


''=============================================================================
''
''    Our sprite datatype
''
''=============================================================================
type Tglsprite
	public:
	width		as integer		'' width-1 of the sprite
	height		as integer
	u_off		as single		'' texture atlas offset
	v_off		as single
	u_width		as single		'' width in texture space
	v_height 	as single
	textureID	as GLuint		'' texture ID for speed and ease of interface
end type

declare sub vsync_on()

declare sub start_2d(byval wid as integer, byval hei as integer)

declare sub end_2d()  

declare sub screen_init(byval screen_wid as integer, byval screen_hei as integer, byval flags as integer = 0)

declare sub set_blend_mode(byval blend_mode as E_BLEND_MODE)

declare sub enable_antialias(byval switch as integer = 1)

declare sub clear_screen()

declare sub put_pixel( byval x as integer, byval y as integer, byval gl2dcolor as GLuint )

declare sub line_2d( byval x1 as integer, byval y1 as integer, byval x2 as integer, byval y2 as integer, byval gl2dcolor as GLuint )

declare sub box( byval x1 as integer, byval y1 as integer, byval x2 as integer, byval y2 as integer, byval gl2dcolor as GLuint )

declare sub box_filled( byval x1 as integer, byval y1 as integer, byval x2 as integer, byval y2 as integer, byval gl2dcolor as GLuint )

declare sub box_filled_gradient( byval x1 as integer, byval y1 as integer,_
						 byval x2 as integer, byval y2 as integer,_
						 byval gl2dcolor1 as GLuint,_
						 byval gl2dcolor2 as GLuint,_
						 byval gl2dcolor3 as GLuint,_
						 byval gl2dcolor4 as GLuint )

declare sub triangle( byval x1 as integer, byval y1 as integer, byval x2 as integer, byval y2 as integer,_
			  byval x3 as integer, byval y3 as integer, byval gl2dcolor as GLuint )

declare sub triangle_filled( byval x1 as integer, byval y1 as integer, byval x2 as integer, byval y2 as integer,_
			         byval x3 as integer, byval y3 as integer, byval gl2dcolor as GLuint )

declare sub triangle_filled_gradient( byval x1 as integer, byval y1 as integer,_ 
							  byval x2 as integer, byval y2 as integer,_
			                  byval x3 as integer, byval y3 as integer,_
			                  byval gl2dcolor1 as GLuint, byval gl2dcolor2 as GLuint, byval gl2dcolor3 as GLuint )

declare sub circle_2d(byval x as integer, byval y as integer, byval radius as integer, byval gl2dcolor as GLuint)

declare sub circle_2d_filled(byval x as integer, byval y as integer, byval radius as integer, byval gl2dcolor as GLuint )

declare sub ellipse(byval x as single, byval y as single, byval a as single, byval b as single, byval angle as single, byval gl2dcolor as GLuint )

declare sub ellipse_filled(byval x as single, byval y as single, byval a as single, byval b as single, byval angle as single, byval gl2dcolor as GLuint )

declare sub sprite( byval x as integer, byval y as integer, byref image as const Tglsprite)

declare sub sprite_flip( byval x as integer, byval y as integer, byval mode as E_FLIP_MODE, byref image as const Tglsprite)

declare sub sprite_scale( byval x as integer, byval y as integer, byval scale as single, byref image as const Tglsprite)

declare sub sprite_rotate( byval x as integer, byval y as integer, byval angle as integer,  byref image as const Tglsprite)

declare sub sprite_rotate_scale( byval x as integer, byval y as integer, byval angle as integer, byval scale as single, byref image as const Tglsprite)

declare sub sprite_stretch( byval x1 as integer, byval y1 as integer,_
					byval x2 as integer, byval y2 as integer,_
					byref image as const Tglsprite)

declare sub sprite_stretch_on_quad( byval x1 as integer, byval y1 as integer,_
							byval x2 as integer, byval y2 as integer,_
							byval x3 as integer, byval y3 as integer,_
							byval x4 as integer, byval y4 as integer,_
							byref image as const Tglsprite)

declare sub sprite_stretch_h( byval x as integer, byval y as integer, byval length as integer, byref image as const Tglsprite )

declare sub line_glow ( byval x1 as single, byval y1 as single, byval x2 as single, byval y2 as single,_
				byval lwidth as single, byval mycolor as GLuint)

declare sub print_scale(byval x as integer, byval y as integer,byval scale as single, byref text as const string)

declare function load_image( byval image as any ptr, byval filter_mode as GLuint = GL_NEAREST ) as GLuint

declare function load_image_24bit_alpha( byval image as any ptr, byval filter_mode as GLuint = GL_NEAREST ) as GLuint

declare function load_image_8bit_alpha( byval image as any ptr, byval filter_mode as GLuint = GL_NEAREST ) as GLuint

declare function load_BMP_to_texture(byref filename as string) as GLuint

declare function load_BMP_to_glsprite(byref filename as string) as Tglsprite

declare sub init_sprites(spriteset() as Tglsprite, texcoords() as uinteger,_
				 byval wid as integer, byval hei as integer,_
				 byval textureID as GLuint)

declare sub destroy_sprites(spriteset() as Tglsprite)

declare sub destroy()

declare function fps_limit(byval max_FPS as single) as single


end namespace



