#pragma once



'' include needed libs
#include once "fbgfx.bi"
#include once "/gl/gl.bi" 
#include once "/gl/glu.bi"   

#include once "gl2d.bi"   
#include once "gl2d.bas" 

'' include headers automatically generated by
'' Rel's texture packer
#include once "uvcoord_texturepack.bi"
#include once "uvcoord_bg_8bit.bi"


'' just a simple sub to draw our BG tiles
declare sub draw_bg( images() as GL2D.Tglsprite )

#ifndef FALSE 
const as integer FALSE = 0
const as integer TRUE = not FALSE
#endif

dim as integer limit_fps = FALSE

print "Limit FPS? Y/N"

dim as string k = ucase(input(1))

select case k
	case "Y"
		limit_fps = TRUE
	case "N"
		limit_fps = FALSE
End Select

const SCR_WIDTH = 640
const SCR_HEIGHT = 480

const as single PI = atn(1)*4
'' set up textures
dim as GLuint texture
dim as GLuint texture_bg


dim as single time_start = 0
dim demosecs as integer
demosecs = 0

'' initialize gl2d
gl2d.screen_init( SCR_WIDTH, SCR_HEIGHT )

'' example of loading a BMP directly to a sprite	
dim as GL2D.Tglsprite sprite_sheet = gl2d.load_bmp_to_glsprite("images/texturepack.bmp")
'' example of loading a BMP to a spriteset
'' 24 bit
texture =  gl2d.load_bmp_to_texture("images/texturepack.bmp")
'' 8 bit (same call)
texture_bg =  gl2d.load_bmp_to_texture("images/bg_8bit.bmp")


'' set up dynamic array to hold our images
redim as GL2D.Tglsprite images(0)
redim as GL2D.Tglsprite bgs(0)

'' init spritesheets
gl2d.init_sprites(images(),texturepack_texcoords(),TEXTUREPACK_BITMAP_WIDTH,TEXTUREPACK_BITMAP_HEIGHT,texture)
gl2d.init_sprites(bgs(),bg_8bit_texcoords(),BG_8BIT_BITMAP_WIDTH,BG_8BIT_BITMAP_HEIGHT,texture_bg)



using FB



screencontrol ( SET_WINDOW_TITLE  , "Easy GL2D Proof of Concept by Relminator" )

dim as integer frame = 0
dim as integer x, y, sprite_frame

sprite_frame = 0
dim as integer frames_per_sec = 0
dim as integer fps = 0

'' UNREM Enable antialias
'  GL2D.enable_antialias()



if limit_fps then
	gl2d.vsync_on()
end if

do
	
	frames_per_sec += 1
	frame += 1
	if ( (frame and 7) = 0 ) then
		sprite_frame += 1
		if sprite_frame > 2 then sprite_frame = 0
	endif
	
	x = ( ((cos(frame/140) + sin(frame/110)) * (SCR_WIDTH\5)))
	y = ( ((sin(-frame/120) + sin(frame/60)) * (SCR_HEIGHT\5)))
	
	
	'' clear buffer
	gl2d.clear_screen()
	
	'' normal color
	glColor4ub(255,255,255,255)

	
	
	'' draw BG in solid mode
	gl2d.set_blend_mode(GL2D.E_SOLID)
	
	'' draw bg
	draw_bg(bgs())


	'' circle test
	gl2d.circle_2d_filled(100,100,150-abs(sin(frame/25)*150),GL2D_RGBA(0,255,0,255))
	gl2d.circle_2d(100,100,abs(sin(frame/25)*150),GL2D_RGBA(255,255,0,255))
	
	'' Draw black box
	gl2d.set_blend_mode(GL2D.E_SOLID)
	
	GL2D.box_filled(400,40,639,479,GL2D_RGBA(0,0,0,0))

	'' ellipse test
	gl2d.set_blend_mode(GL2D.E_BLENDED)	
	gl2d.ellipse(320, 240, 50, 200, PI/6*5, GL2D_RGBA(255, 128, 64, 255))
	gl2d.ellipse_filled(320, 240, 10+abs(sin(frame/25)*250), 10+250-abs(sin(frame/25)*250), frame/65, GL2D_RGBA(255, 128, 64, 255))

	'' transparency drawing
	gl2d.set_blend_mode(GL2D.E_TRANS)
	gl2d.sprite(0,0,sprite_sheet)
	
	dim as single scale = abs(sin(frame/20))
	gl2d.sprite_scale(310,30,scale*3,images(81))
	
	'' return to solid for kicks
	gl2d.set_blend_mode(GL2D.E_SOLID)		
	gl2d.sprite(280,30,images(81))
	    
	
	''' transparent again
	gl2d.set_blend_mode(GL2D.E_TRANS)
	gl2d.sprite(310,30,images(81))
	
	
	
	gl2d.sprite(230,300,images(88))
	
	
	'' flipped and shadow test
	dim as integer f = 82	
	gl2d.sprite_flip(50,400,GL2D.E_NONE,images(87 + sprite_frame))
	gl2d.sprite_flip(50+images(f).width,400,GL2D.E_H,images(87 + sprite_frame))
	glColor4ub(255,255,255,64) '' blend with /14 opacity for shadow fx
	gl2d.set_blend_mode(GL2D.E_BLENDED)
	gl2d.sprite_flip(50,400+images(f).height,GL2D.E_V,images(87 + sprite_frame))
	gl2d.sprite_flip(50+images(f).width,400+images(f).height,GL2D.E_VH,images(87 + sprite_frame))
	
	
	'' stretch_h test
	gl2d.set_blend_mode(GL2D.E_TRANS)		
	gl2d.sprite_stretch_h(10,290, images(14).width + abs(sin(frame/30)*400), images(14) )
	
	''' glow
	gl2d.set_blend_mode(GL2D.E_GLOW)
	gl2d.sprite(230,330,images(88))
	gl2d.sprite(230,330,images(88))
	gl2d.sprite(230,330,images(88))
	
	
	glColor4ub(255,255,255,200)  '' 200/256 translucency
	'' alpha blended
	gl2d.set_blend_mode(GL2D.E_BLENDED)
	gl2d.sprite(200,200,images(32))
	
	gl2d.sprite(200,400,images(81))
	
	
	'' transparent
	gl2d.set_blend_mode(GL2D.E_TRANS)
	gl2d.sprite_rotate(SCR_WIDTH\2,SCR_HEIGHT\2,frame*3,images(30))
	    
	'' alpha blended
	gl2d.set_blend_mode(GL2D.E_BLENDED)
	gl2d.sprite_rotate_scale(SCR_WIDTH\2,SCR_HEIGHT\2,frame*3,5-scale*5,images(30))
	gl2d.sprite_rotate(SCR_WIDTH\2 + 30,SCR_HEIGHT\2,-frame*3,images(30))
	
	'' black mode
	glColor4ub(255,255,255,255)
	gl2d.set_blend_mode(GL2D.E_BLACK)
	gl2d.sprite(30,130,images(81))
	
	
	'' color mode
	glColor4ub(255,0,0,255)
	gl2d.set_blend_mode(GL2D.E_TRANS)
	gl2d.sprite(130,130,images(81))
	
	gl2d.set_blend_mode(GL2D.E_BLENDED)
	gl2d.sprite(230,130,images(81))
	
	glColor4ub(255,0,255,255)
	gl2d.set_blend_mode(GL2D.E_GLOW)
	gl2d.sprite(30,330,images(32))

	'' free stretching test
	dim as integer x1 = (SCR_WIDTH\2+200) + x\2
	dim as integer x2 = (SCR_WIDTH\2+200) - x\2
	dim as integer y1 = (SCR_HEIGHT\2) + y\2
	dim as integer y2 = (SCR_HEIGHT\2) - y\2
	glColor4ub(255,255,255,255)
	gl2d.set_blend_mode(GL2D.E_TRANS)
	gl2d.sprite_stretch(x1, y1, x2, y2,images(81))

	
	'' back to standard coloring
	'' and draw our animated sprite
	glColor4ub(255,255,255,128)		'' factor of 128 blending
	'' trans
	gl2d.set_blend_mode(GL2D.E_TRANS)
	gl2d.sprite((SCR_WIDTH\2) + x,(SCR_HEIGHT\2) + y,images(87 + sprite_frame))
	'' blended
	gl2d.set_blend_mode(GL2D.E_BLENDED)
	gl2d.sprite((SCR_WIDTH\2) - x,(SCR_HEIGHT\2) + y,images(87 + sprite_frame))
	'' green colored blended by 128/256
	glcolor4ub(0,255,0,128)
	gl2d.sprite((SCR_WIDTH\2) - x,(SCR_HEIGHT\2) - y,images(87 + sprite_frame))
	'' back to trans but colored
	gl2d.set_blend_mode(GL2D.E_TRANS)
	gl2d.sprite((SCR_WIDTH\2) + x,(SCR_HEIGHT\2) - y,images(87 + sprite_frame))
	
	
	'' test gradient box
	GL2D.box_filled_gradient(420,350,560,460,_
			   			  	 GL2D_RGBA(0,255,255,255),_
							 GL2D_RGBA(255,255,0,255),_
							 GL2D_RGBA(255,255,255,255),_
							 GL2D_RGBA(255,0,255,255))
	
	
	
    gl2d.set_blend_mode(GL2D.E_GLOW)
    ' draw 3 blended lines with decreasing widths to
    ' make the effect  better.
	gl2d.line_glow (320,290,620,290,20,GL2D_RGBA(128,32,225,128))
	gl2d.line_glow (320,290,620,290,15,GL2D_RGBA(128,32,225,200))
	gl2d.line_glow (320,290,620,290,10,GL2D_RGBA(128,32,225,255))

	''  draw just a single glowline
	gl2d.line_glow (320,290,620,425,40,GL2D_RGBA(255,32,2,255))
	
	'' draw a solid line
	gl2d.line_2d (620,290,620,425,GL2D_RGBA(255,255,0,255))

	gl2d.set_blend_mode(GL2D.E_SOLID)
	
	'' box
	GL2D.box(400,40,639,479,GL2D_RGBA(220,255,55,0))
	
	'' triangle test
	gl2d.triangle(480,100,630,50,560,200,GL2D_RGBA(25,2,255,255))
	GL2D.Triangle_filled(490,105,610,60,590,135,GL2D_RGBA(255,255,255,255))
	
	glColor4ub(255,255,255,64)		'' factor of 64/256 blending
	gl2d.set_blend_mode(GL2D.E_BLENDED)
	GL2D.Triangle_filled_gradient(290,150,510,60,490,135,_
								  GL2D_RGBA(0,255,255,255),_
								  GL2D_RGBA(255,255,0,255),_
								  GL2D_RGBA(255,0,255,255))
	
	gl2d.set_blend_mode(GL2D.E_SOLID)  '' back to solid
	glColor4ub(255,255,255,255)		'' Opaque again
	'' pset test
	for i as integer = 0 to 359 step 10
		dim as integer px = 20 * cos(i*PI/180)
		dim as integer py = 20 * sin(i*PI/180)
		gl2d.put_pixel(430+px,70+py,GL2D_RGBA(255,2,255,255))
	next i
	
	
	gl2d.set_blend_mode(GL2D.E_GLOW)
	'' glow lines on steroids
	for i as integer = frame to 359+frame step 20
		dim as integer px = 120 * cos(i*PI/180)
		dim as integer py = 120 * sin(i*PI/180)
		dim as integer px2 = 120 * cos((i+20)*PI/180)
		dim as integer py2 = 120 * sin((i+20)*PI/180)
		dim as integer adder = abs(7*sin(frame/20))
		for j as integer= 0 to adder
			gl2d.line_glow (320+px,240+py,320+px2,240+py2,20-(adder*2),GL2D_RGBA(255+frame,255-frame,128+frame,255))
		next j
	next i

	
	dim as single timer_elapsed = (timer - demosecs)
	time_start =  timer
	if timer_elapsed > 1 then 
		fps = frames_per_sec/timer_elapsed
		frames_per_sec = 0
	    demosecs = timer
	end if
	
	
	'' Test print
	gl2d.set_blend_mode(GL2D.E_BLENDED)   '' blended
	glColor4ub(255,255,0,128)  '' 1/2 transluceny
	gl2d.print_scale(40, 10,2, "Easy GL2D by Relminator    FPS = " + str(fps))


    flip
    
    
	sleep 1,1
Loop Until Multikey( FB.SC_ESCAPE ) 


gl2d.destroy_sprites(images())
gl2d.destroy_sprites(bgs())

gl2d.destroy()

end


'' A little sub to draw the BG
sub draw_bg( images() as GL2D.Tglsprite )
	
	const as integer index = 1
	dim as integer tiles_x = SCR_WIDTH\images(index).width 
	dim as integer tiles_Y = SCR_HEIGHT\images(index).height 
	
	gl2d.set_blend_mode(GL2D.E_SOLID)
			
	for y as integer = 0 to tiles_y
		for x as integer = 0 to tiles_x
			gl2d.sprite(x * images(index).width,y * images(index).height,images(index))
		next x
	next y
	
end sub
