' Compiler: FreeBASIC (compilable in version 0.18.3b)
'*********************************************************************
'*********Richard Eric Lope's Pixel By Pixel Scrolling Engine*********
'*********************************************************************
'            THIS IS NOT A GAME DEMO BUT A SCROLLING ENGINE
'*********************************************************************
' The purpose of this scrolling engine is to enable people to create 
' nice games in it and therefore is fully commented. It's especially 
' meant for those who coded in QBasic and have troubles in switching 
' to FreeBASIC. Beside being a scrolling engine this is a really nice
' GFXLib 2 example program. OpenGL freaks and others will not be 
' interested in this. This scrolling engine is made using GFXlib 2 
' graphic statements and does not rely on any other library. Still, 
' it can be altered to work with Allegro or SDL (I assume) video 
' functions, but currently I'm not interested to port it to any 
' other library. The original scrolling engine was made in QBasic using 
' RelLib by R.E.Lope in order to show the powers of the mentioned 
' library. The FreeBASIC port is done by me (Lachie Dazdarian) with
' the usage of some C.Chadwick's code (custom font text printing 
' routine) ported to FreeBASIC, and Mysoft's pixel perfect collision
' function.

' Send comments and additions to lachie@yahoo.com or visit
' http://games.freebasic.net/forum
'**********************************************************************

#include "fbgfx.bi"
#include "mysoft_collision.bi"
#include "24bitcustomfont.bi"
USING FB

' SpriteType is used to hold character related data (from the player
' to NPCs).
TYPE SpriteType
         Typ            AS INTEGER    ' Character ID (used with NPCs).
         X              AS SINGLE     ' World X position of the character.
         Y              AS SINGLE     ' World Y position of the character.
         XV             AS SINGLE     ' X Speed of the character.
         YV             AS SINGLE     ' Y speed of the character.
         Frame          AS INTEGER    ' Used to display the proper image of the character from the PUT file.
         Move           AS INTEGER    ' Used to flag if the character moving.
         RANGE          AS INTEGER    ' Not used!
         Active         AS INTEGER    ' Not used!
         HIT            AS INTEGER    ' Not used!
         AI             AS INTEGER    ' Not used!
         MONEY          AS INTEGER    ' Not used!
         HP             AS INTEGER    ' Not used!
         ITEM           AS INTEGER    ' Not used!
         Direction      AS INTEGER    ' Used to flag the direction of the character.
         TileX          AS INTEGER    ' Tiles on which the character is.
         TileY          AS INTEGER     
         
         OldX           AS INTEGER    ' Used with character to
         OldY           AS INTEGER    ' to character collision to
                                      ' restore the old positions of
                                      ' colliding characters
                                      ' (ie, player to NPC collision).
         Exists AS INTEGER
END TYPE

' Used to hold the data related to scrolling (camera position, etc).
TYPE LevelType
        Xmax    AS INTEGER     ' Maximum number of tiles a map has.
        Ymax    AS INTEGER 
        CamX    AS INTEGER     ' Pixel*Pixel camera Position.
        CamY    AS INTEGER 
        TileX   AS INTEGER     ' Tile postion of the camera.
        TileY   AS INTEGER     ' Calculated by CamX\TileSize.
        Xpos    AS INTEGER     ' Pixel position inside the tile
        Ypos    AS INTEGER     ' 0 to 19 (used to enable pixel by 
                               ' pixel scrolling).
END TYPE

TYPE MapLayerType
       BaseL    AS INTEGER          ' Base Layer - Implemented
       FringeL  AS INTEGER          ' Fringe Layer - Not Implemented
       ObjectL  AS INTEGER          ' Object Layer - Not Implemented
END TYPE

DECLARE FUNCTION EngineTileCollide (Character AS SpriteType) AS INTEGER ' Sub used to check collision with tiles.
DECLARE SUB EngineDrawPlayer (Player AS SpriteType) ' Sub used to draw our hero on the screen.
DECLARE SUB EngineDrawScreen () ' Sub used to draw all our stuff on the screen and to control the page flipping.
DECLARE SUB AINPC (currentNPC AS INTEGER)   ' Sub used to move and control the movement of NPCs.
DECLARE SUB EngineDrawNPC ()    ' Sub used to draw the NPCs.
DECLARE SUB InitVariables ()    ' This sub is used to initate various variables (player's starting position, etc).
DECLARE SUB EngineDrawMap ()    ' Sub used to draw our map on the screen (paste the tiles).
DECLARE SUB InitMap (mapcon AS STRING)    ' This sub loads our map in the Map array (used in Engine.DrawMap sub).
DECLARE SUB EngineUpdatePlayer (Player AS SpriteType, Direction AS INTEGER) ' Sub used to update the position of the player.
DECLARE SUB EngineUpdateCamera (Level AS LevelType, Player AS SpriteType) ' Sub used to update the position of the camera.
DECLARE SUB Main ()        ' Main loop where the statements for the player controls are.
DECLARE SUB MainScreen ()  ' Extra sub for the title screen.
DECLARE SUB LoadTiles (tilesfile AS STRING) ' Sub for loading tiles (called with a tiles bmp file).
DECLARE SUB DestroyTiles ' Sub for destroying tile image buffers.
DECLARE SUB LoadSprites  ' Sub for loading sprites.
DECLARE SUB DestroySprites ' Sub for destroying sprites image buffers.
DECLARE SUB LoadScript (script_file AS STRING) ' Script file data loading sub.
DECLARE SUB ParseScriptLine (script_file_line AS STRING) ' A sub for parsing lines from the script file
                                                         ' (extracting variables).
'============================================================================
DECLARE SUB EngineDoCollision (currentNPC AS INTEGER)   ' Sub used to detect the collison between
                                                        ' the player and the NPCs.
'============================================================================

' Declare your constants here!
CONST NULL = 0
CONST CENTRETEXT = -1

' Directional constants for easy sprite handling
' DN=Neutral(not Moving), DR=Right...........
CONST DN = 0, DR = 1, DU = 2, DL = 3, DD = 4

' More needed constants.
CONST FALSE = 0
CONST TRUE = 1

CONST fpslimit = 70 ' The speed of our program (in FPS).

CONST number_of_NPC = 40 ' Max number of NPCs.

' Arrays that will hold our sprites, tiles and our font.
DIM SHARED Tile(100) as any ptr
DIM SHARED Sprite(8) as any ptr
DIM SHARED NPCSprite(8) as any ptr
DIM SHARED Font1 AS FontType

' Map array used to hold the map data (which tiles go where in the map).
' Change 150, 150 to the biggest horizontal and vertical size any 
' of your maps will feature.
REDIM SHARED Map(150, 150) AS MapLayerType         

DIM SHARED Level AS LevelType    ' Used to hold data related to
                                 ' scrolling (camera position, etc).
DIM SHARED Player AS SpriteType  ' Our Player.
DIM SHARED NPC(number_of_NPC) AS SpriteType 
                                 ' Our non-player controled sprites.
                                 ' We have defined 'number_of_NPC' 
                                 ' elements (max of NPCs per map). 
                                 ' Change this above to any desired 
                                 ' number of maximum NPCs you want to 
                                 ' be featured on a single map.

DIM SHARED pathf AS STRING  ' This variable is used to locate the dir of your files.
                            ' Don't use hard paths in your public programs!
                  
' Some variables we use in our program.                            
DIM SHARED AS INTEGER Frame1, Frame2, Frame3, number_of_tiles
DIM SHARED AS INTEGER FPS, FPS2

' FPS control related variables.
DIM SHARED AS DOUBLE stt, Starttime
DIM SHARED frameintvl As Double = 1.0/fpslimit
DIM SHARED sleepintvl As Integer

' Screen and tile size variables (loaded from a script).
DIM SHARED AS INTEGER ScrnXmax, ScrnYmax, ScrnXmid, ScrnYmid, ScrnXmin, ScrnYMin, ScrnTileXmax, ScrnTileYmax, TileW, TileH
' Map, tiles and sprites file names loaded from the script file.
DIM SHARED AS STRING tiles_file, sprites_file, map_file

' Script file loading related variables.
DIM SHARED AS STRING row
DIM SHARED AS STRING varname, varval

DIM SHARED AS INTEGER MapXMax  ' Variables used to set the
DIM SHARED AS INTEGER MapYMax  ' size of our map.

' If your working files are in the directory where the compiled
' file is, pathf$ should be "".
pathf = "d:/working/freebasic/mycoding/scroll/"
pathf = ""

' Open our script to load the screen and tiles size, and
' map, tiles and sprites file names.
LoadScript "engine_script1.txt"

' Initiate our screen mode. 1 work page.
' Change 0 to 1 for full screen mode.
SCREENRES ScrnXmax, ScrnYmax, 32, 1, 0
SETMOUSE 0,0,0 ' Hides the mouse cursor.

InitMap map_file          ' Read our Map Array (from a file).

SCREENLOCK

LoadTiles tiles_file ' Load tiles.

LoadSprites ' Load sprites.

LoadFont "24bitFNT1.BMP", Font1, 0 ' Load our font.

CLS

SCREENUNLOCK

MainScreen              ' Displays introducing screen. 

InitVariables           ' Initializes our variables.

Main                    ' Main Loop.

DestroyTiles    ' Clear memory before ending the program.
DestroySprites

END ' End program.


SUB AINPC (currentNPC AS INTEGER)
    
DIM AS INTEGER ChangeDirec

' This is the sub which moves our NPCs. In this example the movement
' in randomized unless the player is in NPCs area (TileX>19 and
' TileY>25) and more than 30 pixels(in both directions) away
' from them. The only code important to you is the one in
' select case. The way the NPCs will move is up to you. Create
' your own AI.

' Default: the current NPC is not moving.
NPC(currentNPC).Direction = 0
NPC(currentNPC).Move = FALSE

' We tell our NPC to follow the player if the player is in the NPCs
' area and not too close to the NPC.
IF Player.TileX > 19 AND Player.TileY > 25 AND ABS(Player.X - NPC(currentNPC).X)>30 AND ABS(Player.Y - NPC(currentNPC).Y)>30 THEN
IF Player.X > NPC(currentNPC).X THEN NPC(currentNPC).Direction = 1
IF Player.Y < NPC(currentNPC).Y THEN NPC(currentNPC).Direction = 2
IF Player.X < NPC(currentNPC).X THEN NPC(currentNPC).Direction = 3
IF Player.Y > NPC(currentNPC).Y THEN NPC(currentNPC).Direction = 4
NPC(currentNPC).Move = TRUE
GOTO skiprnddirec: ' Skip regular movement if the NPC is following the
                   ' player( ALERT! ALERT! I used a GOTO statement.
                   ' Don't shoot me!) :P
END IF

' We randomize in which direction the current NPC will go and if
' the NPC will move at all.
ChangeDirec = INT(RND * 100) + 1
IF ChangeDirec = 2 THEN 
NPC(currentNPC).Direction = INT(RND * 4) + 1
NPC(currentNPC).Move = TRUE
END IF

skiprnddirec:

' These two lines of code prevent NPCs to go outside the NPCs 
' area (bottom-right corner of the map). This is just for the 
' purpose of the demo.
IF NPC(currentNPC).TileX<20 AND NPC(currentNPC).TileY>25 THEN NPC(currentNPC).Direction = 1
IF NPC(currentNPC).TileY<26 AND NPC(currentNPC).TileX>19 THEN NPC(currentNPC).Direction = 4

' According to NPC's direction the NPC moves and is checked for 
' collision with colliding tiles.
SELECT CASE NPC(currentNPC).Direction
        CASE 1
                NPC(currentNPC).OldX = NPC(currentNPC).X   ' We save the old position of the NPC for collision purposes.
                NPC(currentNPC).X = NPC(currentNPC).X + NPC(currentNPC).XV
                IF EngineTileCollide(NPC(currentNPC)) THEN NPC(currentNPC).X = NPC(currentNPC).X - NPC(currentNPC).XV
                IF NPC(currentNPC).X > (Level.Xmax * TileW) - TileW THEN NPC(currentNPC).X = (Level.Xmax * TileW) - TileW
        CASE 2
                NPC(currentNPC).OldY = NPC(currentNPC).Y 
                NPC(currentNPC).Y = NPC(currentNPC).Y - NPC(currentNPC).YV
                IF EngineTileCollide(NPC(currentNPC)) THEN NPC(currentNPC).Y = NPC(currentNPC).Y + NPC(currentNPC).YV
                IF NPC(currentNPC).Y < ScrnYmin THEN NPC(currentNPC).Y = ScrnYmin
        CASE 3
                NPC(currentNPC).OldX = NPC(currentNPC).X 
                NPC(currentNPC).X = NPC(currentNPC).X - NPC(currentNPC).XV
                IF EngineTileCollide(NPC(currentNPC)) THEN NPC(currentNPC).X = NPC(currentNPC).X + NPC(currentNPC).XV
                IF NPC(currentNPC).X < ScrnXmin THEN NPC(currentNPC).X = ScrnXmin
        CASE 4
                NPC(currentNPC).OldY = NPC(currentNPC).Y 
                NPC(currentNPC).Y = NPC(currentNPC).Y + NPC(currentNPC).YV
                IF EngineTileCollide(NPC(currentNPC)) THEN NPC(currentNPC).Y = NPC(currentNPC).Y - NPC(currentNPC).YV
                IF NPC(currentNPC).Y > (Level.Ymax * TileH) - TileH THEN NPC(currentNPC).Y = (Level.Ymax * TileH) - TileH
        CASE ELSE
END SELECT

END SUB


SUB EngineDoCollision (currentNPC AS INTEGER)

' This checks for collision between the player and the current NPC and
' if collision is TRUE the old positions of the player and the NPC
' are restored (positions before the last move).

IF Collision(Sprite(Player.Frame), Player.X, Player.Y, NPCSprite(NPC(currentNPC).Frame), NPC(currentNPC).X, NPC(currentNPC).Y) > 0 THEN
    NPC(currentNPC).X = NPC(currentNPC).OldX 
    NPC(currentNPC).Y = NPC(currentNPC).OldY 
    Player.X = Player.OldX
    Player.Y = Player.OldY
END IF

' This checks for collision between NPCs.
FOR countNPC2 AS INTEGER = 1 TO 4
    IF countNPC2 <> currentNPC THEN
        IF Collision(NPCSprite(NPC(countNPC2).Frame), NPC(countNPC2).X, NPC(countNPC2).Y, NPCSprite(NPC(currentNPC).Frame), NPC(currentNPC).X, NPC(currentNPC).Y) > 0 THEN
            NPC(currentNPC).X = NPC(currentNPC).OldX 
            NPC(currentNPC).Y = NPC(currentNPC).OldY 
            ' NPC(countNPC2).X = NPC(countNPC2).OldX
            ' NPC(countNPC2).Y = NPC(countNPC2).OldY 
        END IF
    END IF
NEXT countNPC2

END SUB

SUB EngineDrawMap 
    
' This sub draws our map on the screen. Can and should be used
' to implement other possible layers which are pasted over the
' main map layer.

DIM AS INTEGER tilep

' We need to MOD our Cam variables with TileW and TileH to get 
' the correct offset inside the tile.

'==========BaseLayer====================
' Calculate the first tile to draw. Use integer division!
' Why? Because integer division turns the result of 9.6 into
' 9 and we have to get such results due the way scrolling
' is enabled. 
' Integer division => \
' Normal division (turns the result of 9.6 into 10 if
' the result is an integer) => \
Level.TileX = Level.CamX \ TileW
Level.TileY = Level.CamY \ TileH

' Get the offset inside the tile (the remainder when
' camera's x and y position are divided with the tile
' sizes).
Level.Xpos = (Level.CamX MOD TileW)          
Level.Ypos = (Level.CamY MOD TileH)          

' Formula for X (the loop below).
' (X * TileW) = video screen coordinate (0 to 320 Step 20).
' (X * TileW) - Level.Xpos = tile offset that we have to show from 
' 0 to 20 - Level.Xpos
' Assuming Level.Xpos = 4
' So if X * TileW = 0 then (X * TileW)- Level.Xpos = -4
' We start Drawing from X = -4 to X = -4 + TileW
' ie. (for tile size 20*20), we draw our first tile from X = -4 to 
' X = 16 then the next tile from X = 17 to X = 17 + 20.

' Loop through our visible screen and draw tiles on it.
FOR XT AS INTEGER = 0 TO ScrnTileXmax          ' 16 tiles(320/20)
FOR YT AS INTEGER = 0 TO ScrnTileYmax          ' 11 tiles(200/20)

' We flag which tile to draw. Note how the Map array is used.
tilep = Map(XT + Level.TileX, YT + Level.TileY).BaseL

' Explained with the comments above and in the Engine.DrawPlayer sub.
IF tilep > 0 THEN PUT ((XT * TileW) - Level.Xpos, (YT * TileH) - Level.Ypos), tile(tilep), PSET

NEXT YT
NEXT XT

' ==========FringeLayer====================
' Not implemented!
' ==========ObjectLayer====================
' Not implemented!

END SUB


SUB EngineDrawNPC
    
' This is the main sub where we move our NPCs.

DIM AS INTEGER Framem

FOR countNPC AS INTEGER = 1 TO 4   
                        ' Loop through 4 NPC. You can change this
                        ' to any number of NPCs you want on a single
                        ' map, but be sure to declare it above
                        ' first.
                         
NPC(countNPC).TileX = NPC(countNPC).X \ TileW
NPC(countNPC).TileY = NPC(countNPC).Y \ TileH

Framem = 1

IF NPC(countNPC).Move = TRUE THEN Framem = Frame1
' If the NPC is moving then animate the movement with the Frame1
' variable (Frame1 variable loops from 1 to 2).

' According to NPC's direction flag the proper sprite to be
' displayed.
SELECT CASE NPC(countNPC).Direction
CASE 1
NPC(countNPC).Frame = 6 + Framem  
CASE 2                               
NPC(countNPC).Frame = 2 + Framem     
CASE 3
NPC(countNPC).Frame = 4 + Framem
CASE 4
NPC(countNPC).Frame = Framem
END SELECT

AINPC countNPC  ' AI for the NPCs. We use AI on the current NPC in the 
                ' loop. Note how the AINPC sub is declared and how 
                ' countNPC value is passed into the AINPC sub!
                ' This sub also moves the NPCs.

' If the current NPC exists (not dead or similar) draw it.
IF NPC(countNPC).Exists = TRUE THEN
PUT ((NPC(countNPC).X - Level.CamX), (NPC(countNPC).Y - Level.CamY)), NPCSprite(NPC(countNPC).Frame), TRANS
END IF

NEXT countNPC

END SUB


SUB EngineDrawPlayer (Player AS SpriteType)
    
' This sub uses direction constants defined at module level (DN, DR...)
' to flag the right sprite to be pasted.

IF Player.Move = TRUE THEN   ' Check if the player has moved.

' According to player's direction this flags the proper sprite (Frame1 
' variable is used to enable animation and it loops from 1 to 2).
        SELECT CASE Player.Direction
                CASE DR
                        Player.Frame = Frame1 + 6      
                CASE DU
                        Player.Frame = Frame1 + 2
                CASE DL
                        Player.Frame = Frame1 + 4       
                CASE DD
                        Player.Frame = Frame1           
                CASE ELSE
        END SELECT

        Player.Move = FALSE   ' Stops the player from waving
                              ' with his arms while he is not moving.
END IF

' Formula:
' Player.X - Level.CamX :
' puts the player at the center of the screen.
' So if Player.X = 500 then Level.CamX = Player.X - ScrnYmid (ScrnYmid = 320/2 = 160)
' Level.CamX: 500 - 160 = 340
' Player.X = 500
' Xcenter: 500 - 340 = 160 (ScrnXmid)
' Same goes for Y.
' See Engine.UpdateCamera for more Details :)

IF Player.Frame <> 0 THEN    ' Just to be sure to prevent errors. 
                             ' Player.Frame can't be 0 but since
                             ' we loaded tiles into the sprites
                             ' array from position 1.

' A classic PUT statement which pastes our player using its
' current frame.
PUT ((Player.X - Level.CamX), (Player.Y - Level.CamY)), Sprite(Player.Frame), TRANS
      
END IF
            
END SUB


SUB EngineDrawScreen
    
' This sub draws our stuff on the screen and controls the page
' flipping.

stt = TIMER

FPS = FPS + 1                     ' Used to count FPS.
IF StartTime + 1 < TIMER THEN
 FPS2 = FPS
 FPS = 0
 StartTime = TIMER
END IF

' Frame variables are used to time all kind of animations in our
' game like walking. Play with these variables to change the
' speed of "walking" animation.
Frame3 = (Frame3 MOD 8) + 1 
IF Frame3 = 1 THEN Frame1 = (Frame1 MOD 2) + 1     
IF Frame1 = 0 THEN Frame1 = 1
Frame2 = (Frame2 MOD 2) + 1  

' Hide our work page and draw stuff on it.
screenlock

' We clear our work page.
' LINE (0,0)-(320, 200), 0, bf

FOR countNPC AS INTEGER = 1 to 4
EngineDoCollision countNPC  ' We check for collision (NPC to
                            ' other NPC collision or player
                            ' to NPC collison).
NEXT countNPC

' If the player's position is restored to the old one, don't
' animate his legs (no movement).
IF Player.X = Player.OldX AND Player.Y = Player.OldY THEN Player.Move = FALSE

EngineDrawMap            ' Draw our map tiles on the screen.
EngineDrawPlayer Player  ' Draw our player on the scren.
EngineDrawNPC            ' Draw the NPCs on the screen.

' Print some variables on the screen with our custom font routine.
PrintFont 5, 5,  "FPS: " + STR(FPS2), Font1, 1,1
PrintFont 5, 15, "Player.TileX: " + STR(Player.TileX), Font1, 1,1
PrintFont 5, 25, "Player.TileY: " + STR(Player.TileY), Font1, 1,1

' Code needed only for this demo to display some text when
' the player comes near the sign.
IF Player.TileX>23 and Player.TileX<27 and Player.TileY>20 and Player.TileY<25 then
PrintFont 100, 150, "Welcome To Free Basicville", Font1, 1,3
END IF

screenunlock 

' Keep the FPS value within fpslimit (set above).
sleepintvl = Cint((stt + frameintvl - Timer)*1000.0)
If sleepintvl>1 Then
  Sleep sleepintvl, 1
else 
    sleep 1, 1
end if

END SUB

FUNCTION EngineTileCollide (Character AS SpriteType) AS INTEGER
    
' Crappy tile*tile collision detection ;)
' Returns TRUE if collision is detected, FALSE if not.
' Pixel perfect collision with map tiles is not an option since
' tiles don't feature TRANSPARENT color. You can use another layer
' for trees and similar static objects and then apply pixel by
' pixel collision on that layer.

DIM TX AS INTEGER
DIM TY AS INTEGER
DIM X AS INTEGER
DIM Y AS INTEGER

' Init the function to be FALSE (no collision).
EngineTileCollide = FALSE

' 4 checks are done to be sure ;)
' This checks all the corners of the character for tile collision.
' + 10 in Character.Y for up-left and up-right corner is used to
' create an illusion of collision with the feet.

' Up-Left corner of Character
X = Character.X + TileW/4      
Y = Character.Y + TileH/2
' Check fo collision
TX = X \ TileW          ' Character.X/TileW=Character.TileX
TY = Y \ TileH          ' Character.Y/TileH=Character.TileY
' In this demo, all tiles above 2 are colliding.
IF Map(TX, TY).BaseL > 5 THEN
   EngineTileCollide = TRUE
   'Character.Move = FALSE
END IF      

' Up-Right corner of the character.
X = Character.X + TileW-1-TileW/4
Y = Character.Y + TileH/2
TX = X \ TileW          ' Character.X/TileW=Character.TileX
TY = Y \ TileH          ' Character.Y/TileH=Character.TileY
IF Map(TX, TY).BaseL > 5 THEN
   EngineTileCollide = TRUE
   'Character.Move = FALSE
END IF    

' Down-Right corner of the character.
X = Character.X + TileW-1-TileW/4
Y = Character.Y + TileH-1
TX = X \ TileW          ' Character.X/TileW=Character.TileX
TY = Y \ TileH          ' Character.Y/TileH=Character.TileY
IF Map(TX, TY).BaseL > 5 THEN
   EngineTileCollide = TRUE
   'Character.Move = FALSE
END IF    

' Down-Left corner of the character.
X = Character.X + TileW/4 
Y = Character.Y + TileH-1
TX = X \ TileW          ' Character.X/TileW=Character.TileX
TY = Y \ TileH          ' Character.Y/TileH=Character.TileY
IF Map(TX, TY).BaseL > 5 THEN
   EngineTileCollide = TRUE
   'Character.Move = FALSE
END IF    

END FUNCTION


SUB EngineUpdateCamera (Level AS LevelType, Player AS SpriteType) 

' Updates CAMX, CAMY in relation to Player.X, Player.Y to achieve
' ZELDA style scrolling engine.
' Sample Code:
' CODE: CASE DR
        ' Right Direction of movement.
' CODE: Level.CamX = Player.X - ScrnXmid
        ' Centers our player and moves the camera to where
        ' the player is going.
        ' ie, Assume: Player.X=1200, ScrnMid=Constant 160 (middle of the screen)
        ' Level.CamX: 1200-160=1040
        ' To get the TileX:
        ' TileX=Level.CamX\TileW=1040\20=52 (This will be used with 
        ' Engine.DrawMap).
' CODE: IF Level.CamX < ScrnXmin THEN Level.CamX = ScrnXmin
        ' Checks if Level.CamX<0, zero it if it's negative to prevent 
        ' errors. ScrnYmin=0 (constant).
' CODE: IF Level.CamX > (Level.Xmax * TileW) - ScrnXmax THEN Level.CamX = (Level.Xmax * TileW) - ScrnXmax
        ' Checks if Level.CamX > (Level.Xmax * TileW) - ScrnXmax
        ' ScrnXmax = Maximum number of PIXELS our map has.
        ' Level.Xmax = Maximum number of tiles our map has.
        ' TileW = Width of our tile (constant).
        ' ScrnXmax = 320 (constant).
        ' To calculate: Level.Xmax = MapXmax
        ' Formula: (Level.Xmax * TileW) - ScrnXmax
        ' ie, Level.Xmax = 36
        ' (36*20)-320 = 400
        ' Level.CamX =400
        ' To calculate TileX:
        ' Level.CamX\TileW
        ' 400\20 = 20
        ' TileX = 20 (Start Drawing from 20 to 36) in Engine.DrawMap sub.
        ' 20 is the first tile to draw in X direction.
        ' 36-20 = 16 (See, we have to draw 16 tiles horizontally!!!)
        ' Same goes for Y.
        ' See Engine.DrawMap SUB for more details. ;)

SELECT CASE Player.Direction
        CASE DR
                Level.CamX = Player.X - ScrnXmid
                IF Level.CamX < ScrnXmin THEN Level.CamX = ScrnXmin
                IF Level.CamX > (Level.Xmax * TileW) - ScrnXmax THEN Level.CamX = (Level.Xmax * TileW) - ScrnXmax
        CASE DU
                Level.CamY = Player.Y - ScrnYmid
                IF Level.CamY < ScrnYmin THEN Level.CamY = ScrnYmin
                IF Level.CamY > (Level.Ymax * TileH) - ScrnYmax THEN Level.CamY = (Level.Ymax * TileH) - ScrnYmax
        CASE DL
                Level.CamX = Player.X - ScrnXmid
                IF Level.CamX < ScrnXmin THEN Level.CamX = ScrnXmin
                IF Level.CamX > (Level.Xmax * TileW) - ScrnXmax THEN Level.CamX = (Level.Xmax * TileW) - ScrnXmax
        CASE DD
                Level.CamY = Player.Y - ScrnYmid
                IF Level.CamY < ScrnYmin THEN Level.CamY = ScrnYmin
                IF Level.CamY > (Level.Ymax * TileH) - ScrnYmax THEN Level.CamY = (Level.Ymax * TileH) - ScrnYmax
        CASE ELSE
END SELECT

END SUB

SUB EngineUpdatePlayer (Player AS SpriteType, Direction AS INTEGER) 
    
' Updates the player's position according to player's direction.
' ZELDA style pixel by pixel free movement.
' Sample Code:
' CODE: CASE DR
      ' Direction of player's movement.
' CODE: Player.X = Player.X + Player.XV
      ' Adds Xspeed to Player's X position since we are moving right.
' CODE: IF Engine.TileCollide(Player) THEN Player.X = Player.X - Player.XV
        ' Check for collision. If collided with valid "collidable" tile
        ' subtract Xspeed to return the player to its original place.
        ' Also prevents the player to stick to tiles when changing direction.
' CODE: IF Player.X > (Level.Xmax * TileW) - TileW THEN Player.X = (Level.Xmax * TileW) - TileW
        ' Checks if player is outside the map boudaries.
        ' Subtracting TileW is necessary to prevent errors if your
        ' speed is greater than 1. Also used for padding.

SELECT CASE Direction
        CASE DR
                Player.X = Player.X + Player.XV
                ' Flag that player is moving. This flags animation of the player
                ' (REM this for no animation).
                Player.Move = TRUE
                IF EngineTileCollide(Player) THEN Player.X = Player.X - Player.XV
                IF Player.X > (Level.Xmax * TileW) - TileW THEN Player.X = (Level.Xmax * TileW) - TileW
        CASE DU
                Player.Y = Player.Y - Player.YV
                Player.Move = TRUE
                IF EngineTileCollide(Player) THEN Player.Y = Player.Y + Player.YV
                IF Player.Y < ScrnYmin THEN Player.Y = ScrnYmin
        CASE DL
                Player.X = Player.X - Player.XV
                Player.Move = TRUE
                IF EngineTileCollide(Player) THEN Player.X = Player.X + Player.XV
                IF Player.X < ScrnXmin THEN Player.X = ScrnXmin
        CASE DD
                Player.Y = Player.Y + Player.YV
                Player.Move = TRUE
                IF EngineTileCollide(Player) THEN Player.Y = Player.Y - Player.YV
                IF Player.Y > (Level.Ymax * TileH) - TileH THEN Player.Y = (Level.Ymax * TileH) - TileH
        CASE ELSE
END SELECT

' Calculates on which tile the player is.
' Adds (TileW/2) or (TileH/2) to X and Y to get center of the player. 
Player.TileX = (Player.X + (TileW/2)) \ TileW  
Player.TileY = (Player.Y + (TileH/2)) \ TileH

END SUB


SUB InitMap (mapcon AS STRING)
    
' This sub loads the map data from an external file. You are
' advised to use some map editing tool. Map loading is not glued 
' to the very scrolling engine. This map loader first loads the 
' map's x size and map's y size (in number of tiles) and then the 
' very tiles. You should leave (create) one line of unused tiles 
' horizontally and vertically on the right and down edge of the
' map to avoid errors.

OPEN pathf + mapcon FOR INPUT AS #2
INPUT #2, MapXMax
INPUT #2, MapYMax
FOR Y AS INTEGER = 0 TO MapYMax
FOR X AS INTEGER = 0 TO MapXMax
INPUT #2, Map(X, Y).BaseL  ' Map is loaded from a file (note the INPUT #2
NEXT X                     ' statement) and stored into the map array.
NEXT Y
CLOSE #2

END SUB


SUB InitVariables 

' Player's starting variables.
' You can ignore most of the variable since they don't
' relate to the very scrolling engine.

DIM AS INTEGER XRND, YRND

Player.Typ = 1           ' ID?????????
Player.X = 17 * TileW    ' Change this to where you want for player to
Player.Y = 20 * TileH    ' start (be sure not to go over the map dimensions).
Player.XV = 2            ' Player's XSpeed. Change this for faster movement.
Player.YV = 2            ' Player's Yspeed.
Player.Frame = 1         ' We start at frame 1 (looking-at-screen-sprite) :)
Player.Move = FALSE      ' Static(no movement) :)
Player.RANGE = 0         ' Ignore.
Player.Active = TRUE     ' Ignore.
Player.HIT = FALSE       ' Ignore.
Player.AI = 1            ' Ignore.
Player.MONEY = 9999      ' Ignore.
Player.HP = 9999         ' Ignore.
Player.ITEM = 1          ' Ignore.
Player.Direction = DU    ' Starting direction (down).
Player.OldX = Player.X
Player.OldY = Player.Y

RANDOMIZE TIMER

FOR countNPC AS INTEGER = 1 TO number_of_NPC   ' We loop through all NPCs.

NPC(countNPC).XV = 1     ' X and Y speeds of our NPCs.
NPC(countNPC).YV = 1

            
XRND = INT(RND * 5) + 23   ' We randomize the positions of our NPCs.
YRND = INT(RND * 5) + 25 

NPC(countNPC).Direction = INT(RND * 4) + 1 

NPC(countNPC).X = XRND * TileW   ' We multiply XRND or YRND with 20 to
NPC(countNPC).Y = YRND * TileH   ' put a NPC on XRND and YRND tile!
NPC(countNPC).Exists = TRUE      ' May be used with killable NPCs
                                 ' to flag if you want to display it
                                 ' or check collision with it if
                                 ' a specific NPC is dead/gone (not Alive)

NPC(countNPC).OldX = NPC(countNPC).X
NPC(countNPC).OldY = NPC(countNPC).Y
NPC(countNPC).Frame = 1

NEXT countNPC     
         
Level.Xmax = MapXMax    ' Flags our level (play map) size from the
Level.Ymax = MapYMax    ' map size we have loaded.

' Not sure how much this matters but heck.     
Level.CamX = 0
Level.CamY = 0
Level.TileX = 0
Level.TileY = 0
Level.Xpos = 0
Level.Ypos = 0

Player.Direction = DU             ' Two directions so that engine will
EngineUpdateCamera Level, Player  ' know where level TileX and TileY
Player.Direction = DR             ' positions are from left to right.
EngineUpdateCamera Level, Player  ' No warping ;)
                                  ' In other words, inital camera
                                  ' setting.                                   
END SUB


SUB Main
    
' Our main loop. Checks which key the player has pressed and moves
' the player according to that.
' It also initiates Engine.DrawScreen sub which draws all our
' stuff on the screen.
' Storing old player's position is used with player to NPC
' collision in order to restore the player's old position when he
' bumps with a NPC.

DO
        ' Save old player's X and Y position (used with
        ' position restoring on tile and NPC collision).
        Player.OldX = Player.X
        Player.OldY = Player.Y
        
        IF MULTIKEY(SC_UP) AND NOT MULTIKEY(SC_DOWN) THEN  ' Pressed up
            Player.Direction = DU      ' Direction = up(DU tag)
            'Player.OldX = Player.X    ' Store the player's old position
            Player.OldY = Player.Y     ' (used with collision routines).
            EngineUpdatePlayer Player, Player.Direction ' Update player position.
            EngineUpdateCamera Level, Player ' Update camera position.
        END IF

        IF MULTIKEY(SC_DOWN) AND NOT MULTIKEY(SC_UP) THEN  ' Pressed Down
                        Player.Direction = DD
                        'Player.OldX = Player.X
                        Player.OldY = Player.Y
                        EngineUpdatePlayer Player, Player.Direction
                        EngineUpdateCamera Level, Player
        END IF
        IF MULTIKEY(SC_RIGHT) AND NOT MULTIKEY(SC_LEFT) THEN ' Pressed Right
                        Player.Direction = DR
                        Player.OldX = Player.X
                        'Player.OldY = Player.Y
                        EngineUpdatePlayer Player, Player.Direction
                        EngineUpdateCamera Level, Player
        END IF
        IF MULTIKEY(SC_LEFT) AND NOT MULTIKEY(SC_RIGHT) THEN  ' Pressed Left
                        Player.Direction = DL
                        Player.OldX = Player.X
                        'Player.OldY = Player.Y
                        EngineUpdatePlayer Player, Player.Direction
                        EngineUpdateCamera Level, Player
        END IF

EngineDrawScreen   ' Draw our stuff on the screen

LOOP UNTIL MULTIKEY(SC_ESCAPE)   ' Loop until player presses ESC

END SUB

SUB MainScreen

   
DO
    
    SCREENLOCK
    
    CLS
    
    PrintFont 20, 25, "Richard Eric Lope's", Font1, 1,3
    PrintFont 20, 37, "Pixel By Pixel Scrolling Engine", Font1, 1,3
    PrintFont 20, 59, "Edition #3, Jan 2008.", Font1, 1,3
    PrintFont 20, 95, "FreeBASIC port by", Font1, 1,3
    PrintFont 20, 105, "Richard Eric Lope and Lachie Dazdarian", Font1, 1,3
    PrintFont 20, 145, "Press Any Key", Font1, 1,3

    SCREENUNLOCK
   
    SLEEP 10, 1
    
LOOP UNTIL INKEY<>""

END SUB

SUB LoadTiles (tilesfile AS STRING)
    
' A sub that loads tiles from a 24-bit color
' depth BMP file.
' Tiles need to be aligned without any
' space between them and starting at 0,0.
 
DIM AS INTEGER tiles_bmpfile_width, tiles_bmpfile_height, numofcolumns, numofrows
DIM AS ANY PTR tilebuffer

Open tilesfile For Binary As #1
Get #1, 19, tiles_bmpfile_width
Get #1, 23, tiles_bmpfile_height
Close #1

tilebuffer = IMAGECREATE (tiles_bmpfile_width, tiles_bmpfile_height)

number_of_tiles = tiles_bmpfile_height/TileH * tiles_bmpfile_width/TileW

' Calculate the number of tiles according to bmp file size and
' tile size.
number_of_tiles = tiles_bmpfile_height/TileH * tiles_bmpfile_width/TileW

numofcolumns = tiles_bmpfile_width/TileW

IF tiles_bmpfile_width Mod TileW <> 0 THEN
    numofcolumns = tiles_bmpfile_width\TileW
    tiles_bmpfile_width = TileW * numofcolumns
END IF

numofrows = number_of_tiles/numofcolumns

FOR count_tiles AS INTEGER = 1 TO number_of_tiles
    tile(count_tiles) = IMAGECREATE(TileW, TileH)
NEXT count_tiles

BLOAD tilesfile, tilebuffer

FOR count_tilerow AS INTEGER = 1 TO numofrows
    FOR count_tilecolumn AS INTEGER = 1 TO numofcolumns
 
        PUT (0, 0), tilebuffer, (0+(count_tilecolumn-1)*TileW,0+(count_tilerow-1)*TileH)-(TileW-1+(count_tilecolumn-1)*TileW,TileH-1+(count_tilerow-1)*TileH), PSET
        GET (0,0)-(TileW-1,TileH-1), tile(count_tilecolumn+(count_tilerow-1)*numofcolumns)

    NEXT count_tilecolumn
NEXT count_tilerow

IMAGEDESTROY tilebuffer

END SUB

SUB DestroyTiles

FOR count_tiles AS INTEGER = 1 TO number_of_tiles
    IMAGEDESTROY tile(count_tiles)
NEXT count_tiles

END SUB

SUB LoadSprites
    
BLOAD sprites_file, 0
FOR imagepos AS INTEGER = 1 TO 8
    Sprite(imagepos) = IMAGECREATE (TileH, TileW)
    GET (0+(imagepos-1)*20,0)-(TileW-1+(imagepos-1)*20,TileH-1),  Sprite(imagepos)
NEXT imagepos

FOR imagepos AS INTEGER = 1 TO 8
    NPCSprite(imagepos) = IMAGECREATE (TileH, TileW)
    GET (20*8+(imagepos-1)*20,0)-(20*8+TileW-1+(imagepos-1)*20,TileH-1),  NPCSprite(imagepos)
NEXT imagepos

END SUB

SUB DestroySprites

FOR count_sprites AS INTEGER = 1 TO 8
    IMAGEDESTROY Sprite(count_sprites)
    IMAGEDESTROY NPCSprite(count_sprites)
NEXT count_sprites

END SUB

SUB LoadScript (script_file AS STRING)
    
' A sub that loads variables from the script file.
' Note how the lines read from the script file
' are parsed and appropriate variables
' extracted. This allows us to add comments 
' in our script file.
    
OPEN script_file FOR INPUT AS #1
INPUT #1, row
ParseScriptLine row
ScrnXMax = VAL(varval)
INPUT #1, row
ParseScriptLine row
ScrnYMax = VAL(varval)
INPUT #1, row
ParseScriptLine row
TileW = VAL(varval)
INPUT #1, row
ParseScriptLine row
TileH = VAL(varval)
INPUT #1, row
ParseScriptLine row
map_file = varval
INPUT #1, row
ParseScriptLine row
tiles_file = varval
INPUT #1, row
ParseScriptLine row
sprites_file = varval
CLOSE #1

ScrnXmid = ScrnXmax\2
ScrnYmid = ScrnYmax\2
ScrnXmin = 0
ScrnYmin = 0
ScrnTileXmax = ScrnXmax \ TileW ' Number of tiles on the screen
ScrnTileYmax = ScrnYmax \ TileH ' vertically and horizontally.

END SUB

SUB ParseScriptLine (script_file_line AS STRING)

dim as ubyte state=0
dim as string c

varname = ""
varval = ""

for i as integer = 1 to len(script_file_line)
    c = mid(script_file_line,i,1)
    if c = "=" and state = 0 then state += 1
    if c <> " " then
        if state = 0 then varname += c
        if state > 0 AND c <> "=" then varval += c
    end if
next

END SUB

