
' Custom font printing demo with scrolling text and a background.

' We include our font printing module.
#include "customfont.bi"

#include "fbgfx.bi"
Using FB

const fpslimit = 60

' We declare 3 font arrays since we are going to load
' 3 fonts.
DIM SHARED Font1 AS FontType
DIM SHARED Font2 AS FontType
DIM SHARED Font3 AS FontType
DIM SHARED bimage(64004) AS INTEGER ' Memory buffer for our 
                                    ' background image.
                                    
DIM SHARED xmov AS INTEGER, sblender AS INTEGER
DIM SHARED workpage AS INTEGER

DIM SHARED frameintvl As Double = 1.0/fpslimit
DIM SHARED sleepintvl As Integer, stt AS DOUBLE

' Sets a graphic mode and 8bit color depth.
SCREEN 13,8,2,0

' This loads FONT 2, 3 and 4 and places each one
' in another array. The last parameter sets the
' width mode. 1 means relative width(each character
' features it's own width) while 2 means unique
' width( all characters feature a single preset 
' width and this is to be used with fonts that 
' are designed and inputted in the font grid on 
' a specific way (FONT 2, FONT 51 and FONT 52).
LoadFont "Fonts/FNT3PAL2.bmp", Font1, 1
LoadFont "Fonts/FNT4PAL2.bmp", Font2, 1
LoadFont "Fonts/FNT2PAL2.bmp", Font3, 2

' This loads the background onto the screen and
' then into the bimage array.
BLOAD "DEMOBGR1.BMP",0
GET (0,0)-(319,199), bimage(0)

' Deafult scrolling text position(+320).
xmov = 0

' A simple loop that ends when the user pushes the
' ESCAPE key.
DO
    
stt = Timer

screenlock
screenset workpage, workpage xor 1
 
' This moves the scrolling text. 
xmov = xmov + 1
IF xmov=630 THEN xmov=0

CLS

' This pastes the background.
PUT (0,0), bimage(0), PSET

' Font printing calls. First 2 parameters are the
' string's starting coordinates. Second last parameter
' sets the spacing while the last parameter sets the mode
' of printing (1 - TRANS; 2 - PSET). If you input any
' other number as the last parameter the characters
' will be printed with TRANS.
PrintFont 80,20, "Let's get crazy! %&/)=?:;", Font1, 1, 1
PrintFont 30,40, "Evil spacing!!!", Font3, 10, 1
PrintFont 320-xmov,100, "BIG SCROLLING TEXT!!", Font2, 1, 1

' The next line prints the following text in FONT 3 with PSET.
PrintFont 100,170, "Press ESC to exit", Font3, 0, 2

workpage xor = 1
screenunlock

sleepintvl = Cint((stt + frameintvl - Timer)*1000.0)
If sleepintvl>1 Then 
    Sleep sleepintvl
else 
    sleep 1
end if

LOOP UNTIL MULTIKEY(SC_ESCAPE)

END
