'' Code supplement on how to use:
''  1. Metaballs as lasers 
''  2. Glowlines as lightsabers
''  3. Fire

'' Relminator(Richard Eric M. Lope BSN RN)
'' Http://rel.betterwebber.com


#include once "fbgl2d.bi"   
#include once "fbgl2d.bas" 


'' particles struct for our laser, saber and fire
type Tparticle
	x			as single
	y			as single
	life		as integer
	alpha		as integer
	active		as integer
	ID			as integer
end type



const PI = 3.141593
const TWOPI = (2 * PI) 
const MAXPARTS = 256	'' maximum particle on screen * 2(Laser and Fire)
const MAXSEGMENT = 32   '' Saber trail effect
const MAXFLARES = 10

'' screen dimensions
const SCR_WIDTH = 640
const SCR_HEIGHT = 480

const false = 0
const true = not false

randomize timer


using FB


dim as Tparticle parts(0 to MAXPARTS-1)
dim as Tparticle fire(0 to MAXPARTS-1)
dim as Tparticle laser(0 to MAXSEGMENT-1)

dim as GLuint colors(MAXFLARES)

'' laser and fire particles
for i as integer = 0 to  MAXPARTS-1
	parts(i).active = FALSE
 	fire(i).active = FALSE 
next i

'' saber trail effect
for j as integer = 0 to (MAXSEGMENT - 1)
    laser(j).x = 320
    laser(j).y = 240
next j
    

for i as integer = 0 to MAXFLARES
	colors(i) = GL2D_RGBA(rnd * 256,rnd * 256,rnd * 256,rnd * 256)
next i


'' initialize gl2d (640 x 480)
gl2d.screen_init( SCR_WIDTH, SCR_HEIGHT )

gl2d.vsync_on()   '' set vsynch on

'' particle sprites	(force linear mapping for better effect)
redim as GL2D.IMAGE ptr parts_image(0)
gl2d.init_sprites(parts_image(), 64, 64, "metaball.bmp", GL_LINEAR)


'' Saber
dim img as fb.image ptr = imagecreate( 32, 32, rgb(255, 255, 255), 32 )
gl2d.load_image_to_HW(cast(gl2d.image ptr, img), GL_LINEAR)



'' flare
dim as gl2d.image ptr flare_image = gl2d.load_BMP_to_glsprite( "particle.bmp", GL_LINEAR )


'' smoke
dim as gl2d.image ptr smoke_image = gl2d.load_BMP_to_glsprite( "smoke.bmp", GL_LINEAR )


dim as gl2d.image ptr ship_images(1)
ship_images(0) = gl2d.load_BMP_to_glsprite( "triunglow.bmp", GL_LINEAR )
ship_images(1) = gl2d.load_BMP_to_glsprite( "triglow.bmp", GL_LINEAR )

'' frame counter to animate stuff
dim as integer frame = 0
dim as single ox, oy

do
	frame += 1	
	
	'' clear buffer
	gl2d.clear_screen()     '' clear buffer


	'' Flares
	gl2d.set_blend_mode(GL2D.E_GLOW)

	for i as integer = 0 to MAXFLARES
		dim as integer x = 5 *  ( (cos((frame)/10*i/5) + sin((frame)/60)) )
		dim as integer y = 4 *  ( (sin(-(frame)/20*i/9) + sin((frame)/30)) )
		glColor4ubv(  cast( GLubyte ptr, @colors(i) ) )   '' random colors
		gl2d.sprite_rotate_scale(x + 64+(img->width/2), y + 200+(img->height/2), frame + i*15*sgn(i),1 + i/3,cast(gl2d.image ptr, flare_image))
	next i	


	'' Blobies
	for i as integer = 0 to MAXFLARES
		dim as integer x = 30 *  ( (cos((frame)/10*i/5) + sin((frame)/40)) )
		dim as integer y = 25 *  ( (sin(-(frame)/20*i/9) + sin((frame)/50)) )
		'dim as integer  angle = 		
		glColor4ubv(  cast( GLubyte ptr, @colors(i) ) )   '' random colors
		gl2d.sprite_rotate_scale(x + 570+(img->width/2), y + 200+(img->height/2), 0, 1 + i/5,cast(gl2d.image ptr, parts_image(i and 1)))
	next i	

	'' *******************FIRE***************************
		'' Glow it for kicks
		gl2d.set_blend_mode(GL2D.E_GLOW)
		glColor4ub(255,255,255,255)   '' full glow
	
		'' parts update for fire
		for j as integer = 0 to 10
			for i as integer = 0 to  MAXPARTS-1
				if fire(i).active = false then 
					fire(i).x			= rnd*600
					fire(i).y			= 470
					fire(i).life		= 10+rnd*200
					fire(i).alpha		= 255
					fire(i).active		= true
					exit for   		
				end if
			next i
		next j
		
			'' do parts
		for i as integer = 0 to  MAXPARTS-1
			if fire(i).active then
				fire(i).life		-= 1
				if fire(i).alpha >0 then fire(i).alpha -= 1
				fire(i).y		    -= 0.32
				if fire(i).life < 0 then 
					fire(i).active = false						
				endif
			endif
		next i
	
		'' draw parts
		for i as integer = 0 to  MAXPARTS-1
			if fire(i).active then
				glColor4ub(fire(i).life,fire(i).life/2,fire(i).life/2,fire(i).life/3)   '' full glow
				gl2d.sprite_scale(fire(i).x-32,fire(i).y-16,1.5*(fire(i).life/210),cast(gl2d.image ptr, smoke_image) )
			endif
		next i
	

	'' *******************LIGHT SABER**************************
		
		gl2d.set_blend_mode(GL2D.E_BLENDED)
		glColor4ub(255,255,255,255)   '' full glow
	
	
		dim as integer saber_x = 320 + ( ((cos((frame)/10) + sin((frame)/60)) * (SCR_WIDTH\5)))
		dim as integer saber_y = 240 + ( ((sin(-(frame)/20) + sin((frame)/30)) * (SCR_HEIGHT\5)))		
	
		'' set initial value to tip of saber
		laser(0).x = saber_x
	    laser(0).y = saber_y
	    
	    '' reverse copy
	    for j as integer = (MAXSEGMENT - 1) to 1 step -1
	        laser(j)= laser(j-1)
	    next j
	    
	    '' draw trail effect using triangles
	    for j as integer = (MAXSEGMENT - 1) to 1 step -1
	    	dim as integer x1 = laser(j).x
	    	dim as integer y1 = laser(j).y
	    	dim as integer x2 = laser(j-1).x
	    	dim as integer y2 = laser(j-1).y
	    	dim as integer strength = (MAXSEGMENT-j)/MAXSEGMENT * 255
			gl2d.triangle_filled( 320, 240, x1, y1, x2, y2, GL2D_RGBA(strength,0,strength,strength))
	    next j
	    
		'' draw the main part of the saber
		'' multiple glowlines for better effect
		gl2d.line_glow (320, 240, saber_x, saber_y, 30,GL2D_RGBA(60,128,25,255))
		gl2d.line_glow (320, 240, saber_x, saber_y, 20,GL2D_RGBA(100,200,200,255))
		gl2d.line_glow (320, 240, saber_x, saber_y, 15,GL2D_RGBA(160,128,215,255))
		gl2d.line_glow (320, 240, saber_x, saber_y, 10,GL2D_RGBA(55,128,25,255))


	'' *******************LASER ***************************
	
		'' move lasers
		dim as integer x = ( ((cos((frame)/70) + sin((frame)/90)) * (SCR_WIDTH\5)))
		dim as integer y = ( ((sin(-(frame)/60) + sin((frame)/40)) * (SCR_HEIGHT\5)))		
	
		'' Laser 1
		'' parts update
		for i as integer = 0 to  MAXPARTS-1
			if parts(i).active = false then 
				parts(i).x			= 320 + x
				parts(i).y			= 240 + y
				parts(i).life		= 100
				parts(i).alpha		= 255
				parts(i).active		= true
				parts(i).ID			= 0
				exit for   		
			end if
		next i
	
		'' laser 2
		'' parts update
		for i as integer = 0 to  MAXPARTS-1
			if parts(i).active = false then 
				parts(i).x			= 320 - x
				parts(i).y			= 240 - y
				parts(i).life		= 100
				parts(i).alpha		= 255
				parts(i).active		= true
				parts(i).ID			= 1
				exit for   		
			end if
		next i
	    
	    
	    '' update particles
		'' do parts
		for i as integer = 0 to  MAXPARTS-1
			if parts(i).active then
				parts(i).life		-= 1
				parts(i).alpha		-= 2
				if parts(i).life < 0 then 
					parts(i).active = false						
				endif
			endif
		next i
	
		'' glow mode
		gl2d.set_blend_mode(GL2D.E_GLOW)
		glColor4ub(255,255,255,255)   '' full glow
	
		'' draw using additive blending
		'' draw parts
		for i as integer = 0 to  MAXPARTS-1
			if parts(i).active then
				glColor4ub(255,255,255,parts(i).alpha)
				gl2d.sprite_scale(parts(i).x,parts(i).y,0.5*(parts(i).alpha/255),cast(gl2d.image ptr, parts_image(parts(i).ID)))
			endif
		next i



	'' glowing ship position
	dim as single sx = 320 + ( ((cos((frame)/30) + sin((frame)/60)) * (SCR_WIDTH\4)))
	dim as single sy = 240 + ( ((sin(-(frame)/40) + sin((frame)/70)) * (SCR_HEIGHT\4)))		
	
	'' get angle(in degrees) to draw the rotated ship 
	dim as integer angle = atan2(sy - oy, sx - ox) * 180 / PI

	'' save old position for angle calculation
	ox = sx
	oy = sy

	'' draw glowing ship	
	dim as single glow = abs(sin(frame/5) * 0.2)		'' glow it
	
	'' Non-glowing
	gl2d.sprite_rotate_scale(sx+(ship_images(0)->width/2), sy+(ship_images(0)->height/2), angle, 1,cast(gl2d.image ptr, ship_images(0)))
	'' Glowing
	gl2d.sprite_rotate_scale(sx+(ship_images(1)->width/2), sy+(ship_images(1)->height/2), angle, 1+glow,cast(gl2d.image ptr, ship_images(1)))


	'' limit fps to 60 frames per second
	dim as single FPS = gl2d.fps_limit(60)	
    		
	'' Test print
	gl2d.print_scale(0, 10,2, "Easy Laser and Lightsaber  FPS = " + str(FPS))
	
	gl2d.set_blend_mode(GL2D.E_TRANS)   '' transparent
	glColor4ub(0,255,255,128)  '' transluceny	
	gl2d.print_scale(0, 40,1.5, "Just a bunch of particles that looks like a laser")
	gl2d.print_scale(0, 60,1.5, "Lightsaber is done with glowlines and triangles.")
	gl2d.print_scale(0, 80,1.5, "Fire uses a smoke(smoke.bmp) texture.")
	gl2d.print_scale(0, 100,1.5, "Glowing ship uses 2 ship sprites(triglow $ triunglow).")
	

	flip
    
    
	sleep 1,1
	
Loop Until Multikey( FB.SC_ESCAPE ) 


'' cleanup
gl2d.destroy_image(cast(gl2d.image ptr,img))
gl2d.destroy_image(cast(gl2d.image ptr,flare_image))
gl2d.destroy_image(cast(gl2d.image ptr,smoke_image))
gl2d.destroy_image(cast(gl2d.image ptr,ship_images(0)))
gl2d.destroy_image(cast(gl2d.image ptr,ship_images(1)))

gl2d.destroy_sprites(parts_image())
gl2d.destroy()
