#include once "fbgl2d.bi"   
#include once "fbgl2d.bas" 



using FB

const MAX_BLOBS = 256

const SCR_WIDTH = 640
const SCR_HEIGHT = 480
const as single PI = atn(1)*4

'' initialize gl2d (640 x 480)
gl2d.screen_init( SCR_WIDTH, SCR_HEIGHT )

gl2d.vsync_on()   '' set vsynch on

dim img as fb.image ptr = imagecreate( 64, 64, rgba(255, 0, 255,0), 32 )

dim as integer wid_d2 = img->width\2
dim as integer hei_d2 = img->height\2

dim as single strength =  img->width \ 2

dim as integer col
dim as single dist


for y as integer = 0 to img->width - 1
        for x as integer = 0 to img->height - 1
        	dist = sqr((wid_d2-x) ^ 2 + (hei_d2-y) ^ 2)
        	if dist < sqr(img->width ^ 2 + img->height ^ 2) then
        		if (wid_d2-x) = 0 and (hei_d2-y) = 0 then
                    col = 255
                else
                    col = (Strength / (dist)) * 255                    
                    col = col - 255
                end if
                if col < 0 then 
                	col = 0
                EndIf
                if col > 255 then 
                	col = 255                
                EndIf
                pset img,(x,y),RGBA(col,col,col,255)
        	else
        		pset img,(x,y),RGBA(255,0,255,0)
        	end if
        next x
next y

'' load the sprite to HW (SW data still remains for whatever purposes you want)
gl2d.load_image_to_HW(cast(gl2d.image ptr, img), GL_LINEAR)

dim as uinteger colors(MAX_BLOBS)
dim as single scale(MAX_BLOBS)

for i as integer = 0 to MAX_BLOBS
	colors(i) = GL2D_RGBA(RND*256,RND*256,RND*256,RND*256)
	scale(i) = 0.5 + abs(sin(i)*1.5)
Next i


dim as integer xa, ya, xb, yb

xa = 100
ya = 100

xb = 200
yb = 100

dim as single demo_time
 
do
		
	demo_time = timer 
	'' clear buffer
	gl2d.clear_screen()
	
	
	'' normal color
	glColor4ub(255,255,255,255)

	gl2d.set_blend_mode(GL2D.E_GLOW)
	
    for i as integer = 0 to MAX_BLOBS
        dim as integer bx = sin(demo_time / 175 * 0.8 * i) * 320  
        dim as integer by = cos(demo_time / 195 * 0.9 * i) * 240
        glColor4ubv(cast( GLubyte ptr, @colors(i)))             
        gl2d.sprite_scale(320-32+bx,240-32+by,scale(i),cast(gl2d.image ptr,img))            
    next i

	'' limit fps to 60 frames per second
	dim as single FPS = gl2d.fps_limit(60)	

	'' Test print
	gl2d.set_blend_mode(GL2D.E_TRANS)   '' transparent
	glColor4ub(0,0,0,255)  '' no transluceny
	gl2d.print_scale(0, 0,2, "Disco Balls!!!    FPS = " + str(fps))
	gl2d.print_scale(0, 20,2, "Did you just take LSD?")
	
	
	if multikey(SC_LEFT ) and xa >   0 then xa = xa - 1
    if multikey(SC_RIGHT) and xa < 639 then xa = xa + 1
    if multikey(SC_UP   ) and ya >   0 then ya = ya - 1
    if multikey(SC_DOWN ) and ya < 479 then ya = ya + 1

    flip
    
    
	sleep 1,1
Loop Until Multikey( FB.SC_ESCAPE ) 



'' destroy da happy face
gl2d.destroy_image(cast(gl2d.image ptr,img))
gl2d.destroy()


'' Reset screen and test the sprite in
'' FBGFX mode
screenres 640, 480, 32

cls

Print "Back in FBGFX"
Print "This is how our texture looks in FBGFX" 
put(100,100), img, trans

sleep
sleep

end


