#include once "fbgl2d.bi"   
#include once "fbgl2d.bas" 


const SCR_WIDTH = 640
const SCR_HEIGHT = 480
const as single PI = atn(1)*4

'' initialize gl2d (640 x 480)
gl2d.screen_init( SCR_WIDTH, SCR_HEIGHT )

gl2d.vsync_on()   '' set vsynch on

dim as integer frame = 0
do
	
	frame += 1
	'' clear buffer always
	gl2d.clear_screen()
	

	'' circle test
	gl2d.circle_2d_filled(100,100,150-abs(sin(frame/25)*150),GL2D_RGBA(0,255,0,255))
	gl2d.circle_2d(100,100,abs(sin(frame/25)*150),GL2D_RGBA(255,255,0,255))
	
	'' Draw black box
	gl2d.set_blend_mode(GL2D.E_SOLID)
	
	GL2D.box_filled(400,40,639,479,GL2D_RGBA(0,0,0,0))

	'' ellipse test
	gl2d.set_blend_mode(GL2D.E_BLENDED)	
	gl2d.ellipse(320, 240, 50, 200, PI/6*5, GL2D_RGBA(255, 128, 64, 255))
	gl2d.ellipse_filled(320, 240, 10+abs(sin(frame/25)*250), 10+250-abs(sin(frame/25)*250), frame/65, GL2D_RGBA(255, 128, 64, 255))

	
	'' box
	GL2D.box(400,40,639,479,GL2D_RGBA(220,255,55,0))
	
	'' triangle test
	gl2d.triangle(480,100,630,50,560,200,GL2D_RGBA(25,2,255,255))
	GL2D.Triangle_filled(490,105,610,60,590,135,GL2D_RGBA(255,255,255,255))
	
	glColor4ub(255,255,255,64)		'' factor of 64/256 blending
	gl2d.set_blend_mode(GL2D.E_BLENDED)
	GL2D.Triangle_filled_gradient(290,150,510,60,490,135,_
								  GL2D_RGBA(0,255,255,255),_
								  GL2D_RGBA(255,255,0,255),_
								  GL2D_RGBA(255,0,255,255))
	
	gl2d.set_blend_mode(GL2D.E_SOLID)  '' back to solid
	glColor4ub(255,255,255,255)		'' Opaque again
	'' pset test
	for i as integer = 0 to 359 step 10
		dim as integer px = 20 * cos(i*PI/180)
		dim as integer py = 20 * sin(i*PI/180)
		gl2d.put_pixel(430+px,70+py,GL2D_RGBA(255,2,255,255))
	next i
	
	
	gl2d.set_blend_mode(GL2D.E_GLOW)
	'' glow lines on steroids
	for i as integer = frame to 359+frame step 20
		dim as integer px = 120 * cos(i*PI/180)
		dim as integer py = 120 * sin(i*PI/180)
		dim as integer px2 = 120 * cos((i+20)*PI/180)
		dim as integer py2 = 120 * sin((i+20)*PI/180)
		dim as integer adder = abs(7*sin(frame/20))
		for j as integer= 0 to adder
			gl2d.line_glow (320+px,240+py,320+px2,240+py2,20-(adder*2),GL2D_RGBA(255+frame,255-frame,128+frame,255))
		next j
	next i

	
	'' limit fps to 60 frames per second
	dim as single FPS = gl2d.fps_limit(60)	
	
	'' Test print
	gl2d.set_blend_mode(GL2D.E_TRANS)   '' blended
	glColor4ub(255,255,255,255)  '' no transluceny
	gl2d.print_scale(40, 10,2, "Easy GL2D simple test   FPS = " + str(fps))


    flip
    
    
	sleep 1,1
Loop Until Multikey( FB.SC_ESCAPE ) 
