'' Code supplement on how to use:
''  1. Sprites and its plethora of uses 
''  2. Shadows
''  3. Fading

'' Relminator(Richard Eric M. Lope BSN RN)
'' Http://rel.betterwebber.com


#include once "fbgl2d.bi"   
#include once "fbgl2d.bas" 


declare sub draw_bg(byval spr as any ptr)

using FB

const SCR_WIDTH = 640
const SCR_HEIGHT = 480
const as single PI = atn(1)*4

const false = 0
const true = not false


'' initialize gl2d (640 x 480)
gl2d.screen_init( SCR_WIDTH, SCR_HEIGHT )

gl2d.vsync_on()   '' set vsynch on

''===================== FB EXAMPLE FILE TEST ===============================================
'' Got this sprite in the CHM examples
		
	dim img as fb.image ptr = imagecreate( 32, 32, rgb(255, 0, 255), 32 )
	circle img, (16, 16), 15, rgb(255, 255, 0),     ,     , 1, f
	circle img, (10, 10), 3,  rgb(255, 0, 255),     ,     , 2, f
	circle img, (23, 10), 3,  rgb(255, 0, 255),     ,     , 2, f
	circle img, (16, 18), 10, rgb(255, 0, 255), 3.14, 6.28

	'' load the sprite to HW (SW data still remains for whatever purposes you want)
	'' Pixel perfect collision FTW!!!
	gl2d.load_image_to_HW(cast(gl2d.image ptr, img))
''================= END FB EXAMPLE FILE TEST ===============================================



dim as integer xa, ya, xb, yb

xa = 100
ya = 100

xb = 200
yb = 100
dim as integer frame = 0
dim as integer fade = false
dim as integer fade_alpha = 0

do
	frame += 1	
	'' clear buffer
	gl2d.clear_screen()
	
	'' draw our bg
	draw_bg(img)
	
	
	'' normal color
	glColor4ub(255,255,255,255)

	'' =================================
	'' SOLID
	'' Solid simple
	gl2d.set_blend_mode(GL2D.E_SOLID)
	gl2d.sprite(100,150,cast(gl2d.image ptr,img))
	
	'' solid rotated
	'' add 1/2 dimensions since rotation is center-based
	gl2d.sprite_rotate(200 + (img->width/2),150 + (img->height/2),frame,cast(gl2d.image ptr,img))
	
	'' solid rotated and scaled
	gl2d.sprite_rotate_scale(300 + (img->width/2),150 + (img->height/2),-frame,sin(frame/30)*3,cast(gl2d.image ptr,img))
	
	'' solid flipped
	gl2d.sprite_flip(400,150,GL2D.E_VH,cast(gl2d.image ptr,img))

	
	'' =================================
	'' TRANSPARENT
	'' Trans simple
	gl2d.set_blend_mode(GL2D.E_TRANS)
	gl2d.sprite(100,250,cast(gl2d.image ptr,img))
	
	'' Trans rotated
	'' add 1/2 dimensions since rotation is center-based
	gl2d.sprite_rotate(200 + (img->width/2),250 + (img->height/2),frame,cast(gl2d.image ptr,img))
	
	'' Trans rotated and scaled
	gl2d.sprite_rotate_scale(300 + (img->width/2),250 + (img->height/2),-frame,sin(frame/30)*3,cast(gl2d.image ptr,img))
		
	'' Trans flipped
	gl2d.sprite_flip(400,250,GL2D.E_VH,cast(gl2d.image ptr,img))
	
	
	'' =================================
	'' BLENDED
	
	
	'' set color to 200/256 blending
	glColor4ub(255,255,255,200)
	'' blend simple
	gl2d.set_blend_mode(GL2D.E_BLENDED)
	gl2d.sprite(100,350,cast(gl2d.image ptr,img))
	
	'' blend rotated
	'' add 1/2 dimensions since rotation is center-based
	gl2d.sprite_rotate(200 + (img->width/2),350 + (img->height/2),frame,cast(gl2d.image ptr,img))
	
	'' blend rotated and scaled
	gl2d.sprite_rotate_scale(300 + (img->width/2),350 + (img->height/2),-frame,sin(frame/30)*3,cast(gl2d.image ptr,img))
	
	'' blend flipped
	gl2d.sprite_flip(400,350,GL2D.E_VH,cast(gl2d.image ptr,img))

	
	'' =================================
	'' Green blended streched
	gl2d.set_blend_mode(GL2D.E_BLENDED)
	glColor4ub(0,255,255,200)
	gl2d.sprite_stretch_h(xb,yb,32+abs(sin(frame/20)*300),cast(gl2d.image ptr,img))

	'' red transparent
	gl2d.set_blend_mode(GL2D.E_TRANS)
	glColor4ub(255,0,0,255)
	
	gl2d.sprite(xa,ya,cast(gl2d.image ptr,img))

	'' shadow and fade effect
	gl2d.set_blend_mode(GL2D.E_BLACK)   '' transparent
	glColor4ub(0,255,255,abs(sin(frame/50)*255))
	'' blend rotated and scaled
	gl2d.sprite_rotate_scale(500 + (img->width/2),100 + (img->height/2),-frame,sin(frame/30)*5,cast(gl2d.image ptr,img))

	

	'' Sprite stencil (draws a sprite in pure RGBA color)
	gl2d.Set_blend_mode(GL2D.E_TRANS)

	'' enable sprite stencil with colour of GL2D_RGBA(0,0,255,255) and env color of GL2D_RGBA(255,0,255,255)
	gl2d.enable_sprite_stencil(true, GL2D_RGBA(0,0,255,255), GL2D_RGBA(255,0,255,255))

	'' Fuchsia color transparent
	gl2d.sprite_rotate_scale(500 + (img->width/2),250 + (img->height/2),frame,sin(frame/20)*5,cast(gl2d.image ptr,img))
	
	'' Pure white blended
	gl2d.enable_sprite_stencil(true, GL2D_RGBA(255,255,255,255), GL2D_RGBA(255,255,255,255))
	gl2d.set_blend_mode(GL2D.E_BLENDED)   '' blending
	glColor4ub(0,0,255,127)
	gl2d.sprite_rotate_scale(500 + (img->width/2),400 + (img->height/2),-frame,sin(frame/24)*5,cast(gl2d.image ptr,img))

	'' disable sprite stencil
	gl2d.enable_sprite_stencil(false)


	
	if multikey(SC_LEFT ) and xa >   0 then xa = xa - 1
    if multikey(SC_RIGHT) and xa < 639 then xa = xa + 1
    if multikey(SC_UP   ) and ya >   0 then ya = ya - 1
    if multikey(SC_DOWN ) and ya < 479 then ya = ya + 1

	if multikey(SC_SPACE) then fade = true
	

	if fade then
		gl2d.set_blend_mode(GL2D.E_BLENDED)   '' fade to white by blending
		gl2d.box_filled(0,0, SCR_WIDTH-1, SCR_HEIGHT-1, GL2D_RGBA(255,255,255,fade_alpha))
		if frame and 7 then fade_alpha += 1   '' increase alpha every 8th frame
		if fade_alpha = 255 then exit do   '' exit if full
	EndIf

	'' limit fps to 60 frames per second
	dim as single FPS = gl2d.fps_limit(60)	

	'' Test print
	gl2d.set_blend_mode(GL2D.E_TRANS)   '' transparent
	glColor4ub(255,255,255,255)  '' no transluceny
	gl2d.print_scale(0, 10,2, "Simple sprites      FPS = " + str(fps))
	gl2d.set_blend_mode(GL2D.E_BLENDED)   '' transparent
	glColor4ub(0,255,255,200)  '' 1/2 transluceny
	gl2d.print_scale(0, 30,1.5, "Use arrow keys to move.")
	
	gl2d.print_scale(0, 50,1.5, "Press <space> to fade.")
		
    flip
    
    
	sleep 1,1
Loop Until Multikey( FB.SC_ESCAPE ) 




'' destroy da happy face
gl2d.destroy_image(cast(gl2d.image ptr,img))
gl2d.destroy()


'' Reset screen and test the sprite in
'' FBGFX mode
screenres 640, 480, 32

cls

Print "Back in FBGFX"
put(100,100), img, trans

sleep
sleep

end


sub draw_bg(byval spr as any ptr)
	
	dim as FB.image ptr temp = spr
	dim as integer tiles_x = SCR_WIDTH\temp->width 
	dim as integer tiles_Y = SCR_HEIGHT\temp->height 
	
	gl2d.set_blend_mode(GL2D.E_TRANS)
			
	for y as integer = 0 to tiles_y
		for x as integer = 0 to tiles_x
			glColor4ub(x*2 / (tiles_x) * 255, y*4 / (tiles_y) * 255, (y+x)*2 / (tiles_y) * 255,255)
			gl2d.sprite(x * temp->width,y * temp->height,cast(gl2d.image ptr, spr))
		next x
	next y

End Sub
