'$dynamic

#include "fmod.bi"
#include "fbgfx.bi"

DECLARE SUB MultiPut(byval lpTarget as any ptr=0, byval xMidPos as integer= 0, byval yMidPos as integer= 0, lpSource as any ptr, byval xScale as single = 1, byval yScale as single = 1, byval Rotate as single = 0, byval ColorKey as integer=-1) 
' More needed constants.

const FALSE = 0
const TRUE = 1

DECLARE SUB SpawnParticle (px!, py!, ptyp, stoogetyp, grndy, duration)
DECLARE SUB SpawnCorpse (cx!, cy!, ctyp, cspr, grndy, corpsedirec)
DECLARE SUB SpawnExplosion (ex!, ey!, etyp, espr)
DECLARE SUB SpawnProjectile (prx!, pry!, prtyp, prspr)
DECLARE SUB ParticleLayer ()
DECLARE SUB CorpseLayer ()
DECLARE SUB ExplosionLayer ()
DECLARE SUB ProjectilesLayer ()
DECLARE SUB MoveDrawStooges ()
DECLARE SUB CheckForHit ()
DECLARE SUB StoogeAI (currentstooge)
DECLARE SUB MainLoop ()
DECLARE SUB AddStooges (snumber)

' Sound/music subs/functions.
DECLARE SUB setSoundVolume
DECLARE SUB playsample(snd as integer ptr)
DECLARE SUB playStreamMusic(musc As String)
DECLARE SUB stopStreamMusic()

dim shared fpslimit AS INTEGER
dim shared st as double

fpslimit = 70

TYPE SpriteType
Alive AS INTEGER
DeathAnim AS INTEGER
DeathMode AS INTEGER
X AS SINGLE
Y AS SINGLE
XSpeed AS SINGLE
YSpeed AS SINGLE
YInertia AS SINGLE
XInertia AS SINGLE
GroundY AS INTEGER
Locked AS INTEGER
Typ AS INTEGER
LifeTime AS INTEGER
Direction AS INTEGER
Sprite AS INTEGER
AIMode AS INTEGER
Mode AS INTEGER
END TYPE

CONST maxparticles = 2000

DIM SHARED Stooge(150) AS SpriteType
DIM SHARED Explosion(25) AS SpriteType
DIM SHARED Projectile(20) AS SpriteType
DIM SHARED Particle(maxparticles) AS SpriteType
DIM SHARED Corpse(maxparticles) AS SpriteType
DIM SHARED gamesprite(400, 6400*4) AS INTEGER
DIM SHARED mainsprite (20, 6400*4) AS INTEGER
DIM SHARED myimage(4, 77000*4) AS INTEGER
DIM SHARED numofstooges, Frame1, Frame2, Frame3, Frame4, Frame5, FreezShot, mmx, mmy, mbutton
DIM SHARED cpart, FPS2, numofpart, Reload, curspr, stagedirec
DIM SHARED CamX, SFXVolume, MusicVolume, StoogeControl, countst
DIM SHARED Tremble, tr
DIM SHARED StartTime&, workpage
DIM SHARED FMODStatus AS INTEGER
DIM SHARED PlaySound AS INTEGER
DIM SHARED sample(16) AS INTEGER PTR
DIM SHARED music_handle AS INTEGER PTR

screenres 320,240,24,2,1
SCREENSET 1, 0
SETMOUSE 50,50,0 ' Hides the mouse cursor.

screenset workpage, workpage xor 1 

BLOAD "BACKG11a24.BMP",0
GET (0,0)-(319,239), myimage(1, 0)
BLOAD "BACKG12a24.BMP",0
GET (0,0)-(319,239), myimage(2, 0)
BLOAD "sprites124.BMP",0
GET (0,0)-(16,17), mainsprite(1, 0)
GET (29,0)-(45,17), mainsprite(2, 0)
FOR countexpl = 1 TO 6
GET (116+(countexpl-1)*29,0)-(140+(countexpl-1)*29,25), mainsprite(countexpl+2,0)    
NEXT countexpl
GET (60,7)-(68,17), mainsprite(9,0) ' bomb
'GET (70,5)-(78,17), mainsprite(10,0)
GET (5,40)-(21,47), mainsprite(11,0)

GET (30,43)-(36,46), mainsprite(12,0) ' corpse shadow big
GET (39,43)-(46,45), mainsprite(13,0) ' corpse shadow small

FOR stoogetype = 1 TO 4
BLOAD "stooge"+ LTRIM$(RTRIM$(STR$(stoogetype)))+"24.BMP",0
FOR countspr = 1 TO 12
GET (0+(countspr-1)*20,0)-(15+(countspr-1)*20, 12), gamesprite(countspr+(stoogetype-1)*57, 0)    
NEXT countspr
GET (0,25)-(3,28), gamesprite(13+(stoogetype-1)*57,0)   ' head 1
GET (20,25)-(23,28), gamesprite(14+(stoogetype-1)*57,0) ' head 2
GET (40,25)-(43,28), gamesprite(15+(stoogetype-1)*57,0) ' head 3
FOR countspr = 1 TO 9
GET (60+(countspr-1)*20, 25)-(63+(countspr-1)*20, 28), gamesprite(countspr+15+(stoogetype-1)*57, 0) ' body parts/blood   
NEXT countspr
GET (20,48)-(35,60), gamesprite(25+(stoogetype-1)*57,0) ' crawling 1
GET (40,48)-(55,60), gamesprite(26+(stoogetype-1)*57,0) ' crawling 2
GET (0,48)-(15,60), gamesprite(27+(stoogetype-1)*57,0)  ' crawler's shot corpse
FOR countspr = 1 TO 10
GET (60+(countspr-1)*20, 48)-(75+(countspr-1)*20, 60), gamesprite(countspr+27+(stoogetype-1)*57, 0) ' burn walk and burn die sprites(32-37)  
NEXT countspr
FOR countspr = 1 TO 4
GET (20+(countspr-1)*20, 73)-(23+(countspr-1)*20, 76), gamesprite(countspr+37+(stoogetype-1)*57, 0) ' ash particles  
NEXT countspr
GET (100,72)-(115,84), gamesprite(42+(stoogetype-1)*57, 0) ' crawler died corpse
GET (120,72)-(135,84), gamesprite(43+(stoogetype-1)*57, 0) ' standing and looking front
GET (140,72)-(155,84), gamesprite(44+(stoogetype-1)*57, 0) ' stooge waving 1
GET (160,72)-(175,84), gamesprite(45+(stoogetype-1)*57, 0) ' stooge waving 2
GET (180,72)-(195,84), gamesprite(46+(stoogetype-1)*57, 0) ' stooge butt scratching 1
GET (200,72)-(215,84), gamesprite(47+(stoogetype-1)*57, 0) ' stooge butt scratching 2
GET (220,72)-(235,84), gamesprite(48+(stoogetype-1)*57, 0) ' stooge jumping 1
GET (0,96)-(15,108), gamesprite(49+(stoogetype-1)*57, 0) ' stooge jumping 2
GET (20,96)-(35,108), gamesprite(50+(stoogetype-1)*57, 0) ' explosion corpse flying
GET (40,96)-(55,108), gamesprite(51+(stoogetype-1)*57, 0) ' explosion corpse on the ground
GET (80,96)-(95,108), gamesprite(52+(stoogetype-1)*57, 0)  ' fighting with the dog 1
GET (100,96)-(115,108), gamesprite(53+(stoogetype-1)*57, 0) ' fighting with the dog 2 
NEXT stoogetype


PlaySound = TRUE
FMODStatus = TRUE

IF FMODStatus = TRUE THEN
FSOUND_Init(44100, 16, 0) 
IF FSOUND_Init(44100, 16, 0) = 0 THEN PlaySound = FALSE
END IF

IF PlaySound = TRUE THEN
sample(1)=FSOUND_SAMPLE_Load(FSOUND_FREE,"Sound/shot.ogg",0,0,0)
sample(2)=FSOUND_SAMPLE_Load(FSOUND_FREE,"Sound/equip.mp3",0,0,0)
sample(3)=FSOUND_SAMPLE_Load(FSOUND_FREE,"Sound/death3.ogg",0,0,0)
sample(4)=FSOUND_SAMPLE_Load(FSOUND_FREE,"Sound/death1.ogg",0,0,0)
sample(7)=FSOUND_SAMPLE_Load(FSOUND_FREE,"Sound/death2.ogg",0,0,0)
sample(5)=FSOUND_SAMPLE_Load(FSOUND_FREE,"Sound/mushy1.ogg",FSOUND_NORMAL,0,0)
sample(6)=FSOUND_SAMPLE_Load(FSOUND_FREE,"Sound/mushy2.ogg",FSOUND_NORMAL,0,0)
sample(8)=FSOUND_SAMPLE_Load(FSOUND_FREE,"Sound/wound.ogg",FSOUND_NORMAL,0,0)
sample(9)=FSOUND_SAMPLE_Load(FSOUND_FREE,"Sound/death4.ogg",FSOUND_NORMAL,0,0)
sample(10)=FSOUND_SAMPLE_Load(FSOUND_FREE,"Sound/death5.ogg",FSOUND_NORMAL,0,0)
sample(11)=FSOUND_SAMPLE_Load(FSOUND_FREE,"Sound/explosion.ogg",FSOUND_NORMAL,0,0)
sample(12)=FSOUND_SAMPLE_Load(FSOUND_FREE,"Sound/bomb_fall.ogg",FSOUND_NORMAL,0,0)

sample(13)=FSOUND_SAMPLE_Load(FSOUND_FREE,"Sound/women_wound.ogg",FSOUND_NORMAL,0,0)
sample(14)=FSOUND_SAMPLE_Load(FSOUND_FREE,"Sound/women_death1.ogg",FSOUND_NORMAL,0,0)
sample(15)=FSOUND_SAMPLE_Load(FSOUND_FREE,"Sound/women_death2.ogg",FSOUND_NORMAL,0,0)
sample(16)=FSOUND_SAMPLE_Load(FSOUND_FREE,"Sound/women_death3.ogg",FSOUND_NORMAL,0,0)
sample(17)=FSOUND_SAMPLE_Load(FSOUND_FREE,"Sound/women_death4.ogg",FSOUND_NORMAL,0,0)

END IF

stagedirec = 1
numofstooges = 100
CamX = 160
SFXVolume = 1
MusicVolume = 1
Tremble = FALSE

FOR initstooge = 1 TO numofstooges
Stooge(initstooge).X = int(rnd * 300) - 320 
Stooge(initstooge).Y = int(rnd * 180) + 38
Stooge(initstooge).Alive = FALSE
IF initstooge < 50 THEN Stooge(initstooge).Alive = TRUE
Stooge(initstooge).DeathAnim = 0
Stooge(initstooge).XSpeed = (int(rnd * 2) + 3) / 10
Stooge(initstooge).AIMode = 1
Stooge(initstooge).YInertia = 0
Stooge(initstooge).XInertia = 0
Stooge(initstooge).Typ = int(rnd * 4) + 1
NEXT initstooge

RANDOMIZE TIMER

MainLoop
END


SUB SpawnParticle (px!, py!, ptyp, stoogetyp, grndy, duration)

FOR cpart2 = 1 TO maxparticles

IF Particle(cpart2).Locked = FALSE THEN
Particle(cpart2).Locked = TRUE
Particle(cpart2).X = px!
Particle(cpart2).Y = py!
Particle(cpart2).LifeTime = 300
Particle(cpart2).Typ = ptyp
IF Particle(cpart2).Typ < 3 THEN
xspd = int(rnd * 6) + 1
IF xspd = 1 THEN Particle(cpart2).XSpeed = 0.15
IF xspd = 2 THEN Particle(cpart2).XSpeed = 0.2
IF xspd = 3 THEN Particle(cpart2).XSpeed = 0.25
IF xspd = 4 THEN Particle(cpart2).XSpeed = -0.15
IF xspd = 5 THEN Particle(cpart2).XSpeed = -0.2
IF xspd = 6 THEN Particle(cpart2).XSpeed = -0.25
Particle(cpart2).YInertia = (int(rnd * 3) + 1) / 10 
Particle(cpart2).GroundY = grndy
Particle(cpart2).Sprite = int(rnd * 9) + 1 + (stoogetyp-1)*57
IF Particle(cpart2).Typ = 2 THEN Particle(cpart2).Sprite = int(rnd * 4) + 3 + (stoogetyp-1)*57
END IF
IF Particle(cpart2).Typ = 4 THEN Particle(cpart2).Sprite = int(rnd * 9) + 1 + (stoogetyp-1)*57
IF Particle(cpart2).Typ = 10 THEN Particle(cpart2).Sprite = stoogetyp
EXIT SUB
END IF

NEXT cpart2
 
END SUB

SUB SpawnCorpse (cx!, cy!, ctyp, cspr, grndy, corpsedirec)

FOR ccorp2 = 1 TO maxparticles
IF Corpse(ccorp2).Locked = FALSE THEN
Corpse(ccorp2).Locked = TRUE
Corpse(ccorp2).X = cx!
Corpse(ccorp2).Y = cy!
Corpse(ccorp2).Mode = 1
Corpse(ccorp2).Typ = ctyp
Corpse(ccorp2).Sprite = cspr
IF Corpse(ccorp2).Typ < 4 THEN
xspd = int(rnd * 6) + 1
IF xspd = 1 THEN Corpse(ccorp2).XSpeed = 0.15
IF xspd = 2 THEN Corpse(ccorp2).XSpeed = 0.2
IF xspd = 3 THEN Corpse(ccorp2).XSpeed = 0.25
IF xspd = 4 THEN Corpse(ccorp2).XSpeed = -0.15
IF xspd = 5 THEN Corpse(ccorp2).XSpeed = -0.2
IF xspd = 6 THEN Corpse(ccorp2).XSpeed = -0.25
IF Corpse(ccorp2).Typ = 2 THEN
xspd = int(rnd * 3) + 1
IF xspd = 1 THEN Corpse(ccorp2).XSpeed = 0.15*corpsedirec
IF xspd = 2 THEN Corpse(ccorp2).XSpeed = 0.2*corpsedirec
IF xspd = 3 THEN Corpse(ccorp2).XSpeed = 0.25*corpsedirec    
END IF
Corpse(ccorp2).YInertia = (int(rnd * 3) + 4) / 10 
IF Corpse(ccorp2).Typ = 2 THEN Corpse(ccorp2).YInertia = (int(rnd * 3) + 5) / 10
Corpse(ccorp2).GroundY = grndy
IF Corpse(ccorp2).Typ = 1 THEN Corpse(ccorp2).Sprite = int(rnd * 3) + 1 + 12+(cspr-1)*57
END IF
EXIT SUB
END IF

NEXT cpart2

END SUB

SUB SpawnExplosion (ex!, ey!, etyp, espr)

FOR cexpl = 1 TO 25
IF Explosion(cexpl).Locked = FALSE THEN
Explosion(cexpl).Locked = TRUE
Explosion(cexpl).X = ex!
Explosion(cexpl).Y = ey!
Explosion(cexpl).Typ = etyp
Explosion(cexpl).LifeTime = 1
Explosion(cexpl).Sprite = espr
EXIT SUB
END IF
NEXT cexpl

END SUB

SUB SpawnProjectile (prx!, pry!, prtyp, prspr)

FOR cproj = 1 TO 20
IF Projectile(cproj).Locked = FALSE THEN
Projectile(cproj).Locked = TRUE
Projectile(cproj).X = prx!
Projectile(cproj).Y = pry!
Projectile(cproj).Typ = prtyp
Projectile(cproj).Sprite = prspr
IF Projectile(cproj).Typ = 1 THEN
Projectile(cproj).XSpeed = mmx
Projectile(cproj).YSpeed = mmy
END IF
EXIT SUB
END IF
NEXT cexpl

END SUB

SUB ProjectileLayer ()

FOR cproj = 1 TO 20
IF Projectile(cproj).Locked = FALSE THEN GOTO skipproj:

IF Projectile(cproj).Typ = 1 THEN 
IF Projectile(cproj).Y < Projectile(cproj).YSpeed THEN Projectile(cproj).Y = Projectile(cproj).Y + 4 
sspr = 13
IF Projectile(cproj).YSpeed - Projectile(cproj).Y < 50 THEN sspr = 12
PUT (Projectile(cproj).X+1-CamX,Projectile(cproj).YSpeed+2+tr), mainsprite(sspr, 0), ALPHA, 100

projspr = 9
IF ABS(Projectile(cproj).Y+9-Projectile(cproj).YSpeed)<4.1 THEN
Projectile(cproj).Locked = FALSE
SpawnExplosion Projectile(cproj).X+4-12+10, Projectile(cproj).Y+9-8-10, 1, 1
SpawnExplosion Projectile(cproj).X+4-12-10, Projectile(cproj).Y+9-8-10, 1, 1
SpawnExplosion Projectile(cproj).X+4-12+10, Projectile(cproj).Y+9-8+10, 1, 1
SpawnExplosion Projectile(cproj).X+4-12-10, Projectile(cproj).Y+9-8+10, 1, 1
SpawnExplosion Projectile(cproj).X+4-12, Projectile(cproj).Y+9-8, 1, 1
SpawnParticle Projectile(cproj).X+4-8,Projectile(cproj).Y+9-1,10,11,0,0
IF PlaySound = TRUE THEN playsample(sample(11))
Tremble = 10
FOR ccorp = 1 TO maxparticles
IF Corpse(ccorp).Locked = TRUE THEN 
IF ABS(Projectile(cproj).X+4-Corpse(ccorp).X-6)<30 AND ABS(Projectile(cproj).Y+9-Corpse(ccorp).Y-6)<30 THEN    
Corpse(ccorp).YInertia = (int(rnd * 3) + 1) / 10
Corpse(ccorp).GroundY = Corpse(ccorp).Y
Corpse(ccorp).Y = Corpse(ccorp).Y - 1
Corpse(ccorp).Mode = 2
cdirec = 1
IF Projectile(cproj).X+3>Corpse(ccorp).X+6 THEN cdirec = -1
xspd = int(rnd * 3) + 1
IF xspd = 1 THEN Corpse(ccorp).XSpeed = 0.15*cdirec
IF xspd = 2 THEN Corpse(ccorp).XSpeed = 0.2*cdirec
IF xspd = 3 THEN Corpse(ccorp).XSpeed = 0.25*cdirec
END IF
END IF
NEXT ccorp

FOR hitstooge = 1 TO numofstooges
IF (Stooge(hitstooge).Alive = TRUE AND ABS(Projectile(cproj).X+4-Stooge(hitstooge).X-6)<30 AND ABS(Projectile(cproj).Y+9-Stooge(hitstooge).Y-6)<30) THEN
Stooge(hitstooge).Alive = FALSE
Stooge(hitstooge).DeathAnim = 3
Stooge(hitstooge).DeathMode = 4
IF PlaySound = TRUE THEN playsample(sample(6)) 
IF PlaySound = TRUE THEN playsample(sample(5)) 
SpawnParticle Stooge(hitstooge).X+5,Stooge(hitstooge).Y+3,1,Stooge(hitstooge).Typ,Stooge(hitstooge).Y+11,10
SpawnParticle Stooge(hitstooge).X+4,Stooge(hitstooge).Y+5,1,Stooge(hitstooge).Typ,Stooge(hitstooge).Y+11,10
SpawnParticle Stooge(hitstooge).X+6,Stooge(hitstooge).Y+4,1,Stooge(hitstooge).Typ,Stooge(hitstooge).Y+11,10
SpawnParticle Stooge(hitstooge).X+7,Stooge(hitstooge).Y+7,1,Stooge(hitstooge).Typ,Stooge(hitstooge).Y+11,10
SpawnParticle Stooge(hitstooge).X+3,Stooge(hitstooge).Y+8,1,Stooge(hitstooge).Typ,Stooge(hitstooge).Y+11,10
SpawnParticle Stooge(hitstooge).X+5,Stooge(hitstooge).Y+7,1,Stooge(hitstooge).Typ,Stooge(hitstooge).Y+11,10
cdirec = 1
IF Projectile(cproj).X+3>Stooge(hitstooge).X+6 THEN cdirec = -1
SpawnCorpse Stooge(hitstooge).X,Stooge(hitstooge).Y, 2, 50+(Stooge(hitstooge).Typ-1)*57, Stooge(hitstooge).Y+1, cdirec
END IF
NEXT hitstooge
END IF
END IF

PUT (Projectile(cproj).X-CamX,Projectile(cproj).Y+tr), mainsprite(projspr,0), TRANS

skipproj:
NEXT cproj

END SUB

SUB ExplosionLayer ()

FOR cexpl = 1 TO 25
IF Explosion(cexpl).Locked = FALSE THEN GOTO skipexpl:

IF Frame2 = 4 THEN Explosion(cexpl).LifeTime = Explosion(cexpl).LifeTime + 1
IF Explosion(cexpl).LifeTime > 6 THEN Explosion(cexpl).Locked = FALSE

IF Explosion(cexpl).Typ = 1 THEN explspr = Explosion(cexpl).LifeTime + 2
IF Explosion(cexpl).Locked = TRUE THEN PUT (Explosion(cexpl).X-CamX,Explosion(cexpl).Y+tr), mainsprite(explspr,0), TRANS

skipexpl:
NEXT cexpl

END SUB

SUB CorpseLayer ()
    
FOR ccorp = 1 TO maxparticles

IF Corpse(ccorp).Locked = FALSE THEN GOTO skipcorpse:

'Corpse(ccorp).LifeTime = Corpse(ccorp).LifeTime - 1
'IF Corpse(ccorp).LifeTime < 0 THEN Corpse(ccorp).Locked = FALSE

IF Corpse(ccorp).Typ < 4 AND Corpse(ccorp).Mode = 1 THEN
IF Corpse(ccorp).Y < Corpse(ccorp).GroundY THEN

Corpse(ccorp).Y = Corpse(ccorp).Y - Corpse(ccorp).YInertia
IF Corpse(ccorp).Y >= Corpse(ccorp).GroundY THEN 
addy = 0
IF Corpse(ccorp).Typ = 2 THEN addy=7
SpawnParticle Corpse(ccorp).X+1,Corpse(ccorp).Y+1+addy,2,1,Corpse(ccorp).Y+3+addy,0
IF Corpse(ccorp).Typ = 2 THEN Corpse(ccorp).Sprite = Corpse(ccorp).Sprite + 1
IF PlaySound = TRUE THEN playsample(sample(6)) 
END IF
Corpse(ccorp).YInertia = Corpse(ccorp).YInertia - 0.008
Corpse(ccorp).X = Corpse(ccorp).X + Corpse(ccorp).XSpeed
END IF
END IF

IF Corpse(ccorp).Mode = 2 THEN
IF Corpse(ccorp).Y < Corpse(ccorp).GroundY THEN
Corpse(ccorp).Y = Corpse(ccorp).Y - Corpse(ccorp).YInertia
IF Corpse(ccorp).Y >= Corpse(ccorp).GroundY THEN 
addy = 0
IF Corpse(ccorp).Typ = 2 THEN addy=7
SpawnParticle Corpse(ccorp).X+1,Corpse(ccorp).Y+1+addy,2,1,Corpse(ccorp).Y+3+addy,0
IF PlaySound = TRUE THEN playsample(sample(6)) 
END IF
Corpse(ccorp).YInertia = Corpse(ccorp).YInertia - 0.008
Corpse(ccorp).X = Corpse(ccorp).X + Corpse(ccorp).XSpeed
END IF   
END IF

cspr = Corpse(ccorp).Sprite
PUT (Corpse(ccorp).X-CamX,Corpse(ccorp).Y+tr), gamesprite(cspr, 0), TRANS

skipcorpse:
NEXT ccorp
    
END SUB

SUB ParticleLayer ()

numofpart = 0
FOR cpart = 1 TO maxparticles

IF Particle(cpart).Locked = FALSE THEN GOTO skipparticle:

'Particle(cpart).LifeTime = Particle(cpart).LifeTime - 1
'IF Particle(cpart).LifeTime < 0 THEN Particle(cpart).Locked = FALSE

numofpart = numofpart + 1

IF Particle(cpart).Typ < 3 THEN

IF Particle(cpart).Y < Particle(cpart).GroundY THEN
Particle(cpart).Y = Particle(cpart).Y - Particle(cpart).YInertia
Particle(cpart).YInertia = Particle(cpart).YInertia - 0.008
Particle(cpart).X = Particle(cpart).X + Particle(cpart).XSpeed
END IF
END IF
partspr = Particle(cpart).Sprite
IF Particle(cpart).Typ < 10 THEN partspr = Particle(cpart).Sprite + 15

IF Particle(cpart).Typ < 10 THEN PUT (Particle(cpart).X-CamX, Particle(cpart).Y+tr), gamesprite(partspr,0), TRANS
IF Particle(cpart).Typ > 9 THEN PUT (Particle(cpart).X-CamX, Particle(cpart).Y+tr), mainsprite(partspr,0), ALPHA, 160

skipparticle: 
NEXT cpart

END SUB

SUB MoveDrawStooges

countst = 0

FOR countstooge = 1 TO numofstooges
    
IF Stooge(countstooge).X > 649 THEN Stooge(countstooge).Alive = FALSE

IF Stooge(countstooge).Alive=TRUE THEN
countst = countst + 1    
StoogeAI countstooge
Stooge(countstooge).DeathMode = 0
END IF

IF Stooge(countstooge).Alive = FALSE AND Stooge(countstooge).DeathAnim<3 THEN

IF Stooge(countstooge).DeathMode = 1 THEN
curspr = Stooge(countstooge).DeathAnim + 5 + (Stooge(countstooge).Typ-1)*57 
'IF PlaySound = TRUE AND Stooge(countstooge).DeathAnim = 1 AND Frame3 = 2 THEN FSOUND_PlaySound(FSOUND_FREE, sample(5)) 
IF Frame3 = 2 AND Stooge(countstooge).DeathAnim<3 THEN Stooge(countstooge).DeathAnim = Stooge(countstooge).DeathAnim + 1
IF Stooge(countstooge).DeathAnim = 3 THEN 
SpawnCorpse Stooge(countstooge).X,Stooge(countstooge).Y, 4, Stooge(countstooge).DeathAnim + 5 + (Stooge(countstooge).Typ-1)*57, 0, 0
PUT (Stooge(countstooge).X-CamX, Stooge(countstooge).Y+tr), gamesprite(curspr,0), TRANS
END IF
END IF
IF Stooge(countstooge).DeathMode = 2 THEN
curspr = Stooge(countstooge).DeathAnim + 9 + (Stooge(countstooge).Typ-1)*57 
'IF PlaySound = TRUE AND Stooge(countstooge).DeathAnim = 1 AND Frame3 = 2 THEN FSOUND_PlaySound(FSOUND_FREE, sample(5)) 
IF Frame3 = 2 AND Stooge(countstooge).DeathAnim<3 THEN Stooge(countstooge).DeathAnim = Stooge(countstooge).DeathAnim + 1
IF Stooge(countstooge).DeathAnim = 3 THEN 
SpawnCorpse Stooge(countstooge).X,Stooge(countstooge).Y, 4, Stooge(countstooge).DeathAnim + 9 + (Stooge(countstooge).Typ-1)*57, 0, 0
PUT (Stooge(countstooge).X-CamX, Stooge(countstooge).Y+tr), gamesprite(curspr,0), TRANS
END IF
END IF
IF Stooge(countstooge).DeathMode = 3 THEN 
Stooge(countstooge).DeathAnim = 3
SpawnCorpse Stooge(countstooge).X,Stooge(countstooge).Y, 4, 27 + (Stooge(countstooge).Typ-1)*57, 0, 0
END IF

END IF

IF Stooge(countstooge).DeathAnim < 3 THEN PUT (Stooge(countstooge).X-CamX, Stooge(countstooge).Y+tr), gamesprite(curspr,0), TRANS


NEXT countstooge

IF countst < 10 THEN AddStooges 30

END SUB

SUB StoogeAI (currentstooge)
    
IF Stooge(currentstooge).AIMode = 1 THEN
Stooge(currentstooge).X = Stooge(currentstooge).X + Stooge(currentstooge).XSpeed    
curspr = Frame1+(Stooge(currentstooge).Typ-1)*57 
END IF

IF Stooge(currentstooge).AIMode = 2 THEN
IF Frame5 = 50 THEN SpawnParticle Stooge(currentstooge).X+5,Stooge(currentstooge).Y+10,4,Stooge(currentstooge).Typ,Stooge(currentstooge).Y+10,10
Stooge(currentstooge).LifeTime = Stooge(currentstooge).LifeTime - 1
IF Stooge(currentstooge).LifeTime < 0 THEN
Stooge(currentstooge).Alive = FALSE
Stooge(currentstooge).DeathAnim = 3
IF PlaySound = TRUE THEN playsample(sample(10)) 
SpawnCorpse Stooge(currentstooge).X,Stooge(currentstooge).Y, 2, 42+(Stooge(currentstooge).Typ-1)*57, 0, 0
PUT (Stooge(currentstooge).X,Stooge(currentstooge).Y), gamesprite(42+(Stooge(currentstooge).Typ-1)*57 ,0), TRANS
END IF
IF Stooge(currentstooge).Y < Stooge(currentstooge).GroundY THEN
Stooge(currentstooge).Y = Stooge(currentstooge).Y - Stooge(currentstooge).YInertia
IF Stooge(currentstooge).Y >= Stooge(currentstooge).GroundY THEN 
SpawnParticle Stooge(currentstooge).X+2,Stooge(currentstooge).Y+5,2,Stooge(currentstooge).Typ,Stooge(currentstooge).Y+10,0
SpawnParticle Stooge(currentstooge).X+4,Stooge(currentstooge).Y+5,2,Stooge(currentstooge).Typ,Stooge(currentstooge).Y+10,0
IF PlaySound = TRUE THEN playsample(sample(6))
END IF
Stooge(currentstooge).YInertia = Stooge(currentstooge).YInertia - 0.008
Stooge(currentstooge).X = Stooge(currentstooge).X + Stooge(currentstooge).XSpeed
curspr = 25+(Stooge(currentstooge).Typ-1)*57 
END IF
IF Stooge(currentstooge).Y >= Stooge(currentstooge).GroundY THEN 
Stooge(currentstooge).X = Stooge(currentstooge).X + 0.03  
curspr = Frame4 + 24+(Stooge(currentstooge).Typ-1)*57 
END IF
END IF

END SUB

SUB CheckForHit ()

Reload = 20
IF PlaySound = TRUE THEN playsample (sample(1)) 

FOR countstooge=1 TO numofstooges
IF ABS(Stooge(countstooge).X+6-CamX-mmx)<5 AND Stooge(countstooge).Alive = TRUE THEN

IF Stooge(countstooge).AIMode = 1 THEN    
IF ABS(mmy-Stooge(countstooge).Y)<5 AND mmy>=Stooge(countstooge).Y THEN 
IF PlaySound = TRUE AND Stooge(countstooge).Typ <> 4 THEN playsample (sample(3)) 
IF PlaySound = TRUE AND Stooge(countstooge).Typ = 4 THEN playsample (sample(17)) 
IF PlaySound = TRUE THEN playsample (sample(5)) 
SpawnParticle Stooge(countstooge).X+5,Stooge(countstooge).Y+2,1,Stooge(countstooge).Typ,Stooge(countstooge).Y+11,10
SpawnParticle Stooge(countstooge).X+6,Stooge(countstooge).Y+5,1,Stooge(countstooge).Typ,Stooge(countstooge).Y+11,10
SpawnParticle Stooge(countstooge).X+6,Stooge(countstooge).Y+4,1,Stooge(countstooge).Typ,Stooge(countstooge).Y+11,10
SpawnCorpse Stooge(countstooge).X+6,Stooge(countstooge).Y, 1, Stooge(countstooge).Typ, Stooge(countstooge).Y+11, 0
Stooge(countstooge).DeathAnim = 0
Stooge(countstooge).DeathMode = 2
Stooge(countstooge).Alive = FALSE
END IF
IF mmy-Stooge(countstooge).Y>4 AND mmy-Stooge(countstooge).Y<10 THEN 
sndtype = int(rnd * 2) + 1
IF PlaySound = TRUE AND sndtype = 1 AND Stooge(countstooge).Typ <> 4 THEN playsample (sample(7)) 
IF PlaySound = TRUE AND sndtype = 2 AND Stooge(countstooge).Typ <> 4 THEN playsample (sample(4)) 
IF PlaySound = TRUE AND sndtype = 1 AND Stooge(countstooge).Typ = 4 THEN playsample (sample(14))
IF PlaySound = TRUE AND sndtype = 2 AND Stooge(countstooge).Typ = 4 THEN playsample (sample(15))
IF PlaySound = TRUE THEN playsample (sample(5)) 
SpawnParticle Stooge(countstooge).X+6,Stooge(countstooge).Y+2,1,Stooge(countstooge).Typ,Stooge(countstooge).Y+11,10
SpawnParticle Stooge(countstooge).X+7,Stooge(countstooge).Y+5,1,Stooge(countstooge).Typ,Stooge(countstooge).Y+11,10
SpawnParticle Stooge(countstooge).X+5,Stooge(countstooge).Y+4,1,Stooge(countstooge).Typ,Stooge(countstooge).Y+11,10
Stooge(countstooge).DeathAnim = 0
Stooge(countstooge).DeathMode = 1
Stooge(countstooge).Alive = FALSE
END IF
IF mmy-Stooge(countstooge).Y>9 AND mmy-Stooge(countstooge).Y<12 THEN 
SpawnParticle Stooge(countstooge).X+6,Stooge(countstooge).Y+2,1,Stooge(countstooge).Typ,Stooge(countstooge).Y+11,10
SpawnParticle Stooge(countstooge).X+7,Stooge(countstooge).Y+5,1,Stooge(countstooge).Typ,Stooge(countstooge).Y+11,10
SpawnParticle Stooge(countstooge).X+5,Stooge(countstooge).Y+4,1,Stooge(countstooge).Typ,Stooge(countstooge).Y+11,10
Stooge(countstooge).AIMode = 2
Stooge(countstooge).LifeTime = 2000
IF PlaySound = TRUE AND Stooge(countstooge).Typ <> 4 THEN playsample (sample(8)) 
IF PlaySound = TRUE AND Stooge(countstooge).Typ = 4 THEN playsample (sample(13)) 
Stooge(countstooge).GroundY = Stooge(countstooge).Y + 6
Stooge(countstooge).YInertia = (int(rnd * 2) + 1) / 10 
xspd = int(rnd * 3) + 1
IF xspd = 1 THEN Stooge(countstooge).XSpeed = 0.1*stagedirec
IF xspd = 2 THEN Stooge(countstooge).XSpeed = 0.15*stagedirec
IF xspd = 3 THEN Stooge(countstooge).XSpeed = 0.2*stagedirec
GOTO skipstooge:
END IF
END IF

IF Stooge(countstooge).AIMode = 2 THEN
IF mmy-Stooge(countstooge).Y>7 AND mmy-Stooge(countstooge).Y<12 AND Stooge(countstooge).Y >= Stooge(countstooge).GroundY THEN 
SpawnParticle Stooge(countstooge).X+6,Stooge(countstooge).Y+9,1,Stooge(countstooge).Typ,Stooge(countstooge).Y+11,10
SpawnParticle Stooge(countstooge).X+7,Stooge(countstooge).Y+8,1,Stooge(countstooge).Typ,Stooge(countstooge).Y+11,10
SpawnParticle Stooge(countstooge).X+5,Stooge(countstooge).Y+10,1,Stooge(countstooge).Typ,Stooge(countstooge).Y+11,10
Stooge(countstooge).Alive = FALSE 
Stooge(countstooge).DeathAnim = 0
Stooge(countstooge).DeathMode = 3
IF PlaySound = TRUE AND Stooge(countstooge).Typ <> 4 THEN playsample (sample(9)) 
IF PlaySound = TRUE AND Stooge(countstooge).Typ = 4 THEN playsample (sample(16)) 
END IF    
END IF

END IF
skipstooge:
NEXT countstooge

END SUB

SUB MainLoop ()

DO
    
IF PlaySound = TRUE THEN FSOUND_Update 

IF MULTIKEY(SC_LEFT) THEN CamX = CamX - 2
IF MULTIKEY(SC_RIGHT) THEN CamX = CamX + 2
IF CamX > 320 THEN CamX = 320
IF CamX < 0 THEN CamX = 0

Reload = Reload - 1
IF Reload < 0 THEN Reload = 0

Frame2 = (Frame2 MOD 5) + 1
Frame3 = (Frame3 MOD 15) + 1
Frame5 = (Frame5 MOD 400) + 1
IF Frame2 = 2 THEN Frame1 = (Frame1 MOD 4) + 1
IF Frame3 = 2 THEN Frame4 = (Frame4 MOD 2) + 1
IF Frame1 = 0 THEN Frame1 = 1
IF Frame4 = 0 THEN Frame4 = 1

FPS = FPS + 1                     ' Used to count FPS.
if StartTime& + 1 < timer then
 FPS2 = FPS
 FPS = 0
 seconds = seconds + 1
 StartTime& = timer
end if

screenset workpage, workpage xor 1

GETMOUSE mmx,mmy,,mbutton
CLS
mx! = mmx
my! = mmy

IF mbutton = 2 AND Reload = 0 THEN
Reload = 20
IF PlaySound = TRUE THEN playsample(sample(12))
SpawnProjectile mx!+CamX-3, -100, 1, 1
END IF

tr = 0
IF Tremble > 0 THEN 
tr = Frame2 - 3
Tremble = Tremble - 1
END IF

PUT (0-CamX,0+tr), myimage(1,0), PSET
PUT (320-CamX,0+tr), myimage(2,0), PSET

IF mbutton = 1 AND Reload = 0 THEN
'FreezShot = TRUE
CheckForHit
END IF

ParticleLayer
CorpseLayer
'GET (0,0)-(319,239), myimage(3,0)
'PUT (0,0), myimage(3,0), PSET
MoveDrawStooges
ExplosionLayer
ProjectileLayer

movy = 0
IF Reload = 20 THEN movy = 1
IF Reload = 19 THEN movy = 2
IF Reload = 18 THEN movy = 3
IF Reload = 17 THEN movy = 2
IF Reload = 16 THEN movy = 1
PUT (mmx-8, mmy-8-movy), mainsprite(1,0), TRANS
IF Reload > 13 THEN PUT (mmx-8, mmy-8), mainsprite(2,0), TRANS

'COLOR &H00C000
'LOCATE 1,1
'PRINT FPS2, numofpart, mmx,mmy, Reload
'PRINT STR$(FRE(1))
workpage xor = 1 

do 
loop until timer - st >= (1/fpslimit) 
st = timer 

SLEEP 1

IF mbutton = 1 THEN GOTO skipbuttonrestore:
FreezShot = FALSE
skipbuttonrestore:

LOOP UNTIL MULTIKEY(SC_ESCAPE)

END SUB

SUB AddStooges (snumber)

countadd = 0
FOR initstooge = 1 TO numofstooges
IF Stooge(initstooge).Alive = FALSE THEN
Stooge(initstooge).X = int(rnd * 300) - 320 
Stooge(initstooge).Y = int(rnd * 180) + 38
Stooge(initstooge).Alive = TRUE
Stooge(initstooge).DeathAnim = 0
Stooge(initstooge).XSpeed = (int(rnd * 2) + 3) / 10
Stooge(initstooge).AIMode = 1
Stooge(initstooge).YInertia = 0
Stooge(initstooge).XInertia = 0
countadd = countadd + 1
IF countadd >= snumber THEN EXIT SUB
END IF
NEXT initstooge

END SUB

Sub setSoundVolume
IF PlaySound = TRUE THEN
IF SFXVolume = 0 THEN SetVol% = 0
IF SFXVolume = 1 THEN SetVol% = 63
IF SFXVolume = 2 THEN SetVol% = 126
IF SFXVolume = 3 THEN SetVol% = 190
IF SFXVolume = 4 THEN SetVol% = 255
  FSOUND_SetSFXMasterVolume(SetVol%)
IF MusicVolume = 0 THEN SetVol% = 0
IF MusicVolume = 1 THEN SetVol% = 63
IF MusicVolume = 2 THEN SetVol% = 126
IF MusicVolume = 3 THEN SetVol% = 190
IF MusicVolume = 4 THEN SetVol% = 255
FSOUND_SetVolumeAbsolute(1, SetVol%)
END IF

End Sub

sub playsample(snd as integer ptr)
    IF SFXVolume = 0 THEN EXIT SUB
    If PlaySound = TRUE Then 
        setSoundVolume
        FSOUND_PlaySound(FSOUND_FREE, snd) 
    end if
end sub


Sub playStreamMusic(musc As String)
    IF MusicVolume = 0 THEN EXIT SUB
    if PlaySound = TRUE then
        music_handle = FSOUND_Stream_Open(musc, FSOUND_LOOP_NORMAL, 0, 0 ) 
        FSOUND_Stream_SetMode(music_handle,FSOUND_LOOP_NORMAL) 
        FSOUND_Stream_Play(1, music_handle)
IF MusicVolume = 0 THEN SetVol% = 0
IF MusicVolume = 1 THEN SetVol% = 63
IF MusicVolume = 2 THEN SetVol% = 126
IF MusicVolume = 3 THEN SetVol% = 190
IF MusicVolume = 4 THEN SetVol% = 255
FSOUND_SetVolumeAbsolute(1, SetVol%)
end if	

end sub

Sub stopStreamMusic()
    if PlaySound = TRUE then
        FSOUND_Stream_Stop music_handle
        FSOUND_Stream_Close music_handle
    end if
end sub

SUB MultiPut(byval lpTarget as any ptr= 0, _ 
             byval xMidPos  as integer= 0, _ 
             byval yMidPos  as integer= 0, _ 
             lpSource as any ptr, _ 
             byval xScale   as single = 1, _ 
             byval yScale   as single = 1, _ 
             byval Rotate   as single = 0, _ 
             byval ColorKey as integer=-1) 

  if (screenptr=0) or (lpSource=0) then exit sub 

  if xScale < 0.001 then xScale=0.001 
  if yScale < 0.001 then yScale=0.001 

  dim as integer MustLock,MustRotate,MustKeying 

  if lpTarget= 0 then MustLock  =1 
  if Rotate  <>0 then MustRotate=1 
  if ColorKey>-1 then MustKeying=1 

  dim as byte  ptr TargetPtr,SourcePtr 
  dim as byte      val8 
  dim as short ptr ptr16 
  dim as short     val16 
  dim as integer   val32,TargetWidth,TargetHeight,TargetBytes 
  if MustLock then 
    screeninfo TargetWidth,TargetHeight,TargetBytes 
    TargetPtr=screenptr:TargetBytes=TargetBytes shr 3 
  else 
    ptr16=cptr(short ptr,lpTarget):TargetPtr=cptr(byte ptr,lpTarget) 
    val16=ptr16[0]:TargetBytes =val16 and &H0007:TargetWidth=val16 shr 3 
    val16=ptr16[1]:TargetHeight=val16:TargetPtr+=4 
  end if 
  if (TargetWidth<4) or (TargetHeight<4) then exit sub 

  dim as integer   SourceWidth,SourceHeight,SourceBytes 
  ptr16=cptr(short ptr,lpSource):SourcePtr=cptr(byte ptr,lpSource) 
  val16=ptr16[0]:SourceBytes =val16 and &H0007:SourceWidth=val16 shr 3 
  val16=ptr16[1]:SourceHeight=val16:SourcePtr+=4 
  if (SourceWidth<2) or (SourceHeight<2) then exit sub 

  if TargetBytes<>SourceBytes then exit sub 

#define xs 0 'screen 
#define ys 1 
#define xt 2 'texture 
#define yt 3 
  redim as single Points(4,5) 
  points(0,xs)=-SourceWidth/2 * xScale 
  points(1,xs)= SourceWidth/2 * xScale 
  points(2,xs)= points(1,xs) 
  points(3,xs)= points(0,xs) 

  points(0,ys)=-SourceHeight/2 * yScale 
  points(1,ys)= points(0,ys) 
  points(2,ys)= SourceHeight/2 * yScale 
  points(3,ys)= points(2,ys) 

  points(1,xt)= SourceWidth-1 
  points(2,xt)= points(1,xt) 
  points(2,yt)= SourceHeight-1 
  points(3,yt)= points(2,yt) 

  dim as uinteger i 
  dim as single x,y 
  if MustRotate then 
    #ifndef UseRad 
    Rotate*=0.017453292 'degre 2 rad 
    #endif 
    while Rotate< 0        :rotate+=6.2831853:wend 
    while Rotate>=6.2831853:rotate-=6.2831853:wend 
    for i=0 to 3 
      x=points(i,xs)*cos(Rotate) - points(i,ys)*sin(Rotate) 
      y=points(i,xs)*sin(Rotate) + points(i,ys)*cos(Rotate) 
      points(i,xs)=x:points(i,ys)=y 
    next 
  end if 

  dim as integer yStart,yEnd,xStart,xEnd 
  yStart=100000:yEnd=-yStart:xStart=yStart:xEnd=yEnd 

#define LI 0   'LeftIndex 
#define RI 1   'RightIndex 
#define  IND 0 'Index 
#define NIND 1 'NextIndex 
  dim as integer CNS(2,2) 'Counters 

  for i=0 to 3 
    points(i,xs)=int(points(i,xs)+xMidPos) 
    points(i,ys)=int(points(i,ys)+yMidPos) 
    if points(i,ys)<yStart then yStart=points(i,ys):CNS(LI,IND)=i 
    if points(i,ys)>yEnd   then yEnd  =points(i,ys) 
    if points(i,xs)<xStart then xStart=points(i,xs) 
    if points(i,xs)>xEnd   then xEnd  =points(i,xs) 
  next 
  if yStart =yEnd         then exit sub 
  if yStart>=TargetHeight then exit sub 
  if yEnd   <0            then exit sub 
  if xStart = xEnd        then exit sub 
  if xStart>=TargetWidth  then exit sub 
  if xEnd   <0            then exit sub 

  dim as byte    ptr t1,s1 
  dim as short   ptr t2,s2 
  dim as integer ptr t4,s4 


#define ADD 0 
#define CMP 1 
#define SET 2 
  dim as integer ACS(2,3) 'add compare and set 
  ACS(LI,ADD)=-1:ACS(LI,CMP)=-1:ACS(LI,SET)=3 
  ACS(RI,ADD)= 1:ACS(RI,CMP)= 4:ACS(RI,SET)=0 

#define EX  0 
#define EU  1 
#define EV  2 
#define EXS 3 
#define EUS 4 
#define EVS 5 
  dim as single E(2,6),S(6),Length,uSlope,vSlope 
  dim as integer U,UV,UA,UN,V,VV,VA,VN 

  ' share the same highest point 
  CNS(RI,IND)=CNS(LI,IND) 
If MustLock then ScreenLock 
  ' loop from Top to Bottom 
  while yStart<yEnd 

    'Scan Left and Right sides together 
    for i=LI to RI 
      ' bad to read but fast and short ;-) 
      if yStart=points(CNS(i,IND),ys) then 
        CNS(i,NIND)=CNS(i,IND)+ACS(i,Add) 
        if CNS(i,NIND)=ACS(i,CMP) then CNS(i,NIND)=ACS(i,SET) 
        while points(CNS(i,IND),ys) = points(CNS(i,NIND),ys) 
          CNS(i, IND)=CNS(i,NIND) 
          CNS(i,NIND)=CNS(i, IND)+ACS(i,Add) 
          if CNS(i,NIND)=ACS(i,CMP) then CNS(i,NIND)=ACS(i,SET) 
        wend 
        E(i,EX) = points(CNS(i, IND),xs) 
        E(i,EU) = points(CNS(i, IND),xt) 
        E(i,EV) = points(CNS(i, IND),yt) 
        Length  = points(CNS(i,NIND),ys) 
        Length -= points(CNS(i, IND),ys) 
        If Length <> 0.0 Then 
          E(i,EXS) = points(CNS(i, NIND),xs)-E(i,EX):E(i,EXS)/=Length 
          E(i,EUS) = points(CNS(i, NIND),xt)-E(i,EU):E(i,EUS)/=Length 
          E(i,EVS) = points(CNS(i, NIND),yt)-E(i,EV):E(i,EVS)/=Length 
        End If 
        CNS(i,IND)=CNS(i,NIND) 
      end if 
    next 

    if yStart<  0                          then goto SkipScanLine 
    xStart=E(LI,EX)+0.5:if xStart>=TargetWidth then goto SkipScanLine 
    xEnd  =E(RI,EX)-0.5:if xEnd  < 0           then goto SkipScanLine 
    if xStart=xEnd                         then goto SkipScanLine 
    'if xEnd  <xStart                       then goto SkipScanLine 
    Length=xEnd-xStart 
    uSlope=E(RI,EU)-E(LI,EU):uSlope/=Length 
    vSlope=E(RI,EV)-E(LI,EV):vSlope/=Length 
    If xstart<0 Then 
      Length=abs(xStart) 
      U=int(E(LI,EU)+uSlope*Length) 
      V=int(E(LI,EV)+vSlope*Length) 
      xStart = 0 
    else 
      U=int(E(LI,EU)):V=int(E(LI,EV)) 
    End If 
    if xEnd>=TargetWidth then xEnd=TargetWidth-1 
    UV=int(uSlope):UA=(uSlope-UV)*10000:UN=0 
    VV=int(vSlope):VA=(vSlope-VV)*10000:VN=0 
    xEnd-=xStart 
    select case TargetBytes 
      case 1 
        t1=TargetPtr:t1+=yStart*TargetWidth:t1+=xStart:xStart=0 
        if MustKeying=0 then 
          while xStart<xEnd 
            s1=SourcePtr:s1+=V*SourceWidth:s1+=U 
            t1[xStart]=s1[0] 
            U+=UV:UN+=UA:if UN>=10000 then U+=1:UN-=10000 
            V+=VV:VN+=VA:if VN>=10000 then V+=1:VN-=10000 
            if u<0 then u=0 
            if v<0 then v=0 
            xStart+=1 
          wend 
        else 
          val8=ColorKey and &HFF 
          while xStart<xEnd 
            s1=SourcePtr:s1+=V*SourceWidth:s1+=U 
            if s1[0]<>val8 then t1[xStart]=s1[0] 
            U+=UV:UN+=UA:if UN>=10000 then U+=1:UN-=10000 
            V+=VV:VN+=VA:if VN>=10000 then V+=1:VN-=10000 
            if u<0 then u=0 
            if v<0 then v=0 
            xStart+=1 
          wend 

        end if 
      case 2 
        t2=cptr(short ptr,TargetPtr) 
        t2+=yStart*TargetWidth:t2+=xStart:xStart=0 
        if MustKeying=0 then 
          while xStart<xEnd 
            s2=cptr(short ptr,SourcePtr):s2+=V*SourceWidth:s2+=U 
            t2[xStart]=s2[0] 
            U+=UV:UN+=UA:if UN>=10000 then U+=1:UN-=10000 
            V+=VV:VN+=VA:if VN>=10000 then V+=1:VN-=10000 
            if u<0 then u=0 
            if v<0 then v=0 
            xStart+=1 
          wend 
        else 
          val16=ColorKey and &HFFFF 
          while xStart<xEnd 
            s2=cptr(short ptr,SourcePtr):s2+=V*SourceWidth:s2+=U 
            if s2[0]<>val16 then t2[xStart]=s2[0] 
            U+=UV:UN+=UA:if UN>=10000 then U+=1:UN-=10000 
            V+=VV:VN+=VA:if VN>=10000 then V+=1:VN-=10000 
            if u<0 then u=0 
            if v<0 then v=0 
            xStart+=1 
          wend 
        end if 
      case 4 
        t4=cptr(integer ptr,TargetPtr) 
        t4+=yStart*TargetWidth:t4+=xStart:xStart=0 
        if MustKeying=0 then 
          while xStart<xEnd 
            s4=cptr(integer ptr,SourcePtr):s4+=V*SourceWidth:s4+=U 
            t4[xStart]=s4[0] 
            U+=UV:UN+=UA:if UN>=10000 then U+=1:UN-=10000 
            V+=VV:VN+=VA:if VN>=10000 then V+=1:VN-=10000 
            if u<0 then u=0 
            if v<0 then v=0 
            xStart+=1 
          wend 
        else 
          val32=ColorKey and &HFFFFFF 
          while xStart<xEnd 
            s4=cptr(integer ptr,SourcePtr):s4+=V*SourceWidth:s4+=U 
            if s4[0]<>val32 then t4[xStart]=s4[0] 
            U+=UV:UN+=UA:if UN>=10000 then U+=1:UN-=10000 
            V+=VV:VN+=VA:if VN>=10000 then V+=1:VN-=10000 
            if u<0 then u=0 
            if v<0 then v=0 
            xStart+=1 
          wend 
        end if 
    end select 

SkipScanLine: 
    E(LI,EX)+=E(LI,EXS):E(LI,EU)+=E(LI,EUS):E(LI,EV)+=E(LI,EVS) 
    E(RI,EX)+=E(RI,EXS):E(RI,EU)+=E(RI,EUS):E(RI,EV)+=E(RI,EVS) 
    yStart+=1:if yStart=TargetHeight then yStart=yEnd 'exit loop 
  wend 
if MustLock then ScreenUnlock 
END SUB 
